package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Cache Policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom cache policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * CachePolicy myCachePolicy = CachePolicy.Builder.create(this, "myCachePolicy")
 *         .cachePolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .defaultTtl(Duration.days(2))
 *         .minTtl(Duration.minutes(1))
 *         .maxTtl(Duration.days(10))
 *         .cookieBehavior(CacheCookieBehavior.all())
 *         .headerBehavior(CacheHeaderBehavior.allowList("X-CustomHeader"))
 *         .queryStringBehavior(CacheQueryStringBehavior.denyList("username"))
 *         .enableAcceptEncodingGzip(true)
 *         .enableAcceptEncodingBrotli(true)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .cachePolicy(myCachePolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CachePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CachePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CachePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique name to identify the cache policy.
     * <p>
     * The name must only include '-', '_', or alphanumeric characters.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyName() {
        return null;
    }

    /**
     * A comment to describe the cache policy.
     * <p>
     * The comment cannot be longer than 128 characters.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * Default: CacheCookieBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CacheCookieBehavior getCookieBehavior() {
        return null;
    }

    /**
     * The default amount of time for objects to stay in the CloudFront cache.
     * <p>
     * Only used when the origin does not send Cache-Control or Expires headers with the object.
     * <p>
     * Default: - The greater of 1 day and ``minTtl``
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDefaultTtl() {
        return null;
    }

    /**
     * Whether to normalize and include the <code>Accept-Encoding</code> header in the cache key when the <code>Accept-Encoding</code> header is 'br'.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableAcceptEncodingBrotli() {
        return null;
    }

    /**
     * Whether to normalize and include the <code>Accept-Encoding</code> header in the cache key when the <code>Accept-Encoding</code> header is 'gzip'.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableAcceptEncodingGzip() {
        return null;
    }

    /**
     * Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * Default: CacheHeaderBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior getHeaderBehavior() {
        return null;
    }

    /**
     * The maximum amount of time for objects to stay in the CloudFront cache.
     * <p>
     * CloudFront uses this value only when the origin sends Cache-Control or Expires headers with the object.
     * <p>
     * Default: - The greater of 1 year and ``defaultTtl``
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxTtl() {
        return null;
    }

    /**
     * The minimum amount of time for objects to stay in the CloudFront cache.
     * <p>
     * Default: Duration.seconds(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMinTtl() {
        return null;
    }

    /**
     * Determines whether any query strings are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * Default: CacheQueryStringBehavior.none()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior getQueryStringBehavior() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CachePolicyProps> {
        java.lang.String cachePolicyName;
        java.lang.String comment;
        software.amazon.awscdk.services.cloudfront.CacheCookieBehavior cookieBehavior;
        software.amazon.awscdk.Duration defaultTtl;
        java.lang.Boolean enableAcceptEncodingBrotli;
        java.lang.Boolean enableAcceptEncodingGzip;
        software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior headerBehavior;
        software.amazon.awscdk.Duration maxTtl;
        software.amazon.awscdk.Duration minTtl;
        software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior queryStringBehavior;

        /**
         * Sets the value of {@link CachePolicyProps#getCachePolicyName}
         * @param cachePolicyName A unique name to identify the cache policy.
         *                        The name must only include '-', '_', or alphanumeric characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyName(java.lang.String cachePolicyName) {
            this.cachePolicyName = cachePolicyName;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getComment}
         * @param comment A comment to describe the cache policy.
         *                The comment cannot be longer than 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getCookieBehavior}
         * @param cookieBehavior Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cookieBehavior(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getDefaultTtl}
         * @param defaultTtl The default amount of time for objects to stay in the CloudFront cache.
         *                   Only used when the origin does not send Cache-Control or Expires headers with the object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTtl(software.amazon.awscdk.Duration defaultTtl) {
            this.defaultTtl = defaultTtl;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getEnableAcceptEncodingBrotli}
         * @param enableAcceptEncodingBrotli Whether to normalize and include the <code>Accept-Encoding</code> header in the cache key when the <code>Accept-Encoding</code> header is 'br'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceptEncodingBrotli(java.lang.Boolean enableAcceptEncodingBrotli) {
            this.enableAcceptEncodingBrotli = enableAcceptEncodingBrotli;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getEnableAcceptEncodingGzip}
         * @param enableAcceptEncodingGzip Whether to normalize and include the <code>Accept-Encoding</code> header in the cache key when the <code>Accept-Encoding</code> header is 'gzip'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceptEncodingGzip(java.lang.Boolean enableAcceptEncodingGzip) {
            this.enableAcceptEncodingGzip = enableAcceptEncodingGzip;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getHeaderBehavior}
         * @param headerBehavior Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerBehavior(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior headerBehavior) {
            this.headerBehavior = headerBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getMaxTtl}
         * @param maxTtl The maximum amount of time for objects to stay in the CloudFront cache.
         *               CloudFront uses this value only when the origin sends Cache-Control or Expires headers with the object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxTtl(software.amazon.awscdk.Duration maxTtl) {
            this.maxTtl = maxTtl;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getMinTtl}
         * @param minTtl The minimum amount of time for objects to stay in the CloudFront cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minTtl(software.amazon.awscdk.Duration minTtl) {
            this.minTtl = minTtl;
            return this;
        }

        /**
         * Sets the value of {@link CachePolicyProps#getQueryStringBehavior}
         * @param queryStringBehavior Determines whether any query strings are included in the cache key and automatically included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringBehavior(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior queryStringBehavior) {
            this.queryStringBehavior = queryStringBehavior;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CachePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CachePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CachePolicyProps {
        private final java.lang.String cachePolicyName;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.cloudfront.CacheCookieBehavior cookieBehavior;
        private final software.amazon.awscdk.Duration defaultTtl;
        private final java.lang.Boolean enableAcceptEncodingBrotli;
        private final java.lang.Boolean enableAcceptEncodingGzip;
        private final software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior headerBehavior;
        private final software.amazon.awscdk.Duration maxTtl;
        private final software.amazon.awscdk.Duration minTtl;
        private final software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior queryStringBehavior;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cachePolicyName = software.amazon.jsii.Kernel.get(this, "cachePolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cookieBehavior = software.amazon.jsii.Kernel.get(this, "cookieBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheCookieBehavior.class));
            this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.enableAcceptEncodingBrotli = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingBrotli", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableAcceptEncodingGzip = software.amazon.jsii.Kernel.get(this, "enableAcceptEncodingGzip", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.headerBehavior = software.amazon.jsii.Kernel.get(this, "headerBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior.class));
            this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.queryStringBehavior = software.amazon.jsii.Kernel.get(this, "queryStringBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cachePolicyName = builder.cachePolicyName;
            this.comment = builder.comment;
            this.cookieBehavior = builder.cookieBehavior;
            this.defaultTtl = builder.defaultTtl;
            this.enableAcceptEncodingBrotli = builder.enableAcceptEncodingBrotli;
            this.enableAcceptEncodingGzip = builder.enableAcceptEncodingGzip;
            this.headerBehavior = builder.headerBehavior;
            this.maxTtl = builder.maxTtl;
            this.minTtl = builder.minTtl;
            this.queryStringBehavior = builder.queryStringBehavior;
        }

        @Override
        public final java.lang.String getCachePolicyName() {
            return this.cachePolicyName;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CacheCookieBehavior getCookieBehavior() {
            return this.cookieBehavior;
        }

        @Override
        public final software.amazon.awscdk.Duration getDefaultTtl() {
            return this.defaultTtl;
        }

        @Override
        public final java.lang.Boolean getEnableAcceptEncodingBrotli() {
            return this.enableAcceptEncodingBrotli;
        }

        @Override
        public final java.lang.Boolean getEnableAcceptEncodingGzip() {
            return this.enableAcceptEncodingGzip;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior getHeaderBehavior() {
            return this.headerBehavior;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxTtl() {
            return this.maxTtl;
        }

        @Override
        public final software.amazon.awscdk.Duration getMinTtl() {
            return this.minTtl;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior getQueryStringBehavior() {
            return this.queryStringBehavior;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCachePolicyName() != null) {
                data.set("cachePolicyName", om.valueToTree(this.getCachePolicyName()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getCookieBehavior() != null) {
                data.set("cookieBehavior", om.valueToTree(this.getCookieBehavior()));
            }
            if (this.getDefaultTtl() != null) {
                data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
            }
            if (this.getEnableAcceptEncodingBrotli() != null) {
                data.set("enableAcceptEncodingBrotli", om.valueToTree(this.getEnableAcceptEncodingBrotli()));
            }
            if (this.getEnableAcceptEncodingGzip() != null) {
                data.set("enableAcceptEncodingGzip", om.valueToTree(this.getEnableAcceptEncodingGzip()));
            }
            if (this.getHeaderBehavior() != null) {
                data.set("headerBehavior", om.valueToTree(this.getHeaderBehavior()));
            }
            if (this.getMaxTtl() != null) {
                data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
            }
            if (this.getMinTtl() != null) {
                data.set("minTtl", om.valueToTree(this.getMinTtl()));
            }
            if (this.getQueryStringBehavior() != null) {
                data.set("queryStringBehavior", om.valueToTree(this.getQueryStringBehavior()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CachePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CachePolicyProps.Jsii$Proxy that = (CachePolicyProps.Jsii$Proxy) o;

            if (this.cachePolicyName != null ? !this.cachePolicyName.equals(that.cachePolicyName) : that.cachePolicyName != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.cookieBehavior != null ? !this.cookieBehavior.equals(that.cookieBehavior) : that.cookieBehavior != null) return false;
            if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
            if (this.enableAcceptEncodingBrotli != null ? !this.enableAcceptEncodingBrotli.equals(that.enableAcceptEncodingBrotli) : that.enableAcceptEncodingBrotli != null) return false;
            if (this.enableAcceptEncodingGzip != null ? !this.enableAcceptEncodingGzip.equals(that.enableAcceptEncodingGzip) : that.enableAcceptEncodingGzip != null) return false;
            if (this.headerBehavior != null ? !this.headerBehavior.equals(that.headerBehavior) : that.headerBehavior != null) return false;
            if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
            if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
            return this.queryStringBehavior != null ? this.queryStringBehavior.equals(that.queryStringBehavior) : that.queryStringBehavior == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cachePolicyName != null ? this.cachePolicyName.hashCode() : 0;
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.cookieBehavior != null ? this.cookieBehavior.hashCode() : 0);
            result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
            result = 31 * result + (this.enableAcceptEncodingBrotli != null ? this.enableAcceptEncodingBrotli.hashCode() : 0);
            result = 31 * result + (this.enableAcceptEncodingGzip != null ? this.enableAcceptEncodingGzip.hashCode() : 0);
            result = 31 * result + (this.headerBehavior != null ? this.headerBehavior.hashCode() : 0);
            result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
            result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
            result = 31 * result + (this.queryStringBehavior != null ? this.queryStringBehavior.hashCode() : 0);
            return result;
        }
    }
}
