package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether CloudFront includes the Strict-Transport-Security HTTP response header and the header’s value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(false).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .removeHeaders(List.of("Server"))
 *         .serverTimingSamplingRate(50)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.858Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseHeadersStrictTransportSecurity")
@software.amazon.jsii.Jsii.Proxy(ResponseHeadersStrictTransportSecurity.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResponseHeadersStrictTransportSecurity extends software.amazon.jsii.JsiiSerializable {

    /**
     * A number that CloudFront uses as the value for the max-age directive in the Strict-Transport-Security HTTP response header.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getAccessControlMaxAge();

    /**
     * A Boolean that determines whether CloudFront overrides the Strict-Transport-Security HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getOverride();

    /**
     * A Boolean that determines whether CloudFront includes the includeSubDomains directive in the Strict-Transport-Security HTTP response header.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeSubdomains() {
        return null;
    }

    /**
     * A Boolean that determines whether CloudFront includes the preload directive in the Strict-Transport-Security HTTP response header.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreload() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResponseHeadersStrictTransportSecurity}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResponseHeadersStrictTransportSecurity}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResponseHeadersStrictTransportSecurity> {
        software.amazon.awscdk.Duration accessControlMaxAge;
        java.lang.Boolean override;
        java.lang.Boolean includeSubdomains;
        java.lang.Boolean preload;

        /**
         * Sets the value of {@link ResponseHeadersStrictTransportSecurity#getAccessControlMaxAge}
         * @param accessControlMaxAge A number that CloudFront uses as the value for the max-age directive in the Strict-Transport-Security HTTP response header. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlMaxAge(software.amazon.awscdk.Duration accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersStrictTransportSecurity#getOverride}
         * @param override A Boolean that determines whether CloudFront overrides the Strict-Transport-Security HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder override(java.lang.Boolean override) {
            this.override = override;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersStrictTransportSecurity#getIncludeSubdomains}
         * @param includeSubdomains A Boolean that determines whether CloudFront includes the includeSubDomains directive in the Strict-Transport-Security HTTP response header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeSubdomains(java.lang.Boolean includeSubdomains) {
            this.includeSubdomains = includeSubdomains;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersStrictTransportSecurity#getPreload}
         * @param preload A Boolean that determines whether CloudFront includes the preload directive in the Strict-Transport-Security HTTP response header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preload(java.lang.Boolean preload) {
            this.preload = preload;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResponseHeadersStrictTransportSecurity}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResponseHeadersStrictTransportSecurity build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResponseHeadersStrictTransportSecurity}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseHeadersStrictTransportSecurity {
        private final software.amazon.awscdk.Duration accessControlMaxAge;
        private final java.lang.Boolean override;
        private final java.lang.Boolean includeSubdomains;
        private final java.lang.Boolean preload;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessControlMaxAge = software.amazon.jsii.Kernel.get(this, "accessControlMaxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeSubdomains = software.amazon.jsii.Kernel.get(this, "includeSubdomains", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.preload = software.amazon.jsii.Kernel.get(this, "preload", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessControlMaxAge = java.util.Objects.requireNonNull(builder.accessControlMaxAge, "accessControlMaxAge is required");
            this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
            this.includeSubdomains = builder.includeSubdomains;
            this.preload = builder.preload;
        }

        @Override
        public final software.amazon.awscdk.Duration getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }

        @Override
        public final java.lang.Boolean getOverride() {
            return this.override;
        }

        @Override
        public final java.lang.Boolean getIncludeSubdomains() {
            return this.includeSubdomains;
        }

        @Override
        public final java.lang.Boolean getPreload() {
            return this.preload;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessControlMaxAge", om.valueToTree(this.getAccessControlMaxAge()));
            data.set("override", om.valueToTree(this.getOverride()));
            if (this.getIncludeSubdomains() != null) {
                data.set("includeSubdomains", om.valueToTree(this.getIncludeSubdomains()));
            }
            if (this.getPreload() != null) {
                data.set("preload", om.valueToTree(this.getPreload()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ResponseHeadersStrictTransportSecurity"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResponseHeadersStrictTransportSecurity.Jsii$Proxy that = (ResponseHeadersStrictTransportSecurity.Jsii$Proxy) o;

            if (!accessControlMaxAge.equals(that.accessControlMaxAge)) return false;
            if (!override.equals(that.override)) return false;
            if (this.includeSubdomains != null ? !this.includeSubdomains.equals(that.includeSubdomains) : that.includeSubdomains != null) return false;
            return this.preload != null ? this.preload.equals(that.preload) : that.preload == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessControlMaxAge.hashCode();
            result = 31 * result + (this.override.hashCode());
            result = 31 * result + (this.includeSubdomains != null ? this.includeSubdomains.hashCode() : 0);
            result = 31 * result + (this.preload != null ? this.preload.hashCode() : 0);
            return result;
        }
    }
}
