package software.amazon.awscdk.services.cloudwatch;

/**
 * A dashboard widget that displays the most recent value for every metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         .metrics(List.of())
 *         .period(Duration.minutes(15))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.076Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SingleValueWidget")
public class SingleValueWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected SingleValueWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SingleValueWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SingleValueWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.SingleValueWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.SingleValueWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps.Builder();
        }

        /**
         * Height of the widget.
         * <p>
         * Default: - 6 for Alarm and Graph widgets.
         * 3 for single value widgets where most recent value of a metric is displayed.
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * The region the metrics of this graph should be taken from.
         * <p>
         * Default: - Current region
         * <p>
         * @return {@code this}
         * @param region The region the metrics of this graph should be taken from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Title for the graph.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param title Title for the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * Metrics to display.
         * <p>
         * @return {@code this}
         * @param metrics Metrics to display. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        /**
         * The end of the time range to use for each widget independently from those of the dashboard.
         * <p>
         * If you specify a value for end, you must also specify a value for start.
         * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Default: When the dashboard loads, the end date will be the current time.
         * <p>
         * @return {@code this}
         * @param end The end of the time range to use for each widget independently from those of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(final java.lang.String end) {
            this.props.end(end);
            return this;
        }

        /**
         * Whether to show as many digits as can fit, before rounding.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param fullPrecision Whether to show as many digits as can fit, before rounding. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullPrecision(final java.lang.Boolean fullPrecision) {
            this.props.fullPrecision(fullPrecision);
            return this;
        }

        /**
         * The default period for all metrics in this widget.
         * <p>
         * The period is the length of time represented by one data point on the graph.
         * This default can be overridden within each metric definition.
         * <p>
         * Default: cdk.Duration.seconds(300)
         * <p>
         * @return {@code this}
         * @param period The default period for all metrics in this widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * Whether to show the value from the entire time range.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(final java.lang.Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        /**
         * Whether to show a graph below the value illustrating the value for the whole time range.
         * <p>
         * Cannot be used in combination with <code>setPeriodToTimeRange</code>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param sparkline Whether to show a graph below the value illustrating the value for the whole time range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sparkline(final java.lang.Boolean sparkline) {
            this.props.sparkline(sparkline);
            return this;
        }

        /**
         * The start of the time range to use for each widget independently from those of the dashboard.
         * <p>
         * You can specify start without specifying end to specify a relative time range that ends with the current time.
         * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         * You can also use start along with an end field, to specify an absolute time range.
         * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Default: When the dashboard loads, the start time will be the default time range.
         * <p>
         * @return {@code this}
         * @param start The start of the time range to use for each widget independently from those of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(final java.lang.String start) {
            this.props.start(start);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.SingleValueWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.SingleValueWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.SingleValueWidget(
                this.props.build()
            );
        }
    }
}
