package software.amazon.awscdk.services.cloudwatch;

/**
 * A widget that doesn't display anything but takes up space.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Spacer spacer = Spacer.Builder.create()
 *         .height(123)
 *         .width(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.077Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Spacer")
public class Spacer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IWidget {

    protected Spacer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Spacer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Spacer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.SpacerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Spacer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Place the widget at a given position.
     * <p>
     * @param _x This parameter is required.
     * @param _y This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void position(final @org.jetbrains.annotations.NotNull java.lang.Number _x, final @org.jetbrains.annotations.NotNull java.lang.Number _y) {
        software.amazon.jsii.Kernel.call(this, "position", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_x, "_x is required"), java.util.Objects.requireNonNull(_y, "_y is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The amount of vertical grid units the widget will take up.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getHeight() {
        return software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of horizontal grid units the widget will take up.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getWidth() {
        return software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.Spacer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.Spacer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.cloudwatch.SpacerProps.Builder props;

        private Builder() {
        }

        /**
         * Height of the spacer.
         * <p>
         * Default: : 1
         * <p>
         * @return {@code this}
         * @param height Height of the spacer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props().height(height);
            return this;
        }

        /**
         * Width of the spacer.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param width Width of the spacer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props().width(width);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.Spacer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.Spacer build() {
            return new software.amazon.awscdk.services.cloudwatch.Spacer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudwatch.SpacerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudwatch.SpacerProps.Builder();
            }
            return this.props;
        }
    }
}
