package software.amazon.awscdk.services.cloudwatch;

/**
 * Specify how missing data points are treated during alarm evaluation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .timeout(Duration.minutes(5))
 *         .build();
 * if (fn.getTimeout()) {
 *     Alarm.Builder.create(this, "MyAlarm")
 *             .metric(fn.metricDuration().with(MetricOptions.builder()
 *                     .statistic("Maximum")
 *                     .build()))
 *             .evaluationPeriods(1)
 *             .datapointsToAlarm(1)
 *             .threshold(fn.timeout.toMilliseconds())
 *             .treatMissingData(TreatMissingData.IGNORE)
 *             .alarmName("My Lambda Timeout")
 *             .build();
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.084Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.TreatMissingData")
public enum TreatMissingData {
    /**
     * Missing data points are treated as breaching the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BREACHING,
    /**
     * Missing data points are treated as being within the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOT_BREACHING,
    /**
     * The current alarm state is maintained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IGNORE,
    /**
     * The alarm does not consider missing data points when evaluating whether to change state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MISSING,
}
