package software.amazon.awscdk.services.codebuild;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * IBuildImage buildImage;
 * BuildSpec buildSpec;
 * Cache cache;
 * IFileSystemLocation fileSystemLocation;
 * Fleet fleet;
 * Key key;
 * LogGroup logGroup;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Object value;
 * Vpc vpc;
 * CommonProjectProps commonProjectProps = CommonProjectProps.builder()
 *         .allowAllOutbound(false)
 *         .autoRetryLimit(123)
 *         .badge(false)
 *         .buildSpec(buildSpec)
 *         .cache(cache)
 *         .checkSecretsInPlainTextEnvVariables(false)
 *         .concurrentBuildLimit(123)
 *         .description("description")
 *         .encryptionKey(key)
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(buildImage)
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(bucket)
 *                         .objectKey("objectKey")
 *                         .build())
 *                 .computeType(ComputeType.SMALL)
 *                 .environmentVariables(Map.of(
 *                         "environmentVariablesKey", BuildEnvironmentVariable.builder()
 *                                 .value(value)
 *                                 // the properties below are optional
 *                                 .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                                 .build()))
 *                 .fleet(fleet)
 *                 .privileged(false)
 *                 .build())
 *         .environmentVariables(Map.of(
 *                 "environmentVariablesKey", BuildEnvironmentVariable.builder()
 *                         .value(value)
 *                         // the properties below are optional
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .build()))
 *         .fileSystemLocations(List.of(fileSystemLocation))
 *         .grantReportGroupPermissions(false)
 *         .logging(LoggingOptions.builder()
 *                 .cloudWatch(CloudWatchLoggingOptions.builder()
 *                         .enabled(false)
 *                         .logGroup(logGroup)
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3(S3LoggingOptions.builder()
 *                         .bucket(bucket)
 *                         // the properties below are optional
 *                         .enabled(false)
 *                         .encrypted(false)
 *                         .prefix("prefix")
 *                         .build())
 *                 .build())
 *         .projectName("projectName")
 *         .queuedTimeout(Duration.minutes(30))
 *         .role(role)
 *         .securityGroups(List.of(securityGroup))
 *         .ssmSessionPermissions(false)
 *         .subnetSelection(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .timeout(Duration.minutes(30))
 *         .visibility(ProjectVisibility.PUBLIC_READ)
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.193Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.CommonProjectProps")
@software.amazon.jsii.Jsii.Proxy(CommonProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonProjectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to allow the CodeBuild to send all network traffic.
     * <p>
     * If set to false, you must individually add traffic rules to allow the
     * CodeBuild project to connect to network targets.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * CodeBuild will automatically call retry build using the project's service role up to the auto-retry limit.
     * <p>
     * <code>autoRetryLimit</code> must be between 0 and 10.
     * <p>
     * Default: - no retry
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutoRetryLimit() {
        return null;
    }

    /**
     * Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
     * <p>
     * For more information, see Build Badges Sample
     * in the AWS CodeBuild User Guide.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBadge() {
        return null;
    }

    /**
     * Filename or contents of buildspec in JSON format.
     * <p>
     * Default: - Empty buildspec.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example">https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-example</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
        return null;
    }

    /**
     * Caching strategy to use.
     * <p>
     * Default: Cache.none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.Cache getCache() {
        return null;
    }

    /**
     * Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCheckSecretsInPlainTextEnvVariables() {
        return null;
    }

    /**
     * Maximum number of concurrent builds.
     * <p>
     * Minimum value is 1 and maximum is account build limit.
     * <p>
     * Default: - no explicit limit is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getConcurrentBuildLimit() {
        return null;
    }

    /**
     * A description of the project.
     * <p>
     * Use the description to identify the purpose
     * of the project.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Encryption key to use to read and write artifacts.
     * <p>
     * Default: - The AWS-managed CMK for Amazon Simple Storage Service (Amazon S3) is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Build environment to use for the build.
     * <p>
     * Default: BuildEnvironment.LinuxBuildImage.STANDARD_7_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
        return null;
    }

    /**
     * Additional environment variables to add to the build environment.
     * <p>
     * Default: - No additional environment variables are specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
        return null;
    }

    /**
     * An  ProjectFileSystemLocation objects for a CodeBuild build project.
     * <p>
     * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
     * and type of a file system created using Amazon Elastic File System.
     * <p>
     * Default: - no file system locations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
        return null;
    }

    /**
     * Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
     * <p>
     * That is the standard report group that gets created when a simple name
     * (in contrast to an ARN)
     * is used in the 'reports' section of the buildspec of this project.
     * This is usually harmless, but you can turn these off if you don't plan on using test
     * reports in this project.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html">https://docs.aws.amazon.com/codebuild/latest/userguide/test-report-group-naming.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGrantReportGroupPermissions() {
        return null;
    }

    /**
     * Information about logs for the build project.
     * <p>
     * A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
     * <p>
     * Default: - no log configuration is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
        return null;
    }

    /**
     * The physical, human-readable name of the CodeBuild Project.
     * <p>
     * Default: - Name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return null;
    }

    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's still in queue.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: - no queue timeout is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getQueuedTimeout() {
        return null;
    }

    /**
     * Service Role to assume while running the build.
     * <p>
     * Default: - A role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * What security group to associate with the codebuild project's network interfaces.
     * <p>
     * If no security group is identified, one will be created automatically.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - Security group will be automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Add the permissions necessary for debugging builds with SSM Session Manager.
     * <p>
     * If the following prerequisites have been met:
     * <p>
     * <ul>
     * <li>The necessary permissions have been added by setting this flag to true.</li>
     * <li>The build image has the SSM agent installed (true for default CodeBuild images).</li>
     * <li>The build is started with <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_StartBuild.html#CodeBuild-StartBuild-request-debugSessionEnabled">debugSessionEnabled</a> set to true.</li>
     * </ul>
     * <p>
     * Then the build container can be paused and inspected using Session Manager
     * by invoking the <code>codebuild-breakpoint</code> command somewhere during the build.
     * <p>
     * <code>codebuild-breakpoint</code> commands will be ignored if the build is not started
     * with <code>debugSessionEnabled=true</code>.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSsmSessionPermissions() {
        return null;
    }

    /**
     * Where to place the network interfaces within the VPC.
     * <p>
     * To access AWS services, your CodeBuild project needs to be in one of the following types of subnets:
     * <p>
     * <ol>
     * <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
     * <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
     * </ol>
     * <p>
     * If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
     * then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
     * AWS service access, add VPC Endpoints to your private subnets.
     * <p>
     * Default: - private subnets if available else public subnets
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * Specifies the visibility of the project's builds.
     * <p>
     * Default: - no visibility is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ProjectVisibility getVisibility() {
        return null;
    }

    /**
     * VPC network to place codebuild network interfaces.
     * <p>
     * Specify this if the codebuild project needs to access resources in a VPC.
     * <p>
     * Default: - No VPC is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonProjectProps> {
        java.lang.Boolean allowAllOutbound;
        java.lang.Number autoRetryLimit;
        java.lang.Boolean badge;
        software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        software.amazon.awscdk.services.codebuild.Cache cache;
        java.lang.Boolean checkSecretsInPlainTextEnvVariables;
        java.lang.Number concurrentBuildLimit;
        java.lang.String description;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        java.lang.Boolean grantReportGroupPermissions;
        software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        java.lang.String projectName;
        software.amazon.awscdk.Duration queuedTimeout;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.Boolean ssmSessionPermissions;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.codebuild.ProjectVisibility visibility;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link CommonProjectProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the CodeBuild to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         CodeBuild project to connect to network targets.
         *                         <p>
         *                         Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getAutoRetryLimit}
         * @param autoRetryLimit CodeBuild will automatically call retry build using the project's service role up to the auto-retry limit.
         *                       <code>autoRetryLimit</code> must be between 0 and 10.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRetryLimit(java.lang.Number autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getBadge}
         * @param badge Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         *              For more information, see Build Badges Sample
         *              in the AWS CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badge(java.lang.Boolean badge) {
            this.badge = badge;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getBuildSpec}
         * @param buildSpec Filename or contents of buildspec in JSON format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getCache}
         * @param cache Caching strategy to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(software.amazon.awscdk.services.codebuild.Cache cache) {
            this.cache = cache;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getCheckSecretsInPlainTextEnvVariables}
         * @param checkSecretsInPlainTextEnvVariables Whether to check for the presence of any secrets in the environment variables of the default type, BuildEnvironmentVariableType.PLAINTEXT. Since using a secret for the value of that kind of variable would result in it being displayed in plain text in the AWS Console, the construct will throw an exception if it detects a secret was passed there. Pass this property as false if you want to skip this validation, and keep using a secret in a plain text environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder checkSecretsInPlainTextEnvVariables(java.lang.Boolean checkSecretsInPlainTextEnvVariables) {
            this.checkSecretsInPlainTextEnvVariables = checkSecretsInPlainTextEnvVariables;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getConcurrentBuildLimit}
         * @param concurrentBuildLimit Maximum number of concurrent builds.
         *                             Minimum value is 1 and maximum is account build limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrentBuildLimit(java.lang.Number concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getDescription}
         * @param description A description of the project.
         *                    Use the description to identify the purpose
         *                    of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getEncryptionKey}
         * @param encryptionKey Encryption key to use to read and write artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getEnvironment}
         * @param environment Build environment to use for the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getEnvironmentVariables}
         * @param environmentVariables Additional environment variables to add to the build environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder environmentVariables(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getFileSystemLocations}
         * @param fileSystemLocations An  ProjectFileSystemLocation objects for a CodeBuild build project.
         *                            A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         *                            and type of a file system created using Amazon Elastic File System.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder fileSystemLocations(java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)fileSystemLocations;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getGrantReportGroupPermissions}
         * @param grantReportGroupPermissions Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
         *                                    That is the standard report group that gets created when a simple name
         *                                    (in contrast to an ARN)
         *                                    is used in the 'reports' section of the buildspec of this project.
         *                                    This is usually harmless, but you can turn these off if you don't plan on using test
         *                                    reports in this project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantReportGroupPermissions(java.lang.Boolean grantReportGroupPermissions) {
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getLogging}
         * @param logging Information about logs for the build project.
         *                A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getProjectName}
         * @param projectName The physical, human-readable name of the CodeBuild Project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getQueuedTimeout}
         * @param queuedTimeout The number of minutes after which AWS CodeBuild stops the build if it's still in queue.
         *                      For valid values, see the timeoutInMinutes field in the AWS
         *                      CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queuedTimeout(software.amazon.awscdk.Duration queuedTimeout) {
            this.queuedTimeout = queuedTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getRole}
         * @param role Service Role to assume while running the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getSecurityGroups}
         * @param securityGroups What security group to associate with the codebuild project's network interfaces.
         *                       If no security group is identified, one will be created automatically.
         *                       <p>
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getSsmSessionPermissions}
         * @param ssmSessionPermissions Add the permissions necessary for debugging builds with SSM Session Manager.
         *                              If the following prerequisites have been met:
         *                              <p>
         *                              <ul>
         *                              <li>The necessary permissions have been added by setting this flag to true.</li>
         *                              <li>The build image has the SSM agent installed (true for default CodeBuild images).</li>
         *                              <li>The build is started with <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_StartBuild.html#CodeBuild-StartBuild-request-debugSessionEnabled">debugSessionEnabled</a> set to true.</li>
         *                              </ul>
         *                              <p>
         *                              Then the build container can be paused and inspected using Session Manager
         *                              by invoking the <code>codebuild-breakpoint</code> command somewhere during the build.
         *                              <p>
         *                              <code>codebuild-breakpoint</code> commands will be ignored if the build is not started
         *                              with <code>debugSessionEnabled=true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(java.lang.Boolean ssmSessionPermissions) {
            this.ssmSessionPermissions = ssmSessionPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getSubnetSelection}
         * @param subnetSelection Where to place the network interfaces within the VPC.
         *                        To access AWS services, your CodeBuild project needs to be in one of the following types of subnets:
         *                        <p>
         *                        <ol>
         *                        <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
         *                        <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
         *                        </ol>
         *                        <p>
         *                        If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
         *                        then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
         *                        AWS service access, add VPC Endpoints to your private subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getVisibility}
         * @param visibility Specifies the visibility of the project's builds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(software.amazon.awscdk.services.codebuild.ProjectVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        /**
         * Sets the value of {@link CommonProjectProps#getVpc}
         * @param vpc VPC network to place codebuild network interfaces.
         *            Specify this if the codebuild project needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonProjectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonProjectProps {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Number autoRetryLimit;
        private final java.lang.Boolean badge;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final software.amazon.awscdk.services.codebuild.Cache cache;
        private final java.lang.Boolean checkSecretsInPlainTextEnvVariables;
        private final java.lang.Number concurrentBuildLimit;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private final java.lang.Boolean grantReportGroupPermissions;
        private final software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        private final java.lang.String projectName;
        private final software.amazon.awscdk.Duration queuedTimeout;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Boolean ssmSessionPermissions;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.codebuild.ProjectVisibility visibility;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoRetryLimit = software.amazon.jsii.Kernel.get(this, "autoRetryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.badge = software.amazon.jsii.Kernel.get(this, "badge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.cache = software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
            this.checkSecretsInPlainTextEnvVariables = software.amazon.jsii.Kernel.get(this, "checkSecretsInPlainTextEnvVariables", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.concurrentBuildLimit = software.amazon.jsii.Kernel.get(this, "concurrentBuildLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable.class)));
            this.fileSystemLocations = software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class)));
            this.grantReportGroupPermissions = software.amazon.jsii.Kernel.get(this, "grantReportGroupPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.LoggingOptions.class));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queuedTimeout = software.amazon.jsii.Kernel.get(this, "queuedTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.ssmSessionPermissions = software.amazon.jsii.Kernel.get(this, "ssmSessionPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ProjectVisibility.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = builder.allowAllOutbound;
            this.autoRetryLimit = builder.autoRetryLimit;
            this.badge = builder.badge;
            this.buildSpec = builder.buildSpec;
            this.cache = builder.cache;
            this.checkSecretsInPlainTextEnvVariables = builder.checkSecretsInPlainTextEnvVariables;
            this.concurrentBuildLimit = builder.concurrentBuildLimit;
            this.description = builder.description;
            this.encryptionKey = builder.encryptionKey;
            this.environment = builder.environment;
            this.environmentVariables = (java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable>)builder.environmentVariables;
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)builder.fileSystemLocations;
            this.grantReportGroupPermissions = builder.grantReportGroupPermissions;
            this.logging = builder.logging;
            this.projectName = builder.projectName;
            this.queuedTimeout = builder.queuedTimeout;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.ssmSessionPermissions = builder.ssmSessionPermissions;
            this.subnetSelection = builder.subnetSelection;
            this.timeout = builder.timeout;
            this.visibility = builder.visibility;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Number getAutoRetryLimit() {
            return this.autoRetryLimit;
        }

        @Override
        public final java.lang.Boolean getBadge() {
            return this.badge;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.Cache getCache() {
            return this.cache;
        }

        @Override
        public final java.lang.Boolean getCheckSecretsInPlainTextEnvVariables() {
            return this.checkSecretsInPlainTextEnvVariables;
        }

        @Override
        public final java.lang.Number getConcurrentBuildLimit() {
            return this.concurrentBuildLimit;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
            return this.fileSystemLocations;
        }

        @Override
        public final java.lang.Boolean getGrantReportGroupPermissions() {
            return this.grantReportGroupPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final software.amazon.awscdk.Duration getQueuedTimeout() {
            return this.queuedTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Boolean getSsmSessionPermissions() {
            return this.ssmSessionPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.ProjectVisibility getVisibility() {
            return this.visibility;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAutoRetryLimit() != null) {
                data.set("autoRetryLimit", om.valueToTree(this.getAutoRetryLimit()));
            }
            if (this.getBadge() != null) {
                data.set("badge", om.valueToTree(this.getBadge()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCache() != null) {
                data.set("cache", om.valueToTree(this.getCache()));
            }
            if (this.getCheckSecretsInPlainTextEnvVariables() != null) {
                data.set("checkSecretsInPlainTextEnvVariables", om.valueToTree(this.getCheckSecretsInPlainTextEnvVariables()));
            }
            if (this.getConcurrentBuildLimit() != null) {
                data.set("concurrentBuildLimit", om.valueToTree(this.getConcurrentBuildLimit()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getFileSystemLocations() != null) {
                data.set("fileSystemLocations", om.valueToTree(this.getFileSystemLocations()));
            }
            if (this.getGrantReportGroupPermissions() != null) {
                data.set("grantReportGroupPermissions", om.valueToTree(this.getGrantReportGroupPermissions()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getQueuedTimeout() != null) {
                data.set("queuedTimeout", om.valueToTree(this.getQueuedTimeout()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSsmSessionPermissions() != null) {
                data.set("ssmSessionPermissions", om.valueToTree(this.getSsmSessionPermissions()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVisibility() != null) {
                data.set("visibility", om.valueToTree(this.getVisibility()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.CommonProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonProjectProps.Jsii$Proxy that = (CommonProjectProps.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.autoRetryLimit != null ? !this.autoRetryLimit.equals(that.autoRetryLimit) : that.autoRetryLimit != null) return false;
            if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) return false;
            if (this.checkSecretsInPlainTextEnvVariables != null ? !this.checkSecretsInPlainTextEnvVariables.equals(that.checkSecretsInPlainTextEnvVariables) : that.checkSecretsInPlainTextEnvVariables != null) return false;
            if (this.concurrentBuildLimit != null ? !this.concurrentBuildLimit.equals(that.concurrentBuildLimit) : that.concurrentBuildLimit != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.fileSystemLocations != null ? !this.fileSystemLocations.equals(that.fileSystemLocations) : that.fileSystemLocations != null) return false;
            if (this.grantReportGroupPermissions != null ? !this.grantReportGroupPermissions.equals(that.grantReportGroupPermissions) : that.grantReportGroupPermissions != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.queuedTimeout != null ? !this.queuedTimeout.equals(that.queuedTimeout) : that.queuedTimeout != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.ssmSessionPermissions != null ? !this.ssmSessionPermissions.equals(that.ssmSessionPermissions) : that.ssmSessionPermissions != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.autoRetryLimit != null ? this.autoRetryLimit.hashCode() : 0);
            result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            result = 31 * result + (this.checkSecretsInPlainTextEnvVariables != null ? this.checkSecretsInPlainTextEnvVariables.hashCode() : 0);
            result = 31 * result + (this.concurrentBuildLimit != null ? this.concurrentBuildLimit.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.fileSystemLocations != null ? this.fileSystemLocations.hashCode() : 0);
            result = 31 * result + (this.grantReportGroupPermissions != null ? this.grantReportGroupPermissions.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.queuedTimeout != null ? this.queuedTimeout.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.ssmSessionPermissions != null ? this.ssmSessionPermissions.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
