package software.amazon.awscdk.services.codepipeline;

/**
 * Trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Action action;
 * Trigger trigger = Trigger.Builder.create()
 *         .providerType(ProviderType.CODE_STAR_SOURCE_CONNECTION)
 *         // the properties below are optional
 *         .gitConfiguration(GitConfiguration.builder()
 *                 .sourceAction(action)
 *                 // the properties below are optional
 *                 .pullRequestFilter(List.of(GitPullRequestFilter.builder()
 *                         .branchesExcludes(List.of("branchesExcludes"))
 *                         .branchesIncludes(List.of("branchesIncludes"))
 *                         .events(List.of(GitPullRequestEvent.OPEN))
 *                         .filePathsExcludes(List.of("filePathsExcludes"))
 *                         .filePathsIncludes(List.of("filePathsIncludes"))
 *                         .build()))
 *                 .pushFilter(List.of(GitPushFilter.builder()
 *                         .tagsExcludes(List.of("tagsExcludes"))
 *                         .tagsIncludes(List.of("tagsIncludes"))
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Trigger")
public class Trigger extends software.amazon.jsii.JsiiObject {

    protected Trigger(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Trigger(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Trigger(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.TriggerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The pipeline source action where the trigger configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.IAction getSourceAction() {
        return software.amazon.jsii.Kernel.get(this, "sourceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IAction.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.Trigger}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.Trigger> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.TriggerProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.TriggerProps.Builder();
        }

        /**
         * The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
         * <p>
         * @return {@code this}
         * @param providerType The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerType(final software.amazon.awscdk.services.codepipeline.ProviderType providerType) {
            this.props.providerType(providerType);
            return this;
        }

        /**
         * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
         * <p>
         * Default: - no configuration.
         * <p>
         * @return {@code this}
         * @param gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gitConfiguration(final software.amazon.awscdk.services.codepipeline.GitConfiguration gitConfiguration) {
            this.props.gitConfiguration(gitConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.Trigger}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.Trigger build() {
            return new software.amazon.awscdk.services.codepipeline.Trigger(
                this.props.build()
            );
        }
    }
}
