package software.amazon.awscdk.services.cognito;

/**
 * Options to customize the behaviour of <code>baseUrl()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * BaseUrlOptions baseUrlOptions = BaseUrlOptions.builder()
 *         .fips(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.625Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.BaseUrlOptions")
@software.amazon.jsii.Jsii.Proxy(BaseUrlOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseUrlOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to return the FIPS-compliant endpoint.
     * <p>
     * Default: return the standard URL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFips() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseUrlOptions> {
        java.lang.Boolean fips;

        /**
         * Sets the value of {@link BaseUrlOptions#getFips}
         * @param fips Whether to return the FIPS-compliant endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fips(java.lang.Boolean fips) {
            this.fips = fips;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseUrlOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseUrlOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseUrlOptions {
        private final java.lang.Boolean fips;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fips = software.amazon.jsii.Kernel.get(this, "fips", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fips = builder.fips;
        }

        @Override
        public final java.lang.Boolean getFips() {
            return this.fips;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFips() != null) {
                data.set("fips", om.valueToTree(this.getFips()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.BaseUrlOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseUrlOptions.Jsii$Proxy that = (BaseUrlOptions.Jsii$Proxy) o;

            return this.fips != null ? this.fips.equals(that.fips) : that.fips == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fips != null ? this.fips.hashCode() : 0;
            return result;
        }
    }
}
