package software.amazon.awscdk.services.comprehend;

/**
 * This resource creates and trains a document classifier to categorize documents.
 * <p>
 * You provide a set of training documents that are labeled with the categories that you want to identify. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html">Document Classification</a> in the Comprehend Developer Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.comprehend.*;
 * CfnDocumentClassifier cfnDocumentClassifier = CfnDocumentClassifier.Builder.create(this, "MyCfnDocumentClassifier")
 *         .dataAccessRoleArn("dataAccessRoleArn")
 *         .documentClassifierName("documentClassifierName")
 *         .inputDataConfig(DocumentClassifierInputDataConfigProperty.builder()
 *                 .augmentedManifests(List.of(AugmentedManifestsListItemProperty.builder()
 *                         .attributeNames(List.of("attributeNames"))
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .split("split")
 *                         .build()))
 *                 .dataFormat("dataFormat")
 *                 .documentReaderConfig(DocumentReaderConfigProperty.builder()
 *                         .documentReadAction("documentReadAction")
 *                         // the properties below are optional
 *                         .documentReadMode("documentReadMode")
 *                         .featureTypes(List.of("featureTypes"))
 *                         .build())
 *                 .documents(DocumentClassifierDocumentsProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .testS3Uri("testS3Uri")
 *                         .build())
 *                 .documentType("documentType")
 *                 .labelDelimiter("labelDelimiter")
 *                 .s3Uri("s3Uri")
 *                 .testS3Uri("testS3Uri")
 *                 .build())
 *         .languageCode("languageCode")
 *         // the properties below are optional
 *         .mode("mode")
 *         .modelKmsKeyId("modelKmsKeyId")
 *         .modelPolicy("modelPolicy")
 *         .outputDataConfig(DocumentClassifierOutputDataConfigProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .s3Uri("s3Uri")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionName("versionName")
 *         .volumeKmsKeyId("volumeKmsKeyId")
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:25.805Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier")
public class CfnDocumentClassifier extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDocumentClassifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDocumentClassifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDocumentClassifier(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.comprehend.CfnDocumentClassifierProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the document classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataAccessRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "dataAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataAccessRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataAccessRoleArn", java.util.Objects.requireNonNull(value, "dataAccessRoleArn is required"));
    }

    /**
     * The name of the document classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDocumentClassifierName() {
        return software.amazon.jsii.Kernel.get(this, "documentClassifierName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the document classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentClassifierName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "documentClassifierName", java.util.Objects.requireNonNull(value, "documentClassifierName is required"));
    }

    /**
     * Specifies the format and location of the input data for the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputDataConfig() {
        return software.amazon.jsii.Kernel.get(this, "inputDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the format and location of the input data for the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputDataConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputDataConfig", java.util.Objects.requireNonNull(value, "inputDataConfig is required"));
    }

    /**
     * Specifies the format and location of the input data for the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputDataConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierInputDataConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputDataConfig", java.util.Objects.requireNonNull(value, "inputDataConfig is required"));
    }

    /**
     * The language of the input documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLanguageCode() {
        return software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The language of the input documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLanguageCode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "languageCode", java.util.Objects.requireNonNull(value, "languageCode is required"));
    }

    /**
     * Indicates the mode in which the classifier will be trained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the mode in which the classifier will be trained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mode", value);
    }

    /**
     * ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "modelKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelKmsKeyId", value);
    }

    /**
     * The resource-based policy to attach to your custom document classifier model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getModelPolicy() {
        return software.amazon.jsii.Kernel.get(this, "modelPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource-based policy to attach to your custom document classifier model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelPolicy", value);
    }

    /**
     * Provides output results configuration parameters for custom classifier jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputDataConfig() {
        return software.amazon.jsii.Kernel.get(this, "outputDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides output results configuration parameters for custom classifier jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputDataConfig", value);
    }

    /**
     * Provides output results configuration parameters for custom classifier jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierOutputDataConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputDataConfig", value);
    }

    /**
     * Tags to associate with the document classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to associate with the document classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The version name given to the newly created classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionName() {
        return software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version name given to the newly created classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionName", value);
    }

    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "volumeKmsKeyId", value);
    }

    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * An augmented manifest file that provides training data for your custom model.
     * <p>
     * An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * AugmentedManifestsListItemProperty augmentedManifestsListItemProperty = AugmentedManifestsListItemProperty.builder()
     *         .attributeNames(List.of("attributeNames"))
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .split("split")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.AugmentedManifestsListItemProperty")
    @software.amazon.jsii.Jsii.Proxy(AugmentedManifestsListItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AugmentedManifestsListItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JSON attribute that contains the annotations for your training documents.
         * <p>
         * The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
         * <p>
         * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
         * <p>
         * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-attributenames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-attributenames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttributeNames();

        /**
         * The Amazon S3 location of the augmented manifest file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The purpose of the data you've provided in the augmented manifest.
         * <p>
         * You can either train or test this data. If you don't specify, the default is train.
         * <p>
         * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
         * <p>
         * TEST - all of the documents in the manifest will be used for testing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-split">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-augmentedmanifestslistitem.html#cfn-comprehend-documentclassifier-augmentedmanifestslistitem-split</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSplit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AugmentedManifestsListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AugmentedManifestsListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AugmentedManifestsListItemProperty> {
            java.util.List<java.lang.String> attributeNames;
            java.lang.String s3Uri;
            java.lang.String split;

            /**
             * Sets the value of {@link AugmentedManifestsListItemProperty#getAttributeNames}
             * @param attributeNames The JSON attribute that contains the annotations for your training documents. This parameter is required.
             *                       The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
             *                       <p>
             *                       If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
             *                       <p>
             *                       If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeNames(java.util.List<java.lang.String> attributeNames) {
                this.attributeNames = attributeNames;
                return this;
            }

            /**
             * Sets the value of {@link AugmentedManifestsListItemProperty#getS3Uri}
             * @param s3Uri The Amazon S3 location of the augmented manifest file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link AugmentedManifestsListItemProperty#getSplit}
             * @param split The purpose of the data you've provided in the augmented manifest.
             *              You can either train or test this data. If you don't specify, the default is train.
             *              <p>
             *              TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
             *              <p>
             *              TEST - all of the documents in the manifest will be used for testing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder split(java.lang.String split) {
                this.split = split;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AugmentedManifestsListItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AugmentedManifestsListItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AugmentedManifestsListItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AugmentedManifestsListItemProperty {
            private final java.util.List<java.lang.String> attributeNames;
            private final java.lang.String s3Uri;
            private final java.lang.String split;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeNames = software.amazon.jsii.Kernel.get(this, "attributeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.split = software.amazon.jsii.Kernel.get(this, "split", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeNames = java.util.Objects.requireNonNull(builder.attributeNames, "attributeNames is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.split = builder.split;
            }

            @Override
            public final java.util.List<java.lang.String> getAttributeNames() {
                return this.attributeNames;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getSplit() {
                return this.split;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeNames", om.valueToTree(this.getAttributeNames()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getSplit() != null) {
                    data.set("split", om.valueToTree(this.getSplit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.AugmentedManifestsListItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AugmentedManifestsListItemProperty.Jsii$Proxy that = (AugmentedManifestsListItemProperty.Jsii$Proxy) o;

                if (!attributeNames.equals(that.attributeNames)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.split != null ? this.split.equals(that.split) : that.split == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeNames.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.split != null ? this.split.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location of the training documents.
     * <p>
     * This parameter is required in a request to create a semi-structured document classification model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * DocumentClassifierDocumentsProperty documentClassifierDocumentsProperty = DocumentClassifierDocumentsProperty.builder()
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .testS3Uri("testS3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierDocumentsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentClassifierDocumentsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentClassifierDocumentsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 URI location of the training documents specified in the S3Uri CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html#cfn-comprehend-documentclassifier-documentclassifierdocuments-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html#cfn-comprehend-documentclassifier-documentclassifierdocuments-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The S3 URI location of the test documents included in the TestS3Uri CSV file.
         * <p>
         * This field is not required if you do not specify a test CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html#cfn-comprehend-documentclassifier-documentclassifierdocuments-tests3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierdocuments.html#cfn-comprehend-documentclassifier-documentclassifierdocuments-tests3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTestS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentClassifierDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentClassifierDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentClassifierDocumentsProperty> {
            java.lang.String s3Uri;
            java.lang.String testS3Uri;

            /**
             * Sets the value of {@link DocumentClassifierDocumentsProperty#getS3Uri}
             * @param s3Uri The S3 URI location of the training documents specified in the S3Uri CSV file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierDocumentsProperty#getTestS3Uri}
             * @param testS3Uri The S3 URI location of the test documents included in the TestS3Uri CSV file.
             *                  This field is not required if you do not specify a test CSV file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder testS3Uri(java.lang.String testS3Uri) {
                this.testS3Uri = testS3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentClassifierDocumentsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentClassifierDocumentsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentClassifierDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentClassifierDocumentsProperty {
            private final java.lang.String s3Uri;
            private final java.lang.String testS3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.testS3Uri = software.amazon.jsii.Kernel.get(this, "testS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.testS3Uri = builder.testS3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getTestS3Uri() {
                return this.testS3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getTestS3Uri() != null) {
                    data.set("testS3Uri", om.valueToTree(this.getTestS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierDocumentsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentClassifierDocumentsProperty.Jsii$Proxy that = (DocumentClassifierDocumentsProperty.Jsii$Proxy) o;

                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.testS3Uri != null ? this.testS3Uri.equals(that.testS3Uri) : that.testS3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri.hashCode();
                result = 31 * result + (this.testS3Uri != null ? this.testS3Uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The input properties for training a document classifier.
     * <p>
     * For more information on how the input file is formatted, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in the Comprehend Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * DocumentClassifierInputDataConfigProperty documentClassifierInputDataConfigProperty = DocumentClassifierInputDataConfigProperty.builder()
     *         .augmentedManifests(List.of(AugmentedManifestsListItemProperty.builder()
     *                 .attributeNames(List.of("attributeNames"))
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .split("split")
     *                 .build()))
     *         .dataFormat("dataFormat")
     *         .documentReaderConfig(DocumentReaderConfigProperty.builder()
     *                 .documentReadAction("documentReadAction")
     *                 // the properties below are optional
     *                 .documentReadMode("documentReadMode")
     *                 .featureTypes(List.of("featureTypes"))
     *                 .build())
     *         .documents(DocumentClassifierDocumentsProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .testS3Uri("testS3Uri")
     *                 .build())
     *         .documentType("documentType")
     *         .labelDelimiter("labelDelimiter")
     *         .s3Uri("s3Uri")
     *         .testS3Uri("testS3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierInputDataConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentClassifierInputDataConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentClassifierInputDataConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of augmented manifest files that provide training data for your custom model.
         * <p>
         * An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         * <p>
         * This parameter is required if you set <code>DataFormat</code> to <code>AUGMENTED_MANIFEST</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-augmentedmanifests">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-augmentedmanifests</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAugmentedManifests() {
            return null;
        }

        /**
         * The format of your training data:.
         * <p>
         * <ul>
         * <li><code>COMPREHEND_CSV</code> : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the <code>S3Uri</code> parameter in your request.</li>
         * <li><code>AUGMENTED_MANIFEST</code> : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.</li>
         * </ul>
         * <p>
         * If you use this value, you must provide the <code>AugmentedManifests</code> parameter in your request.
         * <p>
         * If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-dataformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-dataformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataFormat() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documentreaderconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documentreaderconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentReaderConfig() {
            return null;
        }

        /**
         * The S3 location of the training documents.
         * <p>
         * This parameter is required in a request to create a native document model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocuments() {
            return null;
        }

        /**
         * The type of input documents for training the model.
         * <p>
         * Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-documenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentType() {
            return null;
        }

        /**
         * Indicates the delimiter used to separate each label for training a multi-label classifier.
         * <p>
         * The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-labeldelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-labeldelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabelDelimiter() {
            return null;
        }

        /**
         * The Amazon S3 URI for the input data.
         * <p>
         * The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
         * <p>
         * For example, if you use the URI <code>S3://bucketName/prefix</code> , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
         * <p>
         * This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * This specifies the Amazon S3 location that contains the test annotations for the document classifier.
         * <p>
         * The URI must be in the same AWS Region as the API endpoint that you are calling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-tests3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifierinputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifierinputdataconfig-tests3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTestS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentClassifierInputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentClassifierInputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentClassifierInputDataConfigProperty> {
            java.lang.Object augmentedManifests;
            java.lang.String dataFormat;
            java.lang.Object documentReaderConfig;
            java.lang.Object documents;
            java.lang.String documentType;
            java.lang.String labelDelimiter;
            java.lang.String s3Uri;
            java.lang.String testS3Uri;

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getAugmentedManifests}
             * @param augmentedManifests A list of augmented manifest files that provide training data for your custom model.
             *                           An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
             *                           <p>
             *                           This parameter is required if you set <code>DataFormat</code> to <code>AUGMENTED_MANIFEST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder augmentedManifests(software.amazon.awscdk.IResolvable augmentedManifests) {
                this.augmentedManifests = augmentedManifests;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getAugmentedManifests}
             * @param augmentedManifests A list of augmented manifest files that provide training data for your custom model.
             *                           An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
             *                           <p>
             *                           This parameter is required if you set <code>DataFormat</code> to <code>AUGMENTED_MANIFEST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder augmentedManifests(java.util.List<? extends java.lang.Object> augmentedManifests) {
                this.augmentedManifests = augmentedManifests;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDataFormat}
             * @param dataFormat The format of your training data:.
             *                   <ul>
             *                   <li><code>COMPREHEND_CSV</code> : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the <code>S3Uri</code> parameter in your request.</li>
             *                   <li><code>AUGMENTED_MANIFEST</code> : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.</li>
             *                   </ul>
             *                   <p>
             *                   If you use this value, you must provide the <code>AugmentedManifests</code> parameter in your request.
             *                   <p>
             *                   If you don't specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormat(java.lang.String dataFormat) {
                this.dataFormat = dataFormat;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDocumentReaderConfig}
             * @param documentReaderConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentReaderConfig(software.amazon.awscdk.IResolvable documentReaderConfig) {
                this.documentReaderConfig = documentReaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDocumentReaderConfig}
             * @param documentReaderConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentReaderConfig(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentReaderConfigProperty documentReaderConfig) {
                this.documentReaderConfig = documentReaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDocuments}
             * @param documents The S3 location of the training documents.
             *                  This parameter is required in a request to create a native document model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documents(software.amazon.awscdk.IResolvable documents) {
                this.documents = documents;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDocuments}
             * @param documents The S3 location of the training documents.
             *                  This parameter is required in a request to create a native document model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documents(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierDocumentsProperty documents) {
                this.documents = documents;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getDocumentType}
             * @param documentType The type of input documents for training the model.
             *                     Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentType(java.lang.String documentType) {
                this.documentType = documentType;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getLabelDelimiter}
             * @param labelDelimiter Indicates the delimiter used to separate each label for training a multi-label classifier.
             *                       The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelDelimiter(java.lang.String labelDelimiter) {
                this.labelDelimiter = labelDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getS3Uri}
             * @param s3Uri The Amazon S3 URI for the input data.
             *              The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
             *              <p>
             *              For example, if you use the URI <code>S3://bucketName/prefix</code> , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
             *              <p>
             *              This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierInputDataConfigProperty#getTestS3Uri}
             * @param testS3Uri This specifies the Amazon S3 location that contains the test annotations for the document classifier.
             *                  The URI must be in the same AWS Region as the API endpoint that you are calling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder testS3Uri(java.lang.String testS3Uri) {
                this.testS3Uri = testS3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentClassifierInputDataConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentClassifierInputDataConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentClassifierInputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentClassifierInputDataConfigProperty {
            private final java.lang.Object augmentedManifests;
            private final java.lang.String dataFormat;
            private final java.lang.Object documentReaderConfig;
            private final java.lang.Object documents;
            private final java.lang.String documentType;
            private final java.lang.String labelDelimiter;
            private final java.lang.String s3Uri;
            private final java.lang.String testS3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.augmentedManifests = software.amazon.jsii.Kernel.get(this, "augmentedManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentReaderConfig = software.amazon.jsii.Kernel.get(this, "documentReaderConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documents = software.amazon.jsii.Kernel.get(this, "documents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentType = software.amazon.jsii.Kernel.get(this, "documentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.labelDelimiter = software.amazon.jsii.Kernel.get(this, "labelDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.testS3Uri = software.amazon.jsii.Kernel.get(this, "testS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.augmentedManifests = builder.augmentedManifests;
                this.dataFormat = builder.dataFormat;
                this.documentReaderConfig = builder.documentReaderConfig;
                this.documents = builder.documents;
                this.documentType = builder.documentType;
                this.labelDelimiter = builder.labelDelimiter;
                this.s3Uri = builder.s3Uri;
                this.testS3Uri = builder.testS3Uri;
            }

            @Override
            public final java.lang.Object getAugmentedManifests() {
                return this.augmentedManifests;
            }

            @Override
            public final java.lang.String getDataFormat() {
                return this.dataFormat;
            }

            @Override
            public final java.lang.Object getDocumentReaderConfig() {
                return this.documentReaderConfig;
            }

            @Override
            public final java.lang.Object getDocuments() {
                return this.documents;
            }

            @Override
            public final java.lang.String getDocumentType() {
                return this.documentType;
            }

            @Override
            public final java.lang.String getLabelDelimiter() {
                return this.labelDelimiter;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getTestS3Uri() {
                return this.testS3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAugmentedManifests() != null) {
                    data.set("augmentedManifests", om.valueToTree(this.getAugmentedManifests()));
                }
                if (this.getDataFormat() != null) {
                    data.set("dataFormat", om.valueToTree(this.getDataFormat()));
                }
                if (this.getDocumentReaderConfig() != null) {
                    data.set("documentReaderConfig", om.valueToTree(this.getDocumentReaderConfig()));
                }
                if (this.getDocuments() != null) {
                    data.set("documents", om.valueToTree(this.getDocuments()));
                }
                if (this.getDocumentType() != null) {
                    data.set("documentType", om.valueToTree(this.getDocumentType()));
                }
                if (this.getLabelDelimiter() != null) {
                    data.set("labelDelimiter", om.valueToTree(this.getLabelDelimiter()));
                }
                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }
                if (this.getTestS3Uri() != null) {
                    data.set("testS3Uri", om.valueToTree(this.getTestS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierInputDataConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentClassifierInputDataConfigProperty.Jsii$Proxy that = (DocumentClassifierInputDataConfigProperty.Jsii$Proxy) o;

                if (this.augmentedManifests != null ? !this.augmentedManifests.equals(that.augmentedManifests) : that.augmentedManifests != null) return false;
                if (this.dataFormat != null ? !this.dataFormat.equals(that.dataFormat) : that.dataFormat != null) return false;
                if (this.documentReaderConfig != null ? !this.documentReaderConfig.equals(that.documentReaderConfig) : that.documentReaderConfig != null) return false;
                if (this.documents != null ? !this.documents.equals(that.documents) : that.documents != null) return false;
                if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) return false;
                if (this.labelDelimiter != null ? !this.labelDelimiter.equals(that.labelDelimiter) : that.labelDelimiter != null) return false;
                if (this.s3Uri != null ? !this.s3Uri.equals(that.s3Uri) : that.s3Uri != null) return false;
                return this.testS3Uri != null ? this.testS3Uri.equals(that.testS3Uri) : that.testS3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.augmentedManifests != null ? this.augmentedManifests.hashCode() : 0;
                result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
                result = 31 * result + (this.documentReaderConfig != null ? this.documentReaderConfig.hashCode() : 0);
                result = 31 * result + (this.documents != null ? this.documents.hashCode() : 0);
                result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
                result = 31 * result + (this.labelDelimiter != null ? this.labelDelimiter.hashCode() : 0);
                result = 31 * result + (this.s3Uri != null ? this.s3Uri.hashCode() : 0);
                result = 31 * result + (this.testS3Uri != null ? this.testS3Uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provide the location for output data from a custom classifier job.
     * <p>
     * This field is mandatory if you are training a native document model.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * DocumentClassifierOutputDataConfigProperty documentClassifierOutputDataConfigProperty = DocumentClassifierOutputDataConfigProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierOutputDataConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentClassifierOutputDataConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentClassifierOutputDataConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job.
         * <p>
         * The KmsKeyId can be one of the following formats:
         * <p>
         * <ul>
         * <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * <li>KMS Key Alias: <code>"alias/ExampleAlias"</code></li>
         * <li>ARN of a KMS Key Alias: <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifieroutputdataconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifieroutputdataconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * When you use the <code>OutputDataConfig</code> object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files.
         * <p>
         * The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.
         * <p>
         * When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The <code>S3Uri</code> field contains the location of the output file, called <code>output.tar.gz</code> . It is a compressed archive that contains the confusion matrix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifieroutputdataconfig-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentclassifieroutputdataconfig.html#cfn-comprehend-documentclassifier-documentclassifieroutputdataconfig-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentClassifierOutputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentClassifierOutputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentClassifierOutputDataConfigProperty> {
            java.lang.String kmsKeyId;
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link DocumentClassifierOutputDataConfigProperty#getKmsKeyId}
             * @param kmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job.
             *                 The KmsKeyId can be one of the following formats:
             *                 <p>
             *                 <ul>
             *                 <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
             *                 <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
             *                 <li>KMS Key Alias: <code>"alias/ExampleAlias"</code></li>
             *                 <li>ARN of a KMS Key Alias: <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code></li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link DocumentClassifierOutputDataConfigProperty#getS3Uri}
             * @param s3Uri When you use the <code>OutputDataConfig</code> object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files.
             *              The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.
             *              <p>
             *              When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The <code>S3Uri</code> field contains the location of the output file, called <code>output.tar.gz</code> . It is a compressed archive that contains the confusion matrix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentClassifierOutputDataConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentClassifierOutputDataConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentClassifierOutputDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentClassifierOutputDataConfigProperty {
            private final java.lang.String kmsKeyId;
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
                this.s3Uri = builder.s3Uri;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentClassifierOutputDataConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentClassifierOutputDataConfigProperty.Jsii$Proxy that = (DocumentClassifierOutputDataConfigProperty.Jsii$Proxy) o;

                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                result = 31 * result + (this.s3Uri != null ? this.s3Uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
     * <p>
     * By default, Amazon Comprehend performs the following actions to extract text from files, based on the input file type:
     * <p>
     * <ul>
     * <li><em>Word files</em> - Amazon Comprehend parser extracts the text.</li>
     * <li><em>Digital PDF files</em> - Amazon Comprehend parser extracts the text.</li>
     * <li><em>Image files and scanned PDF files</em> - Amazon Comprehend uses the Amazon Textract <code>DetectDocumentText</code> API to extract the text.</li>
     * </ul>
     * <p>
     * <code>DocumentReaderConfig</code> does not apply to plain text files or Word files.
     * <p>
     * For image files and PDF documents, you can override these default actions using the fields listed below. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html">Setting text extraction options</a> in the Comprehend Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * DocumentReaderConfigProperty documentReaderConfigProperty = DocumentReaderConfigProperty.builder()
     *         .documentReadAction("documentReadAction")
     *         // the properties below are optional
     *         .documentReadMode("documentReadMode")
     *         .featureTypes(List.of("featureTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentReaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentReaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentReaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files.
         * <p>
         * Enter one of the following values:
         * <p>
         * <ul>
         * <li><code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The Amazon Comprehend service uses the <code>DetectDocumentText</code> API operation.</li>
         * <li><code>TEXTRACT_ANALYZE_DOCUMENT</code> - The Amazon Comprehend service uses the <code>AnalyzeDocument</code> API operation.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-documentreadaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-documentreadaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentReadAction();

        /**
         * Determines the text extraction actions for PDF files. Enter one of the following values:.
         * <p>
         * <ul>
         * <li><code>SERVICE_DEFAULT</code> - use the Amazon Comprehend service defaults for PDF files.</li>
         * <li><code>FORCE_DOCUMENT_READ_ACTION</code> - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-documentreadmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-documentreadmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentReadMode() {
            return null;
        }

        /**
         * Specifies the type of Amazon Textract features to apply.
         * <p>
         * If you chose <code>TEXTRACT_ANALYZE_DOCUMENT</code> as the read action, you must specify one or both of the following values:
         * <p>
         * <ul>
         * <li><code>TABLES</code> - Returns additional information about any tables that are detected in the input document.</li>
         * <li><code>FORMS</code> - Returns additional information about any forms that are detected in the input document.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-featuretypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-documentreaderconfig.html#cfn-comprehend-documentclassifier-documentreaderconfig-featuretypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFeatureTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentReaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentReaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentReaderConfigProperty> {
            java.lang.String documentReadAction;
            java.lang.String documentReadMode;
            java.util.List<java.lang.String> featureTypes;

            /**
             * Sets the value of {@link DocumentReaderConfigProperty#getDocumentReadAction}
             * @param documentReadAction This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. This parameter is required.
             *                           Enter one of the following values:
             *                           <p>
             *                           <ul>
             *                           <li><code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The Amazon Comprehend service uses the <code>DetectDocumentText</code> API operation.</li>
             *                           <li><code>TEXTRACT_ANALYZE_DOCUMENT</code> - The Amazon Comprehend service uses the <code>AnalyzeDocument</code> API operation.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentReadAction(java.lang.String documentReadAction) {
                this.documentReadAction = documentReadAction;
                return this;
            }

            /**
             * Sets the value of {@link DocumentReaderConfigProperty#getDocumentReadMode}
             * @param documentReadMode Determines the text extraction actions for PDF files. Enter one of the following values:.
             *                         <ul>
             *                         <li><code>SERVICE_DEFAULT</code> - use the Amazon Comprehend service defaults for PDF files.</li>
             *                         <li><code>FORCE_DOCUMENT_READ_ACTION</code> - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentReadMode(java.lang.String documentReadMode) {
                this.documentReadMode = documentReadMode;
                return this;
            }

            /**
             * Sets the value of {@link DocumentReaderConfigProperty#getFeatureTypes}
             * @param featureTypes Specifies the type of Amazon Textract features to apply.
             *                     If you chose <code>TEXTRACT_ANALYZE_DOCUMENT</code> as the read action, you must specify one or both of the following values:
             *                     <p>
             *                     <ul>
             *                     <li><code>TABLES</code> - Returns additional information about any tables that are detected in the input document.</li>
             *                     <li><code>FORMS</code> - Returns additional information about any forms that are detected in the input document.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTypes(java.util.List<java.lang.String> featureTypes) {
                this.featureTypes = featureTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentReaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentReaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentReaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentReaderConfigProperty {
            private final java.lang.String documentReadAction;
            private final java.lang.String documentReadMode;
            private final java.util.List<java.lang.String> featureTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentReadAction = software.amazon.jsii.Kernel.get(this, "documentReadAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentReadMode = software.amazon.jsii.Kernel.get(this, "documentReadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureTypes = software.amazon.jsii.Kernel.get(this, "featureTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentReadAction = java.util.Objects.requireNonNull(builder.documentReadAction, "documentReadAction is required");
                this.documentReadMode = builder.documentReadMode;
                this.featureTypes = builder.featureTypes;
            }

            @Override
            public final java.lang.String getDocumentReadAction() {
                return this.documentReadAction;
            }

            @Override
            public final java.lang.String getDocumentReadMode() {
                return this.documentReadMode;
            }

            @Override
            public final java.util.List<java.lang.String> getFeatureTypes() {
                return this.featureTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentReadAction", om.valueToTree(this.getDocumentReadAction()));
                if (this.getDocumentReadMode() != null) {
                    data.set("documentReadMode", om.valueToTree(this.getDocumentReadMode()));
                }
                if (this.getFeatureTypes() != null) {
                    data.set("featureTypes", om.valueToTree(this.getFeatureTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.DocumentReaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentReaderConfigProperty.Jsii$Proxy that = (DocumentReaderConfigProperty.Jsii$Proxy) o;

                if (!documentReadAction.equals(that.documentReadAction)) return false;
                if (this.documentReadMode != null ? !this.documentReadMode.equals(that.documentReadMode) : that.documentReadMode != null) return false;
                return this.featureTypes != null ? this.featureTypes.equals(that.featureTypes) : that.featureTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentReadAction.hashCode();
                result = 31 * result + (this.documentReadMode != null ? this.documentReadMode.hashCode() : 0);
                result = 31 * result + (this.featureTypes != null ? this.featureTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.comprehend.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID number for a security group on an instance of your private VPC.
         * <p>
         * Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for your VPC</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html#cfn-comprehend-documentclassifier-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html#cfn-comprehend-documentclassifier-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID for each subnet being used in your private VPC.
         * <p>
         * This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html#cfn-comprehend-documentclassifier-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-comprehend-documentclassifier-vpcconfig.html#cfn-comprehend-documentclassifier-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The ID number for a security group on an instance of your private VPC. This parameter is required.
             *                         Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for your VPC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID for each subnet being used in your private VPC. This parameter is required.
             *                This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifier.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.comprehend.CfnDocumentClassifier}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.comprehend.CfnDocumentClassifier> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.comprehend.CfnDocumentClassifierProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.comprehend.CfnDocumentClassifierProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-dataaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-dataaccessrolearn</a>
         * @param dataAccessRoleArn The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataAccessRoleArn(final java.lang.String dataAccessRoleArn) {
            this.props.dataAccessRoleArn(dataAccessRoleArn);
            return this;
        }

        /**
         * The name of the document classifier.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-documentclassifiername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-documentclassifiername</a>
         * @param documentClassifierName The name of the document classifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentClassifierName(final java.lang.String documentClassifierName) {
            this.props.documentClassifierName(documentClassifierName);
            return this;
        }

        /**
         * Specifies the format and location of the input data for the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig</a>
         * @param inputDataConfig Specifies the format and location of the input data for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDataConfig(final software.amazon.awscdk.IResolvable inputDataConfig) {
            this.props.inputDataConfig(inputDataConfig);
            return this;
        }
        /**
         * Specifies the format and location of the input data for the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig</a>
         * @param inputDataConfig Specifies the format and location of the input data for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDataConfig(final software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierInputDataConfigProperty inputDataConfig) {
            this.props.inputDataConfig(inputDataConfig);
            return this;
        }

        /**
         * The language of the input documents.
         * <p>
         * You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-languagecode</a>
         * @param languageCode The language of the input documents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder languageCode(final java.lang.String languageCode) {
            this.props.languageCode(languageCode);
            return this;
        }

        /**
         * Indicates the mode in which the classifier will be trained.
         * <p>
         * The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-mode</a>
         * @param mode Indicates the mode in which the classifier will be trained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(final java.lang.String mode) {
            this.props.mode(mode);
            return this;
        }

        /**
         * ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models.
         * <p>
         * The ModelKmsKeyId can be either of the following formats:
         * <p>
         * <ul>
         * <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelkmskeyid</a>
         * @param modelKmsKeyId ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelKmsKeyId(final java.lang.String modelKmsKeyId) {
            this.props.modelKmsKeyId(modelKmsKeyId);
            return this;
        }

        /**
         * The resource-based policy to attach to your custom document classifier model.
         * <p>
         * You can use this policy to allow another AWS account to import your custom model.
         * <p>
         * Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:
         * <p>
         * <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code>
         * <p>
         * To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:
         * <p>
         * <code>'{"attribute": "value", "attribute": ["value"]}'</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelpolicy</a>
         * @param modelPolicy The resource-based policy to attach to your custom document classifier model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPolicy(final java.lang.String modelPolicy) {
            this.props.modelPolicy(modelPolicy);
            return this;
        }

        /**
         * Provides output results configuration parameters for custom classifier jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig</a>
         * @param outputDataConfig Provides output results configuration parameters for custom classifier jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputDataConfig(final software.amazon.awscdk.IResolvable outputDataConfig) {
            this.props.outputDataConfig(outputDataConfig);
            return this;
        }
        /**
         * Provides output results configuration parameters for custom classifier jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig</a>
         * @param outputDataConfig Provides output results configuration parameters for custom classifier jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputDataConfig(final software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierOutputDataConfigProperty outputDataConfig) {
            this.props.outputDataConfig(outputDataConfig);
            return this;
        }

        /**
         * Tags to associate with the document classifier.
         * <p>
         * A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-tags</a>
         * @param tags Tags to associate with the document classifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The version name given to the newly created classifier.
         * <p>
         * Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-versionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-versionname</a>
         * @param versionName The version name given to the newly created classifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(final java.lang.String versionName) {
            this.props.versionName(versionName);
            return this;
        }

        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job.
         * <p>
         * The VolumeKmsKeyId can be either of the following formats:
         * <p>
         * <ul>
         * <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-volumekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-volumekmskeyid</a>
         * @param volumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeKmsKeyId(final java.lang.String volumeKmsKeyId) {
            this.props.volumeKmsKeyId(volumeKmsKeyId);
            return this;
        }

        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig</a>
         * @param vpcConfig Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig</a>
         * @param vpcConfig Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.comprehend.CfnDocumentClassifier}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.comprehend.CfnDocumentClassifier build() {
            return new software.amazon.awscdk.services.comprehend.CfnDocumentClassifier(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
