package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnViewVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnViewVersionProps cfnViewVersionProps = CfnViewVersionProps.builder()
 *         .viewArn("viewArn")
 *         // the properties below are optional
 *         .versionDescription("versionDescription")
 *         .viewContentSha256("viewContentSha256")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:26.037Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnViewVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnViewVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnViewVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unqualified Amazon Resource Name (ARN) of the view.
     * <p>
     * For example:
     * <p>
     * <code>arn:&lt;partition&gt;:connect:&lt;region&gt;:&lt;accountId&gt;:instance/00000000-0000-0000-0000-000000000000/view/00000000-0000-0000-0000-000000000000</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-viewarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-viewarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getViewArn();

    /**
     * The description of the view version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-versiondescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return null;
    }

    /**
     * Indicates the checksum value of the latest published view content.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-viewcontentsha256">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-viewversion.html#cfn-connect-viewversion-viewcontentsha256</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getViewContentSha256() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnViewVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnViewVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnViewVersionProps> {
        java.lang.String viewArn;
        java.lang.String versionDescription;
        java.lang.String viewContentSha256;

        /**
         * Sets the value of {@link CfnViewVersionProps#getViewArn}
         * @param viewArn The unqualified Amazon Resource Name (ARN) of the view. This parameter is required.
         *                For example:
         *                <p>
         *                <code>arn:&lt;partition&gt;:connect:&lt;region&gt;:&lt;accountId&gt;:instance/00000000-0000-0000-0000-000000000000/view/00000000-0000-0000-0000-000000000000</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewArn(java.lang.String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewVersionProps#getVersionDescription}
         * @param versionDescription The description of the view version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(java.lang.String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnViewVersionProps#getViewContentSha256}
         * @param viewContentSha256 Indicates the checksum value of the latest published view content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewContentSha256(java.lang.String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnViewVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnViewVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnViewVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnViewVersionProps {
        private final java.lang.String viewArn;
        private final java.lang.String versionDescription;
        private final java.lang.String viewContentSha256;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.viewArn = software.amazon.jsii.Kernel.get(this, "viewArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionDescription = software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.viewContentSha256 = software.amazon.jsii.Kernel.get(this, "viewContentSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.viewArn = java.util.Objects.requireNonNull(builder.viewArn, "viewArn is required");
            this.versionDescription = builder.versionDescription;
            this.viewContentSha256 = builder.viewContentSha256;
        }

        @Override
        public final java.lang.String getViewArn() {
            return this.viewArn;
        }

        @Override
        public final java.lang.String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        public final java.lang.String getViewContentSha256() {
            return this.viewContentSha256;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("viewArn", om.valueToTree(this.getViewArn()));
            if (this.getVersionDescription() != null) {
                data.set("versionDescription", om.valueToTree(this.getVersionDescription()));
            }
            if (this.getViewContentSha256() != null) {
                data.set("viewContentSha256", om.valueToTree(this.getViewContentSha256()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnViewVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnViewVersionProps.Jsii$Proxy that = (CfnViewVersionProps.Jsii$Proxy) o;

            if (!viewArn.equals(that.viewArn)) return false;
            if (this.versionDescription != null ? !this.versionDescription.equals(that.versionDescription) : that.versionDescription != null) return false;
            return this.viewContentSha256 != null ? this.viewContentSha256.equals(that.viewContentSha256) : that.viewContentSha256 == null;
        }

        @Override
        public final int hashCode() {
            int result = this.viewArn.hashCode();
            result = 31 * result + (this.versionDescription != null ? this.versionDescription.hashCode() : 0);
            result = 31 * result + (this.viewContentSha256 != null ? this.viewContentSha256.hashCode() : 0);
            return result;
        }
    }
}
