package software.amazon.awscdk.services.connectcampaignsv2;

/**
 * Creates an outbound campaign.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>For users to be able to view or edit a campaign at a later date by using the Amazon Connect user interface, you must add the instance ID as a tag. For example, <code>{ "tags": {"owner": "arn:aws:connect:{REGION}:{AWS_ACCOUNT_ID}:instance/{CONNECT_INSTANCE_ID}"}}</code> .</li>
 * <li>After a campaign is created, you can't add/remove source.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaignsv2.*;
 * Object agentlessConfig;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .channelSubtypeConfig(ChannelSubtypeConfigProperty.builder()
 *                 .email(EmailChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
 *                                 .connectSourceEmailAddress("connectSourceEmailAddress")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 // the properties below are optional
 *                                 .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
 *                                 .build())
 *                         .outboundMode(EmailOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .sms(SmsChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
 *                                 .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 .build())
 *                         .outboundMode(SmsOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .telephony(TelephonyChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
 *                                 .connectContactFlowId("connectContactFlowId")
 *                                 // the properties below are optional
 *                                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
 *                                         .enableAnswerMachineDetection(false)
 *                                         // the properties below are optional
 *                                         .awaitAnswerMachinePrompt(false)
 *                                         .build())
 *                                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                                 .build())
 *                         .outboundMode(TelephonyOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .predictiveConfig(PredictiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .progressiveConfig(ProgressiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .connectQueueId("connectQueueId")
 *                         .build())
 *                 .build())
 *         .connectInstanceId("connectInstanceId")
 *         .name("name")
 *         // the properties below are optional
 *         .communicationLimitsOverride(CommunicationLimitsConfigProperty.builder()
 *                 .allChannelsSubtypes(CommunicationLimitsProperty.builder()
 *                         .communicationLimitList(List.of(CommunicationLimitProperty.builder()
 *                                 .frequency(123)
 *                                 .maxCountPerRecipient(123)
 *                                 .unit("unit")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .communicationTimeConfig(CommunicationTimeConfigProperty.builder()
 *                 .localTimeZoneConfig(LocalTimeZoneConfigProperty.builder()
 *                         .defaultTimeZone("defaultTimeZone")
 *                         .localTimeZoneDetection(List.of("localTimeZoneDetection"))
 *                         .build())
 *                 // the properties below are optional
 *                 .email(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .sms(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .telephony(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .connectCampaignFlowArn("connectCampaignFlowArn")
 *         .schedule(ScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .startTime("startTime")
 *                 // the properties below are optional
 *                 .refreshFrequency("refreshFrequency")
 *                 .build())
 *         .source(SourceProperty.builder()
 *                 .customerProfilesSegmentArn("customerProfilesSegmentArn")
 *                 .eventTrigger(EventTriggerProperty.builder()
 *                         .customerProfilesDomainArn("customerProfilesDomainArn")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:26.044Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains channel subtype configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getChannelSubtypeConfig() {
        return software.amazon.jsii.Kernel.get(this, "channelSubtypeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains channel subtype configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelSubtypeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "channelSubtypeConfig", java.util.Objects.requireNonNull(value, "channelSubtypeConfig is required"));
    }

    /**
     * Contains channel subtype configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelSubtypeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "channelSubtypeConfig", java.util.Objects.requireNonNull(value, "channelSubtypeConfig is required"));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "connectInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectInstanceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectInstanceId", java.util.Objects.requireNonNull(value, "connectInstanceId is required"));
    }

    /**
     * The name of the outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Communication limits configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationLimitsOverride() {
        return software.amazon.jsii.Kernel.get(this, "communicationLimitsOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Communication limits configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationLimitsOverride(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "communicationLimitsOverride", value);
    }

    /**
     * Communication limits configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationLimitsOverride(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "communicationLimitsOverride", value);
    }

    /**
     * Contains communication time configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationTimeConfig() {
        return software.amazon.jsii.Kernel.get(this, "communicationTimeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains communication time configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationTimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "communicationTimeConfig", value);
    }

    /**
     * Contains communication time configuration for an outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationTimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "communicationTimeConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectCampaignFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "connectCampaignFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectCampaignFlowArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectCampaignFlowArn", value);
    }

    /**
     * Contains the schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Contains the schedule configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Contains source configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains source configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", value);
    }

    /**
     * Contains source configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains answering machine detection configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * AnswerMachineDetectionConfigProperty answerMachineDetectionConfigProperty = AnswerMachineDetectionConfigProperty.builder()
     *         .enableAnswerMachineDetection(false)
     *         // the properties below are optional
     *         .awaitAnswerMachinePrompt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AnswerMachineDetectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnswerMachineDetectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables answering machine detection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-enableanswermachinedetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-enableanswermachinedetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableAnswerMachineDetection();

        /**
         * Whether or not waiting for an answer machine prompt is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-awaitanswermachineprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-awaitanswermachineprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwaitAnswerMachinePrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnswerMachineDetectionConfigProperty> {
            java.lang.Object enableAnswerMachineDetection;
            java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Enables answering machine detection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(java.lang.Boolean enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Enables answering machine detection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(software.amazon.awscdk.IResolvable enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Whether or not waiting for an answer machine prompt is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(java.lang.Boolean awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Whether or not waiting for an answer machine prompt is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(software.amazon.awscdk.IResolvable awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnswerMachineDetectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnswerMachineDetectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnswerMachineDetectionConfigProperty {
            private final java.lang.Object enableAnswerMachineDetection;
            private final java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableAnswerMachineDetection = software.amazon.jsii.Kernel.get(this, "enableAnswerMachineDetection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awaitAnswerMachinePrompt = software.amazon.jsii.Kernel.get(this, "awaitAnswerMachinePrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableAnswerMachineDetection = java.util.Objects.requireNonNull(builder.enableAnswerMachineDetection, "enableAnswerMachineDetection is required");
                this.awaitAnswerMachinePrompt = builder.awaitAnswerMachinePrompt;
            }

            @Override
            public final java.lang.Object getEnableAnswerMachineDetection() {
                return this.enableAnswerMachineDetection;
            }

            @Override
            public final java.lang.Object getAwaitAnswerMachinePrompt() {
                return this.awaitAnswerMachinePrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableAnswerMachineDetection", om.valueToTree(this.getEnableAnswerMachineDetection()));
                if (this.getAwaitAnswerMachinePrompt() != null) {
                    data.set("awaitAnswerMachinePrompt", om.valueToTree(this.getAwaitAnswerMachinePrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnswerMachineDetectionConfigProperty.Jsii$Proxy that = (AnswerMachineDetectionConfigProperty.Jsii$Proxy) o;

                if (!enableAnswerMachineDetection.equals(that.enableAnswerMachineDetection)) return false;
                return this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.equals(that.awaitAnswerMachinePrompt) : that.awaitAnswerMachinePrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableAnswerMachineDetection.hashCode();
                result = 31 * result + (this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains channel subtype configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * ChannelSubtypeConfigProperty channelSubtypeConfigProperty = ChannelSubtypeConfigProperty.builder()
     *         .email(EmailChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
     *                         .connectSourceEmailAddress("connectSourceEmailAddress")
     *                         .wisdomTemplateArn("wisdomTemplateArn")
     *                         // the properties below are optional
     *                         .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *                         .build())
     *                 .outboundMode(EmailOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .build())
     *         .sms(SmsChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
     *                         .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *                         .wisdomTemplateArn("wisdomTemplateArn")
     *                         .build())
     *                 .outboundMode(SmsOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .build())
     *         .telephony(TelephonyChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
     *                         .connectContactFlowId("connectContactFlowId")
     *                         // the properties below are optional
     *                         .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                                 .enableAnswerMachineDetection(false)
     *                                 // the properties below are optional
     *                                 .awaitAnswerMachinePrompt(false)
     *                                 .build())
     *                         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *                         .build())
     *                 .outboundMode(TelephonyOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .predictiveConfig(PredictiveConfigProperty.builder()
     *                                 .bandwidthAllocation(123)
     *                                 .build())
     *                         .progressiveConfig(ProgressiveConfigProperty.builder()
     *                                 .bandwidthAllocation(123)
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .connectQueueId("connectQueueId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the email channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmail() {
            return null;
        }

        /**
         * The configuration of the SMS channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-sms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-sms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSms() {
            return null;
        }

        /**
         * The configuration of the telephony channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-telephony">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-telephony</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTelephony() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelSubtypeConfigProperty> {
            java.lang.Object email;
            java.lang.Object sms;
            java.lang.Object telephony;

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getEmail}
             * @param email The configuration of the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.IResolvable email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getEmail}
             * @param email The configuration of the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getSms}
             * @param sms The configuration of the SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.IResolvable sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getSms}
             * @param sms The configuration of the SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getTelephony}
             * @param telephony The configuration of the telephony channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.IResolvable telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getTelephony}
             * @param telephony The configuration of the telephony channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelSubtypeConfigProperty {
            private final java.lang.Object email;
            private final java.lang.Object sms;
            private final java.lang.Object telephony;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.telephony = software.amazon.jsii.Kernel.get(this, "telephony", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.email = builder.email;
                this.sms = builder.sms;
                this.telephony = builder.telephony;
            }

            @Override
            public final java.lang.Object getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.Object getSms() {
                return this.sms;
            }

            @Override
            public final java.lang.Object getTelephony() {
                return this.telephony;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getSms() != null) {
                    data.set("sms", om.valueToTree(this.getSms()));
                }
                if (this.getTelephony() != null) {
                    data.set("telephony", om.valueToTree(this.getTelephony()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelSubtypeConfigProperty.Jsii$Proxy that = (ChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.sms != null ? !this.sms.equals(that.sms) : that.sms != null) return false;
                return this.telephony != null ? this.telephony.equals(that.telephony) : that.telephony == null;
            }

            @Override
            public final int hashCode() {
                int result = this.email != null ? this.email.hashCode() : 0;
                result = 31 * result + (this.sms != null ? this.sms.hashCode() : 0);
                result = 31 * result + (this.telephony != null ? this.telephony.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a communication limit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitProperty communicationLimitProperty = CommunicationLimitProperty.builder()
     *         .frequency(123)
     *         .maxCountPerRecipient(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency of communication limit evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-frequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFrequency();

        /**
         * The maximum outreaching count for each recipient.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-maxcountperrecipient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-maxcountperrecipient</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCountPerRecipient();

        /**
         * The unit of communication limit evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * @return a {@link Builder} of {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitProperty> {
            java.lang.Number frequency;
            java.lang.Number maxCountPerRecipient;
            java.lang.String unit;

            /**
             * Sets the value of {@link CommunicationLimitProperty#getFrequency}
             * @param frequency The frequency of communication limit evaluation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(java.lang.Number frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitProperty#getMaxCountPerRecipient}
             * @param maxCountPerRecipient The maximum outreaching count for each recipient. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCountPerRecipient(java.lang.Number maxCountPerRecipient) {
                this.maxCountPerRecipient = maxCountPerRecipient;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitProperty#getUnit}
             * @param unit The unit of communication limit evaluation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitProperty {
            private final java.lang.Number frequency;
            private final java.lang.Number maxCountPerRecipient;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxCountPerRecipient = software.amazon.jsii.Kernel.get(this, "maxCountPerRecipient", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequency = java.util.Objects.requireNonNull(builder.frequency, "frequency is required");
                this.maxCountPerRecipient = java.util.Objects.requireNonNull(builder.maxCountPerRecipient, "maxCountPerRecipient is required");
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
            }

            @Override
            public final java.lang.Number getFrequency() {
                return this.frequency;
            }

            @Override
            public final java.lang.Number getMaxCountPerRecipient() {
                return this.maxCountPerRecipient;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequency", om.valueToTree(this.getFrequency()));
                data.set("maxCountPerRecipient", om.valueToTree(this.getMaxCountPerRecipient()));
                data.set("unit", om.valueToTree(this.getUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitProperty.Jsii$Proxy that = (CommunicationLimitProperty.Jsii$Proxy) o;

                if (!frequency.equals(that.frequency)) return false;
                if (!maxCountPerRecipient.equals(that.maxCountPerRecipient)) return false;
                return this.unit.equals(that.unit);
            }

            @Override
            public final int hashCode() {
                int result = this.frequency.hashCode();
                result = 31 * result + (this.maxCountPerRecipient.hashCode());
                result = 31 * result + (this.unit.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the communication limits configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitsConfigProperty communicationLimitsConfigProperty = CommunicationLimitsConfigProperty.builder()
     *         .allChannelsSubtypes(CommunicationLimitsProperty.builder()
     *                 .communicationLimitList(List.of(CommunicationLimitProperty.builder()
     *                         .frequency(123)
     *                         .maxCountPerRecipient(123)
     *                         .unit("unit")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html#cfn-connectcampaignsv2-campaign-communicationlimitsconfig-allchannelssubtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html#cfn-connectcampaignsv2-campaign-communicationlimitsconfig-allchannelssubtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllChannelsSubtypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitsConfigProperty> {
            java.lang.Object allChannelsSubtypes;

            /**
             * Sets the value of {@link CommunicationLimitsConfigProperty#getAllChannelsSubtypes}
             * @param allChannelsSubtypes The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allChannelsSubtypes(software.amazon.awscdk.IResolvable allChannelsSubtypes) {
                this.allChannelsSubtypes = allChannelsSubtypes;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitsConfigProperty#getAllChannelsSubtypes}
             * @param allChannelsSubtypes The CommunicationLimits that apply to all channel subtypes defined in an outbound campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allChannelsSubtypes(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty allChannelsSubtypes) {
                this.allChannelsSubtypes = allChannelsSubtypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitsConfigProperty {
            private final java.lang.Object allChannelsSubtypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allChannelsSubtypes = software.amazon.jsii.Kernel.get(this, "allChannelsSubtypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allChannelsSubtypes = builder.allChannelsSubtypes;
            }

            @Override
            public final java.lang.Object getAllChannelsSubtypes() {
                return this.allChannelsSubtypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllChannelsSubtypes() != null) {
                    data.set("allChannelsSubtypes", om.valueToTree(this.getAllChannelsSubtypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitsConfigProperty.Jsii$Proxy that = (CommunicationLimitsConfigProperty.Jsii$Proxy) o;

                return this.allChannelsSubtypes != null ? this.allChannelsSubtypes.equals(that.allChannelsSubtypes) : that.allChannelsSubtypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allChannelsSubtypes != null ? this.allChannelsSubtypes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains information about communication limits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitsProperty communicationLimitsProperty = CommunicationLimitsProperty.builder()
     *         .communicationLimitList(List.of(CommunicationLimitProperty.builder()
     *                 .frequency(123)
     *                 .maxCountPerRecipient(123)
     *                 .unit("unit")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of CommunicationLimits.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html#cfn-connectcampaignsv2-campaign-communicationlimits-communicationlimitlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html#cfn-connectcampaignsv2-campaign-communicationlimits-communicationlimitlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationLimitList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitsProperty> {
            java.lang.Object communicationLimitList;

            /**
             * Sets the value of {@link CommunicationLimitsProperty#getCommunicationLimitList}
             * @param communicationLimitList The list of CommunicationLimits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder communicationLimitList(software.amazon.awscdk.IResolvable communicationLimitList) {
                this.communicationLimitList = communicationLimitList;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitsProperty#getCommunicationLimitList}
             * @param communicationLimitList The list of CommunicationLimits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder communicationLimitList(java.util.List<? extends java.lang.Object> communicationLimitList) {
                this.communicationLimitList = communicationLimitList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitsProperty {
            private final java.lang.Object communicationLimitList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.communicationLimitList = software.amazon.jsii.Kernel.get(this, "communicationLimitList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.communicationLimitList = builder.communicationLimitList;
            }

            @Override
            public final java.lang.Object getCommunicationLimitList() {
                return this.communicationLimitList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommunicationLimitList() != null) {
                    data.set("communicationLimitList", om.valueToTree(this.getCommunicationLimitList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitsProperty.Jsii$Proxy that = (CommunicationLimitsProperty.Jsii$Proxy) o;

                return this.communicationLimitList != null ? this.communicationLimitList.equals(that.communicationLimitList) : that.communicationLimitList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.communicationLimitList != null ? this.communicationLimitList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Communication time configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationTimeConfigProperty communicationTimeConfigProperty = CommunicationTimeConfigProperty.builder()
     *         .localTimeZoneConfig(LocalTimeZoneConfigProperty.builder()
     *                 .defaultTimeZone("defaultTimeZone")
     *                 .localTimeZoneDetection(List.of("localTimeZoneDetection"))
     *                 .build())
     *         // the properties below are optional
     *         .email(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .sms(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .telephony(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationTimeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationTimeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The local timezone configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-localtimezoneconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-localtimezoneconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocalTimeZoneConfig();

        /**
         * The communication time configuration for the email channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmail() {
            return null;
        }

        /**
         * The communication time configuration for the SMS channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-sms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-sms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSms() {
            return null;
        }

        /**
         * The communication time configuration for the telephony channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-telephony">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-telephony</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTelephony() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationTimeConfigProperty> {
            java.lang.Object localTimeZoneConfig;
            java.lang.Object email;
            java.lang.Object sms;
            java.lang.Object telephony;

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getLocalTimeZoneConfig}
             * @param localTimeZoneConfig The local timezone configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneConfig(software.amazon.awscdk.IResolvable localTimeZoneConfig) {
                this.localTimeZoneConfig = localTimeZoneConfig;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getLocalTimeZoneConfig}
             * @param localTimeZoneConfig The local timezone configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty localTimeZoneConfig) {
                this.localTimeZoneConfig = localTimeZoneConfig;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getEmail}
             * @param email The communication time configuration for the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.IResolvable email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getEmail}
             * @param email The communication time configuration for the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getSms}
             * @param sms The communication time configuration for the SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.IResolvable sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getSms}
             * @param sms The communication time configuration for the SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getTelephony}
             * @param telephony The communication time configuration for the telephony channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.IResolvable telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getTelephony}
             * @param telephony The communication time configuration for the telephony channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationTimeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationTimeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationTimeConfigProperty {
            private final java.lang.Object localTimeZoneConfig;
            private final java.lang.Object email;
            private final java.lang.Object sms;
            private final java.lang.Object telephony;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localTimeZoneConfig = software.amazon.jsii.Kernel.get(this, "localTimeZoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.telephony = software.amazon.jsii.Kernel.get(this, "telephony", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localTimeZoneConfig = java.util.Objects.requireNonNull(builder.localTimeZoneConfig, "localTimeZoneConfig is required");
                this.email = builder.email;
                this.sms = builder.sms;
                this.telephony = builder.telephony;
            }

            @Override
            public final java.lang.Object getLocalTimeZoneConfig() {
                return this.localTimeZoneConfig;
            }

            @Override
            public final java.lang.Object getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.Object getSms() {
                return this.sms;
            }

            @Override
            public final java.lang.Object getTelephony() {
                return this.telephony;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localTimeZoneConfig", om.valueToTree(this.getLocalTimeZoneConfig()));
                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getSms() != null) {
                    data.set("sms", om.valueToTree(this.getSms()));
                }
                if (this.getTelephony() != null) {
                    data.set("telephony", om.valueToTree(this.getTelephony()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationTimeConfigProperty.Jsii$Proxy that = (CommunicationTimeConfigProperty.Jsii$Proxy) o;

                if (!localTimeZoneConfig.equals(that.localTimeZoneConfig)) return false;
                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.sms != null ? !this.sms.equals(that.sms) : that.sms != null) return false;
                return this.telephony != null ? this.telephony.equals(that.telephony) : that.telephony == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localTimeZoneConfig.hashCode();
                result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
                result = 31 * result + (this.sms != null ? this.sms.hashCode() : 0);
                result = 31 * result + (this.telephony != null ? this.telephony.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The daily hours configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * DailyHourProperty dailyHourProperty = DailyHourProperty.builder()
     *         .key("key")
     *         .value(List.of(TimeRangeProperty.builder()
     *                 .endTime("endTime")
     *                 .startTime("startTime")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.DailyHourProperty")
    @software.amazon.jsii.Jsii.Proxy(DailyHourProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DailyHourProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key for DailyHour.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value for DailyHour.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DailyHourProperty> {
            java.lang.String key;
            java.lang.Object value;

            /**
             * Sets the value of {@link DailyHourProperty#getKey}
             * @param key The key for DailyHour.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link DailyHourProperty#getValue}
             * @param value The value for DailyHour.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DailyHourProperty#getValue}
             * @param value The value for DailyHour.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.util.List<? extends java.lang.Object> value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DailyHourProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DailyHourProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DailyHourProperty {
            private final java.lang.String key;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.DailyHourProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DailyHourProperty.Jsii$Proxy that = (DailyHourProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the email channel subtype.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * EmailChannelSubtypeConfigProperty emailChannelSubtypeConfigProperty = EmailChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
     *                 .connectSourceEmailAddress("connectSourceEmailAddress")
     *                 .wisdomTemplateArn("wisdomTemplateArn")
     *                 // the properties below are optional
     *                 .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *                 .build())
     *         .outboundMode(EmailOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default email outbound configuration of an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * The outbound mode for email of an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * The allocation of email capacity between multiple running outbound campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default email outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default email outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode for email of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode for email of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getCapacity}
             * @param capacity The allocation of email capacity between multiple running outbound campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailChannelSubtypeConfigProperty.Jsii$Proxy that = (EmailChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                return this.capacity != null ? this.capacity.equals(that.capacity) : that.capacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The outbound configuration for email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * EmailOutboundConfigProperty emailOutboundConfigProperty = EmailOutboundConfigProperty.builder()
     *         .connectSourceEmailAddress("connectSourceEmailAddress")
     *         .wisdomTemplateArn("wisdomTemplateArn")
     *         // the properties below are optional
     *         .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Connect source email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-connectsourceemailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-connectsourceemailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectSourceEmailAddress();

        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-wisdomtemplatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-wisdomtemplatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWisdomTemplateArn();

        /**
         * The display name for the Amazon Connect source email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-sourceemailaddressdisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-sourceemailaddressdisplayname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceEmailAddressDisplayName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailOutboundConfigProperty> {
            java.lang.String connectSourceEmailAddress;
            java.lang.String wisdomTemplateArn;
            java.lang.String sourceEmailAddressDisplayName;

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getConnectSourceEmailAddress}
             * @param connectSourceEmailAddress The Amazon Connect source email address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourceEmailAddress(java.lang.String connectSourceEmailAddress) {
                this.connectSourceEmailAddress = connectSourceEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getWisdomTemplateArn}
             * @param wisdomTemplateArn The Amazon Resource Name (ARN) of the Amazon Q in Connect template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wisdomTemplateArn(java.lang.String wisdomTemplateArn) {
                this.wisdomTemplateArn = wisdomTemplateArn;
                return this;
            }

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getSourceEmailAddressDisplayName}
             * @param sourceEmailAddressDisplayName The display name for the Amazon Connect source email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceEmailAddressDisplayName(java.lang.String sourceEmailAddressDisplayName) {
                this.sourceEmailAddressDisplayName = sourceEmailAddressDisplayName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailOutboundConfigProperty {
            private final java.lang.String connectSourceEmailAddress;
            private final java.lang.String wisdomTemplateArn;
            private final java.lang.String sourceEmailAddressDisplayName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectSourceEmailAddress = software.amazon.jsii.Kernel.get(this, "connectSourceEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.wisdomTemplateArn = software.amazon.jsii.Kernel.get(this, "wisdomTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceEmailAddressDisplayName = software.amazon.jsii.Kernel.get(this, "sourceEmailAddressDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectSourceEmailAddress = java.util.Objects.requireNonNull(builder.connectSourceEmailAddress, "connectSourceEmailAddress is required");
                this.wisdomTemplateArn = java.util.Objects.requireNonNull(builder.wisdomTemplateArn, "wisdomTemplateArn is required");
                this.sourceEmailAddressDisplayName = builder.sourceEmailAddressDisplayName;
            }

            @Override
            public final java.lang.String getConnectSourceEmailAddress() {
                return this.connectSourceEmailAddress;
            }

            @Override
            public final java.lang.String getWisdomTemplateArn() {
                return this.wisdomTemplateArn;
            }

            @Override
            public final java.lang.String getSourceEmailAddressDisplayName() {
                return this.sourceEmailAddressDisplayName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectSourceEmailAddress", om.valueToTree(this.getConnectSourceEmailAddress()));
                data.set("wisdomTemplateArn", om.valueToTree(this.getWisdomTemplateArn()));
                if (this.getSourceEmailAddressDisplayName() != null) {
                    data.set("sourceEmailAddressDisplayName", om.valueToTree(this.getSourceEmailAddressDisplayName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailOutboundConfigProperty.Jsii$Proxy that = (EmailOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectSourceEmailAddress.equals(that.connectSourceEmailAddress)) return false;
                if (!wisdomTemplateArn.equals(that.wisdomTemplateArn)) return false;
                return this.sourceEmailAddressDisplayName != null ? this.sourceEmailAddressDisplayName.equals(that.sourceEmailAddressDisplayName) : that.sourceEmailAddressDisplayName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectSourceEmailAddress.hashCode();
                result = 31 * result + (this.wisdomTemplateArn.hashCode());
                result = 31 * result + (this.sourceEmailAddressDisplayName != null ? this.sourceEmailAddressDisplayName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about email outbound mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * EmailOutboundModeProperty emailOutboundModeProperty = EmailOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The agentless outbound mode configuration for email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html#cfn-connectcampaignsv2-campaign-emailoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html#cfn-connectcampaignsv2-campaign-emailoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailOutboundModeProperty> {
            java.lang.Object agentlessConfig;

            /**
             * Sets the value of {@link EmailOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig The agentless outbound mode configuration for email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailOutboundModeProperty {
            private final java.lang.Object agentlessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailOutboundModeProperty.Jsii$Proxy that = (EmailOutboundModeProperty.Jsii$Proxy) o;

                return this.agentlessConfig != null ? this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The event trigger of the campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * EventTriggerProperty eventTriggerProperty = EventTriggerProperty.builder()
     *         .customerProfilesDomainArn("customerProfilesDomainArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EventTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(EventTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Customer Profiles domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html#cfn-connectcampaignsv2-campaign-eventtrigger-customerprofilesdomainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-eventtrigger.html#cfn-connectcampaignsv2-campaign-eventtrigger-customerprofilesdomainarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomerProfilesDomainArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventTriggerProperty> {
            java.lang.String customerProfilesDomainArn;

            /**
             * Sets the value of {@link EventTriggerProperty#getCustomerProfilesDomainArn}
             * @param customerProfilesDomainArn The Amazon Resource Name (ARN) of the Customer Profiles domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerProfilesDomainArn(java.lang.String customerProfilesDomainArn) {
                this.customerProfilesDomainArn = customerProfilesDomainArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventTriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventTriggerProperty {
            private final java.lang.String customerProfilesDomainArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerProfilesDomainArn = software.amazon.jsii.Kernel.get(this, "customerProfilesDomainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerProfilesDomainArn = builder.customerProfilesDomainArn;
            }

            @Override
            public final java.lang.String getCustomerProfilesDomainArn() {
                return this.customerProfilesDomainArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerProfilesDomainArn() != null) {
                    data.set("customerProfilesDomainArn", om.valueToTree(this.getCustomerProfilesDomainArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EventTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventTriggerProperty.Jsii$Proxy that = (EventTriggerProperty.Jsii$Proxy) o;

                return this.customerProfilesDomainArn != null ? this.customerProfilesDomainArn.equals(that.customerProfilesDomainArn) : that.customerProfilesDomainArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerProfilesDomainArn != null ? this.customerProfilesDomainArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration of timezone for recipient.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * LocalTimeZoneConfigProperty localTimeZoneConfigProperty = LocalTimeZoneConfigProperty.builder()
     *         .defaultTimeZone("defaultTimeZone")
     *         .localTimeZoneDetection(List.of("localTimeZoneDetection"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalTimeZoneConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalTimeZoneConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The timezone to use for all recipients.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-defaulttimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-defaulttimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTimeZone() {
            return null;
        }

        /**
         * Detects methods for the recipient's timezone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-localtimezonedetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-localtimezonedetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalTimeZoneDetection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalTimeZoneConfigProperty> {
            java.lang.String defaultTimeZone;
            java.util.List<java.lang.String> localTimeZoneDetection;

            /**
             * Sets the value of {@link LocalTimeZoneConfigProperty#getDefaultTimeZone}
             * @param defaultTimeZone The timezone to use for all recipients.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTimeZone(java.lang.String defaultTimeZone) {
                this.defaultTimeZone = defaultTimeZone;
                return this;
            }

            /**
             * Sets the value of {@link LocalTimeZoneConfigProperty#getLocalTimeZoneDetection}
             * @param localTimeZoneDetection Detects methods for the recipient's timezone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneDetection(java.util.List<java.lang.String> localTimeZoneDetection) {
                this.localTimeZoneDetection = localTimeZoneDetection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalTimeZoneConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalTimeZoneConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalTimeZoneConfigProperty {
            private final java.lang.String defaultTimeZone;
            private final java.util.List<java.lang.String> localTimeZoneDetection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTimeZone = software.amazon.jsii.Kernel.get(this, "defaultTimeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localTimeZoneDetection = software.amazon.jsii.Kernel.get(this, "localTimeZoneDetection", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTimeZone = builder.defaultTimeZone;
                this.localTimeZoneDetection = builder.localTimeZoneDetection;
            }

            @Override
            public final java.lang.String getDefaultTimeZone() {
                return this.defaultTimeZone;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalTimeZoneDetection() {
                return this.localTimeZoneDetection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultTimeZone() != null) {
                    data.set("defaultTimeZone", om.valueToTree(this.getDefaultTimeZone()));
                }
                if (this.getLocalTimeZoneDetection() != null) {
                    data.set("localTimeZoneDetection", om.valueToTree(this.getLocalTimeZoneDetection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalTimeZoneConfigProperty.Jsii$Proxy that = (LocalTimeZoneConfigProperty.Jsii$Proxy) o;

                if (this.defaultTimeZone != null ? !this.defaultTimeZone.equals(that.defaultTimeZone) : that.defaultTimeZone != null) return false;
                return this.localTimeZoneDetection != null ? this.localTimeZoneDetection.equals(that.localTimeZoneDetection) : that.localTimeZoneDetection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTimeZone != null ? this.defaultTimeZone.hashCode() : 0;
                result = 31 * result + (this.localTimeZoneDetection != null ? this.localTimeZoneDetection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about open hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * OpenHoursProperty openHoursProperty = OpenHoursProperty.builder()
     *         .dailyHours(List.of(DailyHourProperty.builder()
     *                 .key("key")
     *                 .value(List.of(TimeRangeProperty.builder()
     *                         .endTime("endTime")
     *                         .startTime("startTime")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.OpenHoursProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenHoursProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenHoursProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The daily hours configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html#cfn-connectcampaignsv2-campaign-openhours-dailyhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html#cfn-connectcampaignsv2-campaign-openhours-dailyhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDailyHours();

        /**
         * @return a {@link Builder} of {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenHoursProperty> {
            java.lang.Object dailyHours;

            /**
             * Sets the value of {@link OpenHoursProperty#getDailyHours}
             * @param dailyHours The daily hours configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyHours(software.amazon.awscdk.IResolvable dailyHours) {
                this.dailyHours = dailyHours;
                return this;
            }

            /**
             * Sets the value of {@link OpenHoursProperty#getDailyHours}
             * @param dailyHours The daily hours configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyHours(java.util.List<? extends java.lang.Object> dailyHours) {
                this.dailyHours = dailyHours;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenHoursProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenHoursProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenHoursProperty {
            private final java.lang.Object dailyHours;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dailyHours = software.amazon.jsii.Kernel.get(this, "dailyHours", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dailyHours = java.util.Objects.requireNonNull(builder.dailyHours, "dailyHours is required");
            }

            @Override
            public final java.lang.Object getDailyHours() {
                return this.dailyHours;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dailyHours", om.valueToTree(this.getDailyHours()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.OpenHoursProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenHoursProperty.Jsii$Proxy that = (OpenHoursProperty.Jsii$Proxy) o;

                return this.dailyHours.equals(that.dailyHours);
            }

            @Override
            public final int hashCode() {
                int result = this.dailyHours.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains predictive outbound mode configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * PredictiveConfigProperty predictiveConfigProperty = PredictiveConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.PredictiveConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Bandwidth allocation for the predictive outbound mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html#cfn-connectcampaignsv2-campaign-predictiveconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html#cfn-connectcampaignsv2-campaign-predictiveconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link PredictiveConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation Bandwidth allocation for the predictive outbound mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.PredictiveConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveConfigProperty.Jsii$Proxy that = (PredictiveConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the progressive outbound mode configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * ProgressiveConfigProperty progressiveConfigProperty = ProgressiveConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProgressiveConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProgressiveConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Bandwidth allocation for the progressive outbound mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html#cfn-connectcampaignsv2-campaign-progressiveconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html#cfn-connectcampaignsv2-campaign-progressiveconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProgressiveConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link ProgressiveConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation Bandwidth allocation for the progressive outbound mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProgressiveConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProgressiveConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProgressiveConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProgressiveConfigProperty.Jsii$Proxy that = (ProgressiveConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about a restricted period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * RestrictedPeriodProperty restrictedPeriodProperty = RestrictedPeriodProperty.builder()
     *         .endDate("endDate")
     *         .startDate("startDate")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictedPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictedPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end date of the restricted period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-enddate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-enddate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndDate();

        /**
         * The start date of the restricted period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-startdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-startdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartDate();

        /**
         * The name of the restricted period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictedPeriodProperty> {
            java.lang.String endDate;
            java.lang.String startDate;
            java.lang.String name;

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getEndDate}
             * @param endDate The end date of the restricted period. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endDate(java.lang.String endDate) {
                this.endDate = endDate;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getStartDate}
             * @param startDate The start date of the restricted period. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startDate(java.lang.String startDate) {
                this.startDate = startDate;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getName}
             * @param name The name of the restricted period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictedPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictedPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictedPeriodProperty {
            private final java.lang.String endDate;
            private final java.lang.String startDate;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endDate = java.util.Objects.requireNonNull(builder.endDate, "endDate is required");
                this.startDate = java.util.Objects.requireNonNull(builder.startDate, "startDate is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getEndDate() {
                return this.endDate;
            }

            @Override
            public final java.lang.String getStartDate() {
                return this.startDate;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endDate", om.valueToTree(this.getEndDate()));
                data.set("startDate", om.valueToTree(this.getStartDate()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictedPeriodProperty.Jsii$Proxy that = (RestrictedPeriodProperty.Jsii$Proxy) o;

                if (!endDate.equals(that.endDate)) return false;
                if (!startDate.equals(that.startDate)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endDate.hashCode();
                result = 31 * result + (this.startDate.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about restricted periods.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * RestrictedPeriodsProperty restrictedPeriodsProperty = RestrictedPeriodsProperty.builder()
     *         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                 .endDate("endDate")
     *                 .startDate("startDate")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictedPeriodsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictedPeriodsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The restricted period list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html#cfn-connectcampaignsv2-campaign-restrictedperiods-restrictedperiodlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html#cfn-connectcampaignsv2-campaign-restrictedperiods-restrictedperiodlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRestrictedPeriodList();

        /**
         * @return a {@link Builder} of {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictedPeriodsProperty> {
            java.lang.Object restrictedPeriodList;

            /**
             * Sets the value of {@link RestrictedPeriodsProperty#getRestrictedPeriodList}
             * @param restrictedPeriodList The restricted period list. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriodList(software.amazon.awscdk.IResolvable restrictedPeriodList) {
                this.restrictedPeriodList = restrictedPeriodList;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodsProperty#getRestrictedPeriodList}
             * @param restrictedPeriodList The restricted period list. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriodList(java.util.List<? extends java.lang.Object> restrictedPeriodList) {
                this.restrictedPeriodList = restrictedPeriodList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictedPeriodsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictedPeriodsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictedPeriodsProperty {
            private final java.lang.Object restrictedPeriodList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictedPeriodList = software.amazon.jsii.Kernel.get(this, "restrictedPeriodList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictedPeriodList = java.util.Objects.requireNonNull(builder.restrictedPeriodList, "restrictedPeriodList is required");
            }

            @Override
            public final java.lang.Object getRestrictedPeriodList() {
                return this.restrictedPeriodList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictedPeriodList", om.valueToTree(this.getRestrictedPeriodList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictedPeriodsProperty.Jsii$Proxy that = (RestrictedPeriodsProperty.Jsii$Proxy) o;

                return this.restrictedPeriodList.equals(that.restrictedPeriodList);
            }

            @Override
            public final int hashCode() {
                int result = this.restrictedPeriodList.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the schedule configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         // the properties below are optional
     *         .refreshFrequency("refreshFrequency")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end time of the schedule in UTC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * The start time of the schedule in UTC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * The refresh frequency of the campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-refreshfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-refreshfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshFrequency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String endTime;
            java.lang.String startTime;
            java.lang.String refreshFrequency;

            /**
             * Sets the value of {@link ScheduleProperty#getEndTime}
             * @param endTime The end time of the schedule in UTC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getStartTime}
             * @param startTime The start time of the schedule in UTC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRefreshFrequency}
             * @param refreshFrequency The refresh frequency of the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshFrequency(java.lang.String refreshFrequency) {
                this.refreshFrequency = refreshFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;
            private final java.lang.String refreshFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshFrequency = software.amazon.jsii.Kernel.get(this, "refreshFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
                this.refreshFrequency = builder.refreshFrequency;
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            public final java.lang.String getRefreshFrequency() {
                return this.refreshFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));
                if (this.getRefreshFrequency() != null) {
                    data.set("refreshFrequency", om.valueToTree(this.getRefreshFrequency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                if (!startTime.equals(that.startTime)) return false;
                return this.refreshFrequency != null ? this.refreshFrequency.equals(that.refreshFrequency) : that.refreshFrequency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                result = 31 * result + (this.refreshFrequency != null ? this.refreshFrequency.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the SMS channel subtype.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * SmsChannelSubtypeConfigProperty smsChannelSubtypeConfigProperty = SmsChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
     *                 .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *                 .wisdomTemplateArn("wisdomTemplateArn")
     *                 .build())
     *         .outboundMode(SmsOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default SMS outbound configuration of an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * The outbound mode of SMS for an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * The allocation of SMS capacity between multiple running outbound campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default SMS outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default SMS outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode of SMS for an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode of SMS for an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getCapacity}
             * @param capacity The allocation of SMS capacity between multiple running outbound campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsChannelSubtypeConfigProperty.Jsii$Proxy that = (SmsChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                return this.capacity != null ? this.capacity.equals(that.capacity) : that.capacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The outbound configuration for SMS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * SmsOutboundConfigProperty smsOutboundConfigProperty = SmsOutboundConfigProperty.builder()
     *         .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *         .wisdomTemplateArn("wisdomTemplateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Connect source SMS phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-connectsourcephonenumberarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-connectsourcephonenumberarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectSourcePhoneNumberArn();

        /**
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-wisdomtemplatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-wisdomtemplatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWisdomTemplateArn();

        /**
         * @return a {@link Builder} of {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsOutboundConfigProperty> {
            java.lang.String connectSourcePhoneNumberArn;
            java.lang.String wisdomTemplateArn;

            /**
             * Sets the value of {@link SmsOutboundConfigProperty#getConnectSourcePhoneNumberArn}
             * @param connectSourcePhoneNumberArn The Amazon Resource Name (ARN) of the Amazon Connect source SMS phone number. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumberArn(java.lang.String connectSourcePhoneNumberArn) {
                this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
                return this;
            }

            /**
             * Sets the value of {@link SmsOutboundConfigProperty#getWisdomTemplateArn}
             * @param wisdomTemplateArn The Amazon Resource Name (ARN) of the Amazon Q in Connect template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wisdomTemplateArn(java.lang.String wisdomTemplateArn) {
                this.wisdomTemplateArn = wisdomTemplateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsOutboundConfigProperty {
            private final java.lang.String connectSourcePhoneNumberArn;
            private final java.lang.String wisdomTemplateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectSourcePhoneNumberArn = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.wisdomTemplateArn = software.amazon.jsii.Kernel.get(this, "wisdomTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectSourcePhoneNumberArn = java.util.Objects.requireNonNull(builder.connectSourcePhoneNumberArn, "connectSourcePhoneNumberArn is required");
                this.wisdomTemplateArn = java.util.Objects.requireNonNull(builder.wisdomTemplateArn, "wisdomTemplateArn is required");
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumberArn() {
                return this.connectSourcePhoneNumberArn;
            }

            @Override
            public final java.lang.String getWisdomTemplateArn() {
                return this.wisdomTemplateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectSourcePhoneNumberArn", om.valueToTree(this.getConnectSourcePhoneNumberArn()));
                data.set("wisdomTemplateArn", om.valueToTree(this.getWisdomTemplateArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsOutboundConfigProperty.Jsii$Proxy that = (SmsOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectSourcePhoneNumberArn.equals(that.connectSourcePhoneNumberArn)) return false;
                return this.wisdomTemplateArn.equals(that.wisdomTemplateArn);
            }

            @Override
            public final int hashCode() {
                int result = this.connectSourcePhoneNumberArn.hashCode();
                result = 31 * result + (this.wisdomTemplateArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about the SMS outbound mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * SmsOutboundModeProperty smsOutboundModeProperty = SmsOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains agentless outbound mode configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html#cfn-connectcampaignsv2-campaign-smsoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html#cfn-connectcampaignsv2-campaign-smsoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsOutboundModeProperty> {
            java.lang.Object agentlessConfig;

            /**
             * Sets the value of {@link SmsOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig Contains agentless outbound mode configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsOutboundModeProperty {
            private final java.lang.Object agentlessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsOutboundModeProperty.Jsii$Proxy that = (SmsOutboundModeProperty.Jsii$Proxy) o;

                return this.agentlessConfig != null ? this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains source configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .customerProfilesSegmentArn("customerProfilesSegmentArn")
     *         .eventTrigger(EventTriggerProperty.builder()
     *                 .customerProfilesDomainArn("customerProfilesDomainArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Customer Profiles segment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-customerprofilessegmentarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-customerprofilessegmentarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomerProfilesSegmentArn() {
            return null;
        }

        /**
         * The event trigger of the campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-eventtrigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-eventtrigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventTrigger() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String customerProfilesSegmentArn;
            java.lang.Object eventTrigger;

            /**
             * Sets the value of {@link SourceProperty#getCustomerProfilesSegmentArn}
             * @param customerProfilesSegmentArn The Amazon Resource Name (ARN) of the Customer Profiles segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerProfilesSegmentArn(java.lang.String customerProfilesSegmentArn) {
                this.customerProfilesSegmentArn = customerProfilesSegmentArn;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getEventTrigger}
             * @param eventTrigger The event trigger of the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventTrigger(software.amazon.awscdk.IResolvable eventTrigger) {
                this.eventTrigger = eventTrigger;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getEventTrigger}
             * @param eventTrigger The event trigger of the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventTrigger(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EventTriggerProperty eventTrigger) {
                this.eventTrigger = eventTrigger;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String customerProfilesSegmentArn;
            private final java.lang.Object eventTrigger;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerProfilesSegmentArn = software.amazon.jsii.Kernel.get(this, "customerProfilesSegmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventTrigger = software.amazon.jsii.Kernel.get(this, "eventTrigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerProfilesSegmentArn = builder.customerProfilesSegmentArn;
                this.eventTrigger = builder.eventTrigger;
            }

            @Override
            public final java.lang.String getCustomerProfilesSegmentArn() {
                return this.customerProfilesSegmentArn;
            }

            @Override
            public final java.lang.Object getEventTrigger() {
                return this.eventTrigger;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerProfilesSegmentArn() != null) {
                    data.set("customerProfilesSegmentArn", om.valueToTree(this.getCustomerProfilesSegmentArn()));
                }
                if (this.getEventTrigger() != null) {
                    data.set("eventTrigger", om.valueToTree(this.getEventTrigger()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (this.customerProfilesSegmentArn != null ? !this.customerProfilesSegmentArn.equals(that.customerProfilesSegmentArn) : that.customerProfilesSegmentArn != null) return false;
                return this.eventTrigger != null ? this.eventTrigger.equals(that.eventTrigger) : that.eventTrigger == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerProfilesSegmentArn != null ? this.customerProfilesSegmentArn.hashCode() : 0;
                result = 31 * result + (this.eventTrigger != null ? this.eventTrigger.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the telephony channel subtype.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * TelephonyChannelSubtypeConfigProperty telephonyChannelSubtypeConfigProperty = TelephonyChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
     *                 .connectContactFlowId("connectContactFlowId")
     *                 // the properties below are optional
     *                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                         .enableAnswerMachineDetection(false)
     *                         // the properties below are optional
     *                         .awaitAnswerMachinePrompt(false)
     *                         .build())
     *                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *                 .build())
     *         .outboundMode(TelephonyOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .predictiveConfig(PredictiveConfigProperty.builder()
     *                         .bandwidthAllocation(123)
     *                         .build())
     *                 .progressiveConfig(ProgressiveConfigProperty.builder()
     *                         .bandwidthAllocation(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .connectQueueId("connectQueueId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default telephony outbound configuration of an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * The outbound mode of telephony for an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * The allocation of telephony capacity between multiple running outbound campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * The identifier of the Amazon Connect queue associated with telephony outbound requests of an outbound campaign.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-connectqueueid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-connectqueueid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectQueueId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;
            java.lang.String connectQueueId;

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default telephony outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig The default telephony outbound configuration of an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode of telephony for an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode The outbound mode of telephony for an outbound campaign. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getCapacity}
             * @param capacity The allocation of telephony capacity between multiple running outbound campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getConnectQueueId}
             * @param connectQueueId The identifier of the Amazon Connect queue associated with telephony outbound requests of an outbound campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectQueueId(java.lang.String connectQueueId) {
                this.connectQueueId = connectQueueId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;
            private final java.lang.String connectQueueId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.connectQueueId = software.amazon.jsii.Kernel.get(this, "connectQueueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
                this.connectQueueId = builder.connectQueueId;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            public final java.lang.String getConnectQueueId() {
                return this.connectQueueId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }
                if (this.getConnectQueueId() != null) {
                    data.set("connectQueueId", om.valueToTree(this.getConnectQueueId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyChannelSubtypeConfigProperty.Jsii$Proxy that = (TelephonyChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) return false;
                return this.connectQueueId != null ? this.connectQueueId.equals(that.connectQueueId) : that.connectQueueId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                result = 31 * result + (this.connectQueueId != null ? this.connectQueueId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The outbound configuration for telephony.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TelephonyOutboundConfigProperty telephonyOutboundConfigProperty = TelephonyOutboundConfigProperty.builder()
     *         .connectContactFlowId("connectContactFlowId")
     *         // the properties below are optional
     *         .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                 .enableAnswerMachineDetection(false)
     *                 // the properties below are optional
     *                 .awaitAnswerMachinePrompt(false)
     *                 .build())
     *         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the published Amazon Connect contact flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectcontactflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectcontactflowid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectContactFlowId();

        /**
         * The answering machine detection configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-answermachinedetectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-answermachinedetectionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerMachineDetectionConfig() {
            return null;
        }

        /**
         * The Amazon Connect source phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectsourcephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectsourcephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectSourcePhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyOutboundConfigProperty> {
            java.lang.String connectContactFlowId;
            java.lang.Object answerMachineDetectionConfig;
            java.lang.String connectSourcePhoneNumber;

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getConnectContactFlowId}
             * @param connectContactFlowId The identifier of the published Amazon Connect contact flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectContactFlowId(java.lang.String connectContactFlowId) {
                this.connectContactFlowId = connectContactFlowId;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig The answering machine detection configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.IResolvable answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig The answering machine detection configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getConnectSourcePhoneNumber}
             * @param connectSourcePhoneNumber The Amazon Connect source phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumber(java.lang.String connectSourcePhoneNumber) {
                this.connectSourcePhoneNumber = connectSourcePhoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyOutboundConfigProperty {
            private final java.lang.String connectContactFlowId;
            private final java.lang.Object answerMachineDetectionConfig;
            private final java.lang.String connectSourcePhoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectContactFlowId = software.amazon.jsii.Kernel.get(this, "connectContactFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.answerMachineDetectionConfig = software.amazon.jsii.Kernel.get(this, "answerMachineDetectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectSourcePhoneNumber = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectContactFlowId = java.util.Objects.requireNonNull(builder.connectContactFlowId, "connectContactFlowId is required");
                this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
                this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
            }

            @Override
            public final java.lang.String getConnectContactFlowId() {
                return this.connectContactFlowId;
            }

            @Override
            public final java.lang.Object getAnswerMachineDetectionConfig() {
                return this.answerMachineDetectionConfig;
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumber() {
                return this.connectSourcePhoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectContactFlowId", om.valueToTree(this.getConnectContactFlowId()));
                if (this.getAnswerMachineDetectionConfig() != null) {
                    data.set("answerMachineDetectionConfig", om.valueToTree(this.getAnswerMachineDetectionConfig()));
                }
                if (this.getConnectSourcePhoneNumber() != null) {
                    data.set("connectSourcePhoneNumber", om.valueToTree(this.getConnectSourcePhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyOutboundConfigProperty.Jsii$Proxy that = (TelephonyOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectContactFlowId.equals(that.connectContactFlowId)) return false;
                if (this.answerMachineDetectionConfig != null ? !this.answerMachineDetectionConfig.equals(that.answerMachineDetectionConfig) : that.answerMachineDetectionConfig != null) return false;
                return this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.equals(that.connectSourcePhoneNumber) : that.connectSourcePhoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectContactFlowId.hashCode();
                result = 31 * result + (this.answerMachineDetectionConfig != null ? this.answerMachineDetectionConfig.hashCode() : 0);
                result = 31 * result + (this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about telephony outbound mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * TelephonyOutboundModeProperty telephonyOutboundModeProperty = TelephonyOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .predictiveConfig(PredictiveConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .progressiveConfig(ProgressiveConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The agentless outbound mode configuration for telephony.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * Contains predictive outbound mode configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-predictiveconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-predictiveconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveConfig() {
            return null;
        }

        /**
         * Contains progressive telephony outbound mode configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-progressiveconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-progressiveconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProgressiveConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyOutboundModeProperty> {
            java.lang.Object agentlessConfig;
            java.lang.Object predictiveConfig;
            java.lang.Object progressiveConfig;

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig The agentless outbound mode configuration for telephony.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getPredictiveConfig}
             * @param predictiveConfig Contains predictive outbound mode configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveConfig(software.amazon.awscdk.IResolvable predictiveConfig) {
                this.predictiveConfig = predictiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getPredictiveConfig}
             * @param predictiveConfig Contains predictive outbound mode configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.PredictiveConfigProperty predictiveConfig) {
                this.predictiveConfig = predictiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getProgressiveConfig}
             * @param progressiveConfig Contains progressive telephony outbound mode configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveConfig(software.amazon.awscdk.IResolvable progressiveConfig) {
                this.progressiveConfig = progressiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getProgressiveConfig}
             * @param progressiveConfig Contains progressive telephony outbound mode configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty progressiveConfig) {
                this.progressiveConfig = progressiveConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyOutboundModeProperty {
            private final java.lang.Object agentlessConfig;
            private final java.lang.Object predictiveConfig;
            private final java.lang.Object progressiveConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predictiveConfig = software.amazon.jsii.Kernel.get(this, "predictiveConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.progressiveConfig = software.amazon.jsii.Kernel.get(this, "progressiveConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
                this.predictiveConfig = builder.predictiveConfig;
                this.progressiveConfig = builder.progressiveConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            public final java.lang.Object getPredictiveConfig() {
                return this.predictiveConfig;
            }

            @Override
            public final java.lang.Object getProgressiveConfig() {
                return this.progressiveConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }
                if (this.getPredictiveConfig() != null) {
                    data.set("predictiveConfig", om.valueToTree(this.getPredictiveConfig()));
                }
                if (this.getProgressiveConfig() != null) {
                    data.set("progressiveConfig", om.valueToTree(this.getProgressiveConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyOutboundModeProperty.Jsii$Proxy that = (TelephonyOutboundModeProperty.Jsii$Proxy) o;

                if (this.agentlessConfig != null ? !this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig != null) return false;
                if (this.predictiveConfig != null ? !this.predictiveConfig.equals(that.predictiveConfig) : that.predictiveConfig != null) return false;
                return this.progressiveConfig != null ? this.progressiveConfig.equals(that.progressiveConfig) : that.progressiveConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                result = 31 * result + (this.predictiveConfig != null ? this.predictiveConfig.hashCode() : 0);
                result = 31 * result + (this.progressiveConfig != null ? this.progressiveConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a time range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TimeRangeProperty timeRangeProperty = TimeRangeProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end time of the time range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * The start time of the time range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * @return a {@link Builder} of {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeRangeProperty> {
            java.lang.String endTime;
            java.lang.String startTime;

            /**
             * Sets the value of {@link TimeRangeProperty#getEndTime}
             * @param endTime The end time of the time range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link TimeRangeProperty#getStartTime}
             * @param startTime The start time of the time range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeRangeProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeRangeProperty.Jsii$Proxy that = (TimeRangeProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about a time window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TimeWindowProperty timeWindowProperty = TimeWindowProperty.builder()
     *         .openHours(OpenHoursProperty.builder()
     *                 .dailyHours(List.of(DailyHourProperty.builder()
     *                         .key("key")
     *                         .value(List.of(TimeRangeProperty.builder()
     *                                 .endTime("endTime")
     *                                 .startTime("startTime")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                         .endDate("endDate")
     *                         .startDate("startDate")
     *                         // the properties below are optional
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The open hours configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-openhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-openhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOpenHours();

        /**
         * The restricted periods configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-restrictedperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-restrictedperiods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictedPeriods() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeWindowProperty> {
            java.lang.Object openHours;
            java.lang.Object restrictedPeriods;

            /**
             * Sets the value of {@link TimeWindowProperty#getOpenHours}
             * @param openHours The open hours configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openHours(software.amazon.awscdk.IResolvable openHours) {
                this.openHours = openHours;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getOpenHours}
             * @param openHours The open hours configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openHours(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.OpenHoursProperty openHours) {
                this.openHours = openHours;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getRestrictedPeriods}
             * @param restrictedPeriods The restricted periods configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriods(software.amazon.awscdk.IResolvable restrictedPeriods) {
                this.restrictedPeriods = restrictedPeriods;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getRestrictedPeriods}
             * @param restrictedPeriods The restricted periods configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriods(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty restrictedPeriods) {
                this.restrictedPeriods = restrictedPeriods;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeWindowProperty {
            private final java.lang.Object openHours;
            private final java.lang.Object restrictedPeriods;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.openHours = software.amazon.jsii.Kernel.get(this, "openHours", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictedPeriods = software.amazon.jsii.Kernel.get(this, "restrictedPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.openHours = java.util.Objects.requireNonNull(builder.openHours, "openHours is required");
                this.restrictedPeriods = builder.restrictedPeriods;
            }

            @Override
            public final java.lang.Object getOpenHours() {
                return this.openHours;
            }

            @Override
            public final java.lang.Object getRestrictedPeriods() {
                return this.restrictedPeriods;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("openHours", om.valueToTree(this.getOpenHours()));
                if (this.getRestrictedPeriods() != null) {
                    data.set("restrictedPeriods", om.valueToTree(this.getRestrictedPeriods()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeWindowProperty.Jsii$Proxy that = (TimeWindowProperty.Jsii$Proxy) o;

                if (!openHours.equals(that.openHours)) return false;
                return this.restrictedPeriods != null ? this.restrictedPeriods.equals(that.restrictedPeriods) : that.restrictedPeriods == null;
            }

            @Override
            public final int hashCode() {
                int result = this.openHours.hashCode();
                result = 31 * result + (this.restrictedPeriods != null ? this.restrictedPeriods.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps.Builder();
        }

        /**
         * Contains channel subtype configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig</a>
         * @param channelSubtypeConfig Contains channel subtype configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(final software.amazon.awscdk.IResolvable channelSubtypeConfig) {
            this.props.channelSubtypeConfig(channelSubtypeConfig);
            return this;
        }
        /**
         * Contains channel subtype configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig</a>
         * @param channelSubtypeConfig Contains channel subtype configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty channelSubtypeConfig) {
            this.props.channelSubtypeConfig(channelSubtypeConfig);
            return this;
        }

        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * You can find the <code>instanceId</code> in the ARN of the instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid</a>
         * @param connectInstanceId The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceId(final java.lang.String connectInstanceId) {
            this.props.connectInstanceId(connectInstanceId);
            return this;
        }

        /**
         * The name of the outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name</a>
         * @param name The name of the outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Communication limits configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride</a>
         * @param communicationLimitsOverride Communication limits configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(final software.amazon.awscdk.IResolvable communicationLimitsOverride) {
            this.props.communicationLimitsOverride(communicationLimitsOverride);
            return this;
        }
        /**
         * Communication limits configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride</a>
         * @param communicationLimitsOverride Communication limits configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty communicationLimitsOverride) {
            this.props.communicationLimitsOverride(communicationLimitsOverride);
            return this;
        }

        /**
         * Contains communication time configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig</a>
         * @param communicationTimeConfig Contains communication time configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(final software.amazon.awscdk.IResolvable communicationTimeConfig) {
            this.props.communicationTimeConfig(communicationTimeConfig);
            return this;
        }
        /**
         * Contains communication time configuration for an outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig</a>
         * @param communicationTimeConfig Contains communication time configuration for an outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty communicationTimeConfig) {
            this.props.communicationTimeConfig(communicationTimeConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn</a>
         * @param connectCampaignFlowArn The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectCampaignFlowArn(final java.lang.String connectCampaignFlowArn) {
            this.props.connectCampaignFlowArn(connectCampaignFlowArn);
            return this;
        }

        /**
         * Contains the schedule configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule</a>
         * @param schedule Contains the schedule configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * Contains the schedule configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule</a>
         * @param schedule Contains the schedule configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * Contains source configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source</a>
         * @param source Contains source configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.IResolvable source) {
            this.props.source(source);
            return this;
        }
        /**
         * Contains source configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source</a>
         * @param source Contains source configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty source) {
            this.props.source(source);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign build() {
            return new software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
