package software.amazon.awscdk.services.dms;

/**
 * Properties for defining a <code>CfnEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnEndpointProps cfnEndpointProps = CfnEndpointProps.builder()
 *         .endpointType("endpointType")
 *         .engineName("engineName")
 *         // the properties below are optional
 *         .certificateArn("certificateArn")
 *         .databaseName("databaseName")
 *         .docDbSettings(DocDbSettingsProperty.builder()
 *                 .docsToInvestigate(123)
 *                 .extractDocId(false)
 *                 .nestingLevel("nestingLevel")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .dynamoDbSettings(DynamoDbSettingsProperty.builder()
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .elasticsearchSettings(ElasticsearchSettingsProperty.builder()
 *                 .endpointUri("endpointUri")
 *                 .errorRetryDuration(123)
 *                 .fullLoadErrorPercentage(123)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .endpointIdentifier("endpointIdentifier")
 *         .extraConnectionAttributes("extraConnectionAttributes")
 *         .gcpMySqlSettings(GcpMySQLSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .cleanSourceMetadataOnMismatch(false)
 *                 .databaseName("databaseName")
 *                 .eventsPollInterval(123)
 *                 .maxFileSize(123)
 *                 .parallelLoadThreads(123)
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .serverTimezone("serverTimezone")
 *                 .username("username")
 *                 .build())
 *         .ibmDb2Settings(IbmDb2SettingsProperty.builder()
 *                 .currentLsn("currentLsn")
 *                 .keepCsvFiles(false)
 *                 .loadTimeout(123)
 *                 .maxFileSize(123)
 *                 .maxKBytesPerRead(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .setDataCaptureChanges(false)
 *                 .writeBufferSize(123)
 *                 .build())
 *         .kafkaSettings(KafkaSettingsProperty.builder()
 *                 .broker("broker")
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includePartitionValue(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .messageMaxBytes(123)
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .saslPassword("saslPassword")
 *                 .saslUserName("saslUserName")
 *                 .securityProtocol("securityProtocol")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslClientCertificateArn("sslClientCertificateArn")
 *                 .sslClientKeyArn("sslClientKeyArn")
 *                 .sslClientKeyPassword("sslClientKeyPassword")
 *                 .topic("topic")
 *                 .build())
 *         .kinesisSettings(KinesisSettingsProperty.builder()
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includePartitionValue(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                 .bcpPacketSize(123)
 *                 .controlTablesFileGroup("controlTablesFileGroup")
 *                 .databaseName("databaseName")
 *                 .forceLobLookup(false)
 *                 .password("password")
 *                 .port(123)
 *                 .querySingleAlwaysOnNode(false)
 *                 .readBackupOnly(false)
 *                 .safeguardPolicy("safeguardPolicy")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .tlogAccessMode("tlogAccessMode")
 *                 .trimSpaceInChar(false)
 *                 .useBcpFullLoad(false)
 *                 .username("username")
 *                 .useThirdPartyBackupDevice(false)
 *                 .build())
 *         .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                 .authMechanism("authMechanism")
 *                 .authSource("authSource")
 *                 .authType("authType")
 *                 .databaseName("databaseName")
 *                 .docsToInvestigate("docsToInvestigate")
 *                 .extractDocId("extractDocId")
 *                 .nestingLevel("nestingLevel")
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .username("username")
 *                 .build())
 *         .mySqlSettings(MySqlSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .cleanSourceMetadataOnMismatch(false)
 *                 .eventsPollInterval(123)
 *                 .maxFileSize(123)
 *                 .parallelLoadThreads(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverTimezone("serverTimezone")
 *                 .targetDbType("targetDbType")
 *                 .build())
 *         .neptuneSettings(NeptuneSettingsProperty.builder()
 *                 .errorRetryDuration(123)
 *                 .iamAuthEnabled(false)
 *                 .maxFileSize(123)
 *                 .maxRetryCount(123)
 *                 .s3BucketFolder("s3BucketFolder")
 *                 .s3BucketName("s3BucketName")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .oracleSettings(OracleSettingsProperty.builder()
 *                 .accessAlternateDirectly(false)
 *                 .additionalArchivedLogDestId(123)
 *                 .addSupplementalLogging(false)
 *                 .allowSelectNestedTables(false)
 *                 .archivedLogDestId(123)
 *                 .archivedLogsOnly(false)
 *                 .asmPassword("asmPassword")
 *                 .asmServer("asmServer")
 *                 .asmUser("asmUser")
 *                 .charLengthSemantics("charLengthSemantics")
 *                 .directPathNoLog(false)
 *                 .directPathParallelLoad(false)
 *                 .enableHomogenousTablespace(false)
 *                 .extraArchivedLogDestIds(List.of(123))
 *                 .failTasksOnLobTruncation(false)
 *                 .numberDatatypeScale(123)
 *                 .oraclePathPrefix("oraclePathPrefix")
 *                 .parallelAsmReadThreads(123)
 *                 .readAheadBlocks(123)
 *                 .readTableSpaceName(false)
 *                 .replacePathPrefix(false)
 *                 .retryInterval(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                 .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .securityDbEncryption("securityDbEncryption")
 *                 .securityDbEncryptionName("securityDbEncryptionName")
 *                 .spatialDataOptionToGeoJsonFunctionName("spatialDataOptionToGeoJsonFunctionName")
 *                 .standbyDelayTime(123)
 *                 .useAlternateFolderForOnline(false)
 *                 .useBFile(false)
 *                 .useDirectPathFullLoad(false)
 *                 .useLogminerReader(false)
 *                 .usePathPrefix("usePathPrefix")
 *                 .build())
 *         .password("password")
 *         .port(123)
 *         .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .babelfishDatabaseName("babelfishDatabaseName")
 *                 .captureDdls(false)
 *                 .databaseMode("databaseMode")
 *                 .ddlArtifactsSchema("ddlArtifactsSchema")
 *                 .executeTimeout(123)
 *                 .failTasksOnLobTruncation(false)
 *                 .heartbeatEnable(false)
 *                 .heartbeatFrequency(123)
 *                 .heartbeatSchema("heartbeatSchema")
 *                 .mapBooleanAsBoolean(false)
 *                 .maxFileSize(123)
 *                 .pluginName("pluginName")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .slotName("slotName")
 *                 .build())
 *         .redisSettings(RedisSettingsProperty.builder()
 *                 .authPassword("authPassword")
 *                 .authType("authType")
 *                 .authUserName("authUserName")
 *                 .port(123)
 *                 .serverName("serverName")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslSecurityProtocol("sslSecurityProtocol")
 *                 .build())
 *         .redshiftSettings(RedshiftSettingsProperty.builder()
 *                 .acceptAnyDate(false)
 *                 .afterConnectScript("afterConnectScript")
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .caseSensitiveNames(false)
 *                 .compUpdate(false)
 *                 .connectionTimeout(123)
 *                 .dateFormat("dateFormat")
 *                 .emptyAsNull(false)
 *                 .encryptionMode("encryptionMode")
 *                 .explicitIds(false)
 *                 .fileTransferUploadStreams(123)
 *                 .loadTimeout(123)
 *                 .mapBooleanAsBoolean(false)
 *                 .maxFileSize(123)
 *                 .removeQuotes(false)
 *                 .replaceChars("replaceChars")
 *                 .replaceInvalidChars("replaceInvalidChars")
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .timeFormat("timeFormat")
 *                 .trimBlanks(false)
 *                 .truncateColumns(false)
 *                 .writeBufferSize(123)
 *                 .build())
 *         .resourceIdentifier("resourceIdentifier")
 *         .s3Settings(S3SettingsProperty.builder()
 *                 .addColumnName(false)
 *                 .addTrailingPaddingCharacter(false)
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .cannedAclForObjects("cannedAclForObjects")
 *                 .cdcInsertsAndUpdates(false)
 *                 .cdcInsertsOnly(false)
 *                 .cdcMaxBatchInterval(123)
 *                 .cdcMinFileSize(123)
 *                 .cdcPath("cdcPath")
 *                 .compressionType("compressionType")
 *                 .csvDelimiter("csvDelimiter")
 *                 .csvNoSupValue("csvNoSupValue")
 *                 .csvNullValue("csvNullValue")
 *                 .csvRowDelimiter("csvRowDelimiter")
 *                 .dataFormat("dataFormat")
 *                 .dataPageSize(123)
 *                 .datePartitionDelimiter("datePartitionDelimiter")
 *                 .datePartitionEnabled(false)
 *                 .datePartitionSequence("datePartitionSequence")
 *                 .datePartitionTimezone("datePartitionTimezone")
 *                 .dictPageSizeLimit(123)
 *                 .enableStatistics(false)
 *                 .encodingType("encodingType")
 *                 .encryptionMode("encryptionMode")
 *                 .expectedBucketOwner("expectedBucketOwner")
 *                 .externalTableDefinition("externalTableDefinition")
 *                 .glueCatalogGeneration(false)
 *                 .ignoreHeaderRows(123)
 *                 .includeOpForFullLoad(false)
 *                 .maxFileSize(123)
 *                 .parquetTimestampInMillisecond(false)
 *                 .parquetVersion("parquetVersion")
 *                 .preserveTransactions(false)
 *                 .rfc4180(false)
 *                 .rowGroupLength(123)
 *                 .serverSideEncryptionKmsKeyId("serverSideEncryptionKmsKeyId")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .timestampColumnName("timestampColumnName")
 *                 .useCsvNoSupValue(false)
 *                 .useTaskStartTimeForFullLoadTimestamp(false)
 *                 .build())
 *         .serverName("serverName")
 *         .sslMode("sslMode")
 *         .sybaseSettings(SybaseSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .username("username")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:26.537Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of endpoint.
     * <p>
     * Valid values are <code>source</code> and <code>target</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointType();

    /**
     * The type of engine for the endpoint, depending on the <code>EndpointType</code> value.
     * <p>
     * <em>Valid values</em> : <code>mysql</code> | <code>oracle</code> | <code>postgres</code> | <code>mariadb</code> | <code>aurora</code> | <code>aurora-postgresql</code> | <code>opensearch</code> | <code>redshift</code> | <code>redshift-serverless</code> | <code>s3</code> | <code>db2</code> | <code>azuredb</code> | <code>sybase</code> | <code>dynamodb</code> | <code>mongodb</code> | <code>kinesis</code> | <code>kafka</code> | <code>elasticsearch</code> | <code>docdb</code> | <code>sqlserver</code> | <code>neptune</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineName();

    /**
     * The Amazon Resource Name (ARN) for the certificate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
        return null;
    }

    /**
     * The name of the endpoint database.
     * <p>
     * For a MySQL source or target endpoint, don't specify <code>DatabaseName</code> . To migrate to a specific database, use this setting and <code>targetDbType</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target DocumentDB endpoint.
     * <p>
     * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-docdbsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDocDbSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchSettings() {
        return null;
    }

    /**
     * The database endpoint identifier.
     * <p>
     * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointIdentifier() {
        return null;
    }

    /**
     * Additional attributes associated with the connection.
     * <p>
     * Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtraConnectionAttributes() {
        return null;
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     * <p>
     * These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-gcpmysqlsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGcpMySqlSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the source IBM Db2 LUW endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-ibmdb2settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIbmDb2Settings() {
        return null;
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     * <p>
     * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKafkaSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     * <p>
     * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisSettings() {
        return null;
    }

    /**
     * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, AWS DMS uses your default encryption key.
     * <p>
     * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target Microsoft SQL Server endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-microsoftsqlserversettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMicrosoftSqlServerSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the source MongoDB endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Using MongoDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mysqlsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMySqlSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the target Amazon Neptune endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNeptuneSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-oraclesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOracleSettings() {
        return null;
    }

    /**
     * The password to be used to log in to the endpoint database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * The port used by the endpoint database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target PostgreSQL endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-postgresqlsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redissettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedisSettings() {
        return null;
    }

    /**
     * Settings in JSON format for the Amazon Redshift endpoint.
     * <p>
     * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-redshiftsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSettings() {
        return null;
    }

    /**
     * A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object.
     * <p>
     * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> .
     * <p>
     * For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-resourceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target Amazon S3 endpoint.
     * <p>
     * For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3Settings() {
        return null;
    }

    /**
     * The name of the server where the endpoint database resides.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return null;
    }

    /**
     * The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> .
     * <p>
     * <blockquote>
     * <p>
     * When <code>engine_name</code> is set to S3, the only allowed value is <code>none</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
        return null;
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sybasesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSybaseSettings() {
        return null;
    }

    /**
     * One or more tags to be assigned to the endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The user name to be used to log in to the endpoint database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointProps> {
        java.lang.String endpointType;
        java.lang.String engineName;
        java.lang.String certificateArn;
        java.lang.String databaseName;
        java.lang.Object docDbSettings;
        java.lang.Object dynamoDbSettings;
        java.lang.Object elasticsearchSettings;
        java.lang.String endpointIdentifier;
        java.lang.String extraConnectionAttributes;
        java.lang.Object gcpMySqlSettings;
        java.lang.Object ibmDb2Settings;
        java.lang.Object kafkaSettings;
        java.lang.Object kinesisSettings;
        java.lang.String kmsKeyId;
        java.lang.Object microsoftSqlServerSettings;
        java.lang.Object mongoDbSettings;
        java.lang.Object mySqlSettings;
        java.lang.Object neptuneSettings;
        java.lang.Object oracleSettings;
        java.lang.String password;
        java.lang.Number port;
        java.lang.Object postgreSqlSettings;
        java.lang.Object redisSettings;
        java.lang.Object redshiftSettings;
        java.lang.String resourceIdentifier;
        java.lang.Object s3Settings;
        java.lang.String serverName;
        java.lang.String sslMode;
        java.lang.Object sybaseSettings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String username;

        /**
         * Sets the value of {@link CfnEndpointProps#getEndpointType}
         * @param endpointType The type of endpoint. This parameter is required.
         *                     Valid values are <code>source</code> and <code>target</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(java.lang.String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getEngineName}
         * @param engineName The type of engine for the endpoint, depending on the <code>EndpointType</code> value. This parameter is required.
         *                   <em>Valid values</em> : <code>mysql</code> | <code>oracle</code> | <code>postgres</code> | <code>mariadb</code> | <code>aurora</code> | <code>aurora-postgresql</code> | <code>opensearch</code> | <code>redshift</code> | <code>redshift-serverless</code> | <code>s3</code> | <code>db2</code> | <code>azuredb</code> | <code>sybase</code> | <code>dynamodb</code> | <code>mongodb</code> | <code>kinesis</code> | <code>kafka</code> | <code>elasticsearch</code> | <code>docdb</code> | <code>sqlserver</code> | <code>neptune</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(java.lang.String engineName) {
            this.engineName = engineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getCertificateArn}
         * @param certificateArn The Amazon Resource Name (ARN) for the certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArn(java.lang.String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDatabaseName}
         * @param databaseName The name of the endpoint database.
         *                     For a MySQL source or target endpoint, don't specify <code>DatabaseName</code> . To migrate to a specific database, use this setting and <code>targetDbType</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDocDbSettings}
         * @param docDbSettings Settings in JSON format for the source and target DocumentDB endpoint.
         *                      For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(software.amazon.awscdk.IResolvable docDbSettings) {
            this.docDbSettings = docDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDocDbSettings}
         * @param docDbSettings Settings in JSON format for the source and target DocumentDB endpoint.
         *                      For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html#CHAP_Source.DocumentDB.ECAs">Using extra connections attributes with Amazon DocumentDB as a source</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DocumentDB.html">Using Amazon DocumentDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty docDbSettings) {
            this.docDbSettings = docDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDynamoDbSettings}
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint.
         *                         For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(software.amazon.awscdk.IResolvable dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getDynamoDbSettings}
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint.
         *                         For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using object mapping to migrate data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getElasticsearchSettings}
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint.
         *                              For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(software.amazon.awscdk.IResolvable elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getElasticsearchSettings}
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint.
         *                              For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra connection attributes when using OpenSearch as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getEndpointIdentifier}
         * @param endpointIdentifier The database endpoint identifier.
         *                           Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointIdentifier(java.lang.String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getExtraConnectionAttributes}
         * @param extraConnectionAttributes Additional attributes associated with the connection.
         *                                  Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraConnectionAttributes(java.lang.String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getGcpMySqlSettings}
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint.
         *                         These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(software.amazon.awscdk.IResolvable gcpMySqlSettings) {
            this.gcpMySqlSettings = gcpMySqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getGcpMySqlSettings}
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint.
         *                         These settings are much the same as the settings for any MySQL-compatible endpoint. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(software.amazon.awscdk.services.dms.CfnEndpoint.GcpMySQLSettingsProperty gcpMySqlSettings) {
            this.gcpMySqlSettings = gcpMySqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getIbmDb2Settings}
         * @param ibmDb2Settings Settings in JSON format for the source IBM Db2 LUW endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(software.amazon.awscdk.IResolvable ibmDb2Settings) {
            this.ibmDb2Settings = ibmDb2Settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getIbmDb2Settings}
         * @param ibmDb2Settings Settings in JSON format for the source IBM Db2 LUW endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes when using Db2 LUW as a source for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty ibmDb2Settings) {
            this.ibmDb2Settings = ibmDb2Settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getKafkaSettings}
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint.
         *                      For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(software.amazon.awscdk.IResolvable kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getKafkaSettings}
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint.
         *                      For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getKinesisSettings}
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         *                        For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(software.amazon.awscdk.IResolvable kinesisSettings) {
            this.kinesisSettings = kinesisSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getKinesisSettings}
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         *                        For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to migrate data to a Kinesis data stream</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty kinesisSettings) {
            this.kinesisSettings = kinesisSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getKmsKeyId}
         * @param kmsKeyId An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
         *                 If you don't specify a value for the <code>KmsKeyId</code> parameter, AWS DMS uses your default encryption key.
         *                 <p>
         *                 AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMicrosoftSqlServerSettings}
         * @param microsoftSqlServerSettings Settings in JSON format for the source and target Microsoft SQL Server endpoint.
         *                                   For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(software.amazon.awscdk.IResolvable microsoftSqlServerSettings) {
            this.microsoftSqlServerSettings = microsoftSqlServerSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMicrosoftSqlServerSettings}
         * @param microsoftSqlServerSettings Settings in JSON format for the source and target Microsoft SQL Server endpoint.
         *                                   For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">Extra connection attributes when using SQL Server as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
            this.microsoftSqlServerSettings = microsoftSqlServerSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMongoDbSettings}
         * @param mongoDbSettings Settings in JSON format for the source MongoDB endpoint.
         *                        For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Using MongoDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(software.amazon.awscdk.IResolvable mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMongoDbSettings}
         * @param mongoDbSettings Settings in JSON format for the source MongoDB endpoint.
         *                        For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Using MongoDB as a target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMySqlSettings}
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint.
         *                      For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(software.amazon.awscdk.IResolvable mySqlSettings) {
            this.mySqlSettings = mySqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getMySqlSettings}
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint.
         *                      For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty mySqlSettings) {
            this.mySqlSettings = mySqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getNeptuneSettings}
         * @param neptuneSettings Settings in JSON format for the target Amazon Neptune endpoint.
         *                        For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(software.amazon.awscdk.IResolvable neptuneSettings) {
            this.neptuneSettings = neptuneSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getNeptuneSettings}
         * @param neptuneSettings Settings in JSON format for the target Amazon Neptune endpoint.
         *                        For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying endpoint settings for Amazon Neptune as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty neptuneSettings) {
            this.neptuneSettings = neptuneSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getOracleSettings}
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(software.amazon.awscdk.IResolvable oracleSettings) {
            this.oracleSettings = oracleSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getOracleSettings}
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty oracleSettings) {
            this.oracleSettings = oracleSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getPassword}
         * @param password The password to be used to log in to the endpoint database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getPort}
         * @param port The port used by the endpoint database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getPostgreSqlSettings}
         * @param postgreSqlSettings Settings in JSON format for the source and target PostgreSQL endpoint.
         *                           For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(software.amazon.awscdk.IResolvable postgreSqlSettings) {
            this.postgreSqlSettings = postgreSqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getPostgreSqlSettings}
         * @param postgreSqlSettings Settings in JSON format for the source and target PostgreSQL endpoint.
         *                           For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">Extra connection attributes when using PostgreSQL as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty postgreSqlSettings) {
            this.postgreSqlSettings = postgreSqlSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRedisSettings}
         * @param redisSettings Settings in JSON format for the target Redis endpoint.
         *                      For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(software.amazon.awscdk.IResolvable redisSettings) {
            this.redisSettings = redisSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRedisSettings}
         * @param redisSettings Settings in JSON format for the target Redis endpoint.
         *                      For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redis.html#CHAP_Target.Redis.EndpointSettings">Specifying endpoint settings for Redis as a target</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty redisSettings) {
            this.redisSettings = redisSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRedshiftSettings}
         * @param redshiftSettings Settings in JSON format for the Amazon Redshift endpoint.
         *                         For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(software.amazon.awscdk.IResolvable redshiftSettings) {
            this.redshiftSettings = redshiftSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getRedshiftSettings}
         * @param redshiftSettings Settings in JSON format for the Amazon Redshift endpoint.
         *                         For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Redshift.html#CHAP_Target.Redshift.ConnectionAttrib">Extra connection attributes when using Amazon Redshift as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty redshiftSettings) {
            this.redshiftSettings = redshiftSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getResourceIdentifier}
         * @param resourceIdentifier A display name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is returned in the created <code>Endpoint</code> object.
         *                           The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> .
         *                           <p>
         *                           For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getS3Settings}
         * @param s3Settings Settings in JSON format for the source and target Amazon S3 endpoint.
         *                   For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(software.amazon.awscdk.IResolvable s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getS3Settings}
         * @param s3Settings Settings in JSON format for the source and target Amazon S3 endpoint.
         *                   For more information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.S3.html#CHAP_Source.S3.Configuring">Extra connection attributes when using Amazon S3 as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra connection attributes when using Amazon S3 as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getServerName}
         * @param serverName The name of the server where the endpoint database resides.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(java.lang.String serverName) {
            this.serverName = serverName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getSslMode}
         * @param sslMode The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code> .
         *                <blockquote>
         *                <p>
         *                When <code>engine_name</code> is set to S3, the only allowed value is <code>none</code> .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslMode(java.lang.String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getSybaseSettings}
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(software.amazon.awscdk.IResolvable sybaseSettings) {
            this.sybaseSettings = sybaseSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getSybaseSettings}
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint.
         *                       For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty sybaseSettings) {
            this.sybaseSettings = sybaseSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getTags}
         * @param tags One or more tags to be assigned to the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointProps#getUsername}
         * @param username The user name to be used to log in to the endpoint database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointProps {
        private final java.lang.String endpointType;
        private final java.lang.String engineName;
        private final java.lang.String certificateArn;
        private final java.lang.String databaseName;
        private final java.lang.Object docDbSettings;
        private final java.lang.Object dynamoDbSettings;
        private final java.lang.Object elasticsearchSettings;
        private final java.lang.String endpointIdentifier;
        private final java.lang.String extraConnectionAttributes;
        private final java.lang.Object gcpMySqlSettings;
        private final java.lang.Object ibmDb2Settings;
        private final java.lang.Object kafkaSettings;
        private final java.lang.Object kinesisSettings;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object microsoftSqlServerSettings;
        private final java.lang.Object mongoDbSettings;
        private final java.lang.Object mySqlSettings;
        private final java.lang.Object neptuneSettings;
        private final java.lang.Object oracleSettings;
        private final java.lang.String password;
        private final java.lang.Number port;
        private final java.lang.Object postgreSqlSettings;
        private final java.lang.Object redisSettings;
        private final java.lang.Object redshiftSettings;
        private final java.lang.String resourceIdentifier;
        private final java.lang.Object s3Settings;
        private final java.lang.String serverName;
        private final java.lang.String sslMode;
        private final java.lang.Object sybaseSettings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String username;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineName = software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.docDbSettings = software.amazon.jsii.Kernel.get(this, "docDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dynamoDbSettings = software.amazon.jsii.Kernel.get(this, "dynamoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchSettings = software.amazon.jsii.Kernel.get(this, "elasticsearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointIdentifier = software.amazon.jsii.Kernel.get(this, "endpointIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraConnectionAttributes = software.amazon.jsii.Kernel.get(this, "extraConnectionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gcpMySqlSettings = software.amazon.jsii.Kernel.get(this, "gcpMySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ibmDb2Settings = software.amazon.jsii.Kernel.get(this, "ibmDb2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kafkaSettings = software.amazon.jsii.Kernel.get(this, "kafkaSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisSettings = software.amazon.jsii.Kernel.get(this, "kinesisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.microsoftSqlServerSettings = software.amazon.jsii.Kernel.get(this, "microsoftSqlServerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mongoDbSettings = software.amazon.jsii.Kernel.get(this, "mongoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mySqlSettings = software.amazon.jsii.Kernel.get(this, "mySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.neptuneSettings = software.amazon.jsii.Kernel.get(this, "neptuneSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.oracleSettings = software.amazon.jsii.Kernel.get(this, "oracleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.postgreSqlSettings = software.amazon.jsii.Kernel.get(this, "postgreSqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redisSettings = software.amazon.jsii.Kernel.get(this, "redisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redshiftSettings = software.amazon.jsii.Kernel.get(this, "redshiftSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Settings = software.amazon.jsii.Kernel.get(this, "s3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sybaseSettings = software.amazon.jsii.Kernel.get(this, "sybaseSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointType = java.util.Objects.requireNonNull(builder.endpointType, "endpointType is required");
            this.engineName = java.util.Objects.requireNonNull(builder.engineName, "engineName is required");
            this.certificateArn = builder.certificateArn;
            this.databaseName = builder.databaseName;
            this.docDbSettings = builder.docDbSettings;
            this.dynamoDbSettings = builder.dynamoDbSettings;
            this.elasticsearchSettings = builder.elasticsearchSettings;
            this.endpointIdentifier = builder.endpointIdentifier;
            this.extraConnectionAttributes = builder.extraConnectionAttributes;
            this.gcpMySqlSettings = builder.gcpMySqlSettings;
            this.ibmDb2Settings = builder.ibmDb2Settings;
            this.kafkaSettings = builder.kafkaSettings;
            this.kinesisSettings = builder.kinesisSettings;
            this.kmsKeyId = builder.kmsKeyId;
            this.microsoftSqlServerSettings = builder.microsoftSqlServerSettings;
            this.mongoDbSettings = builder.mongoDbSettings;
            this.mySqlSettings = builder.mySqlSettings;
            this.neptuneSettings = builder.neptuneSettings;
            this.oracleSettings = builder.oracleSettings;
            this.password = builder.password;
            this.port = builder.port;
            this.postgreSqlSettings = builder.postgreSqlSettings;
            this.redisSettings = builder.redisSettings;
            this.redshiftSettings = builder.redshiftSettings;
            this.resourceIdentifier = builder.resourceIdentifier;
            this.s3Settings = builder.s3Settings;
            this.serverName = builder.serverName;
            this.sslMode = builder.sslMode;
            this.sybaseSettings = builder.sybaseSettings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.username = builder.username;
        }

        @Override
        public final java.lang.String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final java.lang.String getEngineName() {
            return this.engineName;
        }

        @Override
        public final java.lang.String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.Object getDocDbSettings() {
            return this.docDbSettings;
        }

        @Override
        public final java.lang.Object getDynamoDbSettings() {
            return this.dynamoDbSettings;
        }

        @Override
        public final java.lang.Object getElasticsearchSettings() {
            return this.elasticsearchSettings;
        }

        @Override
        public final java.lang.String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        @Override
        public final java.lang.String getExtraConnectionAttributes() {
            return this.extraConnectionAttributes;
        }

        @Override
        public final java.lang.Object getGcpMySqlSettings() {
            return this.gcpMySqlSettings;
        }

        @Override
        public final java.lang.Object getIbmDb2Settings() {
            return this.ibmDb2Settings;
        }

        @Override
        public final java.lang.Object getKafkaSettings() {
            return this.kafkaSettings;
        }

        @Override
        public final java.lang.Object getKinesisSettings() {
            return this.kinesisSettings;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMicrosoftSqlServerSettings() {
            return this.microsoftSqlServerSettings;
        }

        @Override
        public final java.lang.Object getMongoDbSettings() {
            return this.mongoDbSettings;
        }

        @Override
        public final java.lang.Object getMySqlSettings() {
            return this.mySqlSettings;
        }

        @Override
        public final java.lang.Object getNeptuneSettings() {
            return this.neptuneSettings;
        }

        @Override
        public final java.lang.Object getOracleSettings() {
            return this.oracleSettings;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.Object getPostgreSqlSettings() {
            return this.postgreSqlSettings;
        }

        @Override
        public final java.lang.Object getRedisSettings() {
            return this.redisSettings;
        }

        @Override
        public final java.lang.Object getRedshiftSettings() {
            return this.redshiftSettings;
        }

        @Override
        public final java.lang.String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final java.lang.Object getS3Settings() {
            return this.s3Settings;
        }

        @Override
        public final java.lang.String getServerName() {
            return this.serverName;
        }

        @Override
        public final java.lang.String getSslMode() {
            return this.sslMode;
        }

        @Override
        public final java.lang.Object getSybaseSettings() {
            return this.sybaseSettings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointType", om.valueToTree(this.getEndpointType()));
            data.set("engineName", om.valueToTree(this.getEngineName()));
            if (this.getCertificateArn() != null) {
                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
            }
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }
            if (this.getDocDbSettings() != null) {
                data.set("docDbSettings", om.valueToTree(this.getDocDbSettings()));
            }
            if (this.getDynamoDbSettings() != null) {
                data.set("dynamoDbSettings", om.valueToTree(this.getDynamoDbSettings()));
            }
            if (this.getElasticsearchSettings() != null) {
                data.set("elasticsearchSettings", om.valueToTree(this.getElasticsearchSettings()));
            }
            if (this.getEndpointIdentifier() != null) {
                data.set("endpointIdentifier", om.valueToTree(this.getEndpointIdentifier()));
            }
            if (this.getExtraConnectionAttributes() != null) {
                data.set("extraConnectionAttributes", om.valueToTree(this.getExtraConnectionAttributes()));
            }
            if (this.getGcpMySqlSettings() != null) {
                data.set("gcpMySqlSettings", om.valueToTree(this.getGcpMySqlSettings()));
            }
            if (this.getIbmDb2Settings() != null) {
                data.set("ibmDb2Settings", om.valueToTree(this.getIbmDb2Settings()));
            }
            if (this.getKafkaSettings() != null) {
                data.set("kafkaSettings", om.valueToTree(this.getKafkaSettings()));
            }
            if (this.getKinesisSettings() != null) {
                data.set("kinesisSettings", om.valueToTree(this.getKinesisSettings()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMicrosoftSqlServerSettings() != null) {
                data.set("microsoftSqlServerSettings", om.valueToTree(this.getMicrosoftSqlServerSettings()));
            }
            if (this.getMongoDbSettings() != null) {
                data.set("mongoDbSettings", om.valueToTree(this.getMongoDbSettings()));
            }
            if (this.getMySqlSettings() != null) {
                data.set("mySqlSettings", om.valueToTree(this.getMySqlSettings()));
            }
            if (this.getNeptuneSettings() != null) {
                data.set("neptuneSettings", om.valueToTree(this.getNeptuneSettings()));
            }
            if (this.getOracleSettings() != null) {
                data.set("oracleSettings", om.valueToTree(this.getOracleSettings()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPostgreSqlSettings() != null) {
                data.set("postgreSqlSettings", om.valueToTree(this.getPostgreSqlSettings()));
            }
            if (this.getRedisSettings() != null) {
                data.set("redisSettings", om.valueToTree(this.getRedisSettings()));
            }
            if (this.getRedshiftSettings() != null) {
                data.set("redshiftSettings", om.valueToTree(this.getRedshiftSettings()));
            }
            if (this.getResourceIdentifier() != null) {
                data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));
            }
            if (this.getS3Settings() != null) {
                data.set("s3Settings", om.valueToTree(this.getS3Settings()));
            }
            if (this.getServerName() != null) {
                data.set("serverName", om.valueToTree(this.getServerName()));
            }
            if (this.getSslMode() != null) {
                data.set("sslMode", om.valueToTree(this.getSslMode()));
            }
            if (this.getSybaseSettings() != null) {
                data.set("sybaseSettings", om.valueToTree(this.getSybaseSettings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUsername() != null) {
                data.set("username", om.valueToTree(this.getUsername()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointProps.Jsii$Proxy that = (CfnEndpointProps.Jsii$Proxy) o;

            if (!endpointType.equals(that.endpointType)) return false;
            if (!engineName.equals(that.engineName)) return false;
            if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
            if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
            if (this.docDbSettings != null ? !this.docDbSettings.equals(that.docDbSettings) : that.docDbSettings != null) return false;
            if (this.dynamoDbSettings != null ? !this.dynamoDbSettings.equals(that.dynamoDbSettings) : that.dynamoDbSettings != null) return false;
            if (this.elasticsearchSettings != null ? !this.elasticsearchSettings.equals(that.elasticsearchSettings) : that.elasticsearchSettings != null) return false;
            if (this.endpointIdentifier != null ? !this.endpointIdentifier.equals(that.endpointIdentifier) : that.endpointIdentifier != null) return false;
            if (this.extraConnectionAttributes != null ? !this.extraConnectionAttributes.equals(that.extraConnectionAttributes) : that.extraConnectionAttributes != null) return false;
            if (this.gcpMySqlSettings != null ? !this.gcpMySqlSettings.equals(that.gcpMySqlSettings) : that.gcpMySqlSettings != null) return false;
            if (this.ibmDb2Settings != null ? !this.ibmDb2Settings.equals(that.ibmDb2Settings) : that.ibmDb2Settings != null) return false;
            if (this.kafkaSettings != null ? !this.kafkaSettings.equals(that.kafkaSettings) : that.kafkaSettings != null) return false;
            if (this.kinesisSettings != null ? !this.kinesisSettings.equals(that.kinesisSettings) : that.kinesisSettings != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.microsoftSqlServerSettings != null ? !this.microsoftSqlServerSettings.equals(that.microsoftSqlServerSettings) : that.microsoftSqlServerSettings != null) return false;
            if (this.mongoDbSettings != null ? !this.mongoDbSettings.equals(that.mongoDbSettings) : that.mongoDbSettings != null) return false;
            if (this.mySqlSettings != null ? !this.mySqlSettings.equals(that.mySqlSettings) : that.mySqlSettings != null) return false;
            if (this.neptuneSettings != null ? !this.neptuneSettings.equals(that.neptuneSettings) : that.neptuneSettings != null) return false;
            if (this.oracleSettings != null ? !this.oracleSettings.equals(that.oracleSettings) : that.oracleSettings != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.postgreSqlSettings != null ? !this.postgreSqlSettings.equals(that.postgreSqlSettings) : that.postgreSqlSettings != null) return false;
            if (this.redisSettings != null ? !this.redisSettings.equals(that.redisSettings) : that.redisSettings != null) return false;
            if (this.redshiftSettings != null ? !this.redshiftSettings.equals(that.redshiftSettings) : that.redshiftSettings != null) return false;
            if (this.resourceIdentifier != null ? !this.resourceIdentifier.equals(that.resourceIdentifier) : that.resourceIdentifier != null) return false;
            if (this.s3Settings != null ? !this.s3Settings.equals(that.s3Settings) : that.s3Settings != null) return false;
            if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
            if (this.sslMode != null ? !this.sslMode.equals(that.sslMode) : that.sslMode != null) return false;
            if (this.sybaseSettings != null ? !this.sybaseSettings.equals(that.sybaseSettings) : that.sybaseSettings != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.username != null ? this.username.equals(that.username) : that.username == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpointType.hashCode();
            result = 31 * result + (this.engineName.hashCode());
            result = 31 * result + (this.certificateArn != null ? this.certificateArn.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.docDbSettings != null ? this.docDbSettings.hashCode() : 0);
            result = 31 * result + (this.dynamoDbSettings != null ? this.dynamoDbSettings.hashCode() : 0);
            result = 31 * result + (this.elasticsearchSettings != null ? this.elasticsearchSettings.hashCode() : 0);
            result = 31 * result + (this.endpointIdentifier != null ? this.endpointIdentifier.hashCode() : 0);
            result = 31 * result + (this.extraConnectionAttributes != null ? this.extraConnectionAttributes.hashCode() : 0);
            result = 31 * result + (this.gcpMySqlSettings != null ? this.gcpMySqlSettings.hashCode() : 0);
            result = 31 * result + (this.ibmDb2Settings != null ? this.ibmDb2Settings.hashCode() : 0);
            result = 31 * result + (this.kafkaSettings != null ? this.kafkaSettings.hashCode() : 0);
            result = 31 * result + (this.kinesisSettings != null ? this.kinesisSettings.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.microsoftSqlServerSettings != null ? this.microsoftSqlServerSettings.hashCode() : 0);
            result = 31 * result + (this.mongoDbSettings != null ? this.mongoDbSettings.hashCode() : 0);
            result = 31 * result + (this.mySqlSettings != null ? this.mySqlSettings.hashCode() : 0);
            result = 31 * result + (this.neptuneSettings != null ? this.neptuneSettings.hashCode() : 0);
            result = 31 * result + (this.oracleSettings != null ? this.oracleSettings.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.postgreSqlSettings != null ? this.postgreSqlSettings.hashCode() : 0);
            result = 31 * result + (this.redisSettings != null ? this.redisSettings.hashCode() : 0);
            result = 31 * result + (this.redshiftSettings != null ? this.redshiftSettings.hashCode() : 0);
            result = 31 * result + (this.resourceIdentifier != null ? this.resourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.s3Settings != null ? this.s3Settings.hashCode() : 0);
            result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
            result = 31 * result + (this.sslMode != null ? this.sslMode.hashCode() : 0);
            result = 31 * result + (this.sybaseSettings != null ? this.sybaseSettings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            return result;
        }
    }
}
