package software.amazon.awscdk.services.ec2;

/**
 * Implementations for IPv6 address management.
 * <p>
 * Note this is specific to the IPv6 CIDR.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.353Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IIpv6Addresses")
@software.amazon.jsii.Jsii.Proxy(IIpv6Addresses.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IIpv6Addresses extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the IPv6 CIDR is Amazon provided or not.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAmazonProvided();

    /**
     * Whether the IPv6 CIDR is Amazon provided or not.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     */
    void setAmazonProvided(final @org.jetbrains.annotations.NotNull java.lang.Boolean value);

    /**
     * Allocates Subnets IPv6 CIDRs. Called by VPC when creating subnets with IPv6 enabled.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     * <p>
     * @param input This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetIpamOptions allocateSubnetsIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateIpv6CidrRequest input);

    /**
     * Called by VPC to allocate IPv6 CIDR.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     * <p>
     * @param input This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPCCidrBlock allocateVpcIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateVpcIpv6CidrRequest input);

    /**
     * Split IPv6 CIDR block up for subnets.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     * <p>
     * @param input This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> createIpv6CidrBlocks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CreateIpv6CidrBlocksRequest input);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IIpv6Addresses.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Whether the IPv6 CIDR is Amazon provided or not.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getAmazonProvided() {
            return software.amazon.jsii.Kernel.get(this, "amazonProvided", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether the IPv6 CIDR is Amazon provided or not.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final void setAmazonProvided(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
            software.amazon.jsii.Kernel.set(this, "amazonProvided", java.util.Objects.requireNonNull(value, "amazonProvided is required"));
        }

        /**
         * Allocates Subnets IPv6 CIDRs. Called by VPC when creating subnets with IPv6 enabled.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetIpamOptions allocateSubnetsIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateIpv6CidrRequest input) {
            return software.amazon.jsii.Kernel.call(this, "allocateSubnetsIpv6Cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetIpamOptions.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
        }

        /**
         * Called by VPC to allocate IPv6 CIDR.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPCCidrBlock allocateVpcIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateVpcIpv6CidrRequest input) {
            return software.amazon.jsii.Kernel.call(this, "allocateVpcIpv6Cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
        }

        /**
         * Split IPv6 CIDR block up for subnets.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> createIpv6CidrBlocks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CreateIpv6CidrBlocksRequest input) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "createIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(input, "input is required") }));
        }
    }

    /**
     * Internal default implementation for {@link IIpv6Addresses}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IIpv6Addresses {

        /**
         * Whether the IPv6 CIDR is Amazon provided or not.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getAmazonProvided() {
            return software.amazon.jsii.Kernel.get(this, "amazonProvided", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Whether the IPv6 CIDR is Amazon provided or not.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default void setAmazonProvided(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
            software.amazon.jsii.Kernel.set(this, "amazonProvided", java.util.Objects.requireNonNull(value, "amazonProvided is required"));
        }

        /**
         * Allocates Subnets IPv6 CIDRs. Called by VPC when creating subnets with IPv6 enabled.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetIpamOptions allocateSubnetsIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateIpv6CidrRequest input) {
            return software.amazon.jsii.Kernel.call(this, "allocateSubnetsIpv6Cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetIpamOptions.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
        }

        /**
         * Called by VPC to allocate IPv6 CIDR.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPCCidrBlock allocateVpcIpv6Cidr(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AllocateVpcIpv6CidrRequest input) {
            return software.amazon.jsii.Kernel.call(this, "allocateVpcIpv6Cidr", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
        }

        /**
         * Split IPv6 CIDR block up for subnets.
         * <p>
         * Note this is specific to the IPv6 CIDR.
         * <p>
         * @param input This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> createIpv6CidrBlocks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CreateIpv6CidrBlocksRequest input) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "createIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(input, "input is required") }));
        }
    }
}
