package software.amazon.awscdk.services.ec2;

/**
 * Represents a new VPC subnet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ApplicationLoadBalancedFargateService loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .minHealthyPercent(100)
 *         .taskSubnets(SubnetSelection.builder()
 *                 .subnets(List.of(Subnet.fromSubnetId(this, "subnet", "VpcISOLATEDSubnet1Subnet80F07FA0")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.480Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.Subnet")
public class Subnet extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.ISubnet {

    protected Subnet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subnet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Subnet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet fromSubnetAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "fromSubnetAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import existing subnet from id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param subnetId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet fromSubnetId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String subnetId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "fromSubnetId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(subnetId, "subnetId is required") });
    }

    /**
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isVpcSubnet(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Subnet.class, "isVpcSubnet", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Create a default route that points to a passed IGW, with a dependency on the IGW's attachment to the VPC.
     * <p>
     * @param gatewayId the logical ID (ref) of the gateway attached to your VPC. This parameter is required.
     * @param gatewayAttachment the gateway attachment construct to be added as a dependency. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDefaultInternetRoute(final @org.jetbrains.annotations.NotNull java.lang.String gatewayId, final @org.jetbrains.annotations.NotNull software.constructs.IDependable gatewayAttachment) {
        software.amazon.jsii.Kernel.call(this, "addDefaultInternetRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(gatewayId, "gatewayId is required"), java.util.Objects.requireNonNull(gatewayAttachment, "gatewayAttachment is required") });
    }

    /**
     * Adds an entry to this subnets route table that points to the passed NATGatewayId.
     * <p>
     * @param natGatewayId The ID of the NAT gateway. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDefaultNatRoute(final @org.jetbrains.annotations.NotNull java.lang.String natGatewayId) {
        software.amazon.jsii.Kernel.call(this, "addDefaultNatRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(natGatewayId, "natGatewayId is required") });
    }

    /**
     * Create a default IPv6 route that points to a passed EIGW.
     * <p>
     * @param gatewayId the logical ID (ref) of the gateway attached to your VPC. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIpv6DefaultEgressOnlyInternetRoute(final @org.jetbrains.annotations.NotNull java.lang.String gatewayId) {
        software.amazon.jsii.Kernel.call(this, "addIpv6DefaultEgressOnlyInternetRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(gatewayId, "gatewayId is required") });
    }

    /**
     * Create a default IPv6 route that points to a passed IGW.
     * <p>
     * @param gatewayId the logical ID (ref) of the gateway attached to your VPC. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIpv6DefaultInternetRoute(final @org.jetbrains.annotations.NotNull java.lang.String gatewayId) {
        software.amazon.jsii.Kernel.call(this, "addIpv6DefaultInternetRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(gatewayId, "gatewayId is required") });
    }

    /**
     * Adds an entry to this subnets route table that points to the passed NATGatewayId.
     * <p>
     * Uses the known 64:ff9b::/96 prefix.
     * <p>
     * @param natGatewayId The ID of the NAT gateway. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addIpv6Nat64Route(final @org.jetbrains.annotations.NotNull java.lang.String natGatewayId) {
        software.amazon.jsii.Kernel.call(this, "addIpv6Nat64Route", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(natGatewayId, "natGatewayId is required") });
    }

    /**
     * Adds an entry to this subnets route table.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRoute(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AddRouteOptions options) {
        software.amazon.jsii.Kernel.call(this, "addRoute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Associate a Network ACL with this subnet.
     * <p>
     * @param id This parameter is required.
     * @param networkAcl This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void associateNetworkAcl(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
        software.amazon.jsii.Kernel.call(this, "associateNetworkAcl", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkAcl, "networkAcl is required") });
    }

    /**
     * The Availability Zone the subnet is located in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Parts of this VPC subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.constructs.IDependable> getDependencyElements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencyElements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class))));
    }

    /**
     * Dependable that can be depended upon to force internet connectivity established on the VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.IDependable getInternetConnectivityEstablished() {
        return software.amazon.jsii.Kernel.get(this, "internetConnectivityEstablished", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
    }

    /**
     * The IPv4 CIDR block for this subnet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpv4CidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "ipv4CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Network ACL associated with this Subnet.
     * <p>
     * Upon creation, this is the default ACL which allows all traffic, except
     * explicit DENY entries that you add.
     * <p>
     * You can replace it with a custom ACL which denies all traffic except
     * the explicit ALLOW entries that you add by creating a <code>NetworkAcl</code>
     * object and calling <code>associateNetworkAcl()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
        return software.amazon.jsii.Kernel.get(this, "networkAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.INetworkAcl.class));
    }

    /**
     * The routeTableId attached to this subnet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IRouteTable getRouteTable() {
        return software.amazon.jsii.Kernel.get(this, "routeTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IRouteTable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "subnetAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subnetId for this particular subnet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIpv6CidrBlocks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnetIpv6CidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetNetworkAclAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "subnetNetworkAclAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost for this subnet (if one exists).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetOutpostArn() {
        return software.amazon.jsii.Kernel.get(this, "subnetOutpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubnetVpcId() {
        return software.amazon.jsii.Kernel.get(this, "subnetVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Subnet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Subnet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.SubnetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.SubnetProps.Builder();
        }

        /**
         * The availability zone for the subnet.
         * <p>
         * @return {@code this}
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The CIDR notation for this subnet.
         * <p>
         * @return {@code this}
         * @param cidrBlock The CIDR notation for this subnet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(final java.lang.String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        /**
         * The VPC which this subnet is part of.
         * <p>
         * @return {@code this}
         * @param vpcId The VPC which this subnet is part of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Indicates whether a network interface created in this subnet receives an IPv6 address.
         * <p>
         * If you specify AssignIpv6AddressOnCreation, you must also specify Ipv6CidrBlock.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(final java.lang.Boolean assignIpv6AddressOnCreation) {
            this.props.assignIpv6AddressOnCreation(assignIpv6AddressOnCreation);
            return this;
        }

        /**
         * The IPv6 CIDR block.
         * <p>
         * If you specify AssignIpv6AddressOnCreation, you must also specify Ipv6CidrBlock.
         * <p>
         * Default: - no IPv6 CIDR block.
         * <p>
         * @return {@code this}
         * @param ipv6CidrBlock The IPv6 CIDR block. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(final java.lang.String ipv6CidrBlock) {
            this.props.ipv6CidrBlock(ipv6CidrBlock);
            return this;
        }

        /**
         * Controls if a public IP is associated to an instance at launch.
         * <p>
         * Default: true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
         * <p>
         * @return {@code this}
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(final java.lang.Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.Subnet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Subnet build() {
            return new software.amazon.awscdk.services.ec2.Subnet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
