package software.amazon.awscdk.services.ecs;

/**
 * The CpuArchitecture for Fargate Runtime Platform.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the Windows container to start
 * FargateTaskDefinition taskDefinition = FargateTaskDefinition.Builder.create(this, "TaskDef")
 *         .runtimePlatform(RuntimePlatform.builder()
 *                 .operatingSystemFamily(OperatingSystemFamily.WINDOWS_SERVER_2019_CORE)
 *                 .cpuArchitecture(CpuArchitecture.X86_64)
 *                 .build())
 *         .cpu(1024)
 *         .memoryLimitMiB(2048)
 *         .build();
 * taskDefinition.addContainer("windowsservercore", ContainerDefinitionOptions.builder()
 *         .logging(LogDriver.awsLogs(AwsLogDriverProps.builder().streamPrefix("win-iis-on-fargate").build()))
 *         .portMappings(List.of(PortMapping.builder().containerPort(80).build()))
 *         .image(ContainerImage.fromRegistry("mcr.microsoft.com/windows/servercore/iis:windowsservercore-ltsc2019"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.805Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CpuArchitecture")
public class CpuArchitecture extends software.amazon.jsii.JsiiObject {

    protected CpuArchitecture(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CpuArchitecture(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ARM64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CpuArchitecture.class, "ARM64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class));
        X86_64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CpuArchitecture.class, "X86_64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class));
    }

    /**
     * Other cpu architecture.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture for all available cpu architecture.">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture for all available cpu architecture.</a>
     * @param cpuArchitecture cpu architecture. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CpuArchitecture of(final @org.jetbrains.annotations.NotNull java.lang.String cpuArchitecture) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CpuArchitecture.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class), new Object[] { java.util.Objects.requireNonNull(cpuArchitecture, "cpuArchitecture is required") });
    }

    /**
     * ARM64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.CpuArchitecture ARM64;

    /**
     * X86_64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ecs.CpuArchitecture X86_64;
}
