package software.amazon.awscdk.services.ecs;

/**
 * Network protocol.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TaskDefinition taskDefinition;
 * Cluster cluster;
 * // Add a container to the task definition
 * ContainerDefinition specificContainer = taskDefinition.addContainer("Container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("/aws/aws-example-app"))
 *         .memoryLimitMiB(2048)
 *         .build());
 * // Add a port mapping
 * specificContainer.addPortMappings(PortMapping.builder()
 *         .containerPort(7600)
 *         .protocol(Protocol.TCP)
 *         .build());
 * Ec2Service.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 // Create SRV records - useful for bridge networking
 *                 .dnsRecordType(DnsRecordType.SRV)
 *                 // Targets port TCP port 7600 `specificContainer`
 *                 .container(specificContainer)
 *                 .containerPort(7600)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Protocol")
public enum Protocol {
    /**
     * TCP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP,
    /**
     * UDP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UDP,
}
