package software.amazon.awscdk.services.ecs;

/**
 * Specify the secret's version id or version stage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret secret;
 * Secret dbSecret;
 * StringParameter parameter;
 * TaskDefinition taskDefinition;
 * Bucket s3Bucket;
 * ContainerDefinition newContainer = taskDefinition.addContainer("container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryLimitMiB(1024)
 *         .environment(Map.of( // clear text, not for sensitive data
 *                 "STAGE", "prod"))
 *         .environmentFiles(List.of(EnvironmentFile.fromAsset("./demo-env-file.env"), EnvironmentFile.fromBucket(s3Bucket, "assets/demo-env-file.env")))
 *         .secrets(Map.of( // Retrieved from AWS Secrets Manager or AWS Systems Manager Parameter Store at container start-up.
 *                 "SECRET", Secret.fromSecretsManager(secret),
 *                 "DB_PASSWORD", Secret.fromSecretsManager(dbSecret, "password"),  // Reference a specific JSON field, (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "API_KEY", Secret.fromSecretsManagerVersion(secret, SecretVersionInfo.builder().versionId("12345").build(), "apiKey"),  // Reference a specific version of the secret by its version id or version stage (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "PARAMETER", Secret.fromSsmParameter(parameter)))
 *         .build());
 * newContainer.addEnvironment("QUEUE_NAME", "MyQueue");
 * newContainer.addSecret("API_KEY", Secret.fromSecretsManager(secret));
 * newContainer.addSecret("DB_PASSWORD", Secret.fromSecretsManager(secret, "password"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.913Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.SecretVersionInfo")
@software.amazon.jsii.Jsii.Proxy(SecretVersionInfo.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretVersionInfo extends software.amazon.jsii.JsiiSerializable {

    /**
     * version id of the secret.
     * <p>
     * Default: - use default version id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
        return null;
    }

    /**
     * version stage of the secret.
     * <p>
     * Default: - use default version stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretVersionInfo}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretVersionInfo}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretVersionInfo> {
        java.lang.String versionId;
        java.lang.String versionStage;

        /**
         * Sets the value of {@link SecretVersionInfo#getVersionId}
         * @param versionId version id of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionId(java.lang.String versionId) {
            this.versionId = versionId;
            return this;
        }

        /**
         * Sets the value of {@link SecretVersionInfo#getVersionStage}
         * @param versionStage version stage of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionStage(java.lang.String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretVersionInfo}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretVersionInfo build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretVersionInfo}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretVersionInfo {
        private final java.lang.String versionId;
        private final java.lang.String versionStage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionStage = software.amazon.jsii.Kernel.get(this, "versionStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.versionId = builder.versionId;
            this.versionStage = builder.versionStage;
        }

        @Override
        public final java.lang.String getVersionId() {
            return this.versionId;
        }

        @Override
        public final java.lang.String getVersionStage() {
            return this.versionStage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getVersionId() != null) {
                data.set("versionId", om.valueToTree(this.getVersionId()));
            }
            if (this.getVersionStage() != null) {
                data.set("versionStage", om.valueToTree(this.getVersionStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.SecretVersionInfo"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretVersionInfo.Jsii$Proxy that = (SecretVersionInfo.Jsii$Proxy) o;

            if (this.versionId != null ? !this.versionId.equals(that.versionId) : that.versionId != null) return false;
            return this.versionStage != null ? this.versionStage.equals(that.versionStage) : that.versionStage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.versionId != null ? this.versionId.hashCode() : 0;
            result = 31 * result + (this.versionStage != null ? this.versionStage.hashCode() : 0);
            return result;
        }
    }
}
