package software.amazon.awscdk.services.ecs;

/**
 * Interface for service connect Service props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * Role role;
 * ServiceConnectService serviceConnectService = ServiceConnectService.builder()
 *         .portMappingName("portMappingName")
 *         // the properties below are optional
 *         .discoveryName("discoveryName")
 *         .dnsName("dnsName")
 *         .idleTimeout(Duration.minutes(30))
 *         .ingressPortOverride(123)
 *         .perRequestTimeout(Duration.minutes(30))
 *         .port(123)
 *         .tls(ServiceConnectTlsConfiguration.builder()
 *                 .awsPcaAuthorityArn("awsPcaAuthorityArn")
 *                 .kmsKey(key)
 *                 .role(role)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.915Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ServiceConnectService")
@software.amazon.jsii.Jsii.Proxy(ServiceConnectService.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceConnectService extends software.amazon.jsii.JsiiSerializable {

    /**
     * portMappingName specifies which port and protocol combination should be used for this service connect service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortMappingName();

    /**
     * Optionally specifies an intermediate dns name to register in the CloudMap namespace.
     * <p>
     * This is required if you wish to use the same port mapping name in more than one service.
     * <p>
     * Default: - port mapping name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDiscoveryName() {
        return null;
    }

    /**
     * The terse DNS alias to use for this port mapping in the service connect mesh.
     * <p>
     * Service Connect-enabled clients will be able to reach this service at
     * http://dnsName:port.
     * <p>
     * Default: - No alias is created. The service is reachable at `portMappingName.namespace:port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDnsName() {
        return null;
    }

    /**
     * The amount of time in seconds a connection for Service Connect will stay active while idle.
     * <p>
     * A value of 0 can be set to disable <code>idleTimeout</code>.
     * <p>
     * If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code>, the connection will close
     * when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code>.
     * <p>
     * Default: - Duration.minutes(5) for HTTP/HTTP2/GRPC, Duration.hours(1) for TCP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getIdleTimeout() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * The port on the Service Connect agent container to use for traffic ingress to this service.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIngressPortOverride() {
        return null;
    }

    /**
     * The amount of time waiting for the upstream to respond with a complete response per request for Service Connect.
     * <p>
     * A value of 0 can be set to disable <code>perRequestTimeout</code>.
     * Can only be set when the <code>appProtocol</code> for the application container is HTTP/HTTP2/GRPC.
     * <p>
     * If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code>, the connection will close
     * when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code>.
     * <p>
     * Default: - Duration.seconds(15)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPerRequestTimeout() {
        return null;
    }

    /**
     * The port for clients to use to communicate with this service via Service Connect.
     * <p>
     * Default: the container port specified by the port mapping in portMappingName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * A reference to an object that represents a Transport Layer Security (TLS) configuration.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration getTls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceConnectService}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceConnectService}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectService> {
        java.lang.String portMappingName;
        java.lang.String discoveryName;
        java.lang.String dnsName;
        software.amazon.awscdk.Duration idleTimeout;
        java.lang.Number ingressPortOverride;
        software.amazon.awscdk.Duration perRequestTimeout;
        java.lang.Number port;
        software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration tls;

        /**
         * Sets the value of {@link ServiceConnectService#getPortMappingName}
         * @param portMappingName portMappingName specifies which port and protocol combination should be used for this service connect service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portMappingName(java.lang.String portMappingName) {
            this.portMappingName = portMappingName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getDiscoveryName}
         * @param discoveryName Optionally specifies an intermediate dns name to register in the CloudMap namespace.
         *                      This is required if you wish to use the same port mapping name in more than one service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder discoveryName(java.lang.String discoveryName) {
            this.discoveryName = discoveryName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getDnsName}
         * @param dnsName The terse DNS alias to use for this port mapping in the service connect mesh.
         *                Service Connect-enabled clients will be able to reach this service at
         *                http://dnsName:port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsName(java.lang.String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getIdleTimeout}
         * @param idleTimeout The amount of time in seconds a connection for Service Connect will stay active while idle.
         *                    A value of 0 can be set to disable <code>idleTimeout</code>.
         *                    <p>
         *                    If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code>, the connection will close
         *                    when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(software.amazon.awscdk.Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getIngressPortOverride}
         * @param ingressPortOverride Optional.
         *                            The port on the Service Connect agent container to use for traffic ingress to this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressPortOverride(java.lang.Number ingressPortOverride) {
            this.ingressPortOverride = ingressPortOverride;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getPerRequestTimeout}
         * @param perRequestTimeout The amount of time waiting for the upstream to respond with a complete response per request for Service Connect.
         *                          A value of 0 can be set to disable <code>perRequestTimeout</code>.
         *                          Can only be set when the <code>appProtocol</code> for the application container is HTTP/HTTP2/GRPC.
         *                          <p>
         *                          If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code>, the connection will close
         *                          when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perRequestTimeout(software.amazon.awscdk.Duration perRequestTimeout) {
            this.perRequestTimeout = perRequestTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getPort}
         * @param port The port for clients to use to communicate with this service via Service Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectService#getTls}
         * @param tls A reference to an object that represents a Transport Layer Security (TLS) configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tls(software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration tls) {
            this.tls = tls;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceConnectService}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceConnectService build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceConnectService}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectService {
        private final java.lang.String portMappingName;
        private final java.lang.String discoveryName;
        private final java.lang.String dnsName;
        private final software.amazon.awscdk.Duration idleTimeout;
        private final java.lang.Number ingressPortOverride;
        private final software.amazon.awscdk.Duration perRequestTimeout;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration tls;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.portMappingName = software.amazon.jsii.Kernel.get(this, "portMappingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.discoveryName = software.amazon.jsii.Kernel.get(this, "discoveryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.ingressPortOverride = software.amazon.jsii.Kernel.get(this, "ingressPortOverride", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.perRequestTimeout = software.amazon.jsii.Kernel.get(this, "perRequestTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portMappingName = java.util.Objects.requireNonNull(builder.portMappingName, "portMappingName is required");
            this.discoveryName = builder.discoveryName;
            this.dnsName = builder.dnsName;
            this.idleTimeout = builder.idleTimeout;
            this.ingressPortOverride = builder.ingressPortOverride;
            this.perRequestTimeout = builder.perRequestTimeout;
            this.port = builder.port;
            this.tls = builder.tls;
        }

        @Override
        public final java.lang.String getPortMappingName() {
            return this.portMappingName;
        }

        @Override
        public final java.lang.String getDiscoveryName() {
            return this.discoveryName;
        }

        @Override
        public final java.lang.String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public final java.lang.Number getIngressPortOverride() {
            return this.ingressPortOverride;
        }

        @Override
        public final software.amazon.awscdk.Duration getPerRequestTimeout() {
            return this.perRequestTimeout;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ServiceConnectTlsConfiguration getTls() {
            return this.tls;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("portMappingName", om.valueToTree(this.getPortMappingName()));
            if (this.getDiscoveryName() != null) {
                data.set("discoveryName", om.valueToTree(this.getDiscoveryName()));
            }
            if (this.getDnsName() != null) {
                data.set("dnsName", om.valueToTree(this.getDnsName()));
            }
            if (this.getIdleTimeout() != null) {
                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
            }
            if (this.getIngressPortOverride() != null) {
                data.set("ingressPortOverride", om.valueToTree(this.getIngressPortOverride()));
            }
            if (this.getPerRequestTimeout() != null) {
                data.set("perRequestTimeout", om.valueToTree(this.getPerRequestTimeout()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getTls() != null) {
                data.set("tls", om.valueToTree(this.getTls()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ServiceConnectService"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceConnectService.Jsii$Proxy that = (ServiceConnectService.Jsii$Proxy) o;

            if (!portMappingName.equals(that.portMappingName)) return false;
            if (this.discoveryName != null ? !this.discoveryName.equals(that.discoveryName) : that.discoveryName != null) return false;
            if (this.dnsName != null ? !this.dnsName.equals(that.dnsName) : that.dnsName != null) return false;
            if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
            if (this.ingressPortOverride != null ? !this.ingressPortOverride.equals(that.ingressPortOverride) : that.ingressPortOverride != null) return false;
            if (this.perRequestTimeout != null ? !this.perRequestTimeout.equals(that.perRequestTimeout) : that.perRequestTimeout != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
        }

        @Override
        public final int hashCode() {
            int result = this.portMappingName.hashCode();
            result = 31 * result + (this.discoveryName != null ? this.discoveryName.hashCode() : 0);
            result = 31 * result + (this.dnsName != null ? this.dnsName.hashCode() : 0);
            result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
            result = 31 * result + (this.ingressPortOverride != null ? this.ingressPortOverride.hashCode() : 0);
            result = 31 * result + (this.perRequestTimeout != null ? this.perRequestTimeout.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
            return result;
        }
    }
}
