package software.amazon.awscdk.services.ecs;

/**
 * TLS configuration for Service Connect service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * IKey kmsKey;
 * IRole role;
 * FargateService service = FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .serviceConnectConfiguration(ServiceConnectProps.builder()
 *                 .services(List.of(ServiceConnectService.builder()
 *                         .tls(ServiceConnectTlsConfiguration.builder()
 *                                 .role(role)
 *                                 .kmsKey(kmsKey)
 *                                 .awsPcaAuthorityArn("arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/123456789012")
 *                                 .build())
 *                         .portMappingName("api")
 *                         .build()))
 *                 .namespace("sample namespace")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.916Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ServiceConnectTlsConfiguration")
@software.amazon.jsii.Jsii.Proxy(ServiceConnectTlsConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceConnectTlsConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the certificate root authority that secures your service.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsPcaAuthorityArn() {
        return null;
    }

    /**
     * The KMS key used for encryption and decryption.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The IAM role that's associated with the Service Connect TLS.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceConnectTlsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceConnectTlsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectTlsConfiguration> {
        java.lang.String awsPcaAuthorityArn;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link ServiceConnectTlsConfiguration#getAwsPcaAuthorityArn}
         * @param awsPcaAuthorityArn The ARN of the certificate root authority that secures your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsPcaAuthorityArn(java.lang.String awsPcaAuthorityArn) {
            this.awsPcaAuthorityArn = awsPcaAuthorityArn;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectTlsConfiguration#getKmsKey}
         * @param kmsKey The KMS key used for encryption and decryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ServiceConnectTlsConfiguration#getRole}
         * @param role The IAM role that's associated with the Service Connect TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceConnectTlsConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceConnectTlsConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceConnectTlsConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectTlsConfiguration {
        private final java.lang.String awsPcaAuthorityArn;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsPcaAuthorityArn = software.amazon.jsii.Kernel.get(this, "awsPcaAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsPcaAuthorityArn = builder.awsPcaAuthorityArn;
            this.kmsKey = builder.kmsKey;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getAwsPcaAuthorityArn() {
            return this.awsPcaAuthorityArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAwsPcaAuthorityArn() != null) {
                data.set("awsPcaAuthorityArn", om.valueToTree(this.getAwsPcaAuthorityArn()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ServiceConnectTlsConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceConnectTlsConfiguration.Jsii$Proxy that = (ServiceConnectTlsConfiguration.Jsii$Proxy) o;

            if (this.awsPcaAuthorityArn != null ? !this.awsPcaAuthorityArn.equals(that.awsPcaAuthorityArn) : that.awsPcaAuthorityArn != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsPcaAuthorityArn != null ? this.awsPcaAuthorityArn.hashCode() : 0;
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
