package software.amazon.awscdk.services.ecs;

/**
 * State of the container version consistency feature.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .versionConsistency(VersionConsistency.DISABLED)
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:27.931Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.VersionConsistency")
public enum VersionConsistency {
    /**
     * The version consistency feature is enabled for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENABLED,
    /**
     * The version consistency feature is disabled for this container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISABLED,
}
