package software.amazon.awscdk.services.eks;

/**
 * Associates an identity provider configuration to a cluster.
 * <p>
 * If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes <code>Role</code> and <code>ClusterRole</code> objects, assign permissions to them, and then bind them to the identities using Kubernetes <code>RoleBinding</code> and <code>ClusterRoleBinding</code> objects. For more information see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization</a> in the Kubernetes documentation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnIdentityProviderConfig cfnIdentityProviderConfig = CfnIdentityProviderConfig.Builder.create(this, "MyCfnIdentityProviderConfig")
 *         .clusterName("clusterName")
 *         .type("type")
 *         // the properties below are optional
 *         .identityProviderConfigName("identityProviderConfigName")
 *         .oidc(OidcIdentityProviderConfigProperty.builder()
 *                 .clientId("clientId")
 *                 .issuerUrl("issuerUrl")
 *                 // the properties below are optional
 *                 .groupsClaim("groupsClaim")
 *                 .groupsPrefix("groupsPrefix")
 *                 .requiredClaims(List.of(RequiredClaimProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .usernameClaim("usernameClaim")
 *                 .usernamePrefix("usernamePrefix")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.185Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnIdentityProviderConfig")
public class CfnIdentityProviderConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnIdentityProviderConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityProviderConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityProviderConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.CfnIdentityProviderConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) associated with the identity provider config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityProviderConfigArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityProviderConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", java.util.Objects.requireNonNull(value, "clusterName is required"));
    }

    /**
     * The type of the identity provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the identity provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityProviderConfigName() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderConfigName", value);
    }

    /**
     * An object representing an OpenID Connect (OIDC) identity provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOidc() {
        return software.amazon.jsii.Kernel.get(this, "oidc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object representing an OpenID Connect (OIDC) identity provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOidc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "oidc", value);
    }

    /**
     * An object representing an OpenID Connect (OIDC) identity provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOidc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "oidc", value);
    }

    /**
     * Metadata that assists with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that assists with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An object representing the configuration for an OpenID Connect (OIDC) identity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * OidcIdentityProviderConfigProperty oidcIdentityProviderConfigProperty = OidcIdentityProviderConfigProperty.builder()
     *         .clientId("clientId")
     *         .issuerUrl("issuerUrl")
     *         // the properties below are optional
     *         .groupsClaim("groupsClaim")
     *         .groupsPrefix("groupsPrefix")
     *         .requiredClaims(List.of(RequiredClaimProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .usernameClaim("usernameClaim")
     *         .usernamePrefix("usernamePrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OidcIdentityProviderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OidcIdentityProviderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This is also known as <em>audience</em> .
         * <p>
         * The ID of the client application that makes authentication requests to the OIDC identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-issuerurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-issuerurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuerUrl();

        /**
         * The JSON web token (JWT) claim that the provider uses to return your groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-groupsclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-groupsclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupsClaim() {
            return null;
        }

        /**
         * The prefix that is prepended to group claims to prevent clashes with existing names (such as <code>system:</code> groups).
         * <p>
         * For example, the value <code>oidc:</code> creates group names like <code>oidc:engineering</code> and <code>oidc:infra</code> . The prefix can't contain <code>system:</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-groupsprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-groupsprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupsPrefix() {
            return null;
        }

        /**
         * The key-value pairs that describe required claims in the identity token.
         * <p>
         * If set, each claim is verified to be present in the token with a matching value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-requiredclaims">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-requiredclaims</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequiredClaims() {
            return null;
        }

        /**
         * The JSON Web token (JWT) claim that is used as the username.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-usernameclaim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-usernameclaim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsernameClaim() {
            return null;
        }

        /**
         * The prefix that is prepended to username claims to prevent clashes with existing names.
         * <p>
         * The prefix can't contain <code>system:</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-usernameprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-oidcidentityproviderconfig.html#cfn-eks-identityproviderconfig-oidcidentityproviderconfig-usernameprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsernamePrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OidcIdentityProviderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OidcIdentityProviderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OidcIdentityProviderConfigProperty> {
            java.lang.String clientId;
            java.lang.String issuerUrl;
            java.lang.String groupsClaim;
            java.lang.String groupsPrefix;
            java.lang.Object requiredClaims;
            java.lang.String usernameClaim;
            java.lang.String usernamePrefix;

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getClientId}
             * @param clientId This is also known as <em>audience</em> . This parameter is required.
             *                 The ID of the client application that makes authentication requests to the OIDC identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getIssuerUrl}
             * @param issuerUrl The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuerUrl(java.lang.String issuerUrl) {
                this.issuerUrl = issuerUrl;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getGroupsClaim}
             * @param groupsClaim The JSON web token (JWT) claim that the provider uses to return your groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupsClaim(java.lang.String groupsClaim) {
                this.groupsClaim = groupsClaim;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getGroupsPrefix}
             * @param groupsPrefix The prefix that is prepended to group claims to prevent clashes with existing names (such as <code>system:</code> groups).
             *                     For example, the value <code>oidc:</code> creates group names like <code>oidc:engineering</code> and <code>oidc:infra</code> . The prefix can't contain <code>system:</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupsPrefix(java.lang.String groupsPrefix) {
                this.groupsPrefix = groupsPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getRequiredClaims}
             * @param requiredClaims The key-value pairs that describe required claims in the identity token.
             *                       If set, each claim is verified to be present in the token with a matching value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requiredClaims(software.amazon.awscdk.IResolvable requiredClaims) {
                this.requiredClaims = requiredClaims;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getRequiredClaims}
             * @param requiredClaims The key-value pairs that describe required claims in the identity token.
             *                       If set, each claim is verified to be present in the token with a matching value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requiredClaims(java.util.List<? extends java.lang.Object> requiredClaims) {
                this.requiredClaims = requiredClaims;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getUsernameClaim}
             * @param usernameClaim The JSON Web token (JWT) claim that is used as the username.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameClaim(java.lang.String usernameClaim) {
                this.usernameClaim = usernameClaim;
                return this;
            }

            /**
             * Sets the value of {@link OidcIdentityProviderConfigProperty#getUsernamePrefix}
             * @param usernamePrefix The prefix that is prepended to username claims to prevent clashes with existing names.
             *                       The prefix can't contain <code>system:</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernamePrefix(java.lang.String usernamePrefix) {
                this.usernamePrefix = usernamePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OidcIdentityProviderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OidcIdentityProviderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OidcIdentityProviderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OidcIdentityProviderConfigProperty {
            private final java.lang.String clientId;
            private final java.lang.String issuerUrl;
            private final java.lang.String groupsClaim;
            private final java.lang.String groupsPrefix;
            private final java.lang.Object requiredClaims;
            private final java.lang.String usernameClaim;
            private final java.lang.String usernamePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.issuerUrl = software.amazon.jsii.Kernel.get(this, "issuerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupsClaim = software.amazon.jsii.Kernel.get(this, "groupsClaim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupsPrefix = software.amazon.jsii.Kernel.get(this, "groupsPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requiredClaims = software.amazon.jsii.Kernel.get(this, "requiredClaims", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.usernameClaim = software.amazon.jsii.Kernel.get(this, "usernameClaim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernamePrefix = software.amazon.jsii.Kernel.get(this, "usernamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.issuerUrl = java.util.Objects.requireNonNull(builder.issuerUrl, "issuerUrl is required");
                this.groupsClaim = builder.groupsClaim;
                this.groupsPrefix = builder.groupsPrefix;
                this.requiredClaims = builder.requiredClaims;
                this.usernameClaim = builder.usernameClaim;
                this.usernamePrefix = builder.usernamePrefix;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getIssuerUrl() {
                return this.issuerUrl;
            }

            @Override
            public final java.lang.String getGroupsClaim() {
                return this.groupsClaim;
            }

            @Override
            public final java.lang.String getGroupsPrefix() {
                return this.groupsPrefix;
            }

            @Override
            public final java.lang.Object getRequiredClaims() {
                return this.requiredClaims;
            }

            @Override
            public final java.lang.String getUsernameClaim() {
                return this.usernameClaim;
            }

            @Override
            public final java.lang.String getUsernamePrefix() {
                return this.usernamePrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("issuerUrl", om.valueToTree(this.getIssuerUrl()));
                if (this.getGroupsClaim() != null) {
                    data.set("groupsClaim", om.valueToTree(this.getGroupsClaim()));
                }
                if (this.getGroupsPrefix() != null) {
                    data.set("groupsPrefix", om.valueToTree(this.getGroupsPrefix()));
                }
                if (this.getRequiredClaims() != null) {
                    data.set("requiredClaims", om.valueToTree(this.getRequiredClaims()));
                }
                if (this.getUsernameClaim() != null) {
                    data.set("usernameClaim", om.valueToTree(this.getUsernameClaim()));
                }
                if (this.getUsernamePrefix() != null) {
                    data.set("usernamePrefix", om.valueToTree(this.getUsernamePrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OidcIdentityProviderConfigProperty.Jsii$Proxy that = (OidcIdentityProviderConfigProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!issuerUrl.equals(that.issuerUrl)) return false;
                if (this.groupsClaim != null ? !this.groupsClaim.equals(that.groupsClaim) : that.groupsClaim != null) return false;
                if (this.groupsPrefix != null ? !this.groupsPrefix.equals(that.groupsPrefix) : that.groupsPrefix != null) return false;
                if (this.requiredClaims != null ? !this.requiredClaims.equals(that.requiredClaims) : that.requiredClaims != null) return false;
                if (this.usernameClaim != null ? !this.usernameClaim.equals(that.usernameClaim) : that.usernameClaim != null) return false;
                return this.usernamePrefix != null ? this.usernamePrefix.equals(that.usernamePrefix) : that.usernamePrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.issuerUrl.hashCode());
                result = 31 * result + (this.groupsClaim != null ? this.groupsClaim.hashCode() : 0);
                result = 31 * result + (this.groupsPrefix != null ? this.groupsPrefix.hashCode() : 0);
                result = 31 * result + (this.requiredClaims != null ? this.requiredClaims.hashCode() : 0);
                result = 31 * result + (this.usernameClaim != null ? this.usernameClaim.hashCode() : 0);
                result = 31 * result + (this.usernamePrefix != null ? this.usernamePrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A key-value pair that describes a required claim in the identity token.
     * <p>
     * If set, each claim is verified to be present in the token with a matching value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * RequiredClaimProperty requiredClaimProperty = RequiredClaimProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnIdentityProviderConfig.RequiredClaimProperty")
    @software.amazon.jsii.Jsii.Proxy(RequiredClaimProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequiredClaimProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key to match from the token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html#cfn-eks-identityproviderconfig-requiredclaim-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html#cfn-eks-identityproviderconfig-requiredclaim-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value for the key from the token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html#cfn-eks-identityproviderconfig-requiredclaim-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-identityproviderconfig-requiredclaim.html#cfn-eks-identityproviderconfig-requiredclaim-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link RequiredClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequiredClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequiredClaimProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link RequiredClaimProperty#getKey}
             * @param key The key to match from the token. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link RequiredClaimProperty#getValue}
             * @param value The value for the key from the token. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequiredClaimProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequiredClaimProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequiredClaimProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequiredClaimProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnIdentityProviderConfig.RequiredClaimProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequiredClaimProperty.Jsii$Proxy that = (RequiredClaimProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.CfnIdentityProviderConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.CfnIdentityProviderConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.CfnIdentityProviderConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.CfnIdentityProviderConfigProps.Builder();
        }

        /**
         * The name of your cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-clustername</a>
         * @param clusterName The name of your cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * The type of the identity provider configuration.
         * <p>
         * The only type available is <code>oidc</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-type</a>
         * @param type The type of the identity provider configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The name of the configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-identityproviderconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-identityproviderconfigname</a>
         * @param identityProviderConfigName The name of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfigName(final java.lang.String identityProviderConfigName) {
            this.props.identityProviderConfigName(identityProviderConfigName);
            return this;
        }

        /**
         * An object representing an OpenID Connect (OIDC) identity provider configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-oidc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-oidc</a>
         * @param oidc An object representing an OpenID Connect (OIDC) identity provider configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidc(final software.amazon.awscdk.IResolvable oidc) {
            this.props.oidc(oidc);
            return this;
        }
        /**
         * An object representing an OpenID Connect (OIDC) identity provider configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-oidc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-oidc</a>
         * @param oidc An object representing an OpenID Connect (OIDC) identity provider configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidc(final software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty oidc) {
            this.props.oidc(oidc);
            return this;
        }

        /**
         * Metadata that assists with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-identityproviderconfig.html#cfn-eks-identityproviderconfig-tags</a>
         * @param tags Metadata that assists with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.CfnIdentityProviderConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.CfnIdentityProviderConfig build() {
            return new software.amazon.awscdk.services.eks.CfnIdentityProviderConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
