package software.amazon.awscdk.services.eks;

/**
 * Attributes for EKS clusters.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * AutoScalingGroup asg;
 * ICluster importedCluster = Cluster.fromClusterAttributes(this, "ImportedCluster", ClusterAttributes.builder()
 *         .clusterName(cluster.getClusterName())
 *         .clusterSecurityGroupId(cluster.getClusterSecurityGroupId())
 *         .build());
 * importedCluster.connectAutoScalingGroupCapacity(asg, AutoScalingGroupOptions.builder().build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.202Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.ClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The physical name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * An AWS Lambda layer that contains the <code>aws</code> CLI.
     * <p>
     * The handler expects the layer to include the following executables:
     * <p>
     * <blockquote><pre>
     * /opt/awscli/aws
     * </pre></blockquote>
     * <p>
     * Default: - a default layer with the AWS CLI 1.x
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getAwscliLayer() {
        return null;
    }

    /**
     * The certificate-authority-data for your cluster.
     * <p>
     * Default: - if not specified `cluster.clusterCertificateAuthorityData` will
     * throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterCertificateAuthorityData() {
        return null;
    }

    /**
     * Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     * <p>
     * Default: - if not specified `cluster.clusterEncryptionConfigKeyArn` will
     * throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEncryptionConfigKeyArn() {
        return null;
    }

    /**
     * The API Server endpoint URL.
     * <p>
     * Default: - if not specified `cluster.clusterEndpoint` will throw an error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
        return null;
    }

    /**
     * A security group id to associate with the Cluster Handler's Lambdas.
     * <p>
     * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
     * <p>
     * Default: - No security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterHandlerSecurityGroupId() {
        return null;
    }

    /**
     * The cluster security group that was created by Amazon EKS for the cluster.
     * <p>
     * Default: - if not specified `cluster.clusterSecurityGroupId` will throw an
     * error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterSecurityGroupId() {
        return null;
    }

    /**
     * Specify which IP family is used to assign Kubernetes pod and service IP addresses.
     * <p>
     * Default: - IpFamily.IP_V4
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-ipFamily</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IpFamily getIpFamily() {
        return null;
    }

    /**
     * Environment variables to use when running <code>kubectl</code> against this cluster.
     * <p>
     * Default: - no additional variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
        return null;
    }

    /**
     * An IAM role that can perform kubectl operations against this cluster.
     * <p>
     * The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
     * <p>
     * This role is directly passed to the lambda handler that sends Kube Ctl commands
     * to the cluster.
     * <p>
     * Default: - if not specified, the default role created by a lambda function will
     * be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
        return null;
    }

    /**
     * An AWS Lambda Layer which includes <code>kubectl</code> and Helm.
     * <p>
     * This layer is used by the kubectl handler to apply manifests and install
     * helm charts. You must pick an appropriate releases of one of the
     * <code>&#64;aws-cdk/layer-kubectl-vXX</code> packages, that works with the version of
     * Kubernetes you have chosen.
     * <p>
     * The handler expects the layer to include the following executables:
     * <p>
     * <blockquote><pre>
     * /opt/helm/helm
     * /opt/kubectl/kubectl
     * </pre></blockquote>
     * <p>
     * Default: - No default layer will be provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
        return null;
    }

    /**
     * Amount of memory to allocate to the provider's lambda function.
     * <p>
     * Default: Size.gibibytes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getKubectlMemory() {
        return null;
    }

    /**
     * Subnets to host the <code>kubectl</code> compute resources.
     * <p>
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     * <p>
     * Default: - k8s endpoint is expected to be accessible publicly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKubectlPrivateSubnetIds() {
        return null;
    }

    /**
     * KubectlProvider for issuing kubectl commands.
     * <p>
     * Default: - Default CDK provider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.IKubectlProvider getKubectlProvider() {
        return null;
    }

    /**
     * An IAM role with cluster administrator and "system:masters" permissions.
     * <p>
     * Default: - if not specified, it not be possible to issue `kubectl` commands
     * against an imported cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKubectlRoleArn() {
        return null;
    }

    /**
     * A security group to use for <code>kubectl</code> execution.
     * <p>
     * If not specified, the k8s
     * endpoint is expected to be accessible publicly.
     * <p>
     * Default: - k8s endpoint is expected to be accessible publicly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKubectlSecurityGroupId() {
        return null;
    }

    /**
     * An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>.
     * <p>
     * This layer
     * is used by the onEvent handler to route AWS SDK requests through a proxy.
     * <p>
     * The handler expects the layer to include the following node_modules:
     * <p>
     * proxy-agent
     * <p>
     * Default: - a layer bundled with this module.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
        return null;
    }

    /**
     * An Open ID Connect provider for this cluster that can be used to configure service accounts.
     * <p>
     * You can either import an existing provider using <code>iam.OpenIdConnectProvider.fromProviderArn</code>,
     * or create a new provider using <code>new eks.OpenIdConnectProvider</code>
     * <p>
     * Default: - if not specified `cluster.openIdConnectProvider` and `cluster.addServiceAccount` will throw an error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
        return null;
    }

    /**
     * Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned.
     * <p>
     * When this is enabled (default), prune labels will be
     * allocated and injected to each resource. These labels will then be used
     * when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * Additional security groups associated with this cluster.
     * <p>
     * Default: - if not specified, no additional security groups will be
     * considered in `cluster.connections`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The VPC in which this Cluster was created.
     * <p>
     * Default: - if not specified `cluster.vpc` will throw an error
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterAttributes> {
        java.lang.String clusterName;
        software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer;
        java.lang.String clusterCertificateAuthorityData;
        java.lang.String clusterEncryptionConfigKeyArn;
        java.lang.String clusterEndpoint;
        java.lang.String clusterHandlerSecurityGroupId;
        java.lang.String clusterSecurityGroupId;
        software.amazon.awscdk.services.eks.IpFamily ipFamily;
        java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        software.amazon.awscdk.services.iam.IRole kubectlLambdaRole;
        software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        software.amazon.awscdk.Size kubectlMemory;
        java.util.List<java.lang.String> kubectlPrivateSubnetIds;
        software.amazon.awscdk.services.eks.IKubectlProvider kubectlProvider;
        java.lang.String kubectlRoleArn;
        java.lang.String kubectlSecurityGroupId;
        software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer;
        software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider;
        java.lang.Boolean prune;
        java.util.List<java.lang.String> securityGroupIds;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ClusterAttributes#getClusterName}
         * @param clusterName The physical name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getAwscliLayer}
         * @param awscliLayer An AWS Lambda layer that contains the <code>aws</code> CLI.
         *                    The handler expects the layer to include the following executables:
         *                    <p>
         *                    <blockquote><pre>
         *                    /opt/awscli/aws
         *                    </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awscliLayer(software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer) {
            this.awscliLayer = awscliLayer;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterCertificateAuthorityData}
         * @param clusterCertificateAuthorityData The certificate-authority-data for your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterCertificateAuthorityData(java.lang.String clusterCertificateAuthorityData) {
            this.clusterCertificateAuthorityData = clusterCertificateAuthorityData;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterEncryptionConfigKeyArn}
         * @param clusterEncryptionConfigKeyArn Amazon Resource Name (ARN) or alias of the customer master key (CMK).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterEncryptionConfigKeyArn(java.lang.String clusterEncryptionConfigKeyArn) {
            this.clusterEncryptionConfigKeyArn = clusterEncryptionConfigKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterEndpoint}
         * @param clusterEndpoint The API Server endpoint URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterHandlerSecurityGroupId}
         * @param clusterHandlerSecurityGroupId A security group id to associate with the Cluster Handler's Lambdas.
         *                                      The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerSecurityGroupId(java.lang.String clusterHandlerSecurityGroupId) {
            this.clusterHandlerSecurityGroupId = clusterHandlerSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterSecurityGroupId}
         * @param clusterSecurityGroupId The cluster security group that was created by Amazon EKS for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroupId(java.lang.String clusterSecurityGroupId) {
            this.clusterSecurityGroupId = clusterSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getIpFamily}
         * @param ipFamily Specify which IP family is used to assign Kubernetes pod and service IP addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipFamily(software.amazon.awscdk.services.eks.IpFamily ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlEnvironment}
         * @param kubectlEnvironment Environment variables to use when running <code>kubectl</code> against this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlEnvironment(java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.kubectlEnvironment = kubectlEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlLambdaRole}
         * @param kubectlLambdaRole An IAM role that can perform kubectl operations against this cluster.
         *                          The role should be mapped to the <code>system:masters</code> Kubernetes RBAC role.
         *                          <p>
         *                          This role is directly passed to the lambda handler that sends Kube Ctl commands
         *                          to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLambdaRole(software.amazon.awscdk.services.iam.IRole kubectlLambdaRole) {
            this.kubectlLambdaRole = kubectlLambdaRole;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlLayer}
         * @param kubectlLayer An AWS Lambda Layer which includes <code>kubectl</code> and Helm.
         *                     This layer is used by the kubectl handler to apply manifests and install
         *                     helm charts. You must pick an appropriate releases of one of the
         *                     <code>&#64;aws-cdk/layer-kubectl-vXX</code> packages, that works with the version of
         *                     Kubernetes you have chosen.
         *                     <p>
         *                     The handler expects the layer to include the following executables:
         *                     <p>
         *                     <blockquote><pre>
         *                     /opt/helm/helm
         *                     /opt/kubectl/kubectl
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLayer(software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.kubectlLayer = kubectlLayer;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlMemory}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlMemory(software.amazon.awscdk.Size kubectlMemory) {
            this.kubectlMemory = kubectlMemory;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlPrivateSubnetIds}
         * @param kubectlPrivateSubnetIds Subnets to host the <code>kubectl</code> compute resources.
         *                                If not specified, the k8s
         *                                endpoint is expected to be accessible publicly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlPrivateSubnetIds(java.util.List<java.lang.String> kubectlPrivateSubnetIds) {
            this.kubectlPrivateSubnetIds = kubectlPrivateSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlProvider}
         * @param kubectlProvider KubectlProvider for issuing kubectl commands.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlProvider(software.amazon.awscdk.services.eks.IKubectlProvider kubectlProvider) {
            this.kubectlProvider = kubectlProvider;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlRoleArn}
         * @param kubectlRoleArn An IAM role with cluster administrator and "system:masters" permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlRoleArn(java.lang.String kubectlRoleArn) {
            this.kubectlRoleArn = kubectlRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getKubectlSecurityGroupId}
         * @param kubectlSecurityGroupId A security group to use for <code>kubectl</code> execution.
         *                               If not specified, the k8s
         *                               endpoint is expected to be accessible publicly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlSecurityGroupId(java.lang.String kubectlSecurityGroupId) {
            this.kubectlSecurityGroupId = kubectlSecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getOnEventLayer}
         * @param onEventLayer An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>.
         *                     This layer
         *                     is used by the onEvent handler to route AWS SDK requests through a proxy.
         *                     <p>
         *                     The handler expects the layer to include the following node_modules:
         *                     <p>
         *                     proxy-agent
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventLayer(software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer) {
            this.onEventLayer = onEventLayer;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getOpenIdConnectProvider}
         * @param openIdConnectProvider An Open ID Connect provider for this cluster that can be used to configure service accounts.
         *                              You can either import an existing provider using <code>iam.OpenIdConnectProvider.fromProviderArn</code>,
         *                              or create a new provider using <code>new eks.OpenIdConnectProvider</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectProvider(software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider) {
            this.openIdConnectProvider = openIdConnectProvider;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getPrune}
         * @param prune Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned.
         *              When this is enabled (default), prune labels will be
         *              allocated and injected to each resource. These labels will then be used
         *              when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getSecurityGroupIds}
         * @param securityGroupIds Additional security groups associated with this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getVpc}
         * @param vpc The VPC in which this Cluster was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterAttributes {
        private final java.lang.String clusterName;
        private final software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer;
        private final java.lang.String clusterCertificateAuthorityData;
        private final java.lang.String clusterEncryptionConfigKeyArn;
        private final java.lang.String clusterEndpoint;
        private final java.lang.String clusterHandlerSecurityGroupId;
        private final java.lang.String clusterSecurityGroupId;
        private final software.amazon.awscdk.services.eks.IpFamily ipFamily;
        private final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private final software.amazon.awscdk.services.iam.IRole kubectlLambdaRole;
        private final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private final software.amazon.awscdk.Size kubectlMemory;
        private final java.util.List<java.lang.String> kubectlPrivateSubnetIds;
        private final software.amazon.awscdk.services.eks.IKubectlProvider kubectlProvider;
        private final java.lang.String kubectlRoleArn;
        private final java.lang.String kubectlSecurityGroupId;
        private final software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer;
        private final software.amazon.awscdk.services.iam.IOpenIdConnectProvider openIdConnectProvider;
        private final java.lang.Boolean prune;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awscliLayer = software.amazon.jsii.Kernel.get(this, "awscliLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.clusterCertificateAuthorityData = software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEncryptionConfigKeyArn = software.amazon.jsii.Kernel.get(this, "clusterEncryptionConfigKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterHandlerSecurityGroupId = software.amazon.jsii.Kernel.get(this, "clusterHandlerSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterSecurityGroupId = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipFamily = software.amazon.jsii.Kernel.get(this, "ipFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IpFamily.class));
            this.kubectlEnvironment = software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlLambdaRole = software.amazon.jsii.Kernel.get(this, "kubectlLambdaRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.kubectlLayer = software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.kubectlMemory = software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.kubectlPrivateSubnetIds = software.amazon.jsii.Kernel.get(this, "kubectlPrivateSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlProvider = software.amazon.jsii.Kernel.get(this, "kubectlProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IKubectlProvider.class));
            this.kubectlRoleArn = software.amazon.jsii.Kernel.get(this, "kubectlRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kubectlSecurityGroupId = software.amazon.jsii.Kernel.get(this, "kubectlSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onEventLayer = software.amazon.jsii.Kernel.get(this, "onEventLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.openIdConnectProvider = software.amazon.jsii.Kernel.get(this, "openIdConnectProvider", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.awscliLayer = builder.awscliLayer;
            this.clusterCertificateAuthorityData = builder.clusterCertificateAuthorityData;
            this.clusterEncryptionConfigKeyArn = builder.clusterEncryptionConfigKeyArn;
            this.clusterEndpoint = builder.clusterEndpoint;
            this.clusterHandlerSecurityGroupId = builder.clusterHandlerSecurityGroupId;
            this.clusterSecurityGroupId = builder.clusterSecurityGroupId;
            this.ipFamily = builder.ipFamily;
            this.kubectlEnvironment = builder.kubectlEnvironment;
            this.kubectlLambdaRole = builder.kubectlLambdaRole;
            this.kubectlLayer = builder.kubectlLayer;
            this.kubectlMemory = builder.kubectlMemory;
            this.kubectlPrivateSubnetIds = builder.kubectlPrivateSubnetIds;
            this.kubectlProvider = builder.kubectlProvider;
            this.kubectlRoleArn = builder.kubectlRoleArn;
            this.kubectlSecurityGroupId = builder.kubectlSecurityGroupId;
            this.onEventLayer = builder.onEventLayer;
            this.openIdConnectProvider = builder.openIdConnectProvider;
            this.prune = builder.prune;
            this.securityGroupIds = builder.securityGroupIds;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getAwscliLayer() {
            return this.awscliLayer;
        }

        @Override
        public final java.lang.String getClusterCertificateAuthorityData() {
            return this.clusterCertificateAuthorityData;
        }

        @Override
        public final java.lang.String getClusterEncryptionConfigKeyArn() {
            return this.clusterEncryptionConfigKeyArn;
        }

        @Override
        public final java.lang.String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        @Override
        public final java.lang.String getClusterHandlerSecurityGroupId() {
            return this.clusterHandlerSecurityGroupId;
        }

        @Override
        public final java.lang.String getClusterSecurityGroupId() {
            return this.clusterSecurityGroupId;
        }

        @Override
        public final software.amazon.awscdk.services.eks.IpFamily getIpFamily() {
            return this.ipFamily;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return this.kubectlEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getKubectlLambdaRole() {
            return this.kubectlLambdaRole;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return this.kubectlLayer;
        }

        @Override
        public final software.amazon.awscdk.Size getKubectlMemory() {
            return this.kubectlMemory;
        }

        @Override
        public final java.util.List<java.lang.String> getKubectlPrivateSubnetIds() {
            return this.kubectlPrivateSubnetIds;
        }

        @Override
        public final software.amazon.awscdk.services.eks.IKubectlProvider getKubectlProvider() {
            return this.kubectlProvider;
        }

        @Override
        public final java.lang.String getKubectlRoleArn() {
            return this.kubectlRoleArn;
        }

        @Override
        public final java.lang.String getKubectlSecurityGroupId() {
            return this.kubectlSecurityGroupId;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
            return this.onEventLayer;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IOpenIdConnectProvider getOpenIdConnectProvider() {
            return this.openIdConnectProvider;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            if (this.getAwscliLayer() != null) {
                data.set("awscliLayer", om.valueToTree(this.getAwscliLayer()));
            }
            if (this.getClusterCertificateAuthorityData() != null) {
                data.set("clusterCertificateAuthorityData", om.valueToTree(this.getClusterCertificateAuthorityData()));
            }
            if (this.getClusterEncryptionConfigKeyArn() != null) {
                data.set("clusterEncryptionConfigKeyArn", om.valueToTree(this.getClusterEncryptionConfigKeyArn()));
            }
            if (this.getClusterEndpoint() != null) {
                data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
            }
            if (this.getClusterHandlerSecurityGroupId() != null) {
                data.set("clusterHandlerSecurityGroupId", om.valueToTree(this.getClusterHandlerSecurityGroupId()));
            }
            if (this.getClusterSecurityGroupId() != null) {
                data.set("clusterSecurityGroupId", om.valueToTree(this.getClusterSecurityGroupId()));
            }
            if (this.getIpFamily() != null) {
                data.set("ipFamily", om.valueToTree(this.getIpFamily()));
            }
            if (this.getKubectlEnvironment() != null) {
                data.set("kubectlEnvironment", om.valueToTree(this.getKubectlEnvironment()));
            }
            if (this.getKubectlLambdaRole() != null) {
                data.set("kubectlLambdaRole", om.valueToTree(this.getKubectlLambdaRole()));
            }
            if (this.getKubectlLayer() != null) {
                data.set("kubectlLayer", om.valueToTree(this.getKubectlLayer()));
            }
            if (this.getKubectlMemory() != null) {
                data.set("kubectlMemory", om.valueToTree(this.getKubectlMemory()));
            }
            if (this.getKubectlPrivateSubnetIds() != null) {
                data.set("kubectlPrivateSubnetIds", om.valueToTree(this.getKubectlPrivateSubnetIds()));
            }
            if (this.getKubectlProvider() != null) {
                data.set("kubectlProvider", om.valueToTree(this.getKubectlProvider()));
            }
            if (this.getKubectlRoleArn() != null) {
                data.set("kubectlRoleArn", om.valueToTree(this.getKubectlRoleArn()));
            }
            if (this.getKubectlSecurityGroupId() != null) {
                data.set("kubectlSecurityGroupId", om.valueToTree(this.getKubectlSecurityGroupId()));
            }
            if (this.getOnEventLayer() != null) {
                data.set("onEventLayer", om.valueToTree(this.getOnEventLayer()));
            }
            if (this.getOpenIdConnectProvider() != null) {
                data.set("openIdConnectProvider", om.valueToTree(this.getOpenIdConnectProvider()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.ClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterAttributes.Jsii$Proxy that = (ClusterAttributes.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (this.awscliLayer != null ? !this.awscliLayer.equals(that.awscliLayer) : that.awscliLayer != null) return false;
            if (this.clusterCertificateAuthorityData != null ? !this.clusterCertificateAuthorityData.equals(that.clusterCertificateAuthorityData) : that.clusterCertificateAuthorityData != null) return false;
            if (this.clusterEncryptionConfigKeyArn != null ? !this.clusterEncryptionConfigKeyArn.equals(that.clusterEncryptionConfigKeyArn) : that.clusterEncryptionConfigKeyArn != null) return false;
            if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
            if (this.clusterHandlerSecurityGroupId != null ? !this.clusterHandlerSecurityGroupId.equals(that.clusterHandlerSecurityGroupId) : that.clusterHandlerSecurityGroupId != null) return false;
            if (this.clusterSecurityGroupId != null ? !this.clusterSecurityGroupId.equals(that.clusterSecurityGroupId) : that.clusterSecurityGroupId != null) return false;
            if (this.ipFamily != null ? !this.ipFamily.equals(that.ipFamily) : that.ipFamily != null) return false;
            if (this.kubectlEnvironment != null ? !this.kubectlEnvironment.equals(that.kubectlEnvironment) : that.kubectlEnvironment != null) return false;
            if (this.kubectlLambdaRole != null ? !this.kubectlLambdaRole.equals(that.kubectlLambdaRole) : that.kubectlLambdaRole != null) return false;
            if (this.kubectlLayer != null ? !this.kubectlLayer.equals(that.kubectlLayer) : that.kubectlLayer != null) return false;
            if (this.kubectlMemory != null ? !this.kubectlMemory.equals(that.kubectlMemory) : that.kubectlMemory != null) return false;
            if (this.kubectlPrivateSubnetIds != null ? !this.kubectlPrivateSubnetIds.equals(that.kubectlPrivateSubnetIds) : that.kubectlPrivateSubnetIds != null) return false;
            if (this.kubectlProvider != null ? !this.kubectlProvider.equals(that.kubectlProvider) : that.kubectlProvider != null) return false;
            if (this.kubectlRoleArn != null ? !this.kubectlRoleArn.equals(that.kubectlRoleArn) : that.kubectlRoleArn != null) return false;
            if (this.kubectlSecurityGroupId != null ? !this.kubectlSecurityGroupId.equals(that.kubectlSecurityGroupId) : that.kubectlSecurityGroupId != null) return false;
            if (this.onEventLayer != null ? !this.onEventLayer.equals(that.onEventLayer) : that.onEventLayer != null) return false;
            if (this.openIdConnectProvider != null ? !this.openIdConnectProvider.equals(that.openIdConnectProvider) : that.openIdConnectProvider != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.awscliLayer != null ? this.awscliLayer.hashCode() : 0);
            result = 31 * result + (this.clusterCertificateAuthorityData != null ? this.clusterCertificateAuthorityData.hashCode() : 0);
            result = 31 * result + (this.clusterEncryptionConfigKeyArn != null ? this.clusterEncryptionConfigKeyArn.hashCode() : 0);
            result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
            result = 31 * result + (this.clusterHandlerSecurityGroupId != null ? this.clusterHandlerSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.clusterSecurityGroupId != null ? this.clusterSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.ipFamily != null ? this.ipFamily.hashCode() : 0);
            result = 31 * result + (this.kubectlEnvironment != null ? this.kubectlEnvironment.hashCode() : 0);
            result = 31 * result + (this.kubectlLambdaRole != null ? this.kubectlLambdaRole.hashCode() : 0);
            result = 31 * result + (this.kubectlLayer != null ? this.kubectlLayer.hashCode() : 0);
            result = 31 * result + (this.kubectlMemory != null ? this.kubectlMemory.hashCode() : 0);
            result = 31 * result + (this.kubectlPrivateSubnetIds != null ? this.kubectlPrivateSubnetIds.hashCode() : 0);
            result = 31 * result + (this.kubectlProvider != null ? this.kubectlProvider.hashCode() : 0);
            result = 31 * result + (this.kubectlRoleArn != null ? this.kubectlRoleArn.hashCode() : 0);
            result = 31 * result + (this.kubectlSecurityGroupId != null ? this.kubectlSecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.onEventLayer != null ? this.onEventLayer.hashCode() : 0);
            result = 31 * result + (this.openIdConnectProvider != null ? this.openIdConnectProvider.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
