package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Options for <code>ListenerAction.authenciateOidc()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationListener listener;
 * ApplicationTargetGroup myTargetGroup;
 * listener.addAction("DefaultAction", AddApplicationActionProps.builder()
 *         .action(ListenerAction.authenticateOidc(AuthenticateOidcOptions.builder()
 *                 .authorizationEndpoint("https://example.com/openid")
 *                 // Other OIDC properties here
 *                 .clientId("...")
 *                 .clientSecret(SecretValue.secretsManager("..."))
 *                 .issuer("...")
 *                 .tokenEndpoint("...")
 *                 .userInfoEndpoint("...")
 *                 // Next
 *                 .next(ListenerAction.forward(List.of(myTargetGroup)))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.415Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.AuthenticateOidcOptions")
@software.amazon.jsii.Jsii.Proxy(AuthenticateOidcOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AuthenticateOidcOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The authorization endpoint of the IdP.
     * <p>
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

    /**
     * The OAuth 2.0 client identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The OAuth 2.0 client secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getClientSecret();

    /**
     * The OIDC issuer identifier of the IdP.
     * <p>
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

    /**
     * What action to execute next.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getNext();

    /**
     * The token endpoint of the IdP.
     * <p>
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTokenEndpoint();

    /**
     * The user info endpoint of the IdP.
     * <p>
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserInfoEndpoint();

    /**
     * Allow HTTPS outbound traffic to communicate with the IdP.
     * <p>
     * Set this property to false if the IP address used for the IdP endpoint is identifiable
     * and you want to control outbound traffic.
     * Then allow HTTPS outbound traffic to the IdP's IP address using the listener's <code>connections</code> property.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://repost.aws/knowledge-center/elb-configure-authentication-alb">https://repost.aws/knowledge-center/elb-configure-authentication-alb</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowHttpsOutbound() {
        return null;
    }

    /**
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     * <p>
     * Default: - No extra parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAuthenticationRequestExtraParams() {
        return null;
    }

    /**
     * The behavior if the user is not authenticated.
     * <p>
     * Default: UnauthenticatedAction.AUTHENTICATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction getOnUnauthenticatedRequest() {
        return null;
    }

    /**
     * The set of user claims to be requested from the IdP.
     * <p>
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     * <p>
     * Default: "openid"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
        return null;
    }

    /**
     * The name of the cookie used to maintain session information.
     * <p>
     * Default: "AWSELBAuthSessionCookie"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
        return null;
    }

    /**
     * The maximum duration of the authentication session.
     * <p>
     * Default: Duration.days(7)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getSessionTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthenticateOidcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthenticateOidcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AuthenticateOidcOptions> {
        java.lang.String authorizationEndpoint;
        java.lang.String clientId;
        software.amazon.awscdk.SecretValue clientSecret;
        java.lang.String issuer;
        software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next;
        java.lang.String tokenEndpoint;
        java.lang.String userInfoEndpoint;
        java.lang.Boolean allowHttpsOutbound;
        java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams;
        software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest;
        java.lang.String scope;
        java.lang.String sessionCookieName;
        software.amazon.awscdk.Duration sessionTimeout;

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getAuthorizationEndpoint}
         * @param authorizationEndpoint The authorization endpoint of the IdP. This parameter is required.
         *                              This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getClientId}
         * @param clientId The OAuth 2.0 client identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getClientSecret}
         * @param clientSecret The OAuth 2.0 client secret. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(software.amazon.awscdk.SecretValue clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getIssuer}
         * @param issuer The OIDC issuer identifier of the IdP. This parameter is required.
         *               This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder issuer(java.lang.String issuer) {
            this.issuer = issuer;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getNext}
         * @param next What action to execute next. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder next(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next) {
            this.next = next;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getTokenEndpoint}
         * @param tokenEndpoint The token endpoint of the IdP. This parameter is required.
         *                      This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getUserInfoEndpoint}
         * @param userInfoEndpoint The user info endpoint of the IdP. This parameter is required.
         *                         This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getAllowHttpsOutbound}
         * @param allowHttpsOutbound Allow HTTPS outbound traffic to communicate with the IdP.
         *                           Set this property to false if the IP address used for the IdP endpoint is identifiable
         *                           and you want to control outbound traffic.
         *                           Then allow HTTPS outbound traffic to the IdP's IP address using the listener's <code>connections</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowHttpsOutbound(java.lang.Boolean allowHttpsOutbound) {
            this.allowHttpsOutbound = allowHttpsOutbound;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getAuthenticationRequestExtraParams}
         * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = authenticationRequestExtraParams;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getOnUnauthenticatedRequest}
         * @param onUnauthenticatedRequest The behavior if the user is not authenticated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUnauthenticatedRequest(software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getScope}
         * @param scope The set of user claims to be requested from the IdP.
         *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getSessionCookieName}
         * @param sessionCookieName The name of the cookie used to maintain session information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionCookieName(java.lang.String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        /**
         * Sets the value of {@link AuthenticateOidcOptions#getSessionTimeout}
         * @param sessionTimeout The maximum duration of the authentication session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeout(software.amazon.awscdk.Duration sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthenticateOidcOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AuthenticateOidcOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthenticateOidcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateOidcOptions {
        private final java.lang.String authorizationEndpoint;
        private final java.lang.String clientId;
        private final software.amazon.awscdk.SecretValue clientSecret;
        private final java.lang.String issuer;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next;
        private final java.lang.String tokenEndpoint;
        private final java.lang.String userInfoEndpoint;
        private final java.lang.Boolean allowHttpsOutbound;
        private final java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest;
        private final java.lang.String scope;
        private final java.lang.String sessionCookieName;
        private final software.amazon.awscdk.Duration sessionTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.next = software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.tokenEndpoint = software.amazon.jsii.Kernel.get(this, "tokenEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userInfoEndpoint = software.amazon.jsii.Kernel.get(this, "userInfoEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowHttpsOutbound = software.amazon.jsii.Kernel.get(this, "allowHttpsOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.authenticationRequestExtraParams = software.amazon.jsii.Kernel.get(this, "authenticationRequestExtraParams", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.onUnauthenticatedRequest = software.amazon.jsii.Kernel.get(this, "onUnauthenticatedRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionCookieName = software.amazon.jsii.Kernel.get(this, "sessionCookieName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionTimeout = software.amazon.jsii.Kernel.get(this, "sessionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationEndpoint = java.util.Objects.requireNonNull(builder.authorizationEndpoint, "authorizationEndpoint is required");
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
            this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
            this.next = java.util.Objects.requireNonNull(builder.next, "next is required");
            this.tokenEndpoint = java.util.Objects.requireNonNull(builder.tokenEndpoint, "tokenEndpoint is required");
            this.userInfoEndpoint = java.util.Objects.requireNonNull(builder.userInfoEndpoint, "userInfoEndpoint is required");
            this.allowHttpsOutbound = builder.allowHttpsOutbound;
            this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
            this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
            this.scope = builder.scope;
            this.sessionCookieName = builder.sessionCookieName;
            this.sessionTimeout = builder.sessionTimeout;
        }

        @Override
        public final java.lang.String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final java.lang.String getIssuer() {
            return this.issuer;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getNext() {
            return this.next;
        }

        @Override
        public final java.lang.String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public final java.lang.String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        @Override
        public final java.lang.Boolean getAllowHttpsOutbound() {
            return this.allowHttpsOutbound;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction getOnUnauthenticatedRequest() {
            return this.onUnauthenticatedRequest;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @Override
        public final software.amazon.awscdk.Duration getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            data.set("issuer", om.valueToTree(this.getIssuer()));
            data.set("next", om.valueToTree(this.getNext()));
            data.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
            data.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
            if (this.getAllowHttpsOutbound() != null) {
                data.set("allowHttpsOutbound", om.valueToTree(this.getAllowHttpsOutbound()));
            }
            if (this.getAuthenticationRequestExtraParams() != null) {
                data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
            }
            if (this.getOnUnauthenticatedRequest() != null) {
                data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getSessionCookieName() != null) {
                data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
            }
            if (this.getSessionTimeout() != null) {
                data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.AuthenticateOidcOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthenticateOidcOptions.Jsii$Proxy that = (AuthenticateOidcOptions.Jsii$Proxy) o;

            if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
            if (!clientId.equals(that.clientId)) return false;
            if (!clientSecret.equals(that.clientSecret)) return false;
            if (!issuer.equals(that.issuer)) return false;
            if (!next.equals(that.next)) return false;
            if (!tokenEndpoint.equals(that.tokenEndpoint)) return false;
            if (!userInfoEndpoint.equals(that.userInfoEndpoint)) return false;
            if (this.allowHttpsOutbound != null ? !this.allowHttpsOutbound.equals(that.allowHttpsOutbound) : that.allowHttpsOutbound != null) return false;
            if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
            if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
            return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationEndpoint.hashCode();
            result = 31 * result + (this.clientId.hashCode());
            result = 31 * result + (this.clientSecret.hashCode());
            result = 31 * result + (this.issuer.hashCode());
            result = 31 * result + (this.next.hashCode());
            result = 31 * result + (this.tokenEndpoint.hashCode());
            result = 31 * result + (this.userInfoEndpoint.hashCode());
            result = 31 * result + (this.allowHttpsOutbound != null ? this.allowHttpsOutbound.hashCode() : 0);
            result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
            result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
            result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
            return result;
        }
    }
}
