package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What kind of addresses to allocate to the load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * NetworkLoadBalancer lb = NetworkLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .ipAddressType(IpAddressType.DUAL_STACK)
 *         .enablePrefixForIpv6SourceNat(true)
 *         .build();
 * NetworkListener listener = lb.addListener("Listener", BaseNetworkListenerProps.builder()
 *         .port(1229)
 *         .protocol(Protocol.UDP)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.IpAddressType")
public enum IpAddressType {
    /**
     * Allocate IPv4 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Allocate both IPv4 and IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
    /**
     * IPv6 only public addresses, with private IPv4 and IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK_WITHOUT_PUBLIC_IPV4,
}
