package software.amazon.awscdk.services.elasticloadbalancingv2.actions;

/**
 * A Listener Action to authenticate with Cognito.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Vpc vpc;
 * Certificate certificate;
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * UserPool userPool = new UserPool(this, "UserPool");
 * UserPoolClient userPoolClient = UserPoolClient.Builder.create(this, "Client")
 *         .userPool(userPool)
 *         // Required minimal configuration for use with an ELB
 *         .generateSecret(true)
 *         .authFlows(AuthFlow.builder()
 *                 .userPassword(true)
 *                 .build())
 *         .oAuth(OAuthSettings.builder()
 *                 .flows(OAuthFlows.builder()
 *                         .authorizationCodeGrant(true)
 *                         .build())
 *                 .scopes(List.of(OAuthScope.EMAIL))
 *                 .callbackUrls(List.of(String.format("https://%s/oauth2/idpresponse", lb.getLoadBalancerDnsName())))
 *                 .build())
 *         .build();
 * CfnUserPoolClient cfnClient = (CfnUserPoolClient)userPoolClient.getNode().getDefaultChild();
 * cfnClient.addPropertyOverride("RefreshTokenValidity", 1);
 * cfnClient.addPropertyOverride("SupportedIdentityProviders", List.of("COGNITO"));
 * UserPoolDomain userPoolDomain = UserPoolDomain.Builder.create(this, "Domain")
 *         .userPool(userPool)
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("test-cdk-prefix")
 *                 .build())
 *         .build();
 * lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(443)
 *         .certificates(List.of(certificate))
 *         .defaultAction(AuthenticateCognitoAction.Builder.create()
 *                 .userPool(userPool)
 *                 .userPoolClient(userPoolClient)
 *                 .userPoolDomain(userPoolDomain)
 *                 .next(ListenerAction.fixedResponse(200, FixedResponseOptions.builder()
 *                         .contentType("text/plain")
 *                         .messageBody("Authenticated")
 *                         .build()))
 *                 .build())
 *         .build());
 * CfnOutput.Builder.create(this, "DNS")
 *         .value(lb.getLoadBalancerDnsName())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.554Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2_actions.AuthenticateCognitoAction")
public class AuthenticateCognitoAction extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction {

    protected AuthenticateCognitoAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AuthenticateCognitoAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AuthenticateCognitoAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoActionProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     * @param associatingConstruct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.constructs.IConstruct associatingConstruct) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoActionProps.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoActionProps.Builder();
        }

        /**
         * What action to execute next.
         * <p>
         * Multiple actions form a linked chain; the chain must always terminate in a
         * (weighted)forward, fixedResponse or redirect action.
         * <p>
         * @return {@code this}
         * @param next What action to execute next. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder next(final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next) {
            this.options.next(next);
            return this;
        }

        /**
         * The Amazon Cognito user pool.
         * <p>
         * @return {@code this}
         * @param userPool The Amazon Cognito user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.options.userPool(userPool);
            return this;
        }

        /**
         * The Amazon Cognito user pool client.
         * <p>
         * @return {@code this}
         * @param userPoolClient The Amazon Cognito user pool client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolClient(final software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient) {
            this.options.userPoolClient(userPoolClient);
            return this;
        }

        /**
         * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         * <p>
         * @return {@code this}
         * @param userPoolDomain The domain prefix or fully-qualified domain name of the Amazon Cognito user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolDomain(final software.amazon.awscdk.services.cognito.IUserPoolDomain userPoolDomain) {
            this.options.userPoolDomain(userPoolDomain);
            return this;
        }

        /**
         * Allow HTTPS outbound traffic to communicate with the IdP.
         * <p>
         * Set this property to false if the IP address used for the IdP endpoint is identifiable
         * and you want to control outbound traffic.
         * Then allow HTTPS outbound traffic to the IdP's IP address using the listener's <code>connections</code> property.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://repost.aws/knowledge-center/elb-configure-authentication-alb">https://repost.aws/knowledge-center/elb-configure-authentication-alb</a>
         * @param allowHttpsOutbound Allow HTTPS outbound traffic to communicate with the IdP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowHttpsOutbound(final java.lang.Boolean allowHttpsOutbound) {
            this.options.allowHttpsOutbound(allowHttpsOutbound);
            return this;
        }

        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * <p>
         * Default: - No extra parameters
         * <p>
         * @return {@code this}
         * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationRequestExtraParams(final java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
            this.options.authenticationRequestExtraParams(authenticationRequestExtraParams);
            return this;
        }

        /**
         * The behavior if the user is not authenticated.
         * <p>
         * Default: UnauthenticatedAction.AUTHENTICATE
         * <p>
         * @return {@code this}
         * @param onUnauthenticatedRequest The behavior if the user is not authenticated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUnauthenticatedRequest(final software.amazon.awscdk.services.elasticloadbalancingv2.UnauthenticatedAction onUnauthenticatedRequest) {
            this.options.onUnauthenticatedRequest(onUnauthenticatedRequest);
            return this;
        }

        /**
         * The set of user claims to be requested from the IdP.
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * <p>
         * Default: "openid"
         * <p>
         * @return {@code this}
         * @param scope The set of user claims to be requested from the IdP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final java.lang.String scope) {
            this.options.scope(scope);
            return this;
        }

        /**
         * The name of the cookie used to maintain session information.
         * <p>
         * Default: "AWSELBAuthSessionCookie"
         * <p>
         * @return {@code this}
         * @param sessionCookieName The name of the cookie used to maintain session information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionCookieName(final java.lang.String sessionCookieName) {
            this.options.sessionCookieName(sessionCookieName);
            return this;
        }

        /**
         * The maximum duration of the authentication session.
         * <p>
         * Default: Duration.days(7)
         * <p>
         * @return {@code this}
         * @param sessionTimeout The maximum duration of the authentication session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeout(final software.amazon.awscdk.Duration sessionTimeout) {
            this.options.sessionTimeout(sessionTimeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoAction build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.actions.AuthenticateCognitoAction(
                this.options.build()
            );
        }
    }
}
