package software.amazon.awscdk.services.events;

/**
 * Creates a connection.
 * <p>
 * A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection.html">Connections for endpoint targets</a> in the <em>Amazon EventBridge User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * CfnConnection cfnConnection = CfnConnection.Builder.create(this, "MyCfnConnection")
 *         .authorizationType("authorizationType")
 *         .authParameters(AuthParametersProperty.builder()
 *                 .apiKeyAuthParameters(ApiKeyAuthParametersProperty.builder()
 *                         .apiKeyName("apiKeyName")
 *                         .apiKeyValue("apiKeyValue")
 *                         .build())
 *                 .basicAuthParameters(BasicAuthParametersProperty.builder()
 *                         .password("password")
 *                         .username("username")
 *                         .build())
 *                 .connectivityParameters(ConnectivityParametersProperty.builder()
 *                         .resourceParameters(ResourceParametersProperty.builder()
 *                                 .resourceConfigurationArn("resourceConfigurationArn")
 *                                 // the properties below are optional
 *                                 .resourceAssociationArn("resourceAssociationArn")
 *                                 .build())
 *                         .build())
 *                 .invocationHttpParameters(ConnectionHttpParametersProperty.builder()
 *                         .bodyParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .headerParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .queryStringParameters(List.of(ParameterProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .isValueSecret(false)
 *                                 .build()))
 *                         .build())
 *                 .oAuthParameters(OAuthParametersProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientParameters(ClientParametersProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 .build())
 *                         .httpMethod("httpMethod")
 *                         // the properties below are optional
 *                         .oAuthHttpParameters(ConnectionHttpParametersProperty.builder()
 *                                 .bodyParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .headerParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .queryStringParameters(List.of(ParameterProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .isValueSecret(false)
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .invocationConnectivityParameters(InvocationConnectivityParametersProperty.builder()
 *                 .resourceParameters(ResourceParametersProperty.builder()
 *                         .resourceConfigurationArn("resourceConfigurationArn")
 *                         // the properties below are optional
 *                         .resourceAssociationArn("resourceAssociationArn")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.761Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection")
public class CfnConnection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.events.CfnConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the connection that was created by the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
     * <p>
     * <blockquote>
     * <p>
     * The value of this property is set by EventBridge . Any value you specify in your template is ignored.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAuthParametersConnectivityParametersResourceParametersResourceAssociationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAuthParametersConnectivityParametersResourceParametersResourceAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
     * <p>
     * <blockquote>
     * <p>
     * The value of this property is set by EventBridge . Any value you specify in your template is ignored.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInvocationConnectivityParametersResourceParametersResourceAssociationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrInvocationConnectivityParametersResourceParametersResourceAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the secret created for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The type of authorization to use for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of authorization to use for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizationType", value);
    }

    /**
     * The authorization parameters to use to authorize with the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuthParameters() {
        return software.amazon.jsii.Kernel.get(this, "authParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The authorization parameters to use to authorize with the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authParameters", value);
    }

    /**
     * The authorization parameters to use to authorize with the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnConnection.AuthParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "authParameters", value);
    }

    /**
     * A description for the connection to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the connection to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInvocationConnectivityParameters() {
        return software.amazon.jsii.Kernel.get(this, "invocationConnectivityParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInvocationConnectivityParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "invocationConnectivityParameters", value);
    }

    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInvocationConnectivityParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnConnection.InvocationConnectivityParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "invocationConnectivityParameters", value);
    }

    /**
     * The name for the connection to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the connection to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * The API key authorization parameters for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ApiKeyAuthParametersProperty apiKeyAuthParametersProperty = ApiKeyAuthParametersProperty.builder()
     *         .apiKeyName("apiKeyName")
     *         .apiKeyValue("apiKeyValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ApiKeyAuthParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiKeyAuthParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiKeyAuthParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the API key to use for authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html#cfn-events-connection-apikeyauthparameters-apikeyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html#cfn-events-connection-apikeyauthparameters-apikeyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKeyName();

        /**
         * The value for the API key to use for authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html#cfn-events-connection-apikeyauthparameters-apikeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-apikeyauthparameters.html#cfn-events-connection-apikeyauthparameters-apikeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKeyValue();

        /**
         * @return a {@link Builder} of {@link ApiKeyAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiKeyAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiKeyAuthParametersProperty> {
            java.lang.String apiKeyName;
            java.lang.String apiKeyValue;

            /**
             * Sets the value of {@link ApiKeyAuthParametersProperty#getApiKeyName}
             * @param apiKeyName The name of the API key to use for authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyName(java.lang.String apiKeyName) {
                this.apiKeyName = apiKeyName;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyAuthParametersProperty#getApiKeyValue}
             * @param apiKeyValue The value for the API key to use for authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyValue(java.lang.String apiKeyValue) {
                this.apiKeyValue = apiKeyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiKeyAuthParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiKeyAuthParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiKeyAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyAuthParametersProperty {
            private final java.lang.String apiKeyName;
            private final java.lang.String apiKeyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKeyName = software.amazon.jsii.Kernel.get(this, "apiKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.apiKeyValue = software.amazon.jsii.Kernel.get(this, "apiKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKeyName = java.util.Objects.requireNonNull(builder.apiKeyName, "apiKeyName is required");
                this.apiKeyValue = java.util.Objects.requireNonNull(builder.apiKeyValue, "apiKeyValue is required");
            }

            @Override
            public final java.lang.String getApiKeyName() {
                return this.apiKeyName;
            }

            @Override
            public final java.lang.String getApiKeyValue() {
                return this.apiKeyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
                data.set("apiKeyValue", om.valueToTree(this.getApiKeyValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ApiKeyAuthParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiKeyAuthParametersProperty.Jsii$Proxy that = (ApiKeyAuthParametersProperty.Jsii$Proxy) o;

                if (!apiKeyName.equals(that.apiKeyName)) return false;
                return this.apiKeyValue.equals(that.apiKeyValue);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKeyName.hashCode();
                result = 31 * result + (this.apiKeyValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Tthe authorization parameters to use for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * AuthParametersProperty authParametersProperty = AuthParametersProperty.builder()
     *         .apiKeyAuthParameters(ApiKeyAuthParametersProperty.builder()
     *                 .apiKeyName("apiKeyName")
     *                 .apiKeyValue("apiKeyValue")
     *                 .build())
     *         .basicAuthParameters(BasicAuthParametersProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .connectivityParameters(ConnectivityParametersProperty.builder()
     *                 .resourceParameters(ResourceParametersProperty.builder()
     *                         .resourceConfigurationArn("resourceConfigurationArn")
     *                         // the properties below are optional
     *                         .resourceAssociationArn("resourceAssociationArn")
     *                         .build())
     *                 .build())
     *         .invocationHttpParameters(ConnectionHttpParametersProperty.builder()
     *                 .bodyParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .headerParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .queryStringParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .build())
     *         .oAuthParameters(OAuthParametersProperty.builder()
     *                 .authorizationEndpoint("authorizationEndpoint")
     *                 .clientParameters(ClientParametersProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         .build())
     *                 .httpMethod("httpMethod")
     *                 // the properties below are optional
     *                 .oAuthHttpParameters(ConnectionHttpParametersProperty.builder()
     *                         .bodyParameters(List.of(ParameterProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 // the properties below are optional
     *                                 .isValueSecret(false)
     *                                 .build()))
     *                         .headerParameters(List.of(ParameterProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 // the properties below are optional
     *                                 .isValueSecret(false)
     *                                 .build()))
     *                         .queryStringParameters(List.of(ParameterProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 // the properties below are optional
     *                                 .isValueSecret(false)
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.AuthParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API Key parameters to use for authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-apikeyauthparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-apikeyauthparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyAuthParameters() {
            return null;
        }

        /**
         * The authorization parameters for Basic authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-basicauthparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-basicauthparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthParameters() {
            return null;
        }

        /**
         * For private OAuth authentication endpoints. The parameters EventBridge uses to authenticate against the endpoint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html">Authorization methods for connections</a> in the <strong>Amazon EventBridge User Guide</strong> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-connectivityparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-connectivityparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectivityParameters() {
            return null;
        }

        /**
         * Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-invocationhttpparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-invocationhttpparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvocationHttpParameters() {
            return null;
        }

        /**
         * The OAuth parameters to use for authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-oauthparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-authparameters.html#cfn-events-connection-authparameters-oauthparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthParametersProperty> {
            java.lang.Object apiKeyAuthParameters;
            java.lang.Object basicAuthParameters;
            java.lang.Object connectivityParameters;
            java.lang.Object invocationHttpParameters;
            java.lang.Object oAuthParameters;

            /**
             * Sets the value of {@link AuthParametersProperty#getApiKeyAuthParameters}
             * @param apiKeyAuthParameters The API Key parameters to use for authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyAuthParameters(software.amazon.awscdk.IResolvable apiKeyAuthParameters) {
                this.apiKeyAuthParameters = apiKeyAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getApiKeyAuthParameters}
             * @param apiKeyAuthParameters The API Key parameters to use for authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyAuthParameters(software.amazon.awscdk.services.events.CfnConnection.ApiKeyAuthParametersProperty apiKeyAuthParameters) {
                this.apiKeyAuthParameters = apiKeyAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getBasicAuthParameters}
             * @param basicAuthParameters The authorization parameters for Basic authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthParameters(software.amazon.awscdk.IResolvable basicAuthParameters) {
                this.basicAuthParameters = basicAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getBasicAuthParameters}
             * @param basicAuthParameters The authorization parameters for Basic authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthParameters(software.amazon.awscdk.services.events.CfnConnection.BasicAuthParametersProperty basicAuthParameters) {
                this.basicAuthParameters = basicAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getConnectivityParameters}
             * @param connectivityParameters For private OAuth authentication endpoints. The parameters EventBridge uses to authenticate against the endpoint.
             *                               For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html">Authorization methods for connections</a> in the <strong>Amazon EventBridge User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectivityParameters(software.amazon.awscdk.IResolvable connectivityParameters) {
                this.connectivityParameters = connectivityParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getConnectivityParameters}
             * @param connectivityParameters For private OAuth authentication endpoints. The parameters EventBridge uses to authenticate against the endpoint.
             *                               For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html">Authorization methods for connections</a> in the <strong>Amazon EventBridge User Guide</strong> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectivityParameters(software.amazon.awscdk.services.events.CfnConnection.ConnectivityParametersProperty connectivityParameters) {
                this.connectivityParameters = connectivityParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getInvocationHttpParameters}
             * @param invocationHttpParameters Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationHttpParameters(software.amazon.awscdk.IResolvable invocationHttpParameters) {
                this.invocationHttpParameters = invocationHttpParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getInvocationHttpParameters}
             * @param invocationHttpParameters Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationHttpParameters(software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty invocationHttpParameters) {
                this.invocationHttpParameters = invocationHttpParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getOAuthParameters}
             * @param oAuthParameters The OAuth parameters to use for authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.IResolvable oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Sets the value of {@link AuthParametersProperty#getOAuthParameters}
             * @param oAuthParameters The OAuth parameters to use for authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthParameters(software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty oAuthParameters) {
                this.oAuthParameters = oAuthParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthParametersProperty {
            private final java.lang.Object apiKeyAuthParameters;
            private final java.lang.Object basicAuthParameters;
            private final java.lang.Object connectivityParameters;
            private final java.lang.Object invocationHttpParameters;
            private final java.lang.Object oAuthParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKeyAuthParameters = software.amazon.jsii.Kernel.get(this, "apiKeyAuthParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.basicAuthParameters = software.amazon.jsii.Kernel.get(this, "basicAuthParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectivityParameters = software.amazon.jsii.Kernel.get(this, "connectivityParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.invocationHttpParameters = software.amazon.jsii.Kernel.get(this, "invocationHttpParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuthParameters = software.amazon.jsii.Kernel.get(this, "oAuthParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKeyAuthParameters = builder.apiKeyAuthParameters;
                this.basicAuthParameters = builder.basicAuthParameters;
                this.connectivityParameters = builder.connectivityParameters;
                this.invocationHttpParameters = builder.invocationHttpParameters;
                this.oAuthParameters = builder.oAuthParameters;
            }

            @Override
            public final java.lang.Object getApiKeyAuthParameters() {
                return this.apiKeyAuthParameters;
            }

            @Override
            public final java.lang.Object getBasicAuthParameters() {
                return this.basicAuthParameters;
            }

            @Override
            public final java.lang.Object getConnectivityParameters() {
                return this.connectivityParameters;
            }

            @Override
            public final java.lang.Object getInvocationHttpParameters() {
                return this.invocationHttpParameters;
            }

            @Override
            public final java.lang.Object getOAuthParameters() {
                return this.oAuthParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiKeyAuthParameters() != null) {
                    data.set("apiKeyAuthParameters", om.valueToTree(this.getApiKeyAuthParameters()));
                }
                if (this.getBasicAuthParameters() != null) {
                    data.set("basicAuthParameters", om.valueToTree(this.getBasicAuthParameters()));
                }
                if (this.getConnectivityParameters() != null) {
                    data.set("connectivityParameters", om.valueToTree(this.getConnectivityParameters()));
                }
                if (this.getInvocationHttpParameters() != null) {
                    data.set("invocationHttpParameters", om.valueToTree(this.getInvocationHttpParameters()));
                }
                if (this.getOAuthParameters() != null) {
                    data.set("oAuthParameters", om.valueToTree(this.getOAuthParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.AuthParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthParametersProperty.Jsii$Proxy that = (AuthParametersProperty.Jsii$Proxy) o;

                if (this.apiKeyAuthParameters != null ? !this.apiKeyAuthParameters.equals(that.apiKeyAuthParameters) : that.apiKeyAuthParameters != null) return false;
                if (this.basicAuthParameters != null ? !this.basicAuthParameters.equals(that.basicAuthParameters) : that.basicAuthParameters != null) return false;
                if (this.connectivityParameters != null ? !this.connectivityParameters.equals(that.connectivityParameters) : that.connectivityParameters != null) return false;
                if (this.invocationHttpParameters != null ? !this.invocationHttpParameters.equals(that.invocationHttpParameters) : that.invocationHttpParameters != null) return false;
                return this.oAuthParameters != null ? this.oAuthParameters.equals(that.oAuthParameters) : that.oAuthParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiKeyAuthParameters != null ? this.apiKeyAuthParameters.hashCode() : 0;
                result = 31 * result + (this.basicAuthParameters != null ? this.basicAuthParameters.hashCode() : 0);
                result = 31 * result + (this.connectivityParameters != null ? this.connectivityParameters.hashCode() : 0);
                result = 31 * result + (this.invocationHttpParameters != null ? this.invocationHttpParameters.hashCode() : 0);
                result = 31 * result + (this.oAuthParameters != null ? this.oAuthParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Basic authorization parameters for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * BasicAuthParametersProperty basicAuthParametersProperty = BasicAuthParametersProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.BasicAuthParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password associated with the user name to use for Basic authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html#cfn-events-connection-basicauthparameters-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html#cfn-events-connection-basicauthparameters-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The user name to use for Basic authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html#cfn-events-connection-basicauthparameters-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-basicauthparameters.html#cfn-events-connection-basicauthparameters-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link BasicAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthParametersProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link BasicAuthParametersProperty#getPassword}
             * @param password The password associated with the user name to use for Basic authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthParametersProperty#getUsername}
             * @param username The user name to use for Basic authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthParametersProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.BasicAuthParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthParametersProperty.Jsii$Proxy that = (BasicAuthParametersProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The OAuth authorization parameters to use for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ClientParametersProperty clientParametersProperty = ClientParametersProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ClientParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The client ID to use for OAuth authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html#cfn-events-connection-clientparameters-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html#cfn-events-connection-clientparameters-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret assciated with the client ID to use for OAuth authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html#cfn-events-connection-clientparameters-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-clientparameters.html#cfn-events-connection-clientparameters-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * @return a {@link Builder} of {@link ClientParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientParametersProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;

            /**
             * Sets the value of {@link ClientParametersProperty#getClientId}
             * @param clientId The client ID to use for OAuth authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link ClientParametersProperty#getClientSecret}
             * @param clientSecret The client secret assciated with the client ID to use for OAuth authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientParametersProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ClientParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientParametersProperty.Jsii$Proxy that = (ClientParametersProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                return this.clientSecret.equals(that.clientSecret);
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                return result;
            }
        }
    }
    /**
     * Any additional parameters for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ConnectionHttpParametersProperty connectionHttpParametersProperty = ConnectionHttpParametersProperty.builder()
     *         .bodyParameters(List.of(ParameterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .isValueSecret(false)
     *                 .build()))
     *         .headerParameters(List.of(ParameterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .isValueSecret(false)
     *                 .build()))
     *         .queryStringParameters(List.of(ParameterProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .isValueSecret(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ConnectionHttpParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionHttpParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionHttpParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Any additional body string parameters for the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-bodyparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-bodyparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBodyParameters() {
            return null;
        }

        /**
         * Any additional header parameters for the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-headerparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-headerparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderParameters() {
            return null;
        }

        /**
         * Any additional query string parameters for the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-querystringparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectionhttpparameters.html#cfn-events-connection-connectionhttpparameters-querystringparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionHttpParametersProperty> {
            java.lang.Object bodyParameters;
            java.lang.Object headerParameters;
            java.lang.Object queryStringParameters;

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getBodyParameters}
             * @param bodyParameters Any additional body string parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyParameters(software.amazon.awscdk.IResolvable bodyParameters) {
                this.bodyParameters = bodyParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getBodyParameters}
             * @param bodyParameters Any additional body string parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyParameters(java.util.List<? extends java.lang.Object> bodyParameters) {
                this.bodyParameters = bodyParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getHeaderParameters}
             * @param headerParameters Any additional header parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(software.amazon.awscdk.IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getHeaderParameters}
             * @param headerParameters Any additional header parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(java.util.List<? extends java.lang.Object> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters Any additional query string parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(software.amazon.awscdk.IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters Any additional query string parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(java.util.List<? extends java.lang.Object> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionHttpParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionHttpParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionHttpParametersProperty {
            private final java.lang.Object bodyParameters;
            private final java.lang.Object headerParameters;
            private final java.lang.Object queryStringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bodyParameters = software.amazon.jsii.Kernel.get(this, "bodyParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bodyParameters = builder.bodyParameters;
                this.headerParameters = builder.headerParameters;
                this.queryStringParameters = builder.queryStringParameters;
            }

            @Override
            public final java.lang.Object getBodyParameters() {
                return this.bodyParameters;
            }

            @Override
            public final java.lang.Object getHeaderParameters() {
                return this.headerParameters;
            }

            @Override
            public final java.lang.Object getQueryStringParameters() {
                return this.queryStringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBodyParameters() != null) {
                    data.set("bodyParameters", om.valueToTree(this.getBodyParameters()));
                }
                if (this.getHeaderParameters() != null) {
                    data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
                }
                if (this.getQueryStringParameters() != null) {
                    data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ConnectionHttpParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionHttpParametersProperty.Jsii$Proxy that = (ConnectionHttpParametersProperty.Jsii$Proxy) o;

                if (this.bodyParameters != null ? !this.bodyParameters.equals(that.bodyParameters) : that.bodyParameters != null) return false;
                if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
                return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bodyParameters != null ? this.bodyParameters.hashCode() : 0;
                result = 31 * result + (this.headerParameters != null ? this.headerParameters.hashCode() : 0);
                result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If you specify a private OAuth endpoint, the parameters for EventBridge to use when authenticating against the endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html">Authorization methods for connections</a> in the <strong>Amazon EventBridge User Guide</strong> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ConnectivityParametersProperty connectivityParametersProperty = ConnectivityParametersProperty.builder()
     *         .resourceParameters(ResourceParametersProperty.builder()
     *                 .resourceConfigurationArn("resourceConfigurationArn")
     *                 // the properties below are optional
     *                 .resourceAssociationArn("resourceAssociationArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectivityparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectivityparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ConnectivityParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectivityParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectivityParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectivityparameters.html#cfn-events-connection-connectivityparameters-resourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-connectivityparameters.html#cfn-events-connection-connectivityparameters-resourceparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getResourceParameters();

        /**
         * @return a {@link Builder} of {@link ConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectivityParametersProperty> {
            java.lang.Object resourceParameters;

            /**
             * Sets the value of {@link ConnectivityParametersProperty#getResourceParameters}
             * @param resourceParameters The parameters for EventBridge to use when invoking the resource endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceParameters(software.amazon.awscdk.IResolvable resourceParameters) {
                this.resourceParameters = resourceParameters;
                return this;
            }

            /**
             * Sets the value of {@link ConnectivityParametersProperty#getResourceParameters}
             * @param resourceParameters The parameters for EventBridge to use when invoking the resource endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceParameters(software.amazon.awscdk.services.events.CfnConnection.ResourceParametersProperty resourceParameters) {
                this.resourceParameters = resourceParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectivityParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectivityParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectivityParametersProperty {
            private final java.lang.Object resourceParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceParameters = software.amazon.jsii.Kernel.get(this, "resourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceParameters = java.util.Objects.requireNonNull(builder.resourceParameters, "resourceParameters is required");
            }

            @Override
            public final java.lang.Object getResourceParameters() {
                return this.resourceParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceParameters", om.valueToTree(this.getResourceParameters()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ConnectivityParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectivityParametersProperty.Jsii$Proxy that = (ConnectivityParametersProperty.Jsii$Proxy) o;

                return this.resourceParameters.equals(that.resourceParameters);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceParameters.hashCode();
                return result;
            }
        }
    }
    /**
     * For connections to private APIs, the parameters to use for invoking the API.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * InvocationConnectivityParametersProperty invocationConnectivityParametersProperty = InvocationConnectivityParametersProperty.builder()
     *         .resourceParameters(ResourceParametersProperty.builder()
     *                 .resourceConfigurationArn("resourceConfigurationArn")
     *                 // the properties below are optional
     *                 .resourceAssociationArn("resourceAssociationArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-invocationconnectivityparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-invocationconnectivityparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.InvocationConnectivityParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(InvocationConnectivityParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InvocationConnectivityParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for EventBridge to use when invoking the resource endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-invocationconnectivityparameters.html#cfn-events-connection-invocationconnectivityparameters-resourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-invocationconnectivityparameters.html#cfn-events-connection-invocationconnectivityparameters-resourceparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getResourceParameters();

        /**
         * @return a {@link Builder} of {@link InvocationConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InvocationConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InvocationConnectivityParametersProperty> {
            java.lang.Object resourceParameters;

            /**
             * Sets the value of {@link InvocationConnectivityParametersProperty#getResourceParameters}
             * @param resourceParameters The parameters for EventBridge to use when invoking the resource endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceParameters(software.amazon.awscdk.IResolvable resourceParameters) {
                this.resourceParameters = resourceParameters;
                return this;
            }

            /**
             * Sets the value of {@link InvocationConnectivityParametersProperty#getResourceParameters}
             * @param resourceParameters The parameters for EventBridge to use when invoking the resource endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceParameters(software.amazon.awscdk.services.events.CfnConnection.ResourceParametersProperty resourceParameters) {
                this.resourceParameters = resourceParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InvocationConnectivityParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InvocationConnectivityParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InvocationConnectivityParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InvocationConnectivityParametersProperty {
            private final java.lang.Object resourceParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceParameters = software.amazon.jsii.Kernel.get(this, "resourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceParameters = java.util.Objects.requireNonNull(builder.resourceParameters, "resourceParameters is required");
            }

            @Override
            public final java.lang.Object getResourceParameters() {
                return this.resourceParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceParameters", om.valueToTree(this.getResourceParameters()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.InvocationConnectivityParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InvocationConnectivityParametersProperty.Jsii$Proxy that = (InvocationConnectivityParametersProperty.Jsii$Proxy) o;

                return this.resourceParameters.equals(that.resourceParameters);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceParameters.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the OAuth authorization parameters to use for the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * OAuthParametersProperty oAuthParametersProperty = OAuthParametersProperty.builder()
     *         .authorizationEndpoint("authorizationEndpoint")
     *         .clientParameters(ClientParametersProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 .build())
     *         .httpMethod("httpMethod")
     *         // the properties below are optional
     *         .oAuthHttpParameters(ConnectionHttpParametersProperty.builder()
     *                 .bodyParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .headerParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .queryStringParameters(List.of(ParameterProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .isValueSecret(false)
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.OAuthParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL to the authorization endpoint when OAuth is specified as the authorization type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-authorizationendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-authorizationendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

        /**
         * The client parameters for OAuth authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-clientparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-clientparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClientParameters();

        /**
         * The method to use for the authorization request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-httpmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-httpmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod();

        /**
         * Details about the additional parameters to use for the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-oauthhttpparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-oauthparameters.html#cfn-events-connection-oauthparameters-oauthhttpparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthHttpParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthParametersProperty> {
            java.lang.String authorizationEndpoint;
            java.lang.Object clientParameters;
            java.lang.String httpMethod;
            java.lang.Object oAuthHttpParameters;

            /**
             * Sets the value of {@link OAuthParametersProperty#getAuthorizationEndpoint}
             * @param authorizationEndpoint The URL to the authorization endpoint when OAuth is specified as the authorization type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getClientParameters}
             * @param clientParameters The client parameters for OAuth authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientParameters(software.amazon.awscdk.IResolvable clientParameters) {
                this.clientParameters = clientParameters;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getClientParameters}
             * @param clientParameters The client parameters for OAuth authorization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientParameters(software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty clientParameters) {
                this.clientParameters = clientParameters;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getHttpMethod}
             * @param httpMethod The method to use for the authorization request. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getOAuthHttpParameters}
             * @param oAuthHttpParameters Details about the additional parameters to use for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthHttpParameters(software.amazon.awscdk.IResolvable oAuthHttpParameters) {
                this.oAuthHttpParameters = oAuthHttpParameters;
                return this;
            }

            /**
             * Sets the value of {@link OAuthParametersProperty#getOAuthHttpParameters}
             * @param oAuthHttpParameters Details about the additional parameters to use for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthHttpParameters(software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty oAuthHttpParameters) {
                this.oAuthHttpParameters = oAuthHttpParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthParametersProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.Object clientParameters;
            private final java.lang.String httpMethod;
            private final java.lang.Object oAuthHttpParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientParameters = software.amazon.jsii.Kernel.get(this, "clientParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthHttpParameters = software.amazon.jsii.Kernel.get(this, "oAuthHttpParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = java.util.Objects.requireNonNull(builder.authorizationEndpoint, "authorizationEndpoint is required");
                this.clientParameters = java.util.Objects.requireNonNull(builder.clientParameters, "clientParameters is required");
                this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
                this.oAuthHttpParameters = builder.oAuthHttpParameters;
            }

            @Override
            public final java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public final java.lang.Object getClientParameters() {
                return this.clientParameters;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.Object getOAuthHttpParameters() {
                return this.oAuthHttpParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                data.set("clientParameters", om.valueToTree(this.getClientParameters()));
                data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                if (this.getOAuthHttpParameters() != null) {
                    data.set("oAuthHttpParameters", om.valueToTree(this.getOAuthHttpParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.OAuthParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthParametersProperty.Jsii$Proxy that = (OAuthParametersProperty.Jsii$Proxy) o;

                if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
                if (!clientParameters.equals(that.clientParameters)) return false;
                if (!httpMethod.equals(that.httpMethod)) return false;
                return this.oAuthHttpParameters != null ? this.oAuthHttpParameters.equals(that.oAuthHttpParameters) : that.oAuthHttpParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationEndpoint.hashCode();
                result = 31 * result + (this.clientParameters.hashCode());
                result = 31 * result + (this.httpMethod.hashCode());
                result = 31 * result + (this.oAuthHttpParameters != null ? this.oAuthHttpParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Any additional query string parameter for the connection.
     * <p>
     * You can include up to 100 additional query string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ParameterProperty parameterProperty = ParameterProperty.builder()
     *         .key("key")
     *         .value("value")
     *         // the properties below are optional
     *         .isValueSecret(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key for a query string parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value associated with the key for the query string parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * Specifies whether the value is secret.
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-isvaluesecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-parameter.html#cfn-events-connection-parameter-isvaluesecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsValueSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterProperty> {
            java.lang.String key;
            java.lang.String value;
            java.lang.Object isValueSecret;

            /**
             * Sets the value of {@link ParameterProperty#getKey}
             * @param key The key for a query string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ParameterProperty#getValue}
             * @param value The value associated with the key for the query string parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ParameterProperty#getIsValueSecret}
             * @param isValueSecret Specifies whether the value is secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isValueSecret(java.lang.Boolean isValueSecret) {
                this.isValueSecret = isValueSecret;
                return this;
            }

            /**
             * Sets the value of {@link ParameterProperty#getIsValueSecret}
             * @param isValueSecret Specifies whether the value is secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isValueSecret(software.amazon.awscdk.IResolvable isValueSecret) {
                this.isValueSecret = isValueSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterProperty {
            private final java.lang.String key;
            private final java.lang.String value;
            private final java.lang.Object isValueSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isValueSecret = software.amazon.jsii.Kernel.get(this, "isValueSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.isValueSecret = builder.isValueSecret;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getIsValueSecret() {
                return this.isValueSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getIsValueSecret() != null) {
                    data.set("isValueSecret", om.valueToTree(this.getIsValueSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterProperty.Jsii$Proxy that = (ParameterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!value.equals(that.value)) return false;
                return this.isValueSecret != null ? this.isValueSecret.equals(that.isValueSecret) : that.isValueSecret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.isValueSecret != null ? this.isValueSecret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for EventBridge to use when invoking the resource endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * ResourceParametersProperty resourceParametersProperty = ResourceParametersProperty.builder()
     *         .resourceConfigurationArn("resourceConfigurationArn")
     *         // the properties below are optional
     *         .resourceAssociationArn("resourceAssociationArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnConnection.ResourceParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration for the resource endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html#cfn-events-connection-resourceparameters-resourceconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html#cfn-events-connection-resourceparameters-resourceconfigurationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceConfigurationArn();

        /**
         * For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
         * <p>
         * <blockquote>
         * <p>
         * The value of this property is set by EventBridge . Any value you specify in your template is ignored.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html#cfn-events-connection-resourceparameters-resourceassociationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-connection-resourceparameters.html#cfn-events-connection-resourceparameters-resourceassociationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceAssociationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceParametersProperty> {
            java.lang.String resourceConfigurationArn;
            java.lang.String resourceAssociationArn;

            /**
             * Sets the value of {@link ResourceParametersProperty#getResourceConfigurationArn}
             * @param resourceConfigurationArn The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration for the resource endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceConfigurationArn(java.lang.String resourceConfigurationArn) {
                this.resourceConfigurationArn = resourceConfigurationArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceParametersProperty#getResourceAssociationArn}
             * @param resourceAssociationArn For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
             *                               <blockquote>
             *                               <p>
             *                               The value of this property is set by EventBridge . Any value you specify in your template is ignored.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAssociationArn(java.lang.String resourceAssociationArn) {
                this.resourceAssociationArn = resourceAssociationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceParametersProperty {
            private final java.lang.String resourceConfigurationArn;
            private final java.lang.String resourceAssociationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceConfigurationArn = software.amazon.jsii.Kernel.get(this, "resourceConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceAssociationArn = software.amazon.jsii.Kernel.get(this, "resourceAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceConfigurationArn = java.util.Objects.requireNonNull(builder.resourceConfigurationArn, "resourceConfigurationArn is required");
                this.resourceAssociationArn = builder.resourceAssociationArn;
            }

            @Override
            public final java.lang.String getResourceConfigurationArn() {
                return this.resourceConfigurationArn;
            }

            @Override
            public final java.lang.String getResourceAssociationArn() {
                return this.resourceAssociationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceConfigurationArn", om.valueToTree(this.getResourceConfigurationArn()));
                if (this.getResourceAssociationArn() != null) {
                    data.set("resourceAssociationArn", om.valueToTree(this.getResourceAssociationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnConnection.ResourceParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceParametersProperty.Jsii$Proxy that = (ResourceParametersProperty.Jsii$Proxy) o;

                if (!resourceConfigurationArn.equals(that.resourceConfigurationArn)) return false;
                return this.resourceAssociationArn != null ? this.resourceAssociationArn.equals(that.resourceAssociationArn) : that.resourceAssociationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceConfigurationArn.hashCode();
                result = 31 * result + (this.resourceAssociationArn != null ? this.resourceAssociationArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.CfnConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.CfnConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.events.CfnConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The type of authorization to use for the connection.
         * <p>
         * <blockquote>
         * <p>
         * OAUTH tokens are refreshed when a 401 or 407 response is returned.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authorizationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authorizationtype</a>
         * @param authorizationType The type of authorization to use for the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(final java.lang.String authorizationType) {
            this.props().authorizationType(authorizationType);
            return this;
        }

        /**
         * The authorization parameters to use to authorize with the endpoint.
         * <p>
         * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters</a>
         * @param authParameters The authorization parameters to use to authorize with the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authParameters(final software.amazon.awscdk.IResolvable authParameters) {
            this.props().authParameters(authParameters);
            return this;
        }
        /**
         * The authorization parameters to use to authorize with the endpoint.
         * <p>
         * You must include only authorization parameters for the <code>AuthorizationType</code> you specify.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-authparameters</a>
         * @param authParameters The authorization parameters to use to authorize with the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authParameters(final software.amazon.awscdk.services.events.CfnConnection.AuthParametersProperty authParameters) {
            this.props().authParameters(authParameters);
            return this;
        }

        /**
         * A description for the connection to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-description</a>
         * @param description A description for the connection to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * For connections to private APIs, the parameters to use for invoking the API.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters</a>
         * @param invocationConnectivityParameters For connections to private APIs, the parameters to use for invoking the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationConnectivityParameters(final software.amazon.awscdk.IResolvable invocationConnectivityParameters) {
            this.props().invocationConnectivityParameters(invocationConnectivityParameters);
            return this;
        }
        /**
         * For connections to private APIs, the parameters to use for invoking the API.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/connection-private.html">Connecting to private APIs</a> in the <strong>Amazon EventBridge User Guide</strong> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-invocationconnectivityparameters</a>
         * @param invocationConnectivityParameters For connections to private APIs, the parameters to use for invoking the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationConnectivityParameters(final software.amazon.awscdk.services.events.CfnConnection.InvocationConnectivityParametersProperty invocationConnectivityParameters) {
            this.props().invocationConnectivityParameters(invocationConnectivityParameters);
            return this;
        }

        /**
         * The name for the connection to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-connection.html#cfn-events-connection-name</a>
         * @param name The name for the connection to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.CfnConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.CfnConnection build() {
            return new software.amazon.awscdk.services.events.CfnConnection(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.CfnConnectionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.CfnConnectionProps.Builder();
            }
            return this.props;
        }
    }
}
