package software.amazon.awscdk.services.events;

/**
 * An additional HTTP parameter to send along with the OAuth request.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.events.*;
 * SecretValue secretValue;
 * HttpParameter httpParameter = HttpParameter.fromSecret(secretValue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:28.829Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.HttpParameter")
public abstract class HttpParameter extends software.amazon.jsii.JsiiObject {

    protected HttpParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected HttpParameter() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Make an OAuthParameter from a secret.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.HttpParameter fromSecret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.HttpParameter.class, "fromSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Make an OAuthParameter from a string value.
     * <p>
     * The value is not treated as a secret.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.HttpParameter fromString(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.HttpParameter.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.events.HttpParameter {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
