package software.amazon.awscdk.services.fsx;

/**
 * Properties required for setting up a daily automatic backup time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Map&lt;String, Object&gt; lustreConfiguration = Map.of(
 *         // ...
 *         "automaticBackupRetention", Duration.days(3),  // backup retention
 *         "copyTagsToBackups", true,  // if true, tags are copied to backups
 *         "dailyAutomaticBackupStartTime", DailyAutomaticBackupStartTime.Builder.create().hour(11).minute(30).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:29.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.DailyAutomaticBackupStartTimeProps")
@software.amazon.jsii.Jsii.Proxy(DailyAutomaticBackupStartTimeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DailyAutomaticBackupStartTimeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The hour of the day (from 0-23) for automatic backup starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getHour();

    /**
     * The minute of the hour (from 0-59) for automatic backup starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinute();

    /**
     * @return a {@link Builder} of {@link DailyAutomaticBackupStartTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DailyAutomaticBackupStartTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DailyAutomaticBackupStartTimeProps> {
        java.lang.Number hour;
        java.lang.Number minute;

        /**
         * Sets the value of {@link DailyAutomaticBackupStartTimeProps#getHour}
         * @param hour The hour of the day (from 0-23) for automatic backup starts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hour(java.lang.Number hour) {
            this.hour = hour;
            return this;
        }

        /**
         * Sets the value of {@link DailyAutomaticBackupStartTimeProps#getMinute}
         * @param minute The minute of the hour (from 0-59) for automatic backup starts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minute(java.lang.Number minute) {
            this.minute = minute;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DailyAutomaticBackupStartTimeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DailyAutomaticBackupStartTimeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DailyAutomaticBackupStartTimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DailyAutomaticBackupStartTimeProps {
        private final java.lang.Number hour;
        private final java.lang.Number minute;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hour = software.amazon.jsii.Kernel.get(this, "hour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minute = software.amazon.jsii.Kernel.get(this, "minute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hour = java.util.Objects.requireNonNull(builder.hour, "hour is required");
            this.minute = java.util.Objects.requireNonNull(builder.minute, "minute is required");
        }

        @Override
        public final java.lang.Number getHour() {
            return this.hour;
        }

        @Override
        public final java.lang.Number getMinute() {
            return this.minute;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hour", om.valueToTree(this.getHour()));
            data.set("minute", om.valueToTree(this.getMinute()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.DailyAutomaticBackupStartTimeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DailyAutomaticBackupStartTimeProps.Jsii$Proxy that = (DailyAutomaticBackupStartTimeProps.Jsii$Proxy) o;

            if (!hour.equals(that.hour)) return false;
            return this.minute.equals(that.minute);
        }

        @Override
        public final int hashCode() {
            int result = this.hour.hashCode();
            result = 31 * result + (this.minute.hashCode());
            return result;
        }
    }
}
