package software.amazon.awscdk.services.glue;

/**
 * A resource that describes the AWS Glue resource for enabling compaction to improve read performance for open table formats.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnTableOptimizer cfnTableOptimizer = CfnTableOptimizer.Builder.create(this, "MyCfnTableOptimizer")
 *         .catalogId("catalogId")
 *         .databaseName("databaseName")
 *         .tableName("tableName")
 *         .tableOptimizerConfiguration(TableOptimizerConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .orphanFileDeletionConfiguration(OrphanFileDeletionConfigurationProperty.builder()
 *                         .icebergConfiguration(IcebergConfigurationProperty.builder()
 *                                 .location("location")
 *                                 .orphanFileRetentionPeriodInDays(123)
 *                                 .build())
 *                         .build())
 *                 .retentionConfiguration(RetentionConfigurationProperty.builder()
 *                         .icebergConfiguration(IcebergConfigurationProperty.builder()
 *                                 .location("location")
 *                                 .orphanFileRetentionPeriodInDays(123)
 *                                 .build())
 *                         .build())
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .glueConnectionName("glueConnectionName")
 *                         .build())
 *                 .build())
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:29.324Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer")
public class CfnTableOptimizer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTableOptimizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTableOptimizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnTableOptimizer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTableOptimizer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTableOptimizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The catalog ID of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The catalog ID of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalogId", java.util.Objects.requireNonNull(value, "catalogId is required"));
    }

    /**
     * The name of the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * The table name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The table name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", java.util.Objects.requireNonNull(value, "tableName is required"));
    }

    /**
     * Specifies configuration details of a table optimizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTableOptimizerConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "tableOptimizerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration details of a table optimizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableOptimizerConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tableOptimizerConfiguration", java.util.Objects.requireNonNull(value, "tableOptimizerConfiguration is required"));
    }

    /**
     * Specifies configuration details of a table optimizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableOptimizerConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTableOptimizer.TableOptimizerConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "tableOptimizerConfiguration", java.util.Objects.requireNonNull(value, "tableOptimizerConfiguration is required"));
    }

    /**
     * The type of table optimizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of table optimizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * IcebergConfigurationProperty icebergConfigurationProperty = IcebergConfigurationProperty.builder()
     *         .location("location")
     *         .orphanFileRetentionPeriodInDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer.IcebergConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IcebergConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IcebergConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html#cfn-glue-tableoptimizer-icebergconfiguration-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html#cfn-glue-tableoptimizer-icebergconfiguration-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html#cfn-glue-tableoptimizer-icebergconfiguration-orphanfileretentionperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-icebergconfiguration.html#cfn-glue-tableoptimizer-icebergconfiguration-orphanfileretentionperiodindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOrphanFileRetentionPeriodInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IcebergConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IcebergConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IcebergConfigurationProperty> {
            java.lang.String location;
            java.lang.Number orphanFileRetentionPeriodInDays;

            /**
             * Sets the value of {@link IcebergConfigurationProperty#getLocation}
             * @param location the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link IcebergConfigurationProperty#getOrphanFileRetentionPeriodInDays}
             * @param orphanFileRetentionPeriodInDays the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orphanFileRetentionPeriodInDays(java.lang.Number orphanFileRetentionPeriodInDays) {
                this.orphanFileRetentionPeriodInDays = orphanFileRetentionPeriodInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IcebergConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IcebergConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IcebergConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IcebergConfigurationProperty {
            private final java.lang.String location;
            private final java.lang.Number orphanFileRetentionPeriodInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orphanFileRetentionPeriodInDays = software.amazon.jsii.Kernel.get(this, "orphanFileRetentionPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = builder.location;
                this.orphanFileRetentionPeriodInDays = builder.orphanFileRetentionPeriodInDays;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Number getOrphanFileRetentionPeriodInDays() {
                return this.orphanFileRetentionPeriodInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getOrphanFileRetentionPeriodInDays() != null) {
                    data.set("orphanFileRetentionPeriodInDays", om.valueToTree(this.getOrphanFileRetentionPeriodInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizer.IcebergConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IcebergConfigurationProperty.Jsii$Proxy that = (IcebergConfigurationProperty.Jsii$Proxy) o;

                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                return this.orphanFileRetentionPeriodInDays != null ? this.orphanFileRetentionPeriodInDays.equals(that.orphanFileRetentionPeriodInDays) : that.orphanFileRetentionPeriodInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location != null ? this.location.hashCode() : 0;
                result = 31 * result + (this.orphanFileRetentionPeriodInDays != null ? this.orphanFileRetentionPeriodInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * OrphanFileDeletionConfigurationProperty orphanFileDeletionConfigurationProperty = OrphanFileDeletionConfigurationProperty.builder()
     *         .icebergConfiguration(IcebergConfigurationProperty.builder()
     *                 .location("location")
     *                 .orphanFileRetentionPeriodInDays(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-orphanfiledeletionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-orphanfiledeletionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer.OrphanFileDeletionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OrphanFileDeletionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrphanFileDeletionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-orphanfiledeletionconfiguration.html#cfn-glue-tableoptimizer-orphanfiledeletionconfiguration-icebergconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-orphanfiledeletionconfiguration.html#cfn-glue-tableoptimizer-orphanfiledeletionconfiguration-icebergconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrphanFileDeletionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrphanFileDeletionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrphanFileDeletionConfigurationProperty> {
            java.lang.Object icebergConfiguration;

            /**
             * Sets the value of {@link OrphanFileDeletionConfigurationProperty#getIcebergConfiguration}
             * @param icebergConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergConfiguration(software.amazon.awscdk.IResolvable icebergConfiguration) {
                this.icebergConfiguration = icebergConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link OrphanFileDeletionConfigurationProperty#getIcebergConfiguration}
             * @param icebergConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.IcebergConfigurationProperty icebergConfiguration) {
                this.icebergConfiguration = icebergConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrphanFileDeletionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrphanFileDeletionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrphanFileDeletionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrphanFileDeletionConfigurationProperty {
            private final java.lang.Object icebergConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.icebergConfiguration = software.amazon.jsii.Kernel.get(this, "icebergConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.icebergConfiguration = builder.icebergConfiguration;
            }

            @Override
            public final java.lang.Object getIcebergConfiguration() {
                return this.icebergConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIcebergConfiguration() != null) {
                    data.set("icebergConfiguration", om.valueToTree(this.getIcebergConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizer.OrphanFileDeletionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrphanFileDeletionConfigurationProperty.Jsii$Proxy that = (OrphanFileDeletionConfigurationProperty.Jsii$Proxy) o;

                return this.icebergConfiguration != null ? this.icebergConfiguration.equals(that.icebergConfiguration) : that.icebergConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.icebergConfiguration != null ? this.icebergConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * RetentionConfigurationProperty retentionConfigurationProperty = RetentionConfigurationProperty.builder()
     *         .icebergConfiguration(IcebergConfigurationProperty.builder()
     *                 .location("location")
     *                 .orphanFileRetentionPeriodInDays(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-retentionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-retentionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer.RetentionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-retentionconfiguration.html#cfn-glue-tableoptimizer-retentionconfiguration-icebergconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-retentionconfiguration.html#cfn-glue-tableoptimizer-retentionconfiguration-icebergconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionConfigurationProperty> {
            java.lang.Object icebergConfiguration;

            /**
             * Sets the value of {@link RetentionConfigurationProperty#getIcebergConfiguration}
             * @param icebergConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergConfiguration(software.amazon.awscdk.IResolvable icebergConfiguration) {
                this.icebergConfiguration = icebergConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RetentionConfigurationProperty#getIcebergConfiguration}
             * @param icebergConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.IcebergConfigurationProperty icebergConfiguration) {
                this.icebergConfiguration = icebergConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionConfigurationProperty {
            private final java.lang.Object icebergConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.icebergConfiguration = software.amazon.jsii.Kernel.get(this, "icebergConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.icebergConfiguration = builder.icebergConfiguration;
            }

            @Override
            public final java.lang.Object getIcebergConfiguration() {
                return this.icebergConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIcebergConfiguration() != null) {
                    data.set("icebergConfiguration", om.valueToTree(this.getIcebergConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizer.RetentionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionConfigurationProperty.Jsii$Proxy that = (RetentionConfigurationProperty.Jsii$Proxy) o;

                return this.icebergConfiguration != null ? this.icebergConfiguration.equals(that.icebergConfiguration) : that.icebergConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.icebergConfiguration != null ? this.icebergConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies configuration details of a table optimizer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TableOptimizerConfigurationProperty tableOptimizerConfigurationProperty = TableOptimizerConfigurationProperty.builder()
     *         .enabled(false)
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .orphanFileDeletionConfiguration(OrphanFileDeletionConfigurationProperty.builder()
     *                 .icebergConfiguration(IcebergConfigurationProperty.builder()
     *                         .location("location")
     *                         .orphanFileRetentionPeriodInDays(123)
     *                         .build())
     *                 .build())
     *         .retentionConfiguration(RetentionConfigurationProperty.builder()
     *                 .icebergConfiguration(IcebergConfigurationProperty.builder()
     *                         .location("location")
     *                         .orphanFileRetentionPeriodInDays(123)
     *                         .build())
     *                 .build())
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .glueConnectionName("glueConnectionName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer.TableOptimizerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TableOptimizerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableOptimizerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether the table optimization is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * A role passed by the caller which gives the service permission to update the resources associated with the optimizer on the caller's behalf.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-orphanfiledeletionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-orphanfiledeletionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrphanFileDeletionConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-retentionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-retentionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-tableoptimizerconfiguration.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableOptimizerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableOptimizerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableOptimizerConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String roleArn;
            java.lang.Object orphanFileDeletionConfiguration;
            java.lang.Object retentionConfiguration;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getEnabled}
             * @param enabled Whether the table optimization is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getEnabled}
             * @param enabled Whether the table optimization is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getRoleArn}
             * @param roleArn A role passed by the caller which gives the service permission to update the resources associated with the optimizer on the caller's behalf. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getOrphanFileDeletionConfiguration}
             * @param orphanFileDeletionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orphanFileDeletionConfiguration(software.amazon.awscdk.IResolvable orphanFileDeletionConfiguration) {
                this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getOrphanFileDeletionConfiguration}
             * @param orphanFileDeletionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orphanFileDeletionConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.OrphanFileDeletionConfigurationProperty orphanFileDeletionConfiguration) {
                this.orphanFileDeletionConfiguration = orphanFileDeletionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getRetentionConfiguration}
             * @param retentionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionConfiguration(software.amazon.awscdk.IResolvable retentionConfiguration) {
                this.retentionConfiguration = retentionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getRetentionConfiguration}
             * @param retentionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.RetentionConfigurationProperty retentionConfiguration) {
                this.retentionConfiguration = retentionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link TableOptimizerConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.glue.CfnTableOptimizer.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableOptimizerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableOptimizerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableOptimizerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableOptimizerConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String roleArn;
            private final java.lang.Object orphanFileDeletionConfiguration;
            private final java.lang.Object retentionConfiguration;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.orphanFileDeletionConfiguration = software.amazon.jsii.Kernel.get(this, "orphanFileDeletionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retentionConfiguration = software.amazon.jsii.Kernel.get(this, "retentionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.orphanFileDeletionConfiguration = builder.orphanFileDeletionConfiguration;
                this.retentionConfiguration = builder.retentionConfiguration;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getOrphanFileDeletionConfiguration() {
                return this.orphanFileDeletionConfiguration;
            }

            @Override
            public final java.lang.Object getRetentionConfiguration() {
                return this.retentionConfiguration;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getOrphanFileDeletionConfiguration() != null) {
                    data.set("orphanFileDeletionConfiguration", om.valueToTree(this.getOrphanFileDeletionConfiguration()));
                }
                if (this.getRetentionConfiguration() != null) {
                    data.set("retentionConfiguration", om.valueToTree(this.getRetentionConfiguration()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizer.TableOptimizerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableOptimizerConfigurationProperty.Jsii$Proxy that = (TableOptimizerConfigurationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.orphanFileDeletionConfiguration != null ? !this.orphanFileDeletionConfiguration.equals(that.orphanFileDeletionConfiguration) : that.orphanFileDeletionConfiguration != null) return false;
                if (this.retentionConfiguration != null ? !this.retentionConfiguration.equals(that.retentionConfiguration) : that.retentionConfiguration != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.orphanFileDeletionConfiguration != null ? this.orphanFileDeletionConfiguration.hashCode() : 0);
                result = 31 * result + (this.retentionConfiguration != null ? this.retentionConfiguration.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .glueConnectionName("glueConnectionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-vpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-vpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTableOptimizer.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-vpcconfiguration.html#cfn-glue-tableoptimizer-vpcconfiguration-glueconnectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-tableoptimizer-vpcconfiguration.html#cfn-glue-tableoptimizer-vpcconfiguration-glueconnectionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGlueConnectionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.lang.String glueConnectionName;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getGlueConnectionName}
             * @param glueConnectionName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionName(java.lang.String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.lang.String glueConnectionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueConnectionName = software.amazon.jsii.Kernel.get(this, "glueConnectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueConnectionName = builder.glueConnectionName;
            }

            @Override
            public final java.lang.String getGlueConnectionName() {
                return this.glueConnectionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueConnectionName() != null) {
                    data.set("glueConnectionName", om.valueToTree(this.getGlueConnectionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTableOptimizer.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                return this.glueConnectionName != null ? this.glueConnectionName.equals(that.glueConnectionName) : that.glueConnectionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueConnectionName != null ? this.glueConnectionName.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnTableOptimizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnTableOptimizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnTableOptimizerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnTableOptimizerProps.Builder();
        }

        /**
         * The catalog ID of the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-catalogid</a>
         * @param catalogId The catalog ID of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(final java.lang.String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        /**
         * The name of the database.
         * <p>
         * For Hive compatibility, this is folded to lowercase when it is stored.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-databasename</a>
         * @param databaseName The name of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * The table name.
         * <p>
         * For Hive compatibility, this must be entirely lowercase.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tablename</a>
         * @param tableName The table name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * Specifies configuration details of a table optimizer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration</a>
         * @param tableOptimizerConfiguration Specifies configuration details of a table optimizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableOptimizerConfiguration(final software.amazon.awscdk.IResolvable tableOptimizerConfiguration) {
            this.props.tableOptimizerConfiguration(tableOptimizerConfiguration);
            return this;
        }
        /**
         * Specifies configuration details of a table optimizer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-tableoptimizerconfiguration</a>
         * @param tableOptimizerConfiguration Specifies configuration details of a table optimizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableOptimizerConfiguration(final software.amazon.awscdk.services.glue.CfnTableOptimizer.TableOptimizerConfigurationProperty tableOptimizerConfiguration) {
            this.props.tableOptimizerConfiguration(tableOptimizerConfiguration);
            return this;
        }

        /**
         * The type of table optimizer.
         * <p>
         * Currently, the only valid value is compaction.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-tableoptimizer.html#cfn-glue-tableoptimizer-type</a>
         * @param type The type of table optimizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnTableOptimizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnTableOptimizer build() {
            return new software.amazon.awscdk.services.glue.CfnTableOptimizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
