package software.amazon.awscdk.services.healthlake;

/**
 * Creates a Data Store that can ingest and export FHIR formatted data.
 * <p>
 * <blockquote>
 * <p>
 * Please note that when a user tries to do an Update operation via CloudFormation, changes to the Data Store name, Type Version, PreloadDataConfig, or SSEConfiguration will delete their existing Data Store for the stack and create a new one. This will lead to potential loss of data.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.healthlake.*;
 * CfnFHIRDatastore cfnFHIRDatastore = CfnFHIRDatastore.Builder.create(this, "MyCfnFHIRDatastore")
 *         .datastoreTypeVersion("datastoreTypeVersion")
 *         // the properties below are optional
 *         .datastoreName("datastoreName")
 *         .identityProviderConfiguration(IdentityProviderConfigurationProperty.builder()
 *                 .authorizationStrategy("authorizationStrategy")
 *                 // the properties below are optional
 *                 .fineGrainedAuthorizationEnabled(false)
 *                 .idpLambdaArn("idpLambdaArn")
 *                 .metadata("metadata")
 *                 .build())
 *         .preloadDataConfig(PreloadDataConfigProperty.builder()
 *                 .preloadDataType("preloadDataType")
 *                 .build())
 *         .sseConfiguration(SseConfigurationProperty.builder()
 *                 .kmsEncryptionConfig(KmsEncryptionConfigProperty.builder()
 *                         .cmkType("cmkType")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:29.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore")
public class CfnFHIRDatastore extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFHIRDatastore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFHIRDatastore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFHIRDatastore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time that a Data Store was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCreatedAtNanos() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAtNanos", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAtSeconds() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAtSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Data Store ARN is generated during the creation of the Data Store and can be found in the output from the initial Data Store creation request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint for the created Data Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon generated Data Store id.
     * <p>
     * This id is in the output from the initial Data Store creation call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreId() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the FHIR Data Store.
     * <p>
     * Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatastoreStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDatastoreStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The FHIR release version supported by the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatastoreTypeVersion() {
        return software.amazon.jsii.Kernel.get(this, "datastoreTypeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The FHIR release version supported by the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreTypeVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datastoreTypeVersion", java.util.Objects.requireNonNull(value, "datastoreTypeVersion is required"));
    }

    /**
     * The data store name (user-generated).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatastoreName() {
        return software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data store name (user-generated).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatastoreName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datastoreName", value);
    }

    /**
     * The identity provider configuration selected when the data store was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The identity provider configuration selected when the data store was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderConfiguration", value);
    }

    /**
     * The identity provider configuration selected when the data store was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.IdentityProviderConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderConfiguration", value);
    }

    /**
     * The preloaded Synthea data configuration for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPreloadDataConfig() {
        return software.amazon.jsii.Kernel.get(this, "preloadDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The preloaded Synthea data configuration for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreloadDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "preloadDataConfig", value);
    }

    /**
     * The preloaded Synthea data configuration for the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreloadDataConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.PreloadDataConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "preloadDataConfig", value);
    }

    /**
     * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSseConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sseConfiguration", value);
    }

    /**
     * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.SseConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sseConfiguration", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The time that a Data Store was created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * CreatedAtProperty createdAtProperty = CreatedAtProperty.builder()
     *         .nanos(123)
     *         .seconds("seconds")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.CreatedAtProperty")
    @software.amazon.jsii.Jsii.Proxy(CreatedAtProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreatedAtProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Nanoseconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html#cfn-healthlake-fhirdatastore-createdat-nanos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html#cfn-healthlake-fhirdatastore-createdat-nanos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNanos();

        /**
         * Seconds since epoch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html#cfn-healthlake-fhirdatastore-createdat-seconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-createdat.html#cfn-healthlake-fhirdatastore-createdat-seconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSeconds();

        /**
         * @return a {@link Builder} of {@link CreatedAtProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreatedAtProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreatedAtProperty> {
            java.lang.Number nanos;
            java.lang.String seconds;

            /**
             * Sets the value of {@link CreatedAtProperty#getNanos}
             * @param nanos Nanoseconds. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nanos(java.lang.Number nanos) {
                this.nanos = nanos;
                return this;
            }

            /**
             * Sets the value of {@link CreatedAtProperty#getSeconds}
             * @param seconds Seconds since epoch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seconds(java.lang.String seconds) {
                this.seconds = seconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreatedAtProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreatedAtProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreatedAtProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreatedAtProperty {
            private final java.lang.Number nanos;
            private final java.lang.String seconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nanos = software.amazon.jsii.Kernel.get(this, "nanos", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.seconds = software.amazon.jsii.Kernel.get(this, "seconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nanos = java.util.Objects.requireNonNull(builder.nanos, "nanos is required");
                this.seconds = java.util.Objects.requireNonNull(builder.seconds, "seconds is required");
            }

            @Override
            public final java.lang.Number getNanos() {
                return this.nanos;
            }

            @Override
            public final java.lang.String getSeconds() {
                return this.seconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("nanos", om.valueToTree(this.getNanos()));
                data.set("seconds", om.valueToTree(this.getSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.CreatedAtProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreatedAtProperty.Jsii$Proxy that = (CreatedAtProperty.Jsii$Proxy) o;

                if (!nanos.equals(that.nanos)) return false;
                return this.seconds.equals(that.seconds);
            }

            @Override
            public final int hashCode() {
                int result = this.nanos.hashCode();
                result = 31 * result + (this.seconds.hashCode());
                return result;
            }
        }
    }
    /**
     * The identity provider configuration selected when the data store was created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * IdentityProviderConfigurationProperty identityProviderConfigurationProperty = IdentityProviderConfigurationProperty.builder()
     *         .authorizationStrategy("authorizationStrategy")
     *         // the properties below are optional
     *         .fineGrainedAuthorizationEnabled(false)
     *         .idpLambdaArn("idpLambdaArn")
     *         .metadata("metadata")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.IdentityProviderConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityProviderConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityProviderConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization strategy selected when the HealthLake data store is created.
         * <p>
         * <blockquote>
         * <p>
         * HealthLake provides support for both SMART on FHIR V1 and V2 as described below.
         * <p>
         * <ul>
         * <li><code>SMART_ON_FHIR_V1</code> – Support for only SMART on FHIR V1, which includes <code>read</code> (read/search) and <code>write</code> (create/update/delete) permissions.</li>
         * <li><code>SMART_ON_FHIR</code> – Support for both SMART on FHIR V1 and V2, which includes <code>create</code> , <code>read</code> , <code>update</code> , <code>delete</code> , and <code>search</code> permissions.</li>
         * <li><code>AWS_AUTH</code> – The default HealthLake authorization strategy; not affiliated with SMART on FHIR.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-authorizationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-authorizationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationStrategy();

        /**
         * The parameter to enable SMART on FHIR fine-grained authorization for the data store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-finegrainedauthorizationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-finegrainedauthorizationenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFineGrainedAuthorizationEnabled() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lambda function to use to decode the access token created by the authorization server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-idplambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-idplambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdpLambdaArn() {
            return null;
        }

        /**
         * The JSON metadata elements to use in your identity provider configuration.
         * <p>
         * Required elements are listed based on the launch specification of the SMART application. For more information on all possible elements, see <a href="https://docs.aws.amazon.com/https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in SMART's App Launch specification.
         * <p>
         * <code>authorization_endpoint</code> : The URL to the OAuth2 authorization endpoint.
         * <p>
         * <code>grant_types_supported</code> : An array of grant types that are supported at the token endpoint. You must provide at least one grant type option. Valid options are <code>authorization_code</code> and <code>client_credentials</code> .
         * <p>
         * <code>token_endpoint</code> : The URL to the OAuth2 token endpoint.
         * <p>
         * <code>capabilities</code> : An array of strings of the SMART capabilities that the authorization server supports.
         * <p>
         * <code>code_challenge_methods_supported</code> : An array of strings of supported PKCE code challenge methods. You must include the <code>S256</code> method in the array of PKCE code challenge methods.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-metadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-identityproviderconfiguration.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration-metadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadata() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderConfigurationProperty> {
            java.lang.String authorizationStrategy;
            java.lang.Object fineGrainedAuthorizationEnabled;
            java.lang.String idpLambdaArn;
            java.lang.String metadata;

            /**
             * Sets the value of {@link IdentityProviderConfigurationProperty#getAuthorizationStrategy}
             * @param authorizationStrategy The authorization strategy selected when the HealthLake data store is created. This parameter is required.
             *                              <blockquote>
             *                              <p>
             *                              HealthLake provides support for both SMART on FHIR V1 and V2 as described below.
             *                              <p>
             *                              <ul>
             *                              <li><code>SMART_ON_FHIR_V1</code> – Support for only SMART on FHIR V1, which includes <code>read</code> (read/search) and <code>write</code> (create/update/delete) permissions.</li>
             *                              <li><code>SMART_ON_FHIR</code> – Support for both SMART on FHIR V1 and V2, which includes <code>create</code> , <code>read</code> , <code>update</code> , <code>delete</code> , and <code>search</code> permissions.</li>
             *                              <li><code>AWS_AUTH</code> – The default HealthLake authorization strategy; not affiliated with SMART on FHIR.</li>
             *                              </ul>
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationStrategy(java.lang.String authorizationStrategy) {
                this.authorizationStrategy = authorizationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderConfigurationProperty#getFineGrainedAuthorizationEnabled}
             * @param fineGrainedAuthorizationEnabled The parameter to enable SMART on FHIR fine-grained authorization for the data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fineGrainedAuthorizationEnabled(java.lang.Boolean fineGrainedAuthorizationEnabled) {
                this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderConfigurationProperty#getFineGrainedAuthorizationEnabled}
             * @param fineGrainedAuthorizationEnabled The parameter to enable SMART on FHIR fine-grained authorization for the data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fineGrainedAuthorizationEnabled(software.amazon.awscdk.IResolvable fineGrainedAuthorizationEnabled) {
                this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderConfigurationProperty#getIdpLambdaArn}
             * @param idpLambdaArn The Amazon Resource Name (ARN) of the Lambda function to use to decode the access token created by the authorization server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idpLambdaArn(java.lang.String idpLambdaArn) {
                this.idpLambdaArn = idpLambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderConfigurationProperty#getMetadata}
             * @param metadata The JSON metadata elements to use in your identity provider configuration.
             *                 Required elements are listed based on the launch specification of the SMART application. For more information on all possible elements, see <a href="https://docs.aws.amazon.com/https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in SMART's App Launch specification.
             *                 <p>
             *                 <code>authorization_endpoint</code> : The URL to the OAuth2 authorization endpoint.
             *                 <p>
             *                 <code>grant_types_supported</code> : An array of grant types that are supported at the token endpoint. You must provide at least one grant type option. Valid options are <code>authorization_code</code> and <code>client_credentials</code> .
             *                 <p>
             *                 <code>token_endpoint</code> : The URL to the OAuth2 token endpoint.
             *                 <p>
             *                 <code>capabilities</code> : An array of strings of the SMART capabilities that the authorization server supports.
             *                 <p>
             *                 <code>code_challenge_methods_supported</code> : An array of strings of supported PKCE code challenge methods. You must include the <code>S256</code> method in the array of PKCE code challenge methods.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(java.lang.String metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityProviderConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityProviderConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderConfigurationProperty {
            private final java.lang.String authorizationStrategy;
            private final java.lang.Object fineGrainedAuthorizationEnabled;
            private final java.lang.String idpLambdaArn;
            private final java.lang.String metadata;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationStrategy = software.amazon.jsii.Kernel.get(this, "authorizationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fineGrainedAuthorizationEnabled = software.amazon.jsii.Kernel.get(this, "fineGrainedAuthorizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idpLambdaArn = software.amazon.jsii.Kernel.get(this, "idpLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationStrategy = java.util.Objects.requireNonNull(builder.authorizationStrategy, "authorizationStrategy is required");
                this.fineGrainedAuthorizationEnabled = builder.fineGrainedAuthorizationEnabled;
                this.idpLambdaArn = builder.idpLambdaArn;
                this.metadata = builder.metadata;
            }

            @Override
            public final java.lang.String getAuthorizationStrategy() {
                return this.authorizationStrategy;
            }

            @Override
            public final java.lang.Object getFineGrainedAuthorizationEnabled() {
                return this.fineGrainedAuthorizationEnabled;
            }

            @Override
            public final java.lang.String getIdpLambdaArn() {
                return this.idpLambdaArn;
            }

            @Override
            public final java.lang.String getMetadata() {
                return this.metadata;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationStrategy", om.valueToTree(this.getAuthorizationStrategy()));
                if (this.getFineGrainedAuthorizationEnabled() != null) {
                    data.set("fineGrainedAuthorizationEnabled", om.valueToTree(this.getFineGrainedAuthorizationEnabled()));
                }
                if (this.getIdpLambdaArn() != null) {
                    data.set("idpLambdaArn", om.valueToTree(this.getIdpLambdaArn()));
                }
                if (this.getMetadata() != null) {
                    data.set("metadata", om.valueToTree(this.getMetadata()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.IdentityProviderConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityProviderConfigurationProperty.Jsii$Proxy that = (IdentityProviderConfigurationProperty.Jsii$Proxy) o;

                if (!authorizationStrategy.equals(that.authorizationStrategy)) return false;
                if (this.fineGrainedAuthorizationEnabled != null ? !this.fineGrainedAuthorizationEnabled.equals(that.fineGrainedAuthorizationEnabled) : that.fineGrainedAuthorizationEnabled != null) return false;
                if (this.idpLambdaArn != null ? !this.idpLambdaArn.equals(that.idpLambdaArn) : that.idpLambdaArn != null) return false;
                return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationStrategy.hashCode();
                result = 31 * result + (this.fineGrainedAuthorizationEnabled != null ? this.fineGrainedAuthorizationEnabled.hashCode() : 0);
                result = 31 * result + (this.idpLambdaArn != null ? this.idpLambdaArn.hashCode() : 0);
                result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The customer-managed-key(CMK) used when creating a Data Store.
     * <p>
     * If a customer owned key is not specified, an Amazon owned key will be used for encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * KmsEncryptionConfigProperty kmsEncryptionConfigProperty = KmsEncryptionConfigProperty.builder()
     *         .cmkType("cmkType")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KmsEncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KmsEncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of customer-managed-key(CMK) used for encryption.
         * <p>
         * The two types of supported CMKs are customer owned CMKs and Amazon owned CMKs. For more information on CMK types, see <a href="https://docs.aws.amazon.com/healthlake/latest/APIReference/API_KmsEncryptionConfig.html#HealthLake-Type-KmsEncryptionConfig-CmkType">KmsEncryptionConfig</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-cmktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-cmktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCmkType();

        /**
         * The Key Management Service (KMS) encryption key id/alias used to encrypt the data store contents at rest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KmsEncryptionConfigProperty> {
            java.lang.String cmkType;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link KmsEncryptionConfigProperty#getCmkType}
             * @param cmkType The type of customer-managed-key(CMK) used for encryption. This parameter is required.
             *                The two types of supported CMKs are customer owned CMKs and Amazon owned CMKs. For more information on CMK types, see <a href="https://docs.aws.amazon.com/healthlake/latest/APIReference/API_KmsEncryptionConfig.html#HealthLake-Type-KmsEncryptionConfig-CmkType">KmsEncryptionConfig</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkType(java.lang.String cmkType) {
                this.cmkType = cmkType;
                return this;
            }

            /**
             * Sets the value of {@link KmsEncryptionConfigProperty#getKmsKeyId}
             * @param kmsKeyId The Key Management Service (KMS) encryption key id/alias used to encrypt the data store contents at rest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KmsEncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KmsEncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KmsEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KmsEncryptionConfigProperty {
            private final java.lang.String cmkType;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cmkType = software.amazon.jsii.Kernel.get(this, "cmkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cmkType = java.util.Objects.requireNonNull(builder.cmkType, "cmkType is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getCmkType() {
                return this.cmkType;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cmkType", om.valueToTree(this.getCmkType()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KmsEncryptionConfigProperty.Jsii$Proxy that = (KmsEncryptionConfigProperty.Jsii$Proxy) o;

                if (!cmkType.equals(that.cmkType)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cmkType.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An optional parameter to preload (import) open source Synthea FHIR data upon creation of the data store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * PreloadDataConfigProperty preloadDataConfigProperty = PreloadDataConfigProperty.builder()
     *         .preloadDataType("preloadDataType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.PreloadDataConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PreloadDataConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PreloadDataConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of preloaded data.
         * <p>
         * Only Synthea preloaded data is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html#cfn-healthlake-fhirdatastore-preloaddataconfig-preloaddatatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html#cfn-healthlake-fhirdatastore-preloaddataconfig-preloaddatatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPreloadDataType();

        /**
         * @return a {@link Builder} of {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PreloadDataConfigProperty> {
            java.lang.String preloadDataType;

            /**
             * Sets the value of {@link PreloadDataConfigProperty#getPreloadDataType}
             * @param preloadDataType The type of preloaded data. This parameter is required.
             *                        Only Synthea preloaded data is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preloadDataType(java.lang.String preloadDataType) {
                this.preloadDataType = preloadDataType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PreloadDataConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PreloadDataConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PreloadDataConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PreloadDataConfigProperty {
            private final java.lang.String preloadDataType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.preloadDataType = software.amazon.jsii.Kernel.get(this, "preloadDataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.preloadDataType = java.util.Objects.requireNonNull(builder.preloadDataType, "preloadDataType is required");
            }

            @Override
            public final java.lang.String getPreloadDataType() {
                return this.preloadDataType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("preloadDataType", om.valueToTree(this.getPreloadDataType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.PreloadDataConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PreloadDataConfigProperty.Jsii$Proxy that = (PreloadDataConfigProperty.Jsii$Proxy) o;

                return this.preloadDataType.equals(that.preloadDataType);
            }

            @Override
            public final int hashCode() {
                int result = this.preloadDataType.hashCode();
                return result;
            }
        }
    }
    /**
     * The server-side encryption key configuration for a customer-provided encryption key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.healthlake.*;
     * SseConfigurationProperty sseConfigurationProperty = SseConfigurationProperty.builder()
     *         .kmsEncryptionConfig(KmsEncryptionConfigProperty.builder()
     *                 .cmkType("cmkType")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.SseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The server-side encryption key configuration for a customer provided encryption key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html#cfn-healthlake-fhirdatastore-sseconfiguration-kmsencryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html#cfn-healthlake-fhirdatastore-sseconfiguration-kmsencryptionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKmsEncryptionConfig();

        /**
         * @return a {@link Builder} of {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SseConfigurationProperty> {
            java.lang.Object kmsEncryptionConfig;

            /**
             * Sets the value of {@link SseConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The server-side encryption key configuration for a customer provided encryption key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.IResolvable kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link SseConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The server-side encryption key configuration for a customer provided encryption key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.KmsEncryptionConfigProperty kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SseConfigurationProperty {
            private final java.lang.Object kmsEncryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsEncryptionConfig = software.amazon.jsii.Kernel.get(this, "kmsEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsEncryptionConfig = java.util.Objects.requireNonNull(builder.kmsEncryptionConfig, "kmsEncryptionConfig is required");
            }

            @Override
            public final java.lang.Object getKmsEncryptionConfig() {
                return this.kmsEncryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsEncryptionConfig", om.valueToTree(this.getKmsEncryptionConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastore.SseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SseConfigurationProperty.Jsii$Proxy that = (SseConfigurationProperty.Jsii$Proxy) o;

                return this.kmsEncryptionConfig.equals(that.kmsEncryptionConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsEncryptionConfig.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.healthlake.CfnFHIRDatastore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.healthlake.CfnFHIRDatastore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.healthlake.CfnFHIRDatastoreProps.Builder();
        }

        /**
         * The FHIR release version supported by the data store.
         * <p>
         * Current support is for version <code>R4</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion</a>
         * @param datastoreTypeVersion The FHIR release version supported by the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreTypeVersion(final java.lang.String datastoreTypeVersion) {
            this.props.datastoreTypeVersion(datastoreTypeVersion);
            return this;
        }

        /**
         * The data store name (user-generated).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename</a>
         * @param datastoreName The data store name (user-generated). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreName(final java.lang.String datastoreName) {
            this.props.datastoreName(datastoreName);
            return this;
        }

        /**
         * The identity provider configuration selected when the data store was created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration</a>
         * @param identityProviderConfiguration The identity provider configuration selected when the data store was created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(final software.amazon.awscdk.IResolvable identityProviderConfiguration) {
            this.props.identityProviderConfiguration(identityProviderConfiguration);
            return this;
        }
        /**
         * The identity provider configuration selected when the data store was created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration</a>
         * @param identityProviderConfiguration The identity provider configuration selected when the data store was created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(final software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.IdentityProviderConfigurationProperty identityProviderConfiguration) {
            this.props.identityProviderConfiguration(identityProviderConfiguration);
            return this;
        }

        /**
         * The preloaded Synthea data configuration for the data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig</a>
         * @param preloadDataConfig The preloaded Synthea data configuration for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(final software.amazon.awscdk.IResolvable preloadDataConfig) {
            this.props.preloadDataConfig(preloadDataConfig);
            return this;
        }
        /**
         * The preloaded Synthea data configuration for the data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig</a>
         * @param preloadDataConfig The preloaded Synthea data configuration for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(final software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.PreloadDataConfigProperty preloadDataConfig) {
            this.props.preloadDataConfig(preloadDataConfig);
            return this;
        }

        /**
         * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration</a>
         * @param sseConfiguration The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(final software.amazon.awscdk.IResolvable sseConfiguration) {
            this.props.sseConfiguration(sseConfiguration);
            return this;
        }
        /**
         * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration</a>
         * @param sseConfiguration The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(final software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.SseConfigurationProperty sseConfiguration) {
            this.props.sseConfiguration(sseConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.healthlake.CfnFHIRDatastore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.healthlake.CfnFHIRDatastore build() {
            return new software.amazon.awscdk.services.healthlake.CfnFHIRDatastore(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
