package software.amazon.awscdk.services.iam;

/**
 * IAM Instance Profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
 *         .build();
 * IInstanceProfile instanceProfile = InstanceProfile.fromInstanceProfileAttributes(this, "ImportedInstanceProfile", InstanceProfileAttributes.builder()
 *         .instanceProfileArn("arn:aws:iam::account-id:instance-profile/MyInstanceProfile")
 *         .role(role)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:29.640Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.InstanceProfile")
public class InstanceProfile extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.IInstanceProfile {

    protected InstanceProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.InstanceProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing InstanceProfile from an InstanceProfile ARN.
     * <p>
     * If the ARN comes from a Token, the InstanceProfile cannot have a path; if so, any attempt
     * to reference its instanceProfileName will fail.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param instanceProfileArn the ARN of the exiting InstanceProfile to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IInstanceProfile fromInstanceProfileArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String instanceProfileArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.InstanceProfile.class, "fromInstanceProfileArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(instanceProfileArn, "instanceProfileArn is required") });
    }

    /**
     * Import an existing InstanceProfile from given InstanceProfile attributes.
     * <p>
     * If the ARN comes from a Token, the InstanceProfile cannot have a path; if so, any attempt
     * to reference its instanceProfileName will fail.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param attrs the attributes of the InstanceProfile to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IInstanceProfile fromInstanceProfileAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.InstanceProfileAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.InstanceProfile.class, "fromInstanceProfileAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing InstanceProfile from an InstanceProfile name.
     * <p>
     * @param scope construct scope. This parameter is required.
     * @param id construct id. This parameter is required.
     * @param instanceProfileName the name of the existing InstanceProfile to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IInstanceProfile fromInstanceProfileName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String instanceProfileName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.InstanceProfile.class, "fromInstanceProfileName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(instanceProfileName, "instanceProfileName is required") });
    }

    /**
     * Returns the ARN of this InstanceProfile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of this InstanceProfile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileName() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the role associated with this InstanceProfile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.InstanceProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.InstanceProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.InstanceProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the InstanceProfile to create.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param instanceProfileName The name of the InstanceProfile to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(final java.lang.String instanceProfileName) {
            this.props().instanceProfileName(instanceProfileName);
            return this;
        }

        /**
         * The path to the InstanceProfile.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param path The path to the InstanceProfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props().path(path);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile that is used by EC2 instances.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * Default: - a role will be automatically created, it can be accessed via the `role` property
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * Role role = Role.Builder.create(this, "MyRole")
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile that is used by EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.InstanceProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.InstanceProfile build() {
            return new software.amazon.awscdk.services.iam.InstanceProfile(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.InstanceProfileProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.InstanceProfileProps.Builder();
            }
            return this.props;
        }
    }
}
