package software.amazon.awscdk.services.iotfleetwise;

/**
 * Creates a collection of standardized signals that can be reused to create vehicle models.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/signal-catalogs.html">Signal catalogs</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnSignalCatalog cfnSignalCatalog = CfnSignalCatalog.Builder.create(this, "MyCfnSignalCatalog")
 *         .description("description")
 *         .name("name")
 *         .nodeCounts(NodeCountsProperty.builder()
 *                 .totalActuators(123)
 *                 .totalAttributes(123)
 *                 .totalBranches(123)
 *                 .totalNodes(123)
 *                 .totalSensors(123)
 *                 .build())
 *         .nodes(List.of(NodeProperty.builder()
 *                 .actuator(ActuatorProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .assignedValue("assignedValue")
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .attribute(AttributeProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .assignedValue("assignedValue")
 *                         .defaultValue("defaultValue")
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .branch(BranchProperty.builder()
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build())
 *                 .sensor(SensorProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:30.094Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog")
public class CfnSignalCatalog extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSignalCatalog(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSignalCatalog(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSignalCatalog(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalogProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSignalCatalog(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The total number of nodes in a vehicle network that represent actuators.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNodeCountsTotalActuators() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCountsTotalActuators", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total number of nodes in a vehicle network that represent attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNodeCountsTotalAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCountsTotalAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total number of nodes in a vehicle network that represent branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNodeCountsTotalBranches() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCountsTotalBranches", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total number of nodes in a vehicle network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNodeCountsTotalNodes() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCountsTotalNodes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total number of nodes in a vehicle network that represent sensors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrNodeCountsTotalSensors() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCountsTotalSensors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A brief description of the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Information about the number of nodes and node types in a vehicle network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeCounts() {
        return software.amazon.jsii.Kernel.get(this, "nodeCounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the number of nodes and node types in a vehicle network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeCounts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeCounts", value);
    }

    /**
     * Information about the number of nodes and node types in a vehicle network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeCounts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.NodeCountsProperty value) {
        software.amazon.jsii.Kernel.set(this, "nodeCounts", value);
    }

    /**
     * A list of information about nodes, which are a general abstraction of signals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodes() {
        return software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of information about nodes, which are a general abstraction of signals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodes", value);
    }

    /**
     * A list of information about nodes, which are a general abstraction of signals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.NodeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.NodeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "nodes", value);
    }

    /**
     * Metadata that can be used to manage the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the signal catalog.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A signal that represents a vehicle device such as the engine, heater, and door locks.
     * <p>
     * Data from an actuator reports the state of a certain vehicle device.
     * <p>
     * <blockquote>
     * <p>
     * Updating actuator data can change the state of a device. For example, you can turn on or off the heater by updating its actuator data.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ActuatorProperty actuatorProperty = ActuatorProperty.builder()
     *         .dataType("dataType")
     *         .fullyQualifiedName("fullyQualifiedName")
     *         // the properties below are optional
     *         .allowedValues(List.of("allowedValues"))
     *         .assignedValue("assignedValue")
     *         .description("description")
     *         .max(123)
     *         .min(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.ActuatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ActuatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActuatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified data type of the actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataType();

        /**
         * The fully qualified name of the actuator.
         * <p>
         * For example, the fully qualified name of an actuator might be <code>Vehicle.Front.Left.Door.Lock</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * A list of possible values an actuator can take.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
            return null;
        }

        /**
         * A specified value for the actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-assignedvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-assignedvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignedValue() {
            return null;
        }

        /**
         * A brief description of the actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The specified possible maximum value of an actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The specified possible minimum value of an actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * The scientific unit for the actuator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-actuator.html#cfn-iotfleetwise-signalcatalog-actuator-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActuatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActuatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActuatorProperty> {
            java.lang.String dataType;
            java.lang.String fullyQualifiedName;
            java.util.List<java.lang.String> allowedValues;
            java.lang.String assignedValue;
            java.lang.String description;
            java.lang.Number max;
            java.lang.Number min;
            java.lang.String unit;

            /**
             * Sets the value of {@link ActuatorProperty#getDataType}
             * @param dataType The specified data type of the actuator. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of the actuator. This parameter is required.
             *                           For example, the fully qualified name of an actuator might be <code>Vehicle.Front.Left.Door.Lock</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getAllowedValues}
             * @param allowedValues A list of possible values an actuator can take.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<java.lang.String> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getAssignedValue}
             * @param assignedValue A specified value for the actuator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignedValue(java.lang.String assignedValue) {
                this.assignedValue = assignedValue;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getDescription}
             * @param description A brief description of the actuator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getMax}
             * @param max The specified possible maximum value of an actuator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getMin}
             * @param min The specified possible minimum value of an actuator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link ActuatorProperty#getUnit}
             * @param unit The scientific unit for the actuator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActuatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActuatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActuatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActuatorProperty {
            private final java.lang.String dataType;
            private final java.lang.String fullyQualifiedName;
            private final java.util.List<java.lang.String> allowedValues;
            private final java.lang.String assignedValue;
            private final java.lang.String description;
            private final java.lang.Number max;
            private final java.lang.Number min;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignedValue = software.amazon.jsii.Kernel.get(this, "assignedValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.allowedValues = builder.allowedValues;
                this.assignedValue = builder.assignedValue;
                this.description = builder.description;
                this.max = builder.max;
                this.min = builder.min;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.String getAssignedValue() {
                return this.assignedValue;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataType", om.valueToTree(this.getDataType()));
                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getAssignedValue() != null) {
                    data.set("assignedValue", om.valueToTree(this.getAssignedValue()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.ActuatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActuatorProperty.Jsii$Proxy that = (ActuatorProperty.Jsii$Proxy) o;

                if (!dataType.equals(that.dataType)) return false;
                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.assignedValue != null ? !this.assignedValue.equals(that.assignedValue) : that.assignedValue != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                if (this.min != null ? !this.min.equals(that.min) : that.min != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataType.hashCode();
                result = 31 * result + (this.fullyQualifiedName.hashCode());
                result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
                result = 31 * result + (this.assignedValue != null ? this.assignedValue.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A signal that represents static information about the vehicle, such as engine type or manufacturing date.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * AttributeProperty attributeProperty = AttributeProperty.builder()
     *         .dataType("dataType")
     *         .fullyQualifiedName("fullyQualifiedName")
     *         // the properties below are optional
     *         .allowedValues(List.of("allowedValues"))
     *         .assignedValue("assignedValue")
     *         .defaultValue("defaultValue")
     *         .description("description")
     *         .max(123)
     *         .min(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.AttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified data type of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataType();

        /**
         * The fully qualified name of the attribute.
         * <p>
         * For example, the fully qualified name of an attribute might be <code>Vehicle.Body.Engine.Type</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * A list of possible values an attribute can be assigned.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
            return null;
        }

        /**
         * A specified value for the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-assignedvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-assignedvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignedValue() {
            return null;
        }

        /**
         * The default value of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * A brief description of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The specified possible maximum value of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The specified possible minimum value of the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * The scientific unit for the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-attribute.html#cfn-iotfleetwise-signalcatalog-attribute-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeProperty> {
            java.lang.String dataType;
            java.lang.String fullyQualifiedName;
            java.util.List<java.lang.String> allowedValues;
            java.lang.String assignedValue;
            java.lang.String defaultValue;
            java.lang.String description;
            java.lang.Number max;
            java.lang.Number min;
            java.lang.String unit;

            /**
             * Sets the value of {@link AttributeProperty#getDataType}
             * @param dataType The specified data type of the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of the attribute. This parameter is required.
             *                           For example, the fully qualified name of an attribute might be <code>Vehicle.Body.Engine.Type</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getAllowedValues}
             * @param allowedValues A list of possible values an attribute can be assigned.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<java.lang.String> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getAssignedValue}
             * @param assignedValue A specified value for the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignedValue(java.lang.String assignedValue) {
                this.assignedValue = assignedValue;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getDefaultValue}
             * @param defaultValue The default value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getDescription}
             * @param description A brief description of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getMax}
             * @param max The specified possible maximum value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getMin}
             * @param min The specified possible minimum value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link AttributeProperty#getUnit}
             * @param unit The scientific unit for the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeProperty {
            private final java.lang.String dataType;
            private final java.lang.String fullyQualifiedName;
            private final java.util.List<java.lang.String> allowedValues;
            private final java.lang.String assignedValue;
            private final java.lang.String defaultValue;
            private final java.lang.String description;
            private final java.lang.Number max;
            private final java.lang.Number min;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignedValue = software.amazon.jsii.Kernel.get(this, "assignedValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.allowedValues = builder.allowedValues;
                this.assignedValue = builder.assignedValue;
                this.defaultValue = builder.defaultValue;
                this.description = builder.description;
                this.max = builder.max;
                this.min = builder.min;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.String getAssignedValue() {
                return this.assignedValue;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataType", om.valueToTree(this.getDataType()));
                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getAssignedValue() != null) {
                    data.set("assignedValue", om.valueToTree(this.getAssignedValue()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.AttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeProperty.Jsii$Proxy that = (AttributeProperty.Jsii$Proxy) o;

                if (!dataType.equals(that.dataType)) return false;
                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.assignedValue != null ? !this.assignedValue.equals(that.assignedValue) : that.assignedValue != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                if (this.min != null ? !this.min.equals(that.min) : that.min != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataType.hashCode();
                result = 31 * result + (this.fullyQualifiedName.hashCode());
                result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
                result = 31 * result + (this.assignedValue != null ? this.assignedValue.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A group of signals that are defined in a hierarchical structure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * BranchProperty branchProperty = BranchProperty.builder()
     *         .fullyQualifiedName("fullyQualifiedName")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.BranchProperty")
    @software.amazon.jsii.Jsii.Proxy(BranchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BranchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fully qualified name of the branch.
         * <p>
         * For example, the fully qualified name of a branch might be <code>Vehicle.Body.Engine</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * A brief description of the branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-branch.html#cfn-iotfleetwise-signalcatalog-branch-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BranchProperty> {
            java.lang.String fullyQualifiedName;
            java.lang.String description;

            /**
             * Sets the value of {@link BranchProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of the branch. This parameter is required.
             *                           For example, the fully qualified name of a branch might be <code>Vehicle.Body.Engine</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link BranchProperty#getDescription}
             * @param description A brief description of the branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BranchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BranchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BranchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BranchProperty {
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.BranchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BranchProperty.Jsii$Proxy that = (BranchProperty.Jsii$Proxy) o;

                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fullyQualifiedName.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the number of nodes and node types in a vehicle network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * NodeCountsProperty nodeCountsProperty = NodeCountsProperty.builder()
     *         .totalActuators(123)
     *         .totalAttributes(123)
     *         .totalBranches(123)
     *         .totalNodes(123)
     *         .totalSensors(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.NodeCountsProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeCountsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeCountsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total number of nodes in a vehicle network that represent actuators.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalactuators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalactuators</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalActuators() {
            return null;
        }

        /**
         * The total number of nodes in a vehicle network that represent attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalAttributes() {
            return null;
        }

        /**
         * The total number of nodes in a vehicle network that represent branches.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalbranches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalbranches</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalBranches() {
            return null;
        }

        /**
         * The total number of nodes in a vehicle network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalnodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalNodes() {
            return null;
        }

        /**
         * The total number of nodes in a vehicle network that represent sensors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalsensors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-nodecounts.html#cfn-iotfleetwise-signalcatalog-nodecounts-totalsensors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotalSensors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeCountsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeCountsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeCountsProperty> {
            java.lang.Number totalActuators;
            java.lang.Number totalAttributes;
            java.lang.Number totalBranches;
            java.lang.Number totalNodes;
            java.lang.Number totalSensors;

            /**
             * Sets the value of {@link NodeCountsProperty#getTotalActuators}
             * @param totalActuators The total number of nodes in a vehicle network that represent actuators.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalActuators(java.lang.Number totalActuators) {
                this.totalActuators = totalActuators;
                return this;
            }

            /**
             * Sets the value of {@link NodeCountsProperty#getTotalAttributes}
             * @param totalAttributes The total number of nodes in a vehicle network that represent attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalAttributes(java.lang.Number totalAttributes) {
                this.totalAttributes = totalAttributes;
                return this;
            }

            /**
             * Sets the value of {@link NodeCountsProperty#getTotalBranches}
             * @param totalBranches The total number of nodes in a vehicle network that represent branches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalBranches(java.lang.Number totalBranches) {
                this.totalBranches = totalBranches;
                return this;
            }

            /**
             * Sets the value of {@link NodeCountsProperty#getTotalNodes}
             * @param totalNodes The total number of nodes in a vehicle network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalNodes(java.lang.Number totalNodes) {
                this.totalNodes = totalNodes;
                return this;
            }

            /**
             * Sets the value of {@link NodeCountsProperty#getTotalSensors}
             * @param totalSensors The total number of nodes in a vehicle network that represent sensors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalSensors(java.lang.Number totalSensors) {
                this.totalSensors = totalSensors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeCountsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeCountsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeCountsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeCountsProperty {
            private final java.lang.Number totalActuators;
            private final java.lang.Number totalAttributes;
            private final java.lang.Number totalBranches;
            private final java.lang.Number totalNodes;
            private final java.lang.Number totalSensors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.totalActuators = software.amazon.jsii.Kernel.get(this, "totalActuators", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalAttributes = software.amazon.jsii.Kernel.get(this, "totalAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalBranches = software.amazon.jsii.Kernel.get(this, "totalBranches", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalNodes = software.amazon.jsii.Kernel.get(this, "totalNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalSensors = software.amazon.jsii.Kernel.get(this, "totalSensors", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.totalActuators = builder.totalActuators;
                this.totalAttributes = builder.totalAttributes;
                this.totalBranches = builder.totalBranches;
                this.totalNodes = builder.totalNodes;
                this.totalSensors = builder.totalSensors;
            }

            @Override
            public final java.lang.Number getTotalActuators() {
                return this.totalActuators;
            }

            @Override
            public final java.lang.Number getTotalAttributes() {
                return this.totalAttributes;
            }

            @Override
            public final java.lang.Number getTotalBranches() {
                return this.totalBranches;
            }

            @Override
            public final java.lang.Number getTotalNodes() {
                return this.totalNodes;
            }

            @Override
            public final java.lang.Number getTotalSensors() {
                return this.totalSensors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTotalActuators() != null) {
                    data.set("totalActuators", om.valueToTree(this.getTotalActuators()));
                }
                if (this.getTotalAttributes() != null) {
                    data.set("totalAttributes", om.valueToTree(this.getTotalAttributes()));
                }
                if (this.getTotalBranches() != null) {
                    data.set("totalBranches", om.valueToTree(this.getTotalBranches()));
                }
                if (this.getTotalNodes() != null) {
                    data.set("totalNodes", om.valueToTree(this.getTotalNodes()));
                }
                if (this.getTotalSensors() != null) {
                    data.set("totalSensors", om.valueToTree(this.getTotalSensors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.NodeCountsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeCountsProperty.Jsii$Proxy that = (NodeCountsProperty.Jsii$Proxy) o;

                if (this.totalActuators != null ? !this.totalActuators.equals(that.totalActuators) : that.totalActuators != null) return false;
                if (this.totalAttributes != null ? !this.totalAttributes.equals(that.totalAttributes) : that.totalAttributes != null) return false;
                if (this.totalBranches != null ? !this.totalBranches.equals(that.totalBranches) : that.totalBranches != null) return false;
                if (this.totalNodes != null ? !this.totalNodes.equals(that.totalNodes) : that.totalNodes != null) return false;
                return this.totalSensors != null ? this.totalSensors.equals(that.totalSensors) : that.totalSensors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.totalActuators != null ? this.totalActuators.hashCode() : 0;
                result = 31 * result + (this.totalAttributes != null ? this.totalAttributes.hashCode() : 0);
                result = 31 * result + (this.totalBranches != null ? this.totalBranches.hashCode() : 0);
                result = 31 * result + (this.totalNodes != null ? this.totalNodes.hashCode() : 0);
                result = 31 * result + (this.totalSensors != null ? this.totalSensors.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A general abstraction of a signal.
     * <p>
     * A node can be specified as an actuator, attribute, branch, or sensor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * NodeProperty nodeProperty = NodeProperty.builder()
     *         .actuator(ActuatorProperty.builder()
     *                 .dataType("dataType")
     *                 .fullyQualifiedName("fullyQualifiedName")
     *                 // the properties below are optional
     *                 .allowedValues(List.of("allowedValues"))
     *                 .assignedValue("assignedValue")
     *                 .description("description")
     *                 .max(123)
     *                 .min(123)
     *                 .unit("unit")
     *                 .build())
     *         .attribute(AttributeProperty.builder()
     *                 .dataType("dataType")
     *                 .fullyQualifiedName("fullyQualifiedName")
     *                 // the properties below are optional
     *                 .allowedValues(List.of("allowedValues"))
     *                 .assignedValue("assignedValue")
     *                 .defaultValue("defaultValue")
     *                 .description("description")
     *                 .max(123)
     *                 .min(123)
     *                 .unit("unit")
     *                 .build())
     *         .branch(BranchProperty.builder()
     *                 .fullyQualifiedName("fullyQualifiedName")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build())
     *         .sensor(SensorProperty.builder()
     *                 .dataType("dataType")
     *                 .fullyQualifiedName("fullyQualifiedName")
     *                 // the properties below are optional
     *                 .allowedValues(List.of("allowedValues"))
     *                 .description("description")
     *                 .max(123)
     *                 .min(123)
     *                 .unit("unit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.NodeProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about a node specified as an actuator.
         * <p>
         * <blockquote>
         * <p>
         * An actuator is a digital representation of a vehicle device.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-actuator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-actuator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActuator() {
            return null;
        }

        /**
         * Information about a node specified as an attribute.
         * <p>
         * <blockquote>
         * <p>
         * An attribute represents static information about a vehicle.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttribute() {
            return null;
        }

        /**
         * Information about a node specified as a branch.
         * <p>
         * <blockquote>
         * <p>
         * A group of signals that are defined in a hierarchical structure.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-branch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-branch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBranch() {
            return null;
        }

        /**
         * An input component that reports the environmental condition of a vehicle.
         * <p>
         * <blockquote>
         * <p>
         * You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-sensor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-node.html#cfn-iotfleetwise-signalcatalog-node-sensor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSensor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeProperty> {
            java.lang.Object actuator;
            java.lang.Object attribute;
            java.lang.Object branch;
            java.lang.Object sensor;

            /**
             * Sets the value of {@link NodeProperty#getActuator}
             * @param actuator Information about a node specified as an actuator.
             *                 <blockquote>
             *                 <p>
             *                 An actuator is a digital representation of a vehicle device.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actuator(software.amazon.awscdk.IResolvable actuator) {
                this.actuator = actuator;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getActuator}
             * @param actuator Information about a node specified as an actuator.
             *                 <blockquote>
             *                 <p>
             *                 An actuator is a digital representation of a vehicle device.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actuator(software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.ActuatorProperty actuator) {
                this.actuator = actuator;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getAttribute}
             * @param attribute Information about a node specified as an attribute.
             *                  <blockquote>
             *                  <p>
             *                  An attribute represents static information about a vehicle.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(software.amazon.awscdk.IResolvable attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getAttribute}
             * @param attribute Information about a node specified as an attribute.
             *                  <blockquote>
             *                  <p>
             *                  An attribute represents static information about a vehicle.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.AttributeProperty attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getBranch}
             * @param branch Information about a node specified as a branch.
             *               <blockquote>
             *               <p>
             *               A group of signals that are defined in a hierarchical structure.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branch(software.amazon.awscdk.IResolvable branch) {
                this.branch = branch;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getBranch}
             * @param branch Information about a node specified as a branch.
             *               <blockquote>
             *               <p>
             *               A group of signals that are defined in a hierarchical structure.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branch(software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.BranchProperty branch) {
                this.branch = branch;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getSensor}
             * @param sensor An input component that reports the environmental condition of a vehicle.
             *               <blockquote>
             *               <p>
             *               You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sensor(software.amazon.awscdk.IResolvable sensor) {
                this.sensor = sensor;
                return this;
            }

            /**
             * Sets the value of {@link NodeProperty#getSensor}
             * @param sensor An input component that reports the environmental condition of a vehicle.
             *               <blockquote>
             *               <p>
             *               You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sensor(software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.SensorProperty sensor) {
                this.sensor = sensor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeProperty {
            private final java.lang.Object actuator;
            private final java.lang.Object attribute;
            private final java.lang.Object branch;
            private final java.lang.Object sensor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actuator = software.amazon.jsii.Kernel.get(this, "actuator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sensor = software.amazon.jsii.Kernel.get(this, "sensor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actuator = builder.actuator;
                this.attribute = builder.attribute;
                this.branch = builder.branch;
                this.sensor = builder.sensor;
            }

            @Override
            public final java.lang.Object getActuator() {
                return this.actuator;
            }

            @Override
            public final java.lang.Object getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.Object getBranch() {
                return this.branch;
            }

            @Override
            public final java.lang.Object getSensor() {
                return this.sensor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActuator() != null) {
                    data.set("actuator", om.valueToTree(this.getActuator()));
                }
                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }
                if (this.getBranch() != null) {
                    data.set("branch", om.valueToTree(this.getBranch()));
                }
                if (this.getSensor() != null) {
                    data.set("sensor", om.valueToTree(this.getSensor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.NodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeProperty.Jsii$Proxy that = (NodeProperty.Jsii$Proxy) o;

                if (this.actuator != null ? !this.actuator.equals(that.actuator) : that.actuator != null) return false;
                if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) return false;
                if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
                return this.sensor != null ? this.sensor.equals(that.sensor) : that.sensor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actuator != null ? this.actuator.hashCode() : 0;
                result = 31 * result + (this.attribute != null ? this.attribute.hashCode() : 0);
                result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
                result = 31 * result + (this.sensor != null ? this.sensor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An input component that reports the environmental condition of a vehicle.
     * <p>
     * <blockquote>
     * <p>
     * You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * SensorProperty sensorProperty = SensorProperty.builder()
     *         .dataType("dataType")
     *         .fullyQualifiedName("fullyQualifiedName")
     *         // the properties below are optional
     *         .allowedValues(List.of("allowedValues"))
     *         .description("description")
     *         .max(123)
     *         .min(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.SensorProperty")
    @software.amazon.jsii.Jsii.Proxy(SensorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SensorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified data type of the sensor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataType();

        /**
         * The fully qualified name of the sensor.
         * <p>
         * For example, the fully qualified name of a sensor might be <code>Vehicle.Body.Engine.Battery</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-fullyqualifiedname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-fullyqualifiedname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * A list of possible values a sensor can take.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
            return null;
        }

        /**
         * A brief description of a sensor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The specified possible maximum value of the sensor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The specified possible minimum value of the sensor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * The scientific unit of measurement for data collected by the sensor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotfleetwise-signalcatalog-sensor.html#cfn-iotfleetwise-signalcatalog-sensor-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SensorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SensorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SensorProperty> {
            java.lang.String dataType;
            java.lang.String fullyQualifiedName;
            java.util.List<java.lang.String> allowedValues;
            java.lang.String description;
            java.lang.Number max;
            java.lang.Number min;
            java.lang.String unit;

            /**
             * Sets the value of {@link SensorProperty#getDataType}
             * @param dataType The specified data type of the sensor. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getFullyQualifiedName}
             * @param fullyQualifiedName The fully qualified name of the sensor. This parameter is required.
             *                           For example, the fully qualified name of a sensor might be <code>Vehicle.Body.Engine.Battery</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getAllowedValues}
             * @param allowedValues A list of possible values a sensor can take.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<java.lang.String> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getDescription}
             * @param description A brief description of a sensor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getMax}
             * @param max The specified possible maximum value of the sensor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getMin}
             * @param min The specified possible minimum value of the sensor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link SensorProperty#getUnit}
             * @param unit The scientific unit of measurement for data collected by the sensor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SensorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SensorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SensorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SensorProperty {
            private final java.lang.String dataType;
            private final java.lang.String fullyQualifiedName;
            private final java.util.List<java.lang.String> allowedValues;
            private final java.lang.String description;
            private final java.lang.Number max;
            private final java.lang.Number min;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.allowedValues = builder.allowedValues;
                this.description = builder.description;
                this.max = builder.max;
                this.min = builder.min;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataType", om.valueToTree(this.getDataType()));
                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalog.SensorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SensorProperty.Jsii$Proxy that = (SensorProperty.Jsii$Proxy) o;

                if (!dataType.equals(that.dataType)) return false;
                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                if (this.min != null ? !this.min.equals(that.min) : that.min != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataType.hashCode();
                result = 31 * result + (this.fullyQualifiedName.hashCode());
                result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalogProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A brief description of the signal catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-description</a>
         * @param description A brief description of the signal catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The name of the signal catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-name</a>
         * @param name The name of the signal catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Information about the number of nodes and node types in a vehicle network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodecounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodecounts</a>
         * @param nodeCounts Information about the number of nodes and node types in a vehicle network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeCounts(final software.amazon.awscdk.IResolvable nodeCounts) {
            this.props().nodeCounts(nodeCounts);
            return this;
        }
        /**
         * Information about the number of nodes and node types in a vehicle network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodecounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodecounts</a>
         * @param nodeCounts Information about the number of nodes and node types in a vehicle network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeCounts(final software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog.NodeCountsProperty nodeCounts) {
            this.props().nodeCounts(nodeCounts);
            return this;
        }

        /**
         * A list of information about nodes, which are a general abstraction of signals.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes</a>
         * @param nodes A list of information about nodes, which are a general abstraction of signals. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodes(final software.amazon.awscdk.IResolvable nodes) {
            this.props().nodes(nodes);
            return this;
        }
        /**
         * A list of information about nodes, which are a general abstraction of signals.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-nodes</a>
         * @param nodes A list of information about nodes, which are a general abstraction of signals. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodes(final java.util.List<? extends java.lang.Object> nodes) {
            this.props().nodes(nodes);
            return this;
        }

        /**
         * Metadata that can be used to manage the signal catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-signalcatalog.html#cfn-iotfleetwise-signalcatalog-tags</a>
         * @param tags Metadata that can be used to manage the signal catalog. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalog(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalogProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iotfleetwise.CfnSignalCatalogProps.Builder();
            }
            return this.props;
        }
    }
}
