package software.amazon.awscdk.services.lambda;

/**
 * Logging levels for the Parametes and Secrets Extension.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.*;
 * import software.amazon.awscdk.services.ssm.*;
 * Secret secret = new Secret(this, "Secret");
 * StringParameter parameter = StringParameter.Builder.create(this, "Parameter")
 *         .parameterName("mySsmParameterName")
 *         .stringValue("mySsmParameterValue")
 *         .build();
 * ParamsAndSecretsLayerVersion paramsAndSecrets = ParamsAndSecretsLayerVersion.fromVersion(ParamsAndSecretsVersions.V1_0_103, ParamsAndSecretsOptions.builder()
 *         .cacheSize(500)
 *         .logLevel(ParamsAndSecretsLogLevel.DEBUG)
 *         .build());
 * Function lambdaFunction = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .architecture(Architecture.ARM_64)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .paramsAndSecrets(paramsAndSecrets)
 *         .build();
 * secret.grantRead(lambdaFunction);
 * parameter.grantRead(lambdaFunction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:30.923Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ParamsAndSecretsLogLevel")
public enum ParamsAndSecretsLogLevel {
    /**
     * Debug.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEBUG,
    /**
     * Info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Warn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WARN,
    /**
     * Error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * No logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
