package software.amazon.awscdk.services.lambda.destinations;

/**
 * Use an Event Bridge event bus as a Lambda destination.
 * <p>
 * If no event bus is specified, the default event bus is used.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.lambda.destinations.*;
 * EventBus eventBus;
 * EventBridgeDestination eventBridgeDestination = new EventBridgeDestination(eventBus);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:30.957Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_destinations.EventBridgeDestination")
public class EventBridgeDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IDestination {

    protected EventBridgeDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBridgeDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Default: - use the default event bus
     * <p>
     * @param eventBus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgeDestination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IEventBus eventBus) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { eventBus });
    }

    /**
     * Default: - use the default event bus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgeDestination() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns a destination configuration.
     * <p>
     * @param _scope This parameter is required.
     * @param fn This parameter is required.
     * @param _options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.DestinationOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(fn, "fn is required"), _options });
    }

    /**
     * Returns a destination configuration.
     * <p>
     * @param _scope This parameter is required.
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(fn, "fn is required") });
    }
}
