package software.amazon.awscdk.services.location;

/**
 * Properties for defining a <code>CfnMap</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnMapProps cfnMapProps = CfnMapProps.builder()
 *         .configuration(MapConfigurationProperty.builder()
 *                 .style("style")
 *                 // the properties below are optional
 *                 .customLayers(List.of("customLayers"))
 *                 .politicalView("politicalView")
 *                 .build())
 *         .mapName("mapName")
 *         // the properties below are optional
 *         .description("description")
 *         .pricingPlan("pricingPlan")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:31.196Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnMapProps")
@software.amazon.jsii.Jsii.Proxy(CfnMapProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMapProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the <code>MapConfiguration</code> , including the map style, for the map resource that you create.
     * <p>
     * The map style defines the look of maps and the data provider for your map resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * The name for the map resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique map resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleMap</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-mapname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-mapname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMapName();

    /**
     * An optional description for the map resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code> .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-pricingplan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-pricingplan</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return null;
    }

    /**
     * Applies one or more tags to the map resource.
     * <p>
     * A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     * <p>
     * Format: <code>"key" : "value"</code>
     * <p>
     * Restrictions:
     * <p>
     * <ul>
     * <li>Maximum 50 tags per resource</li>
     * <li>Each resource tag must be unique with a maximum of one value.</li>
     * <li>Maximum key length: 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length: 256 Unicode characters in UTF-8</li>
     * <li>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html#cfn-location-map-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMapProps> {
        java.lang.Object configuration;
        java.lang.String mapName;
        java.lang.String description;
        java.lang.String pricingPlan;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMapProps#getConfiguration}
         * @param configuration Specifies the <code>MapConfiguration</code> , including the map style, for the map resource that you create. This parameter is required.
         *                      The map style defines the look of maps and the data provider for your map resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMapProps#getConfiguration}
         * @param configuration Specifies the <code>MapConfiguration</code> , including the map style, for the map resource that you create. This parameter is required.
         *                      The map style defines the look of maps and the data provider for your map resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMapProps#getMapName}
         * @param mapName The name for the map resource. This parameter is required.
         *                Requirements:
         *                <p>
         *                <ul>
         *                <li>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         *                <li>Must be a unique map resource name.</li>
         *                <li>No spaces allowed. For example, <code>ExampleMap</code> .</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapName(java.lang.String mapName) {
            this.mapName = mapName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMapProps#getDescription}
         * @param description An optional description for the map resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMapProps#getPricingPlan}
         * @param pricingPlan No longer used. If included, the only allowed value is <code>RequestBasedUsage</code> .
         *                    <em>Allowed Values</em> : <code>RequestBasedUsage</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlan(java.lang.String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnMapProps#getTags}
         * @param tags Applies one or more tags to the map resource.
         *             A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *             <p>
         *             Format: <code>"key" : "value"</code>
         *             <p>
         *             Restrictions:
         *             <p>
         *             <ul>
         *             <li>Maximum 50 tags per resource</li>
         *             <li>Each resource tag must be unique with a maximum of one value.</li>
         *             <li>Maximum key length: 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length: 256 Unicode characters in UTF-8</li>
         *             <li>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMapProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMapProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMapProps {
        private final java.lang.Object configuration;
        private final java.lang.String mapName;
        private final java.lang.String description;
        private final java.lang.String pricingPlan;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mapName = software.amazon.jsii.Kernel.get(this, "mapName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlan = software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.mapName = java.util.Objects.requireNonNull(builder.mapName, "mapName is required");
            this.description = builder.description;
            this.pricingPlan = builder.pricingPlan;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getMapName() {
            return this.mapName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("mapName", om.valueToTree(this.getMapName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPricingPlan() != null) {
                data.set("pricingPlan", om.valueToTree(this.getPricingPlan()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnMapProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMapProps.Jsii$Proxy that = (CfnMapProps.Jsii$Proxy) o;

            if (!configuration.equals(that.configuration)) return false;
            if (!mapName.equals(that.mapName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.pricingPlan != null ? !this.pricingPlan.equals(that.pricingPlan) : that.pricingPlan != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            result = 31 * result + (this.mapName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.pricingPlan != null ? this.pricingPlan.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
