package software.amazon.awscdk.services.macie;

/**
 * Properties for defining a <code>CfnCustomDataIdentifier</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * CfnCustomDataIdentifierProps cfnCustomDataIdentifierProps = CfnCustomDataIdentifierProps.builder()
 *         .name("name")
 *         .regex("regex")
 *         // the properties below are optional
 *         .description("description")
 *         .ignoreWords(List.of("ignoreWords"))
 *         .keywords(List.of("keywords"))
 *         .maximumMatchDistance(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:31.359Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CfnCustomDataIdentifierProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomDataIdentifierProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomDataIdentifierProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A custom name for the custom data identifier. The name can contain 1-128 characters.
     * <p>
     * Avoid including sensitive data in the name of a custom data identifier. Users of the account might be able to see the name, depending on the actions that they're allowed to perform in Amazon Macie .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The regular expression ( <em>regex</em> ) that defines the text pattern to match.
     * <p>
     * The expression can contain 1-512 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-regex</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegex();

    /**
     * A custom description of the custom data identifier. The description can contain 1-512 characters.
     * <p>
     * Avoid including sensitive data in the description. Users of the account might be able to see the description, depending on the actions that they're allowed to perform in Amazon Macie .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array of character sequences ( <em>ignore words</em> ) to exclude from the results.
     * <p>
     * If text matches the regular expression ( <code>Regex</code> ) but it contains a string in this array, Amazon Macie ignores the text and doesn't include it in the results.
     * <p>
     * The array can contain 1-10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-ignorewords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-ignorewords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIgnoreWords() {
        return null;
    }

    /**
     * An array of character sequences ( <em>keywords</em> ), one of which must precede and be in proximity ( <code>MaximumMatchDistance</code> ) of the regular expression ( <code>Regex</code> ) to match.
     * <p>
     * The array can contain 1-50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-keywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-keywords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getKeywords() {
        return null;
    }

    /**
     * The maximum number of characters that can exist between the end of at least one complete character sequence specified by the <code>Keywords</code> array and the end of text that matches the regular expression ( <code>Regex</code> ).
     * <p>
     * If a complete keyword precedes all the text that matches the regular expression and the keyword is within the specified distance, Amazon Macie includes the result.
     * <p>
     * The distance can be 1-300 characters. The default value is 50.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-maximummatchdistance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-maximummatchdistance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMatchDistance() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the custom data identifier.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-customdataidentifier.html#cfn-macie-customdataidentifier-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomDataIdentifierProps> {
        java.lang.String name;
        java.lang.String regex;
        java.lang.String description;
        java.util.List<java.lang.String> ignoreWords;
        java.util.List<java.lang.String> keywords;
        java.lang.Number maximumMatchDistance;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getName}
         * @param name A custom name for the custom data identifier. The name can contain 1-128 characters. This parameter is required.
         *             Avoid including sensitive data in the name of a custom data identifier. Users of the account might be able to see the name, depending on the actions that they're allowed to perform in Amazon Macie .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getRegex}
         * @param regex The regular expression ( <em>regex</em> ) that defines the text pattern to match. This parameter is required.
         *              The expression can contain 1-512 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regex(java.lang.String regex) {
            this.regex = regex;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getDescription}
         * @param description A custom description of the custom data identifier. The description can contain 1-512 characters.
         *                    Avoid including sensitive data in the description. Users of the account might be able to see the description, depending on the actions that they're allowed to perform in Amazon Macie .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getIgnoreWords}
         * @param ignoreWords An array of character sequences ( <em>ignore words</em> ) to exclude from the results.
         *                    If text matches the regular expression ( <code>Regex</code> ) but it contains a string in this array, Amazon Macie ignores the text and doesn't include it in the results.
         *                    <p>
         *                    The array can contain 1-10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreWords(java.util.List<java.lang.String> ignoreWords) {
            this.ignoreWords = ignoreWords;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getKeywords}
         * @param keywords An array of character sequences ( <em>keywords</em> ), one of which must precede and be in proximity ( <code>MaximumMatchDistance</code> ) of the regular expression ( <code>Regex</code> ) to match.
         *                 The array can contain 1-50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keywords(java.util.List<java.lang.String> keywords) {
            this.keywords = keywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getMaximumMatchDistance}
         * @param maximumMatchDistance The maximum number of characters that can exist between the end of at least one complete character sequence specified by the <code>Keywords</code> array and the end of text that matches the regular expression ( <code>Regex</code> ).
         *                             If a complete keyword precedes all the text that matches the regular expression and the keyword is within the specified distance, Amazon Macie includes the result.
         *                             <p>
         *                             The distance can be 1-300 characters. The default value is 50.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMatchDistance(java.lang.Number maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDataIdentifierProps#getTags}
         * @param tags An array of key-value pairs to apply to the custom data identifier.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomDataIdentifierProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomDataIdentifierProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomDataIdentifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomDataIdentifierProps {
        private final java.lang.String name;
        private final java.lang.String regex;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> ignoreWords;
        private final java.util.List<java.lang.String> keywords;
        private final java.lang.Number maximumMatchDistance;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreWords = software.amazon.jsii.Kernel.get(this, "ignoreWords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.keywords = software.amazon.jsii.Kernel.get(this, "keywords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maximumMatchDistance = software.amazon.jsii.Kernel.get(this, "maximumMatchDistance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.regex = java.util.Objects.requireNonNull(builder.regex, "regex is required");
            this.description = builder.description;
            this.ignoreWords = builder.ignoreWords;
            this.keywords = builder.keywords;
            this.maximumMatchDistance = builder.maximumMatchDistance;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRegex() {
            return this.regex;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getIgnoreWords() {
            return this.ignoreWords;
        }

        @Override
        public final java.util.List<java.lang.String> getKeywords() {
            return this.keywords;
        }

        @Override
        public final java.lang.Number getMaximumMatchDistance() {
            return this.maximumMatchDistance;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("regex", om.valueToTree(this.getRegex()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getIgnoreWords() != null) {
                data.set("ignoreWords", om.valueToTree(this.getIgnoreWords()));
            }
            if (this.getKeywords() != null) {
                data.set("keywords", om.valueToTree(this.getKeywords()));
            }
            if (this.getMaximumMatchDistance() != null) {
                data.set("maximumMatchDistance", om.valueToTree(this.getMaximumMatchDistance()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.CfnCustomDataIdentifierProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomDataIdentifierProps.Jsii$Proxy that = (CfnCustomDataIdentifierProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!regex.equals(that.regex)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.ignoreWords != null ? !this.ignoreWords.equals(that.ignoreWords) : that.ignoreWords != null) return false;
            if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) return false;
            if (this.maximumMatchDistance != null ? !this.maximumMatchDistance.equals(that.maximumMatchDistance) : that.maximumMatchDistance != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.regex.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ignoreWords != null ? this.ignoreWords.hashCode() : 0);
            result = 31 * result + (this.keywords != null ? this.keywords.hashCode() : 0);
            result = 31 * result + (this.maximumMatchDistance != null ? this.maximumMatchDistance.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
