package software.amazon.awscdk.services.medialive;

/**
 * Properties for defining a <code>CfnSignalMap</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * CfnSignalMapProps cfnSignalMapProps = CfnSignalMapProps.builder()
 *         .discoveryEntryPointArn("discoveryEntryPointArn")
 *         .name("name")
 *         // the properties below are optional
 *         .cloudWatchAlarmTemplateGroupIdentifiers(List.of("cloudWatchAlarmTemplateGroupIdentifiers"))
 *         .description("description")
 *         .eventBridgeRuleTemplateGroupIdentifiers(List.of("eventBridgeRuleTemplateGroupIdentifiers"))
 *         .forceRediscovery(false)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:31.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnSignalMapProps")
@software.amazon.jsii.Jsii.Proxy(CfnSignalMapProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSignalMapProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A top-level supported Amazon Web Services resource ARN to discover a signal map from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-discoveryentrypointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-discoveryentrypointarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDiscoveryEntryPointArn();

    /**
     * A resource's name.
     * <p>
     * Names must be unique within the scope of a resource type in a specific region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A cloudwatch alarm template group's identifier.
     * <p>
     * Can be either be its id or current name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-cloudwatchalarmtemplategroupidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-cloudwatchalarmtemplategroupidentifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloudWatchAlarmTemplateGroupIdentifiers() {
        return null;
    }

    /**
     * A resource's optional description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An eventbridge rule template group's identifier.
     * <p>
     * Can be either be its id or current name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-eventbridgeruletemplategroupidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-eventbridgeruletemplategroupidentifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventBridgeRuleTemplateGroupIdentifiers() {
        return null;
    }

    /**
     * If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-forcerediscovery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-forcerediscovery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceRediscovery() {
        return null;
    }

    /**
     * Represents the tags associated with a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-signalmap.html#cfn-medialive-signalmap-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSignalMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSignalMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSignalMapProps> {
        java.lang.String discoveryEntryPointArn;
        java.lang.String name;
        java.util.List<java.lang.String> cloudWatchAlarmTemplateGroupIdentifiers;
        java.lang.String description;
        java.util.List<java.lang.String> eventBridgeRuleTemplateGroupIdentifiers;
        java.lang.Object forceRediscovery;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnSignalMapProps#getDiscoveryEntryPointArn}
         * @param discoveryEntryPointArn A top-level supported Amazon Web Services resource ARN to discover a signal map from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder discoveryEntryPointArn(java.lang.String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getName}
         * @param name A resource's name. This parameter is required.
         *             Names must be unique within the scope of a resource type in a specific region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getCloudWatchAlarmTemplateGroupIdentifiers}
         * @param cloudWatchAlarmTemplateGroupIdentifiers A cloudwatch alarm template group's identifier.
         *                                                Can be either be its id or current name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchAlarmTemplateGroupIdentifiers(java.util.List<java.lang.String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = cloudWatchAlarmTemplateGroupIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getDescription}
         * @param description A resource's optional description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getEventBridgeRuleTemplateGroupIdentifiers}
         * @param eventBridgeRuleTemplateGroupIdentifiers An eventbridge rule template group's identifier.
         *                                                Can be either be its id or current name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeRuleTemplateGroupIdentifiers(java.util.List<java.lang.String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = eventBridgeRuleTemplateGroupIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getForceRediscovery}
         * @param forceRediscovery If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceRediscovery(java.lang.Boolean forceRediscovery) {
            this.forceRediscovery = forceRediscovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getForceRediscovery}
         * @param forceRediscovery If true, will force a rediscovery of a signal map if an unchanged discoveryEntryPointArn is provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceRediscovery(software.amazon.awscdk.IResolvable forceRediscovery) {
            this.forceRediscovery = forceRediscovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalMapProps#getTags}
         * @param tags Represents the tags associated with a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSignalMapProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSignalMapProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSignalMapProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSignalMapProps {
        private final java.lang.String discoveryEntryPointArn;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> cloudWatchAlarmTemplateGroupIdentifiers;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> eventBridgeRuleTemplateGroupIdentifiers;
        private final java.lang.Object forceRediscovery;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.discoveryEntryPointArn = software.amazon.jsii.Kernel.get(this, "discoveryEntryPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchAlarmTemplateGroupIdentifiers = software.amazon.jsii.Kernel.get(this, "cloudWatchAlarmTemplateGroupIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBridgeRuleTemplateGroupIdentifiers = software.amazon.jsii.Kernel.get(this, "eventBridgeRuleTemplateGroupIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.forceRediscovery = software.amazon.jsii.Kernel.get(this, "forceRediscovery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.discoveryEntryPointArn = java.util.Objects.requireNonNull(builder.discoveryEntryPointArn, "discoveryEntryPointArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.cloudWatchAlarmTemplateGroupIdentifiers = builder.cloudWatchAlarmTemplateGroupIdentifiers;
            this.description = builder.description;
            this.eventBridgeRuleTemplateGroupIdentifiers = builder.eventBridgeRuleTemplateGroupIdentifiers;
            this.forceRediscovery = builder.forceRediscovery;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getDiscoveryEntryPointArn() {
            return this.discoveryEntryPointArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getCloudWatchAlarmTemplateGroupIdentifiers() {
            return this.cloudWatchAlarmTemplateGroupIdentifiers;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getEventBridgeRuleTemplateGroupIdentifiers() {
            return this.eventBridgeRuleTemplateGroupIdentifiers;
        }

        @Override
        public final java.lang.Object getForceRediscovery() {
            return this.forceRediscovery;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("discoveryEntryPointArn", om.valueToTree(this.getDiscoveryEntryPointArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCloudWatchAlarmTemplateGroupIdentifiers() != null) {
                data.set("cloudWatchAlarmTemplateGroupIdentifiers", om.valueToTree(this.getCloudWatchAlarmTemplateGroupIdentifiers()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventBridgeRuleTemplateGroupIdentifiers() != null) {
                data.set("eventBridgeRuleTemplateGroupIdentifiers", om.valueToTree(this.getEventBridgeRuleTemplateGroupIdentifiers()));
            }
            if (this.getForceRediscovery() != null) {
                data.set("forceRediscovery", om.valueToTree(this.getForceRediscovery()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnSignalMapProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSignalMapProps.Jsii$Proxy that = (CfnSignalMapProps.Jsii$Proxy) o;

            if (!discoveryEntryPointArn.equals(that.discoveryEntryPointArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.cloudWatchAlarmTemplateGroupIdentifiers != null ? !this.cloudWatchAlarmTemplateGroupIdentifiers.equals(that.cloudWatchAlarmTemplateGroupIdentifiers) : that.cloudWatchAlarmTemplateGroupIdentifiers != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventBridgeRuleTemplateGroupIdentifiers != null ? !this.eventBridgeRuleTemplateGroupIdentifiers.equals(that.eventBridgeRuleTemplateGroupIdentifiers) : that.eventBridgeRuleTemplateGroupIdentifiers != null) return false;
            if (this.forceRediscovery != null ? !this.forceRediscovery.equals(that.forceRediscovery) : that.forceRediscovery != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.discoveryEntryPointArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.cloudWatchAlarmTemplateGroupIdentifiers != null ? this.cloudWatchAlarmTemplateGroupIdentifiers.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventBridgeRuleTemplateGroupIdentifiers != null ? this.eventBridgeRuleTemplateGroupIdentifiers.hashCode() : 0);
            result = 31 * result + (this.forceRediscovery != null ? this.forceRediscovery.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
