package software.amazon.awscdk.services.mediatailor;

/**
 * Properties for defining a <code>CfnChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .channelName("channelName")
 *         .outputs(List.of(RequestOutputItemProperty.builder()
 *                 .manifestName("manifestName")
 *                 .sourceGroup("sourceGroup")
 *                 // the properties below are optional
 *                 .dashPlaylistSettings(DashPlaylistSettingsProperty.builder()
 *                         .manifestWindowSeconds(123)
 *                         .minBufferTimeSeconds(123)
 *                         .minUpdatePeriodSeconds(123)
 *                         .suggestedPresentationDelaySeconds(123)
 *                         .build())
 *                 .hlsPlaylistSettings(HlsPlaylistSettingsProperty.builder()
 *                         .adMarkupType(List.of("adMarkupType"))
 *                         .manifestWindowSeconds(123)
 *                         .build())
 *                 .build()))
 *         .playbackMode("playbackMode")
 *         // the properties below are optional
 *         .audiences(List.of("audiences"))
 *         .fillerSlate(SlateSourceProperty.builder()
 *                 .sourceLocationName("sourceLocationName")
 *                 .vodSourceName("vodSourceName")
 *                 .build())
 *         .logConfiguration(LogConfigurationForChannelProperty.builder()
 *                 .logTypes(List.of("logTypes"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tier("tier")
 *         .timeShiftConfiguration(TimeShiftConfigurationProperty.builder()
 *                 .maxTimeDelaySeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:31.765Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-channelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

    /**
     * The channel's output properties.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-outputs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOutputs();

    /**
     * The type of playback mode for this channel.
     * <p>
     * <code>LINEAR</code> - Programs play back-to-back only once.
     * <p>
     * <code>LOOP</code> - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-playbackmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-playbackmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlaybackMode();

    /**
     * The list of audiences defined in channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-audiences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-audiences</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAudiences() {
        return null;
    }

    /**
     * The slate used to fill gaps between programs in the schedule.
     * <p>
     * You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code> . MediaTailor doesn't support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-fillerslate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFillerSlate() {
        return null;
    }

    /**
     * The log configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-logconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return null;
    }

    /**
     * The tags to assign to the channel.
     * <p>
     * Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The tier for this channel.
     * <p>
     * STANDARD tier channels can contain live programs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-tier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTier() {
        return null;
    }

    /**
     * The configuration for time-shifted viewing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-channel.html#cfn-mediatailor-channel-timeshiftconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeShiftConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.String channelName;
        java.lang.Object outputs;
        java.lang.String playbackMode;
        java.util.List<java.lang.String> audiences;
        java.lang.Object fillerSlate;
        java.lang.Object logConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String tier;
        java.lang.Object timeShiftConfiguration;

        /**
         * Sets the value of {@link CfnChannelProps#getChannelName}
         * @param channelName The name of the channel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getOutputs}
         * @param outputs The channel's output properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getOutputs}
         * @param outputs The channel's output properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getPlaybackMode}
         * @param playbackMode The type of playback mode for this channel. This parameter is required.
         *                     <code>LINEAR</code> - Programs play back-to-back only once.
         *                     <p>
         *                     <code>LOOP</code> - Programs play back-to-back in an endless loop. When the last program in the schedule plays, playback loops back to the first program in the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playbackMode(java.lang.String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getAudiences}
         * @param audiences The list of audiences defined in channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder audiences(java.util.List<java.lang.String> audiences) {
            this.audiences = audiences;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getFillerSlate}
         * @param fillerSlate The slate used to fill gaps between programs in the schedule.
         *                    You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code> . MediaTailor doesn't support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fillerSlate(software.amazon.awscdk.IResolvable fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getFillerSlate}
         * @param fillerSlate The slate used to fill gaps between programs in the schedule.
         *                    You must configure filler slate if your channel uses the <code>LINEAR</code> <code>PlaybackMode</code> . MediaTailor doesn't support filler slate for channels using the <code>LOOP</code> <code>PlaybackMode</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fillerSlate(software.amazon.awscdk.services.mediatailor.CfnChannel.SlateSourceProperty fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLogConfiguration}
         * @param logConfiguration The log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLogConfiguration}
         * @param logConfiguration The log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.services.mediatailor.CfnChannel.LogConfigurationForChannelProperty logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags The tags to assign to the channel.
         *             Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTier}
         * @param tier The tier for this channel.
         *             STANDARD tier channels can contain live programs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(java.lang.String tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTimeShiftConfiguration}
         * @param timeShiftConfiguration The configuration for time-shifted viewing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeShiftConfiguration(software.amazon.awscdk.IResolvable timeShiftConfiguration) {
            this.timeShiftConfiguration = timeShiftConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTimeShiftConfiguration}
         * @param timeShiftConfiguration The configuration for time-shifted viewing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeShiftConfiguration(software.amazon.awscdk.services.mediatailor.CfnChannel.TimeShiftConfigurationProperty timeShiftConfiguration) {
            this.timeShiftConfiguration = timeShiftConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.String channelName;
        private final java.lang.Object outputs;
        private final java.lang.String playbackMode;
        private final java.util.List<java.lang.String> audiences;
        private final java.lang.Object fillerSlate;
        private final java.lang.Object logConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String tier;
        private final java.lang.Object timeShiftConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.playbackMode = software.amazon.jsii.Kernel.get(this, "playbackMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.audiences = software.amazon.jsii.Kernel.get(this, "audiences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.fillerSlate = software.amazon.jsii.Kernel.get(this, "fillerSlate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeShiftConfiguration = software.amazon.jsii.Kernel.get(this, "timeShiftConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
            this.outputs = java.util.Objects.requireNonNull(builder.outputs, "outputs is required");
            this.playbackMode = java.util.Objects.requireNonNull(builder.playbackMode, "playbackMode is required");
            this.audiences = builder.audiences;
            this.fillerSlate = builder.fillerSlate;
            this.logConfiguration = builder.logConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tier = builder.tier;
            this.timeShiftConfiguration = builder.timeShiftConfiguration;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.lang.String getPlaybackMode() {
            return this.playbackMode;
        }

        @Override
        public final java.util.List<java.lang.String> getAudiences() {
            return this.audiences;
        }

        @Override
        public final java.lang.Object getFillerSlate() {
            return this.fillerSlate;
        }

        @Override
        public final java.lang.Object getLogConfiguration() {
            return this.logConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTier() {
            return this.tier;
        }

        @Override
        public final java.lang.Object getTimeShiftConfiguration() {
            return this.timeShiftConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelName", om.valueToTree(this.getChannelName()));
            data.set("outputs", om.valueToTree(this.getOutputs()));
            data.set("playbackMode", om.valueToTree(this.getPlaybackMode()));
            if (this.getAudiences() != null) {
                data.set("audiences", om.valueToTree(this.getAudiences()));
            }
            if (this.getFillerSlate() != null) {
                data.set("fillerSlate", om.valueToTree(this.getFillerSlate()));
            }
            if (this.getLogConfiguration() != null) {
                data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }
            if (this.getTimeShiftConfiguration() != null) {
                data.set("timeShiftConfiguration", om.valueToTree(this.getTimeShiftConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (!channelName.equals(that.channelName)) return false;
            if (!outputs.equals(that.outputs)) return false;
            if (!playbackMode.equals(that.playbackMode)) return false;
            if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) return false;
            if (this.fillerSlate != null ? !this.fillerSlate.equals(that.fillerSlate) : that.fillerSlate != null) return false;
            if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tier != null ? !this.tier.equals(that.tier) : that.tier != null) return false;
            return this.timeShiftConfiguration != null ? this.timeShiftConfiguration.equals(that.timeShiftConfiguration) : that.timeShiftConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelName.hashCode();
            result = 31 * result + (this.outputs.hashCode());
            result = 31 * result + (this.playbackMode.hashCode());
            result = 31 * result + (this.audiences != null ? this.audiences.hashCode() : 0);
            result = 31 * result + (this.fillerSlate != null ? this.fillerSlate.hashCode() : 0);
            result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            result = 31 * result + (this.timeShiftConfiguration != null ? this.timeShiftConfiguration.hashCode() : 0);
            return result;
        }
    }
}
