package software.amazon.awscdk.services.mediatailor;

/**
 * Properties for defining a <code>CfnSourceLocation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * CfnSourceLocationProps cfnSourceLocationProps = CfnSourceLocationProps.builder()
 *         .httpConfiguration(HttpConfigurationProperty.builder()
 *                 .baseUrl("baseUrl")
 *                 .build())
 *         .sourceLocationName("sourceLocationName")
 *         // the properties below are optional
 *         .accessConfiguration(AccessConfigurationProperty.builder()
 *                 .accessType("accessType")
 *                 .secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfigurationProperty.builder()
 *                         .headerName("headerName")
 *                         .secretArn("secretArn")
 *                         .secretStringKey("secretStringKey")
 *                         .build())
 *                 .build())
 *         .defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfigurationProperty.builder()
 *                 .baseUrl("baseUrl")
 *                 .build())
 *         .segmentDeliveryConfigurations(List.of(SegmentDeliveryConfigurationProperty.builder()
 *                 .baseUrl("baseUrl")
 *                 .name("name")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:31.791Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnSourceLocationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSourceLocationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSourceLocationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP configuration for the source location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-httpconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-httpconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getHttpConfiguration();

    /**
     * The name of the source location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-sourcelocationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-sourcelocationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationName();

    /**
     * The access configuration for the source location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-accessconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-accessconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessConfiguration() {
        return null;
    }

    /**
     * The default segment delivery configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-defaultsegmentdeliveryconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-defaultsegmentdeliveryconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultSegmentDeliveryConfiguration() {
        return null;
    }

    /**
     * The segment delivery configurations for the source location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-segmentdeliveryconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-segmentdeliveryconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSegmentDeliveryConfigurations() {
        return null;
    }

    /**
     * The tags assigned to the source location.
     * <p>
     * Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-sourcelocation.html#cfn-mediatailor-sourcelocation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSourceLocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSourceLocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSourceLocationProps> {
        java.lang.Object httpConfiguration;
        java.lang.String sourceLocationName;
        java.lang.Object accessConfiguration;
        java.lang.Object defaultSegmentDeliveryConfiguration;
        java.lang.Object segmentDeliveryConfigurations;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSourceLocationProps#getHttpConfiguration}
         * @param httpConfiguration The HTTP configuration for the source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfiguration(software.amazon.awscdk.IResolvable httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getHttpConfiguration}
         * @param httpConfiguration The HTTP configuration for the source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfiguration(software.amazon.awscdk.services.mediatailor.CfnSourceLocation.HttpConfigurationProperty httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getSourceLocationName}
         * @param sourceLocationName The name of the source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationName(java.lang.String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getAccessConfiguration}
         * @param accessConfiguration The access configuration for the source location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfiguration(software.amazon.awscdk.IResolvable accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getAccessConfiguration}
         * @param accessConfiguration The access configuration for the source location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessConfiguration(software.amazon.awscdk.services.mediatailor.CfnSourceLocation.AccessConfigurationProperty accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getDefaultSegmentDeliveryConfiguration}
         * @param defaultSegmentDeliveryConfiguration The default segment delivery configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSegmentDeliveryConfiguration(software.amazon.awscdk.IResolvable defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getDefaultSegmentDeliveryConfiguration}
         * @param defaultSegmentDeliveryConfiguration The default segment delivery configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSegmentDeliveryConfiguration(software.amazon.awscdk.services.mediatailor.CfnSourceLocation.DefaultSegmentDeliveryConfigurationProperty defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getSegmentDeliveryConfigurations}
         * @param segmentDeliveryConfigurations The segment delivery configurations for the source location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDeliveryConfigurations(software.amazon.awscdk.IResolvable segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = segmentDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getSegmentDeliveryConfigurations}
         * @param segmentDeliveryConfigurations The segment delivery configurations for the source location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDeliveryConfigurations(java.util.List<? extends java.lang.Object> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = segmentDeliveryConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnSourceLocationProps#getTags}
         * @param tags The tags assigned to the source location.
         *             Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSourceLocationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSourceLocationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSourceLocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSourceLocationProps {
        private final java.lang.Object httpConfiguration;
        private final java.lang.String sourceLocationName;
        private final java.lang.Object accessConfiguration;
        private final java.lang.Object defaultSegmentDeliveryConfiguration;
        private final java.lang.Object segmentDeliveryConfigurations;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpConfiguration = software.amazon.jsii.Kernel.get(this, "httpConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessConfiguration = software.amazon.jsii.Kernel.get(this, "accessConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultSegmentDeliveryConfiguration = software.amazon.jsii.Kernel.get(this, "defaultSegmentDeliveryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.segmentDeliveryConfigurations = software.amazon.jsii.Kernel.get(this, "segmentDeliveryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpConfiguration = java.util.Objects.requireNonNull(builder.httpConfiguration, "httpConfiguration is required");
            this.sourceLocationName = java.util.Objects.requireNonNull(builder.sourceLocationName, "sourceLocationName is required");
            this.accessConfiguration = builder.accessConfiguration;
            this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
            this.segmentDeliveryConfigurations = builder.segmentDeliveryConfigurations;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getHttpConfiguration() {
            return this.httpConfiguration;
        }

        @Override
        public final java.lang.String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final java.lang.Object getAccessConfiguration() {
            return this.accessConfiguration;
        }

        @Override
        public final java.lang.Object getDefaultSegmentDeliveryConfiguration() {
            return this.defaultSegmentDeliveryConfiguration;
        }

        @Override
        public final java.lang.Object getSegmentDeliveryConfigurations() {
            return this.segmentDeliveryConfigurations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpConfiguration", om.valueToTree(this.getHttpConfiguration()));
            data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));
            if (this.getAccessConfiguration() != null) {
                data.set("accessConfiguration", om.valueToTree(this.getAccessConfiguration()));
            }
            if (this.getDefaultSegmentDeliveryConfiguration() != null) {
                data.set("defaultSegmentDeliveryConfiguration", om.valueToTree(this.getDefaultSegmentDeliveryConfiguration()));
            }
            if (this.getSegmentDeliveryConfigurations() != null) {
                data.set("segmentDeliveryConfigurations", om.valueToTree(this.getSegmentDeliveryConfigurations()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnSourceLocationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSourceLocationProps.Jsii$Proxy that = (CfnSourceLocationProps.Jsii$Proxy) o;

            if (!httpConfiguration.equals(that.httpConfiguration)) return false;
            if (!sourceLocationName.equals(that.sourceLocationName)) return false;
            if (this.accessConfiguration != null ? !this.accessConfiguration.equals(that.accessConfiguration) : that.accessConfiguration != null) return false;
            if (this.defaultSegmentDeliveryConfiguration != null ? !this.defaultSegmentDeliveryConfiguration.equals(that.defaultSegmentDeliveryConfiguration) : that.defaultSegmentDeliveryConfiguration != null) return false;
            if (this.segmentDeliveryConfigurations != null ? !this.segmentDeliveryConfigurations.equals(that.segmentDeliveryConfigurations) : that.segmentDeliveryConfigurations != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpConfiguration.hashCode();
            result = 31 * result + (this.sourceLocationName.hashCode());
            result = 31 * result + (this.accessConfiguration != null ? this.accessConfiguration.hashCode() : 0);
            result = 31 * result + (this.defaultSegmentDeliveryConfiguration != null ? this.defaultSegmentDeliveryConfiguration.hashCode() : 0);
            result = 31 * result + (this.segmentDeliveryConfigurations != null ? this.segmentDeliveryConfigurations.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
