package software.amazon.awscdk.services.notifications;

/**
 * Properties for defining a <code>CfnManagedNotificationAdditionalChannelAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notifications.*;
 * CfnManagedNotificationAdditionalChannelAssociationProps cfnManagedNotificationAdditionalChannelAssociationProps = CfnManagedNotificationAdditionalChannelAssociationProps.builder()
 *         .channelArn("channelArn")
 *         .managedNotificationConfigurationArn("managedNotificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:32.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notifications.CfnManagedNotificationAdditionalChannelAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnManagedNotificationAdditionalChannelAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnManagedNotificationAdditionalChannelAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the <code>Channel</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html#cfn-notifications-managednotificationadditionalchannelassociation-channelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html#cfn-notifications-managednotificationadditionalchannelassociation-channelarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelArn();

    /**
     * The ARN of the <code>ManagedNotificationAdditionalChannelAssociation</code> associated with the <code>Channel</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html#cfn-notifications-managednotificationadditionalchannelassociation-managednotificationconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-managednotificationadditionalchannelassociation.html#cfn-notifications-managednotificationadditionalchannelassociation-managednotificationconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getManagedNotificationConfigurationArn();

    /**
     * @return a {@link Builder} of {@link CfnManagedNotificationAdditionalChannelAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnManagedNotificationAdditionalChannelAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnManagedNotificationAdditionalChannelAssociationProps> {
        java.lang.String channelArn;
        java.lang.String managedNotificationConfigurationArn;

        /**
         * Sets the value of {@link CfnManagedNotificationAdditionalChannelAssociationProps#getChannelArn}
         * @param channelArn The ARN of the <code>Channel</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelArn(java.lang.String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedNotificationAdditionalChannelAssociationProps#getManagedNotificationConfigurationArn}
         * @param managedNotificationConfigurationArn The ARN of the <code>ManagedNotificationAdditionalChannelAssociation</code> associated with the <code>Channel</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedNotificationConfigurationArn(java.lang.String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnManagedNotificationAdditionalChannelAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnManagedNotificationAdditionalChannelAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnManagedNotificationAdditionalChannelAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnManagedNotificationAdditionalChannelAssociationProps {
        private final java.lang.String channelArn;
        private final java.lang.String managedNotificationConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelArn = software.amazon.jsii.Kernel.get(this, "channelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedNotificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "managedNotificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelArn = java.util.Objects.requireNonNull(builder.channelArn, "channelArn is required");
            this.managedNotificationConfigurationArn = java.util.Objects.requireNonNull(builder.managedNotificationConfigurationArn, "managedNotificationConfigurationArn is required");
        }

        @Override
        public final java.lang.String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final java.lang.String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelArn", om.valueToTree(this.getChannelArn()));
            data.set("managedNotificationConfigurationArn", om.valueToTree(this.getManagedNotificationConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_notifications.CfnManagedNotificationAdditionalChannelAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnManagedNotificationAdditionalChannelAssociationProps.Jsii$Proxy that = (CfnManagedNotificationAdditionalChannelAssociationProps.Jsii$Proxy) o;

            if (!channelArn.equals(that.channelArn)) return false;
            return this.managedNotificationConfigurationArn.equals(that.managedNotificationConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.channelArn.hashCode();
            result = 31 * result + (this.managedNotificationConfigurationArn.hashCode());
            return result;
        }
    }
}
