package software.amazon.awscdk.services.opensearchservice;

/**
 * Specifies options for fine-grained access control.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_0)
 *         .enforceHttps(true)
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .fineGrainedAccessControl(AdvancedSecurityOptions.builder()
 *                 .masterUserName("master-user")
 *                 .samlAuthenticationEnabled(true)
 *                 .samlAuthenticationOptions(SAMLOptionsProperty.builder()
 *                         .idpEntityId("entity-id")
 *                         .idpMetadataContent("metadata-content-with-quotes-escaped")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:32.089Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.AdvancedSecurityOptions")
@software.amazon.jsii.Jsii.Proxy(AdvancedSecurityOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AdvancedSecurityOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN for the master user.
     * <p>
     * Only specify this or masterUserName, but not both.
     * <p>
     * Default: - fine-grained access control is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserArn() {
        return null;
    }

    /**
     * Username for the master user.
     * <p>
     * Only specify this or masterUserArn, but not both.
     * <p>
     * Default: - fine-grained access control is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserName() {
        return null;
    }

    /**
     * Password for the master user.
     * <p>
     * You can use <code>SecretValue.unsafePlainText</code> to specify a password in plain text or
     * use <code>secretsmanager.Secret.fromSecretAttributes</code> to reference a secret in
     * Secrets Manager.
     * <p>
     * Default: - A Secrets Manager generated password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getMasterUserPassword() {
        return null;
    }

    /**
     * True to enable SAML authentication for a domain.
     * <p>
     * Default: - SAML authentication is disabled. Enabled if `samlAuthenticationOptions` is set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/saml.html">https://docs.aws.amazon.com/opensearch-service/latest/developerguide/saml.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSamlAuthenticationEnabled() {
        return null;
    }

    /**
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     * <p>
     * If set, <code>samlAuthenticationEnabled</code> will be enabled.
     * <p>
     * Default: - no SAML authentication options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty getSamlAuthenticationOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AdvancedSecurityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AdvancedSecurityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AdvancedSecurityOptions> {
        java.lang.String masterUserArn;
        java.lang.String masterUserName;
        software.amazon.awscdk.SecretValue masterUserPassword;
        java.lang.Boolean samlAuthenticationEnabled;
        software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty samlAuthenticationOptions;

        /**
         * Sets the value of {@link AdvancedSecurityOptions#getMasterUserArn}
         * @param masterUserArn ARN for the master user.
         *                      Only specify this or masterUserName, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserArn(java.lang.String masterUserArn) {
            this.masterUserArn = masterUserArn;
            return this;
        }

        /**
         * Sets the value of {@link AdvancedSecurityOptions#getMasterUserName}
         * @param masterUserName Username for the master user.
         *                       Only specify this or masterUserArn, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserName(java.lang.String masterUserName) {
            this.masterUserName = masterUserName;
            return this;
        }

        /**
         * Sets the value of {@link AdvancedSecurityOptions#getMasterUserPassword}
         * @param masterUserPassword Password for the master user.
         *                           You can use <code>SecretValue.unsafePlainText</code> to specify a password in plain text or
         *                           use <code>secretsmanager.Secret.fromSecretAttributes</code> to reference a secret in
         *                           Secrets Manager.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(software.amazon.awscdk.SecretValue masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link AdvancedSecurityOptions#getSamlAuthenticationEnabled}
         * @param samlAuthenticationEnabled True to enable SAML authentication for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlAuthenticationEnabled(java.lang.Boolean samlAuthenticationEnabled) {
            this.samlAuthenticationEnabled = samlAuthenticationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AdvancedSecurityOptions#getSamlAuthenticationOptions}
         * @param samlAuthenticationOptions Container for information about the SAML configuration for OpenSearch Dashboards.
         *                                  If set, <code>samlAuthenticationEnabled</code> will be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlAuthenticationOptions(software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty samlAuthenticationOptions) {
            this.samlAuthenticationOptions = samlAuthenticationOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AdvancedSecurityOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AdvancedSecurityOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AdvancedSecurityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedSecurityOptions {
        private final java.lang.String masterUserArn;
        private final java.lang.String masterUserName;
        private final software.amazon.awscdk.SecretValue masterUserPassword;
        private final java.lang.Boolean samlAuthenticationEnabled;
        private final software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty samlAuthenticationOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.masterUserArn = software.amazon.jsii.Kernel.get(this, "masterUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserName = software.amazon.jsii.Kernel.get(this, "masterUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.samlAuthenticationEnabled = software.amazon.jsii.Kernel.get(this, "samlAuthenticationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.samlAuthenticationOptions = software.amazon.jsii.Kernel.get(this, "samlAuthenticationOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.masterUserArn = builder.masterUserArn;
            this.masterUserName = builder.masterUserName;
            this.masterUserPassword = builder.masterUserPassword;
            this.samlAuthenticationEnabled = builder.samlAuthenticationEnabled;
            this.samlAuthenticationOptions = builder.samlAuthenticationOptions;
        }

        @Override
        public final java.lang.String getMasterUserArn() {
            return this.masterUserArn;
        }

        @Override
        public final java.lang.String getMasterUserName() {
            return this.masterUserName;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.Boolean getSamlAuthenticationEnabled() {
            return this.samlAuthenticationEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.opensearchservice.SAMLOptionsProperty getSamlAuthenticationOptions() {
            return this.samlAuthenticationOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMasterUserArn() != null) {
                data.set("masterUserArn", om.valueToTree(this.getMasterUserArn()));
            }
            if (this.getMasterUserName() != null) {
                data.set("masterUserName", om.valueToTree(this.getMasterUserName()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getSamlAuthenticationEnabled() != null) {
                data.set("samlAuthenticationEnabled", om.valueToTree(this.getSamlAuthenticationEnabled()));
            }
            if (this.getSamlAuthenticationOptions() != null) {
                data.set("samlAuthenticationOptions", om.valueToTree(this.getSamlAuthenticationOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.AdvancedSecurityOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AdvancedSecurityOptions.Jsii$Proxy that = (AdvancedSecurityOptions.Jsii$Proxy) o;

            if (this.masterUserArn != null ? !this.masterUserArn.equals(that.masterUserArn) : that.masterUserArn != null) return false;
            if (this.masterUserName != null ? !this.masterUserName.equals(that.masterUserName) : that.masterUserName != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.samlAuthenticationEnabled != null ? !this.samlAuthenticationEnabled.equals(that.samlAuthenticationEnabled) : that.samlAuthenticationEnabled != null) return false;
            return this.samlAuthenticationOptions != null ? this.samlAuthenticationOptions.equals(that.samlAuthenticationOptions) : that.samlAuthenticationOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.masterUserArn != null ? this.masterUserArn.hashCode() : 0;
            result = 31 * result + (this.masterUserName != null ? this.masterUserName.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.samlAuthenticationEnabled != null ? this.samlAuthenticationEnabled.hashCode() : 0);
            result = 31 * result + (this.samlAuthenticationOptions != null ? this.samlAuthenticationOptions.hashCode() : 0);
            return result;
        }
    }
}
