package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBProxyTargetGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBProxyTargetGroupProps cfnDBProxyTargetGroupProps = CfnDBProxyTargetGroupProps.builder()
 *         .dbProxyName("dbProxyName")
 *         .targetGroupName("targetGroupName")
 *         // the properties below are optional
 *         .connectionPoolConfigurationInfo(ConnectionPoolConfigurationInfoFormatProperty.builder()
 *                 .connectionBorrowTimeout(123)
 *                 .initQuery("initQuery")
 *                 .maxConnectionsPercent(123)
 *                 .maxIdleConnectionsPercent(123)
 *                 .sessionPinningFilters(List.of("sessionPinningFilters"))
 *                 .build())
 *         .dbClusterIdentifiers(List.of("dbClusterIdentifiers"))
 *         .dbInstanceIdentifiers(List.of("dbInstanceIdentifiers"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:35.637Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBProxyTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBProxyTargetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName();

    /**
     * The identifier for the target group.
     * <p>
     * <blockquote>
     * <p>
     * Currently, this property must be set to <code>default</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupName();

    /**
     * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionPoolConfigurationInfo() {
        return null;
    }

    /**
     * One or more DB cluster identifiers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbClusterIdentifiers() {
        return null;
    }

    /**
     * One or more DB instance identifiers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbInstanceIdentifiers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBProxyTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBProxyTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBProxyTargetGroupProps> {
        java.lang.String dbProxyName;
        java.lang.String targetGroupName;
        java.lang.Object connectionPoolConfigurationInfo;
        java.util.List<java.lang.String> dbClusterIdentifiers;
        java.util.List<java.lang.String> dbInstanceIdentifiers;

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getDbProxyName}
         * @param dbProxyName The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(java.lang.String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getTargetGroupName}
         * @param targetGroupName The identifier for the target group. This parameter is required.
         *                        <blockquote>
         *                        <p>
         *                        Currently, this property must be set to <code>default</code> .
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getConnectionPoolConfigurationInfo}
         * @param connectionPoolConfigurationInfo Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(software.amazon.awscdk.IResolvable connectionPoolConfigurationInfo) {
            this.connectionPoolConfigurationInfo = connectionPoolConfigurationInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getConnectionPoolConfigurationInfo}
         * @param connectionPoolConfigurationInfo Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty connectionPoolConfigurationInfo) {
            this.connectionPoolConfigurationInfo = connectionPoolConfigurationInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getDbClusterIdentifiers}
         * @param dbClusterIdentifiers One or more DB cluster identifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifiers(java.util.List<java.lang.String> dbClusterIdentifiers) {
            this.dbClusterIdentifiers = dbClusterIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyTargetGroupProps#getDbInstanceIdentifiers}
         * @param dbInstanceIdentifiers One or more DB instance identifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifiers(java.util.List<java.lang.String> dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers = dbInstanceIdentifiers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBProxyTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBProxyTargetGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBProxyTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBProxyTargetGroupProps {
        private final java.lang.String dbProxyName;
        private final java.lang.String targetGroupName;
        private final java.lang.Object connectionPoolConfigurationInfo;
        private final java.util.List<java.lang.String> dbClusterIdentifiers;
        private final java.util.List<java.lang.String> dbInstanceIdentifiers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbProxyName = software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetGroupName = software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionPoolConfigurationInfo = software.amazon.jsii.Kernel.get(this, "connectionPoolConfigurationInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dbClusterIdentifiers = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dbInstanceIdentifiers = software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbProxyName = java.util.Objects.requireNonNull(builder.dbProxyName, "dbProxyName is required");
            this.targetGroupName = java.util.Objects.requireNonNull(builder.targetGroupName, "targetGroupName is required");
            this.connectionPoolConfigurationInfo = builder.connectionPoolConfigurationInfo;
            this.dbClusterIdentifiers = builder.dbClusterIdentifiers;
            this.dbInstanceIdentifiers = builder.dbInstanceIdentifiers;
        }

        @Override
        public final java.lang.String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final java.lang.Object getConnectionPoolConfigurationInfo() {
            return this.connectionPoolConfigurationInfo;
        }

        @Override
        public final java.util.List<java.lang.String> getDbClusterIdentifiers() {
            return this.dbClusterIdentifiers;
        }

        @Override
        public final java.util.List<java.lang.String> getDbInstanceIdentifiers() {
            return this.dbInstanceIdentifiers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbProxyName", om.valueToTree(this.getDbProxyName()));
            data.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            if (this.getConnectionPoolConfigurationInfo() != null) {
                data.set("connectionPoolConfigurationInfo", om.valueToTree(this.getConnectionPoolConfigurationInfo()));
            }
            if (this.getDbClusterIdentifiers() != null) {
                data.set("dbClusterIdentifiers", om.valueToTree(this.getDbClusterIdentifiers()));
            }
            if (this.getDbInstanceIdentifiers() != null) {
                data.set("dbInstanceIdentifiers", om.valueToTree(this.getDbInstanceIdentifiers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxyTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBProxyTargetGroupProps.Jsii$Proxy that = (CfnDBProxyTargetGroupProps.Jsii$Proxy) o;

            if (!dbProxyName.equals(that.dbProxyName)) return false;
            if (!targetGroupName.equals(that.targetGroupName)) return false;
            if (this.connectionPoolConfigurationInfo != null ? !this.connectionPoolConfigurationInfo.equals(that.connectionPoolConfigurationInfo) : that.connectionPoolConfigurationInfo != null) return false;
            if (this.dbClusterIdentifiers != null ? !this.dbClusterIdentifiers.equals(that.dbClusterIdentifiers) : that.dbClusterIdentifiers != null) return false;
            return this.dbInstanceIdentifiers != null ? this.dbInstanceIdentifiers.equals(that.dbInstanceIdentifiers) : that.dbInstanceIdentifiers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbProxyName.hashCode();
            result = 31 * result + (this.targetGroupName.hashCode());
            result = 31 * result + (this.connectionPoolConfigurationInfo != null ? this.connectionPoolConfigurationInfo.hashCode() : 0);
            result = 31 * result + (this.dbClusterIdentifiers != null ? this.dbClusterIdentifiers.hashCode() : 0);
            result = 31 * result + (this.dbInstanceIdentifiers != null ? this.dbInstanceIdentifiers.hashCode() : 0);
            return result;
        }
    }
}
