package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBShardGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBShardGroupProps cfnDBShardGroupProps = CfnDBShardGroupProps.builder()
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .maxAcu(123)
 *         // the properties below are optional
 *         .computeRedundancy(123)
 *         .dbShardGroupIdentifier("dbShardGroupIdentifier")
 *         .minAcu(123)
 *         .publiclyAccessible(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:35.652Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBShardGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBShardGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBShardGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the primary DB cluster for the DB shard group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbClusterIdentifier();

    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-maxacu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-maxacu</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxAcu();

    /**
     * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:.
     * <p>
     * <ul>
     * <li>0 - Creates a DB shard group without a standby DB shard group. This is the default value.</li>
     * <li>1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).</li>
     * <li>2 - Creates a DB shard group with two standby DB shard groups in two different AZs.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-computeredundancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-computeredundancy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getComputeRedundancy() {
        return null;
    }

    /**
     * The name of the DB shard group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbshardgroupidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-dbshardgroupidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbShardGroupIdentifier() {
        return null;
    }

    /**
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-minacu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-minacu</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAcu() {
        return null;
    }

    /**
     * Specifies whether the DB shard group is publicly accessible.
     * <p>
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
     * <p>
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
     * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
     * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbshardgroup.html#cfn-rds-dbshardgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBShardGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBShardGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBShardGroupProps> {
        java.lang.String dbClusterIdentifier;
        java.lang.Number maxAcu;
        java.lang.Number computeRedundancy;
        java.lang.String dbShardGroupIdentifier;
        java.lang.Number minAcu;
        java.lang.Object publiclyAccessible;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier The name of the primary DB cluster for the DB shard group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getMaxAcu}
         * @param maxAcu The maximum capacity of the DB shard group in Aurora capacity units (ACUs). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAcu(java.lang.Number maxAcu) {
            this.maxAcu = maxAcu;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getComputeRedundancy}
         * @param computeRedundancy Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:.
         *                          <ul>
         *                          <li>0 - Creates a DB shard group without a standby DB shard group. This is the default value.</li>
         *                          <li>1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).</li>
         *                          <li>2 - Creates a DB shard group with two standby DB shard groups in two different AZs.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeRedundancy(java.lang.Number computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getDbShardGroupIdentifier}
         * @param dbShardGroupIdentifier The name of the DB shard group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbShardGroupIdentifier(java.lang.String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getMinAcu}
         * @param minAcu The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAcu(java.lang.Number minAcu) {
            this.minAcu = minAcu;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getPubliclyAccessible}
         * @param publiclyAccessible Specifies whether the DB shard group is publicly accessible.
         *                           When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         *                           <p>
         *                           When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         *                           <li>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</li>
         *                           </ul>
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         *                           <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getPubliclyAccessible}
         * @param publiclyAccessible Specifies whether the DB shard group is publicly accessible.
         *                           When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         *                           <p>
         *                           When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         *                           <li>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</li>
         *                           </ul>
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</li>
         *                           <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBShardGroupProps#getTags}
         * @param tags An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBShardGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBShardGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBShardGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBShardGroupProps {
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.Number maxAcu;
        private final java.lang.Number computeRedundancy;
        private final java.lang.String dbShardGroupIdentifier;
        private final java.lang.Number minAcu;
        private final java.lang.Object publiclyAccessible;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxAcu = software.amazon.jsii.Kernel.get(this, "maxAcu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeRedundancy = software.amazon.jsii.Kernel.get(this, "computeRedundancy", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dbShardGroupIdentifier = software.amazon.jsii.Kernel.get(this, "dbShardGroupIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minAcu = software.amazon.jsii.Kernel.get(this, "minAcu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbClusterIdentifier = java.util.Objects.requireNonNull(builder.dbClusterIdentifier, "dbClusterIdentifier is required");
            this.maxAcu = java.util.Objects.requireNonNull(builder.maxAcu, "maxAcu is required");
            this.computeRedundancy = builder.computeRedundancy;
            this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
            this.minAcu = builder.minAcu;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.Number getMaxAcu() {
            return this.maxAcu;
        }

        @Override
        public final java.lang.Number getComputeRedundancy() {
            return this.computeRedundancy;
        }

        @Override
        public final java.lang.String getDbShardGroupIdentifier() {
            return this.dbShardGroupIdentifier;
        }

        @Override
        public final java.lang.Number getMinAcu() {
            return this.minAcu;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            data.set("maxAcu", om.valueToTree(this.getMaxAcu()));
            if (this.getComputeRedundancy() != null) {
                data.set("computeRedundancy", om.valueToTree(this.getComputeRedundancy()));
            }
            if (this.getDbShardGroupIdentifier() != null) {
                data.set("dbShardGroupIdentifier", om.valueToTree(this.getDbShardGroupIdentifier()));
            }
            if (this.getMinAcu() != null) {
                data.set("minAcu", om.valueToTree(this.getMinAcu()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBShardGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBShardGroupProps.Jsii$Proxy that = (CfnDBShardGroupProps.Jsii$Proxy) o;

            if (!dbClusterIdentifier.equals(that.dbClusterIdentifier)) return false;
            if (!maxAcu.equals(that.maxAcu)) return false;
            if (this.computeRedundancy != null ? !this.computeRedundancy.equals(that.computeRedundancy) : that.computeRedundancy != null) return false;
            if (this.dbShardGroupIdentifier != null ? !this.dbShardGroupIdentifier.equals(that.dbShardGroupIdentifier) : that.dbShardGroupIdentifier != null) return false;
            if (this.minAcu != null ? !this.minAcu.equals(that.minAcu) : that.minAcu != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbClusterIdentifier.hashCode();
            result = 31 * result + (this.maxAcu.hashCode());
            result = 31 * result + (this.computeRedundancy != null ? this.computeRedundancy.hashCode() : 0);
            result = 31 * result + (this.dbShardGroupIdentifier != null ? this.dbShardGroupIdentifier.hashCode() : 0);
            result = 31 * result + (this.minAcu != null ? this.minAcu.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
