package software.amazon.awscdk.services.rds;

/**
 * A database cluster engine.
 * <p>
 * Provides mapping to the serverless application
 * used for secret rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_01_0).build()))
 *         .credentials(Credentials.fromGeneratedSecret("clusteradmin")) // Optional - will default to 'admin' username and generated password
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .publiclyAccessible(false)
 *                 .build()))
 *         .readers(List.of(ClusterInstance.provisioned("reader1", ProvisionedClusterInstanceProps.builder().promotionTier(1).build()), ClusterInstance.serverlessV2("reader2")))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:35.693Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterEngine")
public class DatabaseClusterEngine extends software.amazon.jsii.JsiiObject {

    protected DatabaseClusterEngine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseClusterEngine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AURORA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        AURORA_MYSQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA_MYSQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        AURORA_POSTGRESQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA_POSTGRESQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseClusterEngine() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (deprecated) Creates a new plain Aurora database cluster engine.
     * <p>
     * @deprecated use <code>auroraMysql()</code> instead
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine aurora(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "aurora", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Aurora MySQL database cluster engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine auroraMysql(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraMysqlClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "auroraMysql", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Aurora PostgreSQL database cluster engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine auroraPostgres(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "auroraPostgres", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (deprecated) The unversioned 'aurora' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the <code>aurora()</code> method
     * <p>
     * @deprecated use <code>AURORA_MYSQL</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA;

    /**
     * The unversioned 'aurora-msql' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the <code>auroraMysql()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA_MYSQL;

    /**
     * The unversioned 'aurora-postgresql' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the <code>auroraPostgres()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA_POSTGRESQL;
}
