package software.amazon.awscdk.services.rds;

/**
 * Construction properties for a DatabaseProxy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder()
 *                 .version(AuroraMysqlEngineVersion.VER_3_03_0)
 *                 .build()))
 *         .writer(ClusterInstance.provisioned("writer"))
 *         .vpc(vpc)
 *         .build();
 * DatabaseProxy proxy = DatabaseProxy.Builder.create(this, "Proxy")
 *         .proxyTarget(ProxyTarget.fromCluster(cluster))
 *         .secrets(List.of(cluster.getSecret()))
 *         .vpc(vpc)
 *         .build();
 * Role role = Role.Builder.create(this, "DBProxyRole").assumedBy(new AccountPrincipal(this.account)).build();
 * proxy.grantConnect(role, "admin");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:35.751Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseProxyProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseProxyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseProxyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.DatabaseProxyOptions {

    /**
     * DB proxy target: Instance or Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ProxyTarget getProxyTarget();

    /**
     * @return a {@link Builder} of {@link DatabaseProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseProxyProps> {
        software.amazon.awscdk.services.rds.ProxyTarget proxyTarget;
        java.util.List<software.amazon.awscdk.services.secretsmanager.ISecret> secrets;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.Duration borrowTimeout;
        software.amazon.awscdk.services.rds.ClientPasswordAuthType clientPasswordAuthType;
        java.lang.String dbProxyName;
        java.lang.Boolean debugLogging;
        java.lang.Boolean iamAuth;
        software.amazon.awscdk.Duration idleClientTimeout;
        java.lang.String initQuery;
        java.lang.Number maxConnectionsPercent;
        java.lang.Number maxIdleConnectionsPercent;
        java.lang.Boolean requireTls;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.util.List<software.amazon.awscdk.services.rds.SessionPinningFilter> sessionPinningFilters;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link DatabaseProxyProps#getProxyTarget}
         * @param proxyTarget DB proxy target: Instance or Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyTarget(software.amazon.awscdk.services.rds.ProxyTarget proxyTarget) {
            this.proxyTarget = proxyTarget;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getSecrets}
         * @param secrets The secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. This parameter is required.
         *                These secrets are stored within Amazon Secrets Manager.
         *                One or more secrets are required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ISecret> secrets) {
            this.secrets = (java.util.List<software.amazon.awscdk.services.secretsmanager.ISecret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getVpc}
         * @param vpc The VPC to associate with the new proxy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getBorrowTimeout}
         * @param borrowTimeout The duration for a proxy to wait for a connection to become available in the connection pool.
         *                      Only applies when the proxy has opened its maximum number of connections and all connections are busy with client
         *                      sessions.
         *                      <p>
         *                      Value must be between 1 second and 1 hour, or <code>Duration.seconds(0)</code> to represent unlimited.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder borrowTimeout(software.amazon.awscdk.Duration borrowTimeout) {
            this.borrowTimeout = borrowTimeout;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getClientPasswordAuthType}
         * @param clientPasswordAuthType Specifies the details of authentication used by a proxy to log in as a specific database user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientPasswordAuthType(software.amazon.awscdk.services.rds.ClientPasswordAuthType clientPasswordAuthType) {
            this.clientPasswordAuthType = clientPasswordAuthType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getDbProxyName}
         * @param dbProxyName The identifier for the proxy.
         *                    This name must be unique for all proxies owned by your AWS account in the specified AWS Region.
         *                    An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens;
         *                    it can't end with a hyphen or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(java.lang.String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getDebugLogging}
         * @param debugLogging Whether the proxy includes detailed information about SQL statements in its logs.
         *                     This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections.
         *                     The debug information includes the text of SQL statements that you submit through the proxy.
         *                     Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive
         *                     information that appears in the logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(java.lang.Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getIamAuth}
         * @param iamAuth Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuth(java.lang.Boolean iamAuth) {
            this.iamAuth = iamAuth;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getIdleClientTimeout}
         * @param idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         *                          You can set this value higher or lower than the connection timeout limit for the associated database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleClientTimeout(software.amazon.awscdk.Duration idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getInitQuery}
         * @param initQuery One or more SQL statements for the proxy to run when opening each new database connection.
         *                  Typically used with SET statements to make sure that each connection has identical settings such as time zone
         *                  and character set.
         *                  For multiple statements, use semicolons as the separator.
         *                  You can also include multiple variables in a single SET statement, such as SET x=1, y=2.
         *                  <p>
         *                  not currently supported for PostgreSQL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initQuery(java.lang.String initQuery) {
            this.initQuery = initQuery;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getMaxConnectionsPercent}
         * @param maxConnectionsPercent The maximum size of the connection pool for each target in a target group.
         *                              For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB
         *                              cluster used by the target group.
         *                              <p>
         *                              1-100
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnectionsPercent(java.lang.Number maxConnectionsPercent) {
            this.maxConnectionsPercent = maxConnectionsPercent;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getMaxIdleConnectionsPercent}
         * @param maxIdleConnectionsPercent Controls how actively the proxy closes idle database connections in the connection pool.
         *                                  A high value enables the proxy to leave a high percentage of idle connections open.
         *                                  A low value causes the proxy to close idle client connections and return the underlying database connections
         *                                  to the connection pool.
         *                                  For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance
         *                                  or Aurora DB cluster used by the target group.
         *                                  <p>
         *                                  between 0 and MaxConnectionsPercent
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxIdleConnectionsPercent(java.lang.Number maxIdleConnectionsPercent) {
            this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getRequireTls}
         * @param requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         *                   By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(java.lang.Boolean requireTls) {
            this.requireTls = requireTls;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getRole}
         * @param role IAM role that the proxy uses to access secrets in AWS Secrets Manager.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getSecurityGroups}
         * @param securityGroups One or more VPC security groups to associate with the new proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getSessionPinningFilters}
         * @param sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
         *                              Including an item in the list exempts that class of SQL operations from the pinning behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sessionPinningFilters(java.util.List<? extends software.amazon.awscdk.services.rds.SessionPinningFilter> sessionPinningFilters) {
            this.sessionPinningFilters = (java.util.List<software.amazon.awscdk.services.rds.SessionPinningFilter>)sessionPinningFilters;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyProps#getVpcSubnets}
         * @param vpcSubnets The subnets used by the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseProxyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseProxyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseProxyProps {
        private final software.amazon.awscdk.services.rds.ProxyTarget proxyTarget;
        private final java.util.List<software.amazon.awscdk.services.secretsmanager.ISecret> secrets;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.Duration borrowTimeout;
        private final software.amazon.awscdk.services.rds.ClientPasswordAuthType clientPasswordAuthType;
        private final java.lang.String dbProxyName;
        private final java.lang.Boolean debugLogging;
        private final java.lang.Boolean iamAuth;
        private final software.amazon.awscdk.Duration idleClientTimeout;
        private final java.lang.String initQuery;
        private final java.lang.Number maxConnectionsPercent;
        private final java.lang.Number maxIdleConnectionsPercent;
        private final java.lang.Boolean requireTls;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.util.List<software.amazon.awscdk.services.rds.SessionPinningFilter> sessionPinningFilters;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.proxyTarget = software.amazon.jsii.Kernel.get(this, "proxyTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProxyTarget.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.borrowTimeout = software.amazon.jsii.Kernel.get(this, "borrowTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.clientPasswordAuthType = software.amazon.jsii.Kernel.get(this, "clientPasswordAuthType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClientPasswordAuthType.class));
            this.dbProxyName = software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.debugLogging = software.amazon.jsii.Kernel.get(this, "debugLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iamAuth = software.amazon.jsii.Kernel.get(this, "iamAuth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.idleClientTimeout = software.amazon.jsii.Kernel.get(this, "idleClientTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.initQuery = software.amazon.jsii.Kernel.get(this, "initQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxIdleConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxIdleConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requireTls = software.amazon.jsii.Kernel.get(this, "requireTLS", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.sessionPinningFilters = software.amazon.jsii.Kernel.get(this, "sessionPinningFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SessionPinningFilter.class)));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.proxyTarget = java.util.Objects.requireNonNull(builder.proxyTarget, "proxyTarget is required");
            this.secrets = (java.util.List<software.amazon.awscdk.services.secretsmanager.ISecret>)java.util.Objects.requireNonNull(builder.secrets, "secrets is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.borrowTimeout = builder.borrowTimeout;
            this.clientPasswordAuthType = builder.clientPasswordAuthType;
            this.dbProxyName = builder.dbProxyName;
            this.debugLogging = builder.debugLogging;
            this.iamAuth = builder.iamAuth;
            this.idleClientTimeout = builder.idleClientTimeout;
            this.initQuery = builder.initQuery;
            this.maxConnectionsPercent = builder.maxConnectionsPercent;
            this.maxIdleConnectionsPercent = builder.maxIdleConnectionsPercent;
            this.requireTls = builder.requireTls;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.sessionPinningFilters = (java.util.List<software.amazon.awscdk.services.rds.SessionPinningFilter>)builder.sessionPinningFilters;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ProxyTarget getProxyTarget() {
            return this.proxyTarget;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.secretsmanager.ISecret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.Duration getBorrowTimeout() {
            return this.borrowTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ClientPasswordAuthType getClientPasswordAuthType() {
            return this.clientPasswordAuthType;
        }

        @Override
        public final java.lang.String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final java.lang.Boolean getDebugLogging() {
            return this.debugLogging;
        }

        @Override
        public final java.lang.Boolean getIamAuth() {
            return this.iamAuth;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdleClientTimeout() {
            return this.idleClientTimeout;
        }

        @Override
        public final java.lang.String getInitQuery() {
            return this.initQuery;
        }

        @Override
        public final java.lang.Number getMaxConnectionsPercent() {
            return this.maxConnectionsPercent;
        }

        @Override
        public final java.lang.Number getMaxIdleConnectionsPercent() {
            return this.maxIdleConnectionsPercent;
        }

        @Override
        public final java.lang.Boolean getRequireTLS() {
            return this.requireTls;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.rds.SessionPinningFilter> getSessionPinningFilters() {
            return this.sessionPinningFilters;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("proxyTarget", om.valueToTree(this.getProxyTarget()));
            data.set("secrets", om.valueToTree(this.getSecrets()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getBorrowTimeout() != null) {
                data.set("borrowTimeout", om.valueToTree(this.getBorrowTimeout()));
            }
            if (this.getClientPasswordAuthType() != null) {
                data.set("clientPasswordAuthType", om.valueToTree(this.getClientPasswordAuthType()));
            }
            if (this.getDbProxyName() != null) {
                data.set("dbProxyName", om.valueToTree(this.getDbProxyName()));
            }
            if (this.getDebugLogging() != null) {
                data.set("debugLogging", om.valueToTree(this.getDebugLogging()));
            }
            if (this.getIamAuth() != null) {
                data.set("iamAuth", om.valueToTree(this.getIamAuth()));
            }
            if (this.getIdleClientTimeout() != null) {
                data.set("idleClientTimeout", om.valueToTree(this.getIdleClientTimeout()));
            }
            if (this.getInitQuery() != null) {
                data.set("initQuery", om.valueToTree(this.getInitQuery()));
            }
            if (this.getMaxConnectionsPercent() != null) {
                data.set("maxConnectionsPercent", om.valueToTree(this.getMaxConnectionsPercent()));
            }
            if (this.getMaxIdleConnectionsPercent() != null) {
                data.set("maxIdleConnectionsPercent", om.valueToTree(this.getMaxIdleConnectionsPercent()));
            }
            if (this.getRequireTLS() != null) {
                data.set("requireTLS", om.valueToTree(this.getRequireTLS()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSessionPinningFilters() != null) {
                data.set("sessionPinningFilters", om.valueToTree(this.getSessionPinningFilters()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseProxyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseProxyProps.Jsii$Proxy that = (DatabaseProxyProps.Jsii$Proxy) o;

            if (!proxyTarget.equals(that.proxyTarget)) return false;
            if (!secrets.equals(that.secrets)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.borrowTimeout != null ? !this.borrowTimeout.equals(that.borrowTimeout) : that.borrowTimeout != null) return false;
            if (this.clientPasswordAuthType != null ? !this.clientPasswordAuthType.equals(that.clientPasswordAuthType) : that.clientPasswordAuthType != null) return false;
            if (this.dbProxyName != null ? !this.dbProxyName.equals(that.dbProxyName) : that.dbProxyName != null) return false;
            if (this.debugLogging != null ? !this.debugLogging.equals(that.debugLogging) : that.debugLogging != null) return false;
            if (this.iamAuth != null ? !this.iamAuth.equals(that.iamAuth) : that.iamAuth != null) return false;
            if (this.idleClientTimeout != null ? !this.idleClientTimeout.equals(that.idleClientTimeout) : that.idleClientTimeout != null) return false;
            if (this.initQuery != null ? !this.initQuery.equals(that.initQuery) : that.initQuery != null) return false;
            if (this.maxConnectionsPercent != null ? !this.maxConnectionsPercent.equals(that.maxConnectionsPercent) : that.maxConnectionsPercent != null) return false;
            if (this.maxIdleConnectionsPercent != null ? !this.maxIdleConnectionsPercent.equals(that.maxIdleConnectionsPercent) : that.maxIdleConnectionsPercent != null) return false;
            if (this.requireTls != null ? !this.requireTls.equals(that.requireTls) : that.requireTls != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.sessionPinningFilters != null ? !this.sessionPinningFilters.equals(that.sessionPinningFilters) : that.sessionPinningFilters != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.proxyTarget.hashCode();
            result = 31 * result + (this.secrets.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.borrowTimeout != null ? this.borrowTimeout.hashCode() : 0);
            result = 31 * result + (this.clientPasswordAuthType != null ? this.clientPasswordAuthType.hashCode() : 0);
            result = 31 * result + (this.dbProxyName != null ? this.dbProxyName.hashCode() : 0);
            result = 31 * result + (this.debugLogging != null ? this.debugLogging.hashCode() : 0);
            result = 31 * result + (this.iamAuth != null ? this.iamAuth.hashCode() : 0);
            result = 31 * result + (this.idleClientTimeout != null ? this.idleClientTimeout.hashCode() : 0);
            result = 31 * result + (this.initQuery != null ? this.initQuery.hashCode() : 0);
            result = 31 * result + (this.maxConnectionsPercent != null ? this.maxConnectionsPercent.hashCode() : 0);
            result = 31 * result + (this.maxIdleConnectionsPercent != null ? this.maxIdleConnectionsPercent.hashCode() : 0);
            result = 31 * result + (this.requireTls != null ? this.requireTls.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.sessionPinningFilters != null ? this.sessionPinningFilters.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
