package software.amazon.awscdk.services.s3;

/**
 * The replication time value used for S3 Replication Time Control (S3 RTC).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IBucket destinationBucket1;
 * IBucket destinationBucket2;
 * IKey kmsKey;
 * Bucket sourceBucket = Bucket.Builder.create(this, "SourceBucket")
 *         // Versioning must be enabled on both the source and destination bucket
 *         .versioned(true)
 *         .replicationRules(List.of(ReplicationRule.builder()
 *                 // The destination bucket for the replication rule.
 *                 .destination(destinationBucket1)
 *                 // The priority of the rule.
 *                 // Amazon S3 will attempt to replicate objects according to all replication rules.
 *                 // However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority.
 *                 // The higher the number, the higher the priority.
 *                 // It is essential to specify priority explicitly when the replication configuration has multiple rules.
 *                 .priority(1)
 *                 .build(), ReplicationRule.builder()
 *                 .destination(destinationBucket2)
 *                 .priority(2)
 *                 // Whether to specify S3 Replication Time Control (S3 RTC).
 *                 // S3 RTC replicates most objects that you upload to Amazon S3 in seconds,
 *                 // and 99.99 percent of those objects within specified time.
 *                 .replicationTimeControl(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // Whether to enable replication metrics about S3 RTC.
 *                 // If set, metrics will be output to indicate whether replication by S3 RTC took longer than the configured time.
 *                 .metrics(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // The kms key to use for the destination bucket.
 *                 .kmsKey(kmsKey)
 *                 // The storage class to use for the destination bucket.
 *                 .storageClass(StorageClass.INFREQUENT_ACCESS)
 *                 // Whether to replicate objects with SSE-KMS encryption.
 *                 .sseKmsEncryptedObjects(false)
 *                 // Whether to replicate modifications on replicas.
 *                 .replicaModifications(true)
 *                 // Whether to replicate delete markers.
 *                 // This property cannot be enabled if the replication rule has a tag filter.
 *                 .deleteMarkerReplication(false)
 *                 // The ID of the rule.
 *                 .id("full-settings-rule")
 *                 // The object filter for the rule.
 *                 .filter(Filter.builder()
 *                         // The prefix filter for the rule.
 *                         .prefix("prefix")
 *                         // The tag filter for the rule.
 *                         .tags(List.of(Tag.builder()
 *                                 .key("tagKey")
 *                                 .value("tagValue")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:36.367Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.ReplicationTimeValue")
public class ReplicationTimeValue extends software.amazon.jsii.JsiiObject {

    protected ReplicationTimeValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReplicationTimeValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        FIFTEEN_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.ReplicationTimeValue.class, "FIFTEEN_MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ReplicationTimeValue.class));
    }

    /**
     * Fifteen minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.s3.ReplicationTimeValue FIFTEEN_MINUTES;

    /**
     * the time in minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinutes() {
        return software.amazon.jsii.Kernel.get(this, "minutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
