package software.amazon.awscdk.services.secretsmanager;

/**
 * Creates a new secret.
 * <p>
 * A <em>secret</em> can be a password, a set of credentials such as a user name and password, an OAuth token, or other secret information that you store in an encrypted form in Secrets Manager.
 * <p>
 * For Amazon RDS master user credentials, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-masterusersecret.html">AWS::RDS::DBCluster MasterUserSecret</a> .
 * <p>
 * For Amazon Redshift admin user credentials, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-cluster.html">AWS::Redshift::Cluster</a> .
 * <p>
 * To retrieve a secret in a CloudFormation template, use a <em>dynamic reference</em> . For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/cfn-example_reference-secret.html">Retrieve a secret in an AWS CloudFormation resource</a> .
 * <p>
 * For information about creating a secret in the console, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_create-basic-secret.html">Create a secret</a> . For information about creating a secret using the CLI or SDK, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret</a> .
 * <p>
 * For information about retrieving a secret in code, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/retrieving-secrets.html">Retrieve secrets from Secrets Manager</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnSecret cfnSecret = CfnSecret.Builder.create(this, "MyCfnSecret")
 *         .description("description")
 *         .generateSecretString(GenerateSecretStringProperty.builder()
 *                 .excludeCharacters("excludeCharacters")
 *                 .excludeLowercase(false)
 *                 .excludeNumbers(false)
 *                 .excludePunctuation(false)
 *                 .excludeUppercase(false)
 *                 .generateStringKey("generateStringKey")
 *                 .includeSpace(false)
 *                 .passwordLength(123)
 *                 .requireEachIncludedType(false)
 *                 .secretStringTemplate("secretStringTemplate")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .name("name")
 *         .replicaRegions(List.of(ReplicaRegionProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build()))
 *         .secretString("secretString")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:36.930Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnSecret")
public class CfnSecret extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.CfnSecret.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The description of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A structure that specifies how to generate a password to encrypt and store in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecretString() {
        return software.amazon.jsii.Kernel.get(this, "generateSecretString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that specifies how to generate a password to encrypt and store in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecretString(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "generateSecretString", value);
    }

    /**
     * A structure that specifies how to generate a password to encrypt and store in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecretString(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnSecret.GenerateSecretStringProperty value) {
        software.amazon.jsii.Kernel.set(this, "generateSecretString", value);
    }

    /**
     * The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The name of the new secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the new secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplicaRegions() {
        return software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaRegions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicaRegions", value);
    }

    /**
     * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicaRegions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.secretsmanager.CfnSecret.ReplicaRegionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.secretsmanager.CfnSecret.ReplicaRegionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "replicaRegions", value);
    }

    /**
     * The text to encrypt and store in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecretString() {
        return software.amazon.jsii.Kernel.get(this, "secretString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The text to encrypt and store in the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecretString(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "secretString", value);
    }

    /**
     * A list of tags to attach to the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of tags to attach to the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Generates a random password.
     * <p>
     * We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
     * <p>
     * <em>Required permissions:</em> <code>secretsmanager:GetRandomPassword</code> . For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions">IAM policy actions for Secrets Manager</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html">Authentication and access control in Secrets Manager</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * GenerateSecretStringProperty generateSecretStringProperty = GenerateSecretStringProperty.builder()
     *         .excludeCharacters("excludeCharacters")
     *         .excludeLowercase(false)
     *         .excludeNumbers(false)
     *         .excludePunctuation(false)
     *         .excludeUppercase(false)
     *         .generateStringKey("generateStringKey")
     *         .includeSpace(false)
     *         .passwordLength(123)
     *         .requireEachIncludedType(false)
     *         .secretStringTemplate("secretStringTemplate")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnSecret.GenerateSecretStringProperty")
    @software.amazon.jsii.Jsii.Proxy(GenerateSecretStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GenerateSecretStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string of the characters that you don't want in the password.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludecharacters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludecharacters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
            return null;
        }

        /**
         * Specifies whether to exclude lowercase letters from the password.
         * <p>
         * If you don't include this switch, the password can contain lowercase letters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludelowercase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludelowercase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeLowercase() {
            return null;
        }

        /**
         * Specifies whether to exclude numbers from the password.
         * <p>
         * If you don't include this switch, the password can contain numbers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludenumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludenumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeNumbers() {
            return null;
        }

        /**
         * Specifies whether to exclude the following punctuation characters from the password: `!
         * <p>
         * " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? &#64; [ \ ] ^ _ <code> { | } ~</code> . If you don't include this switch, the password can contain punctuation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludepunctuation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludepunctuation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludePunctuation() {
            return null;
        }

        /**
         * Specifies whether to exclude uppercase letters from the password.
         * <p>
         * If you don't include this switch, the password can contain uppercase letters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludeuppercase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-excludeuppercase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeUppercase() {
            return null;
        }

        /**
         * The JSON key name for the key/value pair, where the value is the generated password.
         * <p>
         * This pair is added to the JSON structure specified by the <code>SecretStringTemplate</code> parameter. If you specify this parameter, then you must also specify <code>SecretStringTemplate</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-generatestringkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-generatestringkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGenerateStringKey() {
            return null;
        }

        /**
         * Specifies whether to include the space character.
         * <p>
         * If you include this switch, the password can contain space characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-includespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-includespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSpace() {
            return null;
        }

        /**
         * The length of the password.
         * <p>
         * If you don't include this parameter, the default length is 32 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-passwordlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-passwordlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPasswordLength() {
            return null;
        }

        /**
         * Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
         * <p>
         * If you don't include this switch, the password contains at least one of every character type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-requireeachincludedtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-requireeachincludedtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireEachIncludedType() {
            return null;
        }

        /**
         * A template that the generated string must match.
         * <p>
         * When you make a change to this property, a new secret version is created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-secretstringtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-generatesecretstring.html#cfn-secretsmanager-secret-generatesecretstring-secretstringtemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretStringTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GenerateSecretStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GenerateSecretStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GenerateSecretStringProperty> {
            java.lang.String excludeCharacters;
            java.lang.Object excludeLowercase;
            java.lang.Object excludeNumbers;
            java.lang.Object excludePunctuation;
            java.lang.Object excludeUppercase;
            java.lang.String generateStringKey;
            java.lang.Object includeSpace;
            java.lang.Number passwordLength;
            java.lang.Object requireEachIncludedType;
            java.lang.String secretStringTemplate;

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeCharacters}
             * @param excludeCharacters A string of the characters that you don't want in the password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeCharacters(java.lang.String excludeCharacters) {
                this.excludeCharacters = excludeCharacters;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeLowercase}
             * @param excludeLowercase Specifies whether to exclude lowercase letters from the password.
             *                         If you don't include this switch, the password can contain lowercase letters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeLowercase(java.lang.Boolean excludeLowercase) {
                this.excludeLowercase = excludeLowercase;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeLowercase}
             * @param excludeLowercase Specifies whether to exclude lowercase letters from the password.
             *                         If you don't include this switch, the password can contain lowercase letters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeLowercase(software.amazon.awscdk.IResolvable excludeLowercase) {
                this.excludeLowercase = excludeLowercase;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeNumbers}
             * @param excludeNumbers Specifies whether to exclude numbers from the password.
             *                       If you don't include this switch, the password can contain numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeNumbers(java.lang.Boolean excludeNumbers) {
                this.excludeNumbers = excludeNumbers;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeNumbers}
             * @param excludeNumbers Specifies whether to exclude numbers from the password.
             *                       If you don't include this switch, the password can contain numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeNumbers(software.amazon.awscdk.IResolvable excludeNumbers) {
                this.excludeNumbers = excludeNumbers;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludePunctuation}
             * @param excludePunctuation Specifies whether to exclude the following punctuation characters from the password: `!.
             *                           " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? &#64; [ \ ] ^ _ <code> { | } ~</code> . If you don't include this switch, the password can contain punctuation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludePunctuation(java.lang.Boolean excludePunctuation) {
                this.excludePunctuation = excludePunctuation;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludePunctuation}
             * @param excludePunctuation Specifies whether to exclude the following punctuation characters from the password: `!.
             *                           " # $ % &amp; ' ( ) * + , - . / : ; &lt; = &gt; ? &#64; [ \ ] ^ _ <code> { | } ~</code> . If you don't include this switch, the password can contain punctuation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludePunctuation(software.amazon.awscdk.IResolvable excludePunctuation) {
                this.excludePunctuation = excludePunctuation;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeUppercase}
             * @param excludeUppercase Specifies whether to exclude uppercase letters from the password.
             *                         If you don't include this switch, the password can contain uppercase letters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeUppercase(java.lang.Boolean excludeUppercase) {
                this.excludeUppercase = excludeUppercase;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getExcludeUppercase}
             * @param excludeUppercase Specifies whether to exclude uppercase letters from the password.
             *                         If you don't include this switch, the password can contain uppercase letters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeUppercase(software.amazon.awscdk.IResolvable excludeUppercase) {
                this.excludeUppercase = excludeUppercase;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getGenerateStringKey}
             * @param generateStringKey The JSON key name for the key/value pair, where the value is the generated password.
             *                          This pair is added to the JSON structure specified by the <code>SecretStringTemplate</code> parameter. If you specify this parameter, then you must also specify <code>SecretStringTemplate</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generateStringKey(java.lang.String generateStringKey) {
                this.generateStringKey = generateStringKey;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getIncludeSpace}
             * @param includeSpace Specifies whether to include the space character.
             *                     If you include this switch, the password can contain space characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSpace(java.lang.Boolean includeSpace) {
                this.includeSpace = includeSpace;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getIncludeSpace}
             * @param includeSpace Specifies whether to include the space character.
             *                     If you include this switch, the password can contain space characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSpace(software.amazon.awscdk.IResolvable includeSpace) {
                this.includeSpace = includeSpace;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getPasswordLength}
             * @param passwordLength The length of the password.
             *                       If you don't include this parameter, the default length is 32 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordLength(java.lang.Number passwordLength) {
                this.passwordLength = passwordLength;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getRequireEachIncludedType}
             * @param requireEachIncludedType Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
             *                                If you don't include this switch, the password contains at least one of every character type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEachIncludedType(java.lang.Boolean requireEachIncludedType) {
                this.requireEachIncludedType = requireEachIncludedType;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getRequireEachIncludedType}
             * @param requireEachIncludedType Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
             *                                If you don't include this switch, the password contains at least one of every character type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireEachIncludedType(software.amazon.awscdk.IResolvable requireEachIncludedType) {
                this.requireEachIncludedType = requireEachIncludedType;
                return this;
            }

            /**
             * Sets the value of {@link GenerateSecretStringProperty#getSecretStringTemplate}
             * @param secretStringTemplate A template that the generated string must match.
             *                             When you make a change to this property, a new secret version is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretStringTemplate(java.lang.String secretStringTemplate) {
                this.secretStringTemplate = secretStringTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GenerateSecretStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GenerateSecretStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GenerateSecretStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GenerateSecretStringProperty {
            private final java.lang.String excludeCharacters;
            private final java.lang.Object excludeLowercase;
            private final java.lang.Object excludeNumbers;
            private final java.lang.Object excludePunctuation;
            private final java.lang.Object excludeUppercase;
            private final java.lang.String generateStringKey;
            private final java.lang.Object includeSpace;
            private final java.lang.Number passwordLength;
            private final java.lang.Object requireEachIncludedType;
            private final java.lang.String secretStringTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeLowercase = software.amazon.jsii.Kernel.get(this, "excludeLowercase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeNumbers = software.amazon.jsii.Kernel.get(this, "excludeNumbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludePunctuation = software.amazon.jsii.Kernel.get(this, "excludePunctuation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeUppercase = software.amazon.jsii.Kernel.get(this, "excludeUppercase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generateStringKey = software.amazon.jsii.Kernel.get(this, "generateStringKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeSpace = software.amazon.jsii.Kernel.get(this, "includeSpace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passwordLength = software.amazon.jsii.Kernel.get(this, "passwordLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireEachIncludedType = software.amazon.jsii.Kernel.get(this, "requireEachIncludedType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretStringTemplate = software.amazon.jsii.Kernel.get(this, "secretStringTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludeCharacters = builder.excludeCharacters;
                this.excludeLowercase = builder.excludeLowercase;
                this.excludeNumbers = builder.excludeNumbers;
                this.excludePunctuation = builder.excludePunctuation;
                this.excludeUppercase = builder.excludeUppercase;
                this.generateStringKey = builder.generateStringKey;
                this.includeSpace = builder.includeSpace;
                this.passwordLength = builder.passwordLength;
                this.requireEachIncludedType = builder.requireEachIncludedType;
                this.secretStringTemplate = builder.secretStringTemplate;
            }

            @Override
            public final java.lang.String getExcludeCharacters() {
                return this.excludeCharacters;
            }

            @Override
            public final java.lang.Object getExcludeLowercase() {
                return this.excludeLowercase;
            }

            @Override
            public final java.lang.Object getExcludeNumbers() {
                return this.excludeNumbers;
            }

            @Override
            public final java.lang.Object getExcludePunctuation() {
                return this.excludePunctuation;
            }

            @Override
            public final java.lang.Object getExcludeUppercase() {
                return this.excludeUppercase;
            }

            @Override
            public final java.lang.String getGenerateStringKey() {
                return this.generateStringKey;
            }

            @Override
            public final java.lang.Object getIncludeSpace() {
                return this.includeSpace;
            }

            @Override
            public final java.lang.Number getPasswordLength() {
                return this.passwordLength;
            }

            @Override
            public final java.lang.Object getRequireEachIncludedType() {
                return this.requireEachIncludedType;
            }

            @Override
            public final java.lang.String getSecretStringTemplate() {
                return this.secretStringTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludeCharacters() != null) {
                    data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
                }
                if (this.getExcludeLowercase() != null) {
                    data.set("excludeLowercase", om.valueToTree(this.getExcludeLowercase()));
                }
                if (this.getExcludeNumbers() != null) {
                    data.set("excludeNumbers", om.valueToTree(this.getExcludeNumbers()));
                }
                if (this.getExcludePunctuation() != null) {
                    data.set("excludePunctuation", om.valueToTree(this.getExcludePunctuation()));
                }
                if (this.getExcludeUppercase() != null) {
                    data.set("excludeUppercase", om.valueToTree(this.getExcludeUppercase()));
                }
                if (this.getGenerateStringKey() != null) {
                    data.set("generateStringKey", om.valueToTree(this.getGenerateStringKey()));
                }
                if (this.getIncludeSpace() != null) {
                    data.set("includeSpace", om.valueToTree(this.getIncludeSpace()));
                }
                if (this.getPasswordLength() != null) {
                    data.set("passwordLength", om.valueToTree(this.getPasswordLength()));
                }
                if (this.getRequireEachIncludedType() != null) {
                    data.set("requireEachIncludedType", om.valueToTree(this.getRequireEachIncludedType()));
                }
                if (this.getSecretStringTemplate() != null) {
                    data.set("secretStringTemplate", om.valueToTree(this.getSecretStringTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnSecret.GenerateSecretStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GenerateSecretStringProperty.Jsii$Proxy that = (GenerateSecretStringProperty.Jsii$Proxy) o;

                if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
                if (this.excludeLowercase != null ? !this.excludeLowercase.equals(that.excludeLowercase) : that.excludeLowercase != null) return false;
                if (this.excludeNumbers != null ? !this.excludeNumbers.equals(that.excludeNumbers) : that.excludeNumbers != null) return false;
                if (this.excludePunctuation != null ? !this.excludePunctuation.equals(that.excludePunctuation) : that.excludePunctuation != null) return false;
                if (this.excludeUppercase != null ? !this.excludeUppercase.equals(that.excludeUppercase) : that.excludeUppercase != null) return false;
                if (this.generateStringKey != null ? !this.generateStringKey.equals(that.generateStringKey) : that.generateStringKey != null) return false;
                if (this.includeSpace != null ? !this.includeSpace.equals(that.includeSpace) : that.includeSpace != null) return false;
                if (this.passwordLength != null ? !this.passwordLength.equals(that.passwordLength) : that.passwordLength != null) return false;
                if (this.requireEachIncludedType != null ? !this.requireEachIncludedType.equals(that.requireEachIncludedType) : that.requireEachIncludedType != null) return false;
                return this.secretStringTemplate != null ? this.secretStringTemplate.equals(that.secretStringTemplate) : that.secretStringTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0;
                result = 31 * result + (this.excludeLowercase != null ? this.excludeLowercase.hashCode() : 0);
                result = 31 * result + (this.excludeNumbers != null ? this.excludeNumbers.hashCode() : 0);
                result = 31 * result + (this.excludePunctuation != null ? this.excludePunctuation.hashCode() : 0);
                result = 31 * result + (this.excludeUppercase != null ? this.excludeUppercase.hashCode() : 0);
                result = 31 * result + (this.generateStringKey != null ? this.generateStringKey.hashCode() : 0);
                result = 31 * result + (this.includeSpace != null ? this.includeSpace.hashCode() : 0);
                result = 31 * result + (this.passwordLength != null ? this.passwordLength.hashCode() : 0);
                result = 31 * result + (this.requireEachIncludedType != null ? this.requireEachIncludedType.hashCode() : 0);
                result = 31 * result + (this.secretStringTemplate != null ? this.secretStringTemplate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * ReplicaRegionProperty replicaRegionProperty = ReplicaRegionProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnSecret.ReplicaRegionProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaRegionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaRegionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string that represents a <code>Region</code> , for example "us-east-1".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html#cfn-secretsmanager-secret-replicaregion-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html#cfn-secretsmanager-secret-replicaregion-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The ARN, key ID, or alias of the KMS key to encrypt the secret.
         * <p>
         * If you don't include this field, Secrets Manager uses <code>aws/secretsmanager</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html#cfn-secretsmanager-secret-replicaregion-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-secret-replicaregion.html#cfn-secretsmanager-secret-replicaregion-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicaRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaRegionProperty> {
            java.lang.String region;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ReplicaRegionProperty#getRegion}
             * @param region A string that represents a <code>Region</code> , for example "us-east-1". This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaRegionProperty#getKmsKeyId}
             * @param kmsKeyId The ARN, key ID, or alias of the KMS key to encrypt the secret.
             *                 If you don't include this field, Secrets Manager uses <code>aws/secretsmanager</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaRegionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaRegionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaRegionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaRegionProperty {
            private final java.lang.String region;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnSecret.ReplicaRegionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaRegionProperty.Jsii$Proxy that = (ReplicaRegionProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.CfnSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.CfnSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.secretsmanager.CfnSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The description of the secret.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-description</a>
         * @param description The description of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * A structure that specifies how to generate a password to encrypt and store in the secret.
         * <p>
         * To include a specific string in the secret, use <code>SecretString</code> instead. If you omit both <code>GenerateSecretString</code> and <code>SecretString</code> , you create an empty secret. When you make a change to this property, a new secret version is created.
         * <p>
         * We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-generatesecretstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-generatesecretstring</a>
         * @param generateSecretString A structure that specifies how to generate a password to encrypt and store in the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(final software.amazon.awscdk.IResolvable generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }
        /**
         * A structure that specifies how to generate a password to encrypt and store in the secret.
         * <p>
         * To include a specific string in the secret, use <code>SecretString</code> instead. If you omit both <code>GenerateSecretString</code> and <code>SecretString</code> , you create an empty secret. When you make a change to this property, a new secret version is created.
         * <p>
         * We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-generatesecretstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-generatesecretstring</a>
         * @param generateSecretString A structure that specifies how to generate a password to encrypt and store in the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(final software.amazon.awscdk.services.secretsmanager.CfnSecret.GenerateSecretStringProperty generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        /**
         * The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret.
         * <p>
         * An alias is always prefixed by <code>alias/</code> , for example <code>alias/aws/secretsmanager</code> . For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html">About aliases</a> .
         * <p>
         * To use a AWS KMS key in a different account, use the key ARN or the alias ARN.
         * <p>
         * If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         * <p>
         * If the secret is in a different AWS account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed AWS KMS key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-kmskeyid</a>
         * @param kmsKeyId The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The name of the new secret.
         * <p>
         * The secret name can contain ASCII letters, numbers, and the following characters: /_+=.&#64;-
         * <p>
         * Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-name</a>
         * @param name The name of the new secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-replicaregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-replicaregions</a>
         * @param replicaRegions A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaRegions(final software.amazon.awscdk.IResolvable replicaRegions) {
            this.props().replicaRegions(replicaRegions);
            return this;
        }
        /**
         * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-replicaregions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-replicaregions</a>
         * @param replicaRegions A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaRegions(final java.util.List<? extends java.lang.Object> replicaRegions) {
            this.props().replicaRegions(replicaRegions);
            return this;
        }

        /**
         * The text to encrypt and store in the secret.
         * <p>
         * We recommend you use a JSON structure of key/value pairs for your secret value. To generate a random password, use <code>GenerateSecretString</code> instead. If you omit both <code>GenerateSecretString</code> and <code>SecretString</code> , you create an empty secret. When you make a change to this property, a new secret version is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-secretstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-secretstring</a>
         * @param secretString The text to encrypt and store in the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretString(final java.lang.String secretString) {
            this.props().secretString(secretString);
            return this;
        }

        /**
         * A list of tags to attach to the secret.
         * <p>
         * Each tag is a key and value pair of strings in a JSON text string, for example:
         * <p>
         * <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code>
         * <p>
         * Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".
         * <p>
         * Stack-level tags, tags you apply to the CloudFormation stack, are also attached to the secret.
         * <p>
         * If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a> .
         * <p>
         * For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> . If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.
         * <p>
         * The following restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per secret: 50</li>
         * <li>Maximum key length: 127 Unicode characters in UTF-8</li>
         * <li>Maximum value length: 255 Unicode characters in UTF-8</li>
         * <li>Tag keys and values are case sensitive.</li>
         * <li>Do not use the <code>aws:</code> prefix in your tag names or values because AWS reserves it for AWS use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</li>
         * <li>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : /</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secret.html#cfn-secretsmanager-secret-tags</a>
         * @param tags A list of tags to attach to the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.CfnSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.CfnSecret build() {
            return new software.amazon.awscdk.services.secretsmanager.CfnSecret(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.secretsmanager.CfnSecretProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.secretsmanager.CfnSecretProps.Builder();
            }
            return this.props;
        }
    }
}
