package software.amazon.awscdk.services.ses;

/**
 * BoundAction configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * BounceActionConfig bounceActionConfig = BounceActionConfig.builder()
 *         .message("message")
 *         .sender("sender")
 *         .smtpReplyCode("smtpReplyCode")
 *         // the properties below are optional
 *         .statusCode("statusCode")
 *         .topicArn("topicArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.213Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.BounceActionConfig")
@software.amazon.jsii.Jsii.Proxy(BounceActionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BounceActionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Human-readable text to include in the bounce message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMessage();

    /**
     * The email address of the sender of the bounced email.
     * <p>
     * This is the address that the bounce message is sent from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSender();

    /**
     * The SMTP reply code, as defined by RFC 5321.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSmtpReplyCode();

    /**
     * The SMTP enhanced status code, as defined by RFC 3463.
     * <p>
     * Default: - No status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
     * <p>
     * Default: - No notification is sent to SNS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BounceActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BounceActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BounceActionConfig> {
        java.lang.String message;
        java.lang.String sender;
        java.lang.String smtpReplyCode;
        java.lang.String statusCode;
        java.lang.String topicArn;

        /**
         * Sets the value of {@link BounceActionConfig#getMessage}
         * @param message Human-readable text to include in the bounce message. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(java.lang.String message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link BounceActionConfig#getSender}
         * @param sender The email address of the sender of the bounced email. This parameter is required.
         *               This is the address that the bounce message is sent from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sender(java.lang.String sender) {
            this.sender = sender;
            return this;
        }

        /**
         * Sets the value of {@link BounceActionConfig#getSmtpReplyCode}
         * @param smtpReplyCode The SMTP reply code, as defined by RFC 5321. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smtpReplyCode(java.lang.String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        /**
         * Sets the value of {@link BounceActionConfig#getStatusCode}
         * @param statusCode The SMTP enhanced status code, as defined by RFC 3463.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link BounceActionConfig#getTopicArn}
         * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicArn(java.lang.String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BounceActionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BounceActionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BounceActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BounceActionConfig {
        private final java.lang.String message;
        private final java.lang.String sender;
        private final java.lang.String smtpReplyCode;
        private final java.lang.String statusCode;
        private final java.lang.String topicArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sender = software.amazon.jsii.Kernel.get(this, "sender", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smtpReplyCode = software.amazon.jsii.Kernel.get(this, "smtpReplyCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            this.sender = java.util.Objects.requireNonNull(builder.sender, "sender is required");
            this.smtpReplyCode = java.util.Objects.requireNonNull(builder.smtpReplyCode, "smtpReplyCode is required");
            this.statusCode = builder.statusCode;
            this.topicArn = builder.topicArn;
        }

        @Override
        public final java.lang.String getMessage() {
            return this.message;
        }

        @Override
        public final java.lang.String getSender() {
            return this.sender;
        }

        @Override
        public final java.lang.String getSmtpReplyCode() {
            return this.smtpReplyCode;
        }

        @Override
        public final java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final java.lang.String getTopicArn() {
            return this.topicArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("message", om.valueToTree(this.getMessage()));
            data.set("sender", om.valueToTree(this.getSender()));
            data.set("smtpReplyCode", om.valueToTree(this.getSmtpReplyCode()));
            if (this.getStatusCode() != null) {
                data.set("statusCode", om.valueToTree(this.getStatusCode()));
            }
            if (this.getTopicArn() != null) {
                data.set("topicArn", om.valueToTree(this.getTopicArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.BounceActionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BounceActionConfig.Jsii$Proxy that = (BounceActionConfig.Jsii$Proxy) o;

            if (!message.equals(that.message)) return false;
            if (!sender.equals(that.sender)) return false;
            if (!smtpReplyCode.equals(that.smtpReplyCode)) return false;
            if (this.statusCode != null ? !this.statusCode.equals(that.statusCode) : that.statusCode != null) return false;
            return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.message.hashCode();
            result = 31 * result + (this.sender.hashCode());
            result = 31 * result + (this.smtpReplyCode.hashCode());
            result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
            result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
            return result;
        }
    }
}
