package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnDedicatedIpPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnDedicatedIpPoolProps cfnDedicatedIpPoolProps = CfnDedicatedIpPoolProps.builder()
 *         .poolName("poolName")
 *         .scalingMode("scalingMode")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnDedicatedIpPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnDedicatedIpPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDedicatedIpPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the dedicated IP pool that the IP address is associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html#cfn-ses-dedicatedippool-poolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html#cfn-ses-dedicatedippool-poolname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPoolName() {
        return null;
    }

    /**
     * The type of scaling mode.
     * <p>
     * The following options are available:
     * <p>
     * <ul>
     * <li><code>STANDARD</code> - The customer controls which IPs are part of the dedicated IP pool.</li>
     * <li><code>MANAGED</code> - The reputation and number of IPs are automatically managed by Amazon SES .</li>
     * </ul>
     * <p>
     * The <code>STANDARD</code> option is selected by default if no value is specified.
     * <p>
     * <blockquote>
     * <p>
     * Updating <em>ScalingMode</em> doesn't require a replacement if you're updating its value from <code>STANDARD</code> to <code>MANAGED</code> . However, updating <em>ScalingMode</em> from <code>MANAGED</code> to <code>STANDARD</code> is not supported.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html#cfn-ses-dedicatedippool-scalingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-dedicatedippool.html#cfn-ses-dedicatedippool-scalingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScalingMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDedicatedIpPoolProps> {
        java.lang.String poolName;
        java.lang.String scalingMode;

        /**
         * Sets the value of {@link CfnDedicatedIpPoolProps#getPoolName}
         * @param poolName The name of the dedicated IP pool that the IP address is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolName(java.lang.String poolName) {
            this.poolName = poolName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDedicatedIpPoolProps#getScalingMode}
         * @param scalingMode The type of scaling mode.
         *                    The following options are available:
         *                    <p>
         *                    <ul>
         *                    <li><code>STANDARD</code> - The customer controls which IPs are part of the dedicated IP pool.</li>
         *                    <li><code>MANAGED</code> - The reputation and number of IPs are automatically managed by Amazon SES .</li>
         *                    </ul>
         *                    <p>
         *                    The <code>STANDARD</code> option is selected by default if no value is specified.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Updating <em>ScalingMode</em> doesn't require a replacement if you're updating its value from <code>STANDARD</code> to <code>MANAGED</code> . However, updating <em>ScalingMode</em> from <code>MANAGED</code> to <code>STANDARD</code> is not supported.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingMode(java.lang.String scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDedicatedIpPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDedicatedIpPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDedicatedIpPoolProps {
        private final java.lang.String poolName;
        private final java.lang.String scalingMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.poolName = software.amazon.jsii.Kernel.get(this, "poolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingMode = software.amazon.jsii.Kernel.get(this, "scalingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.poolName = builder.poolName;
            this.scalingMode = builder.scalingMode;
        }

        @Override
        public final java.lang.String getPoolName() {
            return this.poolName;
        }

        @Override
        public final java.lang.String getScalingMode() {
            return this.scalingMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPoolName() != null) {
                data.set("poolName", om.valueToTree(this.getPoolName()));
            }
            if (this.getScalingMode() != null) {
                data.set("scalingMode", om.valueToTree(this.getScalingMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnDedicatedIpPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDedicatedIpPoolProps.Jsii$Proxy that = (CfnDedicatedIpPoolProps.Jsii$Proxy) o;

            if (this.poolName != null ? !this.poolName.equals(that.poolName) : that.poolName != null) return false;
            return this.scalingMode != null ? this.scalingMode.equals(that.scalingMode) : that.scalingMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.poolName != null ? this.poolName.hashCode() : 0;
            result = 31 * result + (this.scalingMode != null ? this.scalingMode.hashCode() : 0);
            return result;
        }
    }
}
