package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnReceiptRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnReceiptRuleProps cfnReceiptRuleProps = CfnReceiptRuleProps.builder()
 *         .rule(RuleProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .addHeaderAction(AddHeaderActionProperty.builder()
 *                                 .headerName("headerName")
 *                                 .headerValue("headerValue")
 *                                 .build())
 *                         .bounceAction(BounceActionProperty.builder()
 *                                 .message("message")
 *                                 .sender("sender")
 *                                 .smtpReplyCode("smtpReplyCode")
 *                                 // the properties below are optional
 *                                 .statusCode("statusCode")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .connectAction(ConnectActionProperty.builder()
 *                                 .iamRoleArn("iamRoleArn")
 *                                 .instanceArn("instanceArn")
 *                                 .build())
 *                         .lambdaAction(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 // the properties below are optional
 *                                 .invocationType("invocationType")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .s3Action(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .iamRoleArn("iamRoleArn")
 *                                 .kmsKeyArn("kmsKeyArn")
 *                                 .objectKeyPrefix("objectKeyPrefix")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .snsAction(SNSActionProperty.builder()
 *                                 .encoding("encoding")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .stopAction(StopActionProperty.builder()
 *                                 .scope("scope")
 *                                 // the properties below are optional
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .workmailAction(WorkmailActionProperty.builder()
 *                                 .organizationArn("organizationArn")
 *                                 // the properties below are optional
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .build()))
 *                 .enabled(false)
 *                 .name("name")
 *                 .recipients(List.of("recipients"))
 *                 .scanEnabled(false)
 *                 .tlsPolicy("tlsPolicy")
 *                 .build())
 *         .ruleSetName("ruleSetName")
 *         // the properties below are optional
 *         .after("after")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.298Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnReceiptRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReceiptRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRule();

    /**
     * The name of the rule set where the receipt rule is added.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rulesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rulesetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleSetName();

    /**
     * The name of an existing rule after which the new rule is placed.
     * <p>
     * If this parameter is null, the new rule is inserted at the beginning of the rule list.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-after">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-after</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAfter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReceiptRuleProps> {
        java.lang.Object rule;
        java.lang.String ruleSetName;
        java.lang.String after;

        /**
         * Sets the value of {@link CfnReceiptRuleProps#getRule}
         * @param rule A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(software.amazon.awscdk.IResolvable rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Sets the value of {@link CfnReceiptRuleProps#getRule}
         * @param rule A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(software.amazon.awscdk.services.ses.CfnReceiptRule.RuleProperty rule) {
            this.rule = rule;
            return this;
        }

        /**
         * Sets the value of {@link CfnReceiptRuleProps#getRuleSetName}
         * @param ruleSetName The name of the rule set where the receipt rule is added. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(java.lang.String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReceiptRuleProps#getAfter}
         * @param after The name of an existing rule after which the new rule is placed.
         *              If this parameter is null, the new rule is inserted at the beginning of the rule list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder after(java.lang.String after) {
            this.after = after;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReceiptRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReceiptRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReceiptRuleProps {
        private final java.lang.Object rule;
        private final java.lang.String ruleSetName;
        private final java.lang.String after;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rule = software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ruleSetName = software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.after = software.amazon.jsii.Kernel.get(this, "after", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rule = java.util.Objects.requireNonNull(builder.rule, "rule is required");
            this.ruleSetName = java.util.Objects.requireNonNull(builder.ruleSetName, "ruleSetName is required");
            this.after = builder.after;
        }

        @Override
        public final java.lang.Object getRule() {
            return this.rule;
        }

        @Override
        public final java.lang.String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final java.lang.String getAfter() {
            return this.after;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rule", om.valueToTree(this.getRule()));
            data.set("ruleSetName", om.valueToTree(this.getRuleSetName()));
            if (this.getAfter() != null) {
                data.set("after", om.valueToTree(this.getAfter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReceiptRuleProps.Jsii$Proxy that = (CfnReceiptRuleProps.Jsii$Proxy) o;

            if (!rule.equals(that.rule)) return false;
            if (!ruleSetName.equals(that.ruleSetName)) return false;
            return this.after != null ? this.after.equals(that.after) : that.after == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rule.hashCode();
            result = 31 * result + (this.ruleSetName.hashCode());
            result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
            return result;
        }
    }
}
